<?php

add_filter( 'call_to_action_widget', 'do_shortcode');
add_filter('widget_text', 'do_shortcode');

if(!function_exists('mkdcore_is_theme_installed')) {
    /**
     * Function that checks if Mikado theme is installed
     * @return bool whether theme is installed or not
     */
    function mkdcore_is_theme_installed() {
        return defined('MIKADO_ROOT');
    }
}

if (!function_exists('mkdcore_get_carousel_slider_array')){
    /**
     * Function that returns associative array of carousels,
     * where key is term slug and value is term name
     * @return array
     */
    function mkdcore_get_carousel_slider_array() {
        $carousels_array = array();
        $terms = get_terms('carousels_category');

        if (is_array($terms) && count($terms)) {
            $carousels_array[''] = '';
            foreach ($terms as $term) {
                $carousels_array[$term->slug] = $term->name;
            }
        }

        return $carousels_array;
    }
}

if(!function_exists('mkdcore_get_carousel_slider_array_vc')) {
    /**
     * Function that returns array of carousels formatted for Visual Composer
     *
     * @return array array of carousels where key is term title and value is term slug
     *
     * @see mkdcore_get_carousel_slider_array
     */
    function mkdcore_get_carousel_slider_array_vc() {
        return array_flip(mkdcore_get_carousel_slider_array());
    }
}


if ( ! function_exists( 'mkdcore_enqueue_additional_css_styles' ) ) {
	function mkdcore_enqueue_additional_css_styles() {
		$icon_packs = array(
			'font-awesome',
			'elegant-icons'
		);

		foreach ( $icon_packs as $icon_pack ) {
			wp_enqueue_style( "mikado-one-mikado-" . $icon_pack, MIKADO_CSS_ROOT . "/" . $icon_pack . "/css/" . $icon_pack . ".min.css" );
		}
	}

	add_action( 'mikado_one_mikado_action_enqueue_before_main_css', 'mkdcore_enqueue_additional_css_styles' );
}

if ( ! function_exists( 'mikado_core_register_woocommrce_dropdown_cart' ) ) {
	function mikado_core_register_woocommrce_dropdown_cart() {
		register_widget( "Woocommerce_Dropdown_Cart" );
	}

	add_action( 'mikado_one_mikado_register_woocommece_dropdown_cart', 'mikado_core_register_woocommrce_dropdown_cart');
}



if(!function_exists( 'mikado_core_meta_box_add' )) {
	/**
	 * Function that adds all registered meta boxes.
	 */
	function mikado_core_meta_box_add() {
		$mkdFramework = mikado_one_mikado_return_framework();

		//for each registered meta box
		foreach ($mkdFramework->mkdMetaBoxes->metaBoxes as $key=>$box ) {
			$hidden = false;

			//check if hidden property is set for current meta box
			if (!empty($box->hidden_property)){
				//for each values that should hide this meta box
				foreach ($box->hidden_values as $value) {
					//check if option that should hide meta box has one of defined values
					if ( mikado_one_mikado_option_get_value($box->hidden_property) == $value) {
						$hidden = true;
					}
				}
			}

			add_meta_box(
				'mkdf-meta-box-'.$key,
				$box->title, 'mikado_core_render_meta_box',
				$box->scope,
				'advanced',
				'high',
				array( 'box' => $box)
			);

			//if meta box is hidden
			if ($hidden) {
				//add filter that will add class that will hide meta box from admin page
				add_filter( 'postbox_classes_'.$box->scope.'_mkdf-meta-box-'.$key, 'mikado_core_meta_box_add_hidden_class' );
			}
		}

		if ( mikado_one_mikado_is_gutenberg_installed() ) {
			mikado_one_mikado_enqueue_meta_box_styles();
			mikado_one_mikado_enqueue_meta_box_scripts();
		} else {

			//include necessary styles and scripts
			add_action('admin_enqueue_scripts', 'mikado_one_mikado_enqueue_meta_box_styles');
			add_action('admin_enqueue_scripts', 'mikado_one_mikado_enqueue_meta_box_scripts');
		}
	}
	add_action('add_meta_boxes', 'mikado_core_meta_box_add');

}

if(!function_exists( 'mikado_core_meta_box_save' )) {
	/**
	 * Function that saves custom fields for current post.
	 * @param $post_id int id of current post
	 * @param $post WP_Post object of wp post class
	 */
	function mikado_core_meta_box_save( $post_id, $post ) {
		$mkdFramework = mikado_one_mikado_return_framework();

		$postTypes = array( "page", "post", "portfolio_page", "testimonials", "slides", "carousels");

		//check if nonce is submitted
		if (!isset( $_POST[ '_wpnonce' ])) {
			return;
		}

		//check if current user can edit current post
		if (!current_user_can('edit_post', $post_id)) {
			return;
		}

		//check if current post's type is in our custom post types
		if (!in_array( $post->post_type, $postTypes)) {
			return;
		}

		foreach ($mkdFramework->mkdMetaBoxes->options as $key=>$box ) {
			if (isset( $_POST[ $key ] ) && trim($_POST[$key] !== '')) {

				$value = $_POST[ $key ];
				// Auto-paragraphs for any WYSIWYG
				update_post_meta( $post_id, $key, $value );
			} else {
				delete_post_meta( $post_id, $key );
			}
		}

		$portfolios = false;

		if (isset($_POST['optionLabel'])) {
			foreach ($_POST['optionLabel'] as $key => $value) {
				$portfolios_val[$key] = array('optionLabel'=>$value,'optionValue'=>$_POST['optionValue'][$key],'optionUrl'=>$_POST['optionUrl'][$key],'optionlabelordernumber'=>$_POST['optionlabelordernumber'][$key]);
				$portfolios = true;

			}
		}

		if ($portfolios) {
			update_post_meta( $post_id,  'mkd_portfolios', $portfolios_val );
		} else {
			delete_post_meta( $post_id, 'mkd_portfolios' );
		}

		$portfolio_images = false;
		if (isset($_POST['portfolioimg'])) {
			foreach ($_POST['portfolioimg'] as $key => $value) {
				$portfolio_images_val[$key] = array('portfolioimg'=>$_POST['portfolioimg'][$key],'portfoliotitle'=>$_POST['portfoliotitle'][$key],'portfolioimgordernumber'=>$_POST['portfolioimgordernumber'][$key], 'portfoliovideotype'=>$_POST['portfoliovideotype'][$key], 'portfoliovideoid'=>$_POST['portfoliovideoid'][$key], 'portfoliovideoimage'=>$_POST['portfoliovideoimage'][$key], 'portfoliovideowebm'=>$_POST['portfoliovideowebm'][$key], 'portfoliovideomp4'=>$_POST['portfoliovideomp4'][$key], 'portfoliovideoogv'=>$_POST['portfoliovideoogv'][$key], 'portfolioimgtype'=>$_POST['portfolioimgtype'][$key] );
				$portfolio_images = true;
			}
		}

		if ($portfolio_images) {
			update_post_meta( $post_id,  'mkd_portfolio_images', $portfolio_images_val );
		} else {
			delete_post_meta( $post_id,  'mkd_portfolio_images' );
		}
	}

	add_action( 'save_post', 'mikado_core_meta_box_save', 1, 2 );
}

if(!function_exists( 'mikado_core_render_meta_box' )) {
	/**
	 * Function that renders each meta box
	 * @param $post WP_Post current post object
	 * @param $metabox MikadoMetaBox current meta box object
	 */
	function mikado_core_render_meta_box($post, $metabox) {?>
		<div class="mkdf-meta-box mkdf-page">
			<div class="mkdf-meta-box-holder">

				<?php $metabox["args"]["box"]->render(); ?>

			</div>
		</div>
		<?php
	}
}

if(!function_exists( 'mikado_core_meta_box_add_hidden_class' )) {
	/**
	 * Function that adds class that hides meta box if necessary
	 * @param array $classes
	 * @return array
	 */
	function mikado_core_meta_box_add_hidden_class($classes = array()) {
		if( !in_array('mkdf-meta-box-hidden', $classes)) {
			$classes[] = 'mkdf-meta-box-hidden';
		}

		return $classes;
	}
}