<?php

if(!function_exists( 'mikado_one_core_ajax_meta' )) {
	/**
	 * Function that echoes meta data for ajax
	 * @version 0.2
	 */
	function mikado_one_core_ajax_meta() {
		$mkd_options = mikado_one_mikado_return_global_options();;

		$seo_description = get_post_meta(mikado_one_mikado_get_page_id(), "seo_description", true);
		$seo_keywords = get_post_meta(mikado_one_mikado_get_page_id(), "seo_keywords", true);
		?>

		<div class="seo_title"><?php wp_title('|', true, 'right'); ?></div>

		<?php if($seo_description !== ''){ ?>
			<div class="seo_description"><?php echo esc_html($seo_description); ?></div>
		<?php } else if($mkd_options['meta_description']){?>
			<div class="seo_description"><?php echo esc_html($mkd_options['meta_description']); ?></div>
		<?php } ?>
		<?php if($seo_keywords !== ''){ ?>
			<div class="seo_keywords"><?php echo esc_html($seo_keywords); ?></div>
		<?php }else if($mkd_options['meta_keywords']){?>
			<div class="seo_keywords"><?php echo esc_html($mkd_options['meta_keywords']); ?></div>
		<?php }
	}

	add_action('mikado_one_mikado_action_header_meta', 'mikado_one_core_ajax_meta');
}

if(!function_exists( 'mikado_one_core_header_meta' )) {
	/**
	 * Function that echoes meta data if our seo is enabled
	 */
	function mikado_one_core_header_meta() {
		$mkd_options = mikado_one_mikado_return_global_options();;

		if(isset($mkd_options['disable_mkd_seo']) && $mkd_options['disable_mkd_seo'] == 'no') {
			$seo_description = get_post_meta(mikado_one_mikado_get_page_id(), "seo_description", true);
			$seo_keywords = get_post_meta(mikado_one_mikado_get_page_id(), "seo_keywords", true);
			?>

			<?php if($seo_description) { ?>
				<meta name="description" content="<?php echo esc_html($seo_description); ?>">
			<?php } else if($mkd_options['meta_description']){ ?>
				<meta name="description" content="<?php echo esc_html($mkd_options['meta_description']) ?>">
			<?php } ?>

			<?php if($seo_keywords) { ?>
				<meta name="keywords" content="<?php echo esc_html($seo_keywords); ?>">
			<?php } else if($mkd_options['meta_keywords']){ ?>
				<meta name="keywords" content="<?php echo esc_html($mkd_options['meta_keywords']) ?>">
			<?php }
		}
	}

	add_action('mikado_mikado_one_header_meta', 'mikado_one_core_header_meta');
}


if(!function_exists( 'mikado_one_mikado_remove_yoast_json_on_ajax' )) {
	/**
	 * Function that removes yoast json ld script
	 * that stops page transition to work on home page
	 * Hooks to wpseo_json_ld_output in order to disable json ld script
	 * @return bool
	 *
	 * @param $data array json ld data that is being passed to filter
	 *
	 * @version 0.2
	 */
	function mikado_one_mikado_remove_yoast_json_on_ajax($data) {
		//is current request made through ajax?
		if(mikado_one_mikado_is_ajax()) {
			//disable json ld script
			return array();
		}

		return $data;
	}

	//is yoast installed and it's version is greater or equal of 1.6?
	if(defined('WPSEO_VERSION') && version_compare(WPSEO_VERSION, '1.6') >= 0) {
		add_filter('wpseo_json_ld_output', 'mikado_one_mikado_remove_yoast_json_on_ajax');
	}
}


if(!function_exists( 'mikado_one_mikado_is_ajax' )) {
	/**
	 * Function that checks if current request is ajax request
	 * @return bool whether it's ajax request or not
	 *
	 * @version 0.1
	 */
	function mikado_one_mikado_is_ajax() {
		return !empty( $_SERVER[ 'HTTP_X_REQUESTED_WITH' ]) && strtolower( $_SERVER[ 'HTTP_X_REQUESTED_WITH' ]) == 'xmlhttprequest';
	}
}

if( ! function_exists('mikado_core_add_google_analytics') ){
    function mikado_core_add_google_analytics(){
        if (isset($mkd_options['google_analytics_code'])){
            if($mkd_options['google_analytics_code'] != "") {
                ?>
                <script>
                    var _gaq = _gaq || [];
                    _gaq.push(['_setAccount', '<?php echo esc_attr($mkd_options['google_analytics_code']); ?>']);
                    _gaq.push(['_trackPageview']);

                    (function() {
                        var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
                        ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
                        var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
                    })();
                </script>
            <?php }
        }
    }

    add_action('mikado_mikado_one_after_wrapper_inner', 'mikado_core_add_google_analytics');
}

if ( ! function_exists( 'mikado_core_visual_composer_custom_shortcodce_css' ) ) {
    /**
     * Function that outputs Visual Composer's custom css.
     * Hooks to mikado_one_mikado_visual_composer_custom_shortcodce_css action
     */
    function mikado_core_visual_composer_custom_shortcodce_css() {
        if ( mikado_one_mikado_visual_composer_installed() ) {
            if ( is_page() || is_single() || is_singular( 'portfolio_page' ) ) {
                $shortcodes_custom_css = get_post_meta( mikado_one_mikado_get_page_id(), '_wpb_shortcodes_custom_css', true );
                if ( ! empty( $shortcodes_custom_css ) ) {
                    echo '<style type="text/css" data-type="vc_shortcodes-custom-css-' . esc_attr( mikado_one_mikado_get_page_id() ) . '">';
                    echo esc_attr( $shortcodes_custom_css );
                    echo '</style>';
                }
                $post_custom_css = get_post_meta( mikado_one_mikado_get_page_id(), '_wpb_post_custom_css', true );
                if ( ! empty( $post_custom_css ) ) {
                    echo '<style type="text/css" data-type="vc_custom-css-' . esc_attr( mikado_one_mikado_get_page_id() ) . '">';
                    echo esc_attr( $post_custom_css );
                    echo '</style>';
                }
            }

        }

    }

    add_action( 'mikado_one_mikado_visual_composer_custom_shortcodce_css', 'mikado_core_visual_composer_custom_shortcodce_css' );
}

