<?php

if ( ! function_exists( 'mikado_one_core_blog_options_map' ) ) {
	function mikado_one_core_blog_options_map() {
		$mkdFramework = mikado_one_mikado_return_framework();

		$blogPage = new MikadoAdminPage("8", "Blog");
		$mkdFramework->mkdOptions->addAdminPage("blogPage",$blogPage);

		// Blog Post Lists - General

		$panel1 = new MikadoPanel("Blog Lists","post_lists_general_panel");
		$blogPage->addChild("panel1",$panel1);

		$blog_style = new MikadoField("select","blog_style","1","Archive and Category Layout","Choose a default blog layout for archived Blog Post Lists and Category Blog Lists", array(
			"1" => "Blog: Date in Title",
			"2" => "Blog: Post Info Vertical - Content",
		    "3" => "Blog: Category & Title First (Centered)",
		    "4" => "Blog: Title & Date First",
		    "5" => "Blog: Title & Author (Centered)",
		    "6" => "Blog: Post Info Vertical - Image",
		    "7" => "Blog: Image with Icon (Centered)",
		    "8" => "Blog: Masonry",
			"9" => "Blog: Masonry Full Width",
			"10" => "Blog: Date in Title Whole Post"
		));
		$panel1->addChild("blog_style",$blog_style);

		$category_blog_sidebar = new MikadoField("select","category_blog_sidebar","default","Archive and Category Sidebar","Choose a sidebar layout for archived Blog Post Lists and Category Blog Lists", array(
			"default" => "No Sidebar",
			"1" => "Sidebar 1/3 right",
			"2" => "Sidebar 1/4 right",
			"3" => "Sidebar 1/3 left",
			"4" => "Sidebar 1/4 left"
		));
		$panel1->addChild("category_blog_sidebar",$category_blog_sidebar);

		$pagination = new MikadoField("yesno","pagination","yes","Pagination","Enabling this option will display pagination links on bottom of Blog Post List", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_hide_pagination_list_container"));
		$panel1->addChild("pagination",$pagination);

		$blog_hide_pagination_list_container = new MikadoContainer("blog_hide_pagination_list_container","pagination","");
		$panel1->addChild("blog_hide_pagination_list_container",$blog_hide_pagination_list_container);

		$blog_page_range = new MikadoField("text","blog_page_range","","Pagination Range limit","Enter a number that will limit pagination to a certain range of links",array(), array("col_width" => 3));
		$blog_hide_pagination_list_container->addChild("blog_page_range",$blog_page_range);

		$number_of_chars = new MikadoField("text","number_of_chars","45","Number of Words in Excerpt",' Enter a number of words in excerpt (article summary)', array(), array("col_width" => 3));
		$panel1->addChild("number_of_chars",$number_of_chars);

		// Blog Single

		$panel20 = new MikadoPanel("Blog Single", "blog_single_panel");
		$blogPage->addChild("panel20",$panel20);

			$blog_single_style = new MikadoField("select","blog_single_style","","Blog Single Post Template","Choose template style for blog single post", array(
				"" => "",
				"blog_date_in_title" => "Blog: Date in Title",
				"blog_category_title_first_centered" => "Blog: Category & Title First (Centered)",
				"blog_post_info_vertical_content" => "Blog: Post Info Vertical - Content",
				"blog_title_date_first" => "Blog: Title & Date First",
				"blog_title_author_centered" => "Blog: Title & Author (Centered)",
				"blog_image_with_icon_centered" => "Blog: Image with Icon (Centered)",
		        "blog_post_info_vertical_image" => "Blog: Post Info Vertical - Image"
		    ),
			array("dependence" => true,
				"hide" => array(
					"blog_image_with_icon_centered"=>"#mkdf_blog_single_show_ql_icon_container"
					),
				"show" => array(
					"" => "#mkdf_blog_single_show_ql_icon_container",
					"blog_date_in_title"=>"#mkdf_blog_single_show_ql_icon_container",
					"blog_category_title_first_centered"=>"#mkdf_blog_single_show_ql_icon_container",
					"blog_post_info_vertical_content"=>"#mkdf_blog_single_show_ql_icon_container",
					"blog_title_date_first"=>"#mkdf_blog_single_show_ql_icon_container",
					"blog_title_author_centered"=>"#mkdf_blog_single_show_ql_icon_container",
					"blog_post_info_vertical_image"=>"#mkdf_blog_single_show_ql_icon_container",
				)
			));
			$panel20->addChild("blog_single_style", $blog_single_style);
			
			

			$blog_single_sidebar = new MikadoField("select","blog_single_sidebar","default","Sidebar Layout","Choose a sidebar layout for Blog Single pages", array(
				"default" => "No Sidebar",
				"1" => "Sidebar 1/3 right",
				"2" => "Sidebar 1/4 right",
				"3" => "Sidebar 1/3 left",
				"4" => "Sidebar 1/4 left"
		      ));
			$panel20->addChild("blog_single_sidebar",$blog_single_sidebar);

			$custom_sidebars = array();
			foreach ( $GLOBALS['wp_registered_sidebars'] as $sidebar ) {
				if(mikado_one_mikado_is_user_made_sidebar(ucwords($sidebar['name']))){
					$custom_sidebars[$sidebar['id']] = ucwords( $sidebar['name']);
				}
			}
			$blog_single_sidebar_custom_display = new MikadoField("selectblank","blog_single_sidebar_custom_display","","Sidebar to Display","Choose a sidebar to display on Blog Single pages", $custom_sidebars);
			$panel20->addChild("blog_single_sidebar_custom_display",$blog_single_sidebar_custom_display);

		$blog_single_show_ql_icon_container = new MikadoContainer("blog_single_show_ql_icon_container","blog_single_style","blog_image_with_icon_centered");
		$panel20->addChild("blog_single_show_ql_icon_container",$blog_single_show_ql_icon_container);
			
			$blog_single_show_ql_icon = new MikadoField("yesno","blog_single_show_ql_icon","yes","Enable Quote/Link Icon","Enabling this option will show Quote/Link Icon on Blog Single posts");
			$blog_single_show_ql_icon_container->addChild("blog_single_show_ql_icon",$blog_single_show_ql_icon);

		$blog_single_navigation = new MikadoField("yesno","blog_single_navigation","no","Enable Prev/Next Single Post Navigation Links","Enable navigation links through the blog posts (left and right arrows will appear)", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_hide_pagination_container"));
		$panel20->addChild("blog_single_navigation",$blog_single_navigation);

		$blog_hide_pagination_container = new MikadoContainer("blog_hide_pagination_container","blog_single_navigation","no");
		$panel20->addChild("blog_hide_pagination_container",$blog_hide_pagination_container);

			$blog_navigation_through_same_category = new MikadoField("yesno","blog_navigation_through_same_category","no","Enable Navigation Only in Current Category","Limit your navigation only through current category");
			$blog_hide_pagination_container->addChild("blog_navigation_through_same_category",$blog_navigation_through_same_category);
				
			
			$blog_single_title_tags = new MikadoField("select","blog_single_title_tags","h5","Headlines Below Post Content",'Choose a tag for headlines below post content ("Tags", "Post a comment", etc)', array(
				"h2" => "h2",
				"h3" => "h3",
				"h4" => "h4",
				"h5" => "h5",
				"h6" => "h6"
		      ));
			$panel20->addChild("blog_single_title_tags",$blog_single_title_tags);	
				

			$post_info_data_single = new MikadoTitle("post_info_data_single", "Post Info Data Fields");
			$panel20->addChild("post_info_data_single", $post_info_data_single);

			$blog_single_show_date = new MikadoField("yesno","blog_single_show_date","yes","Show Date","Enabling this option will show date on Blog Single posts");
			$panel20->addChild("blog_single_show_date",$blog_single_show_date);

		    $blog_single_show_like = new MikadoField("yesno","blog_single_show_like","no","Show Like","Enabling this option will turn on 'Likes' on Blog Single posts");
		    $panel20->addChild("blog_single_show_like",$blog_single_show_like);

		    $blog_single_show_social_share = new MikadoField("yesno","blog_single_show_social_share","no","Show Share","Enabling this option will show share on Single Post");
			$panel20->addChild("blog_single_show_social_share",$blog_single_show_social_share);

			$blog_single_show_category = new MikadoField("yesno","blog_single_show_category","yes","Show Category","Enabling this option will show category/categories on Blog Single posts");
			$panel20->addChild("blog_single_show_category",$blog_single_show_category);

			$blog_author_info = new MikadoField("yesno","blog_author_info","no","Show Author Info","Enabling this option will display author name and descriptions on Blog Single pages", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_enable_blog_author_info_container"));
			$panel20->addChild("blog_author_info",$blog_author_info);

			$enable_blog_author_info_container = new MikadoContainer("enable_blog_author_info_container","blog_author_info","no");
			$panel20->addChild("enable_blog_author_info_container",$enable_blog_author_info_container);
			
			$enable_author_info_email = new MikadoField("yesno","enable_author_info_email","no","Show Author Email","Enabling this option will show author email");
			$enable_blog_author_info_container->addChild("enable_author_info_email",$enable_author_info_email);
			
			$group1 = new MikadoGroup("Blog Single Author Info Box Style","Set styles for author info box on single post pages");
			$enable_blog_author_info_container->addChild("group1",$group1);

				$row1 = new MikadoRow();
				$group1->addChild("row1",$row1);			

					$blog_single_post_author_info_margin_top = new MikadoField("textsimple","blog_single_post_author_info_margin_top","","Margin Top for Author Info Holder (px)","This is some description");
					$row1->addChild("blog_single_post_author_info_margin_top",$blog_single_post_author_info_margin_top);

					$blog_single_post_author_info_background_color = new MikadoField("colorsimple","blog_single_post_author_info_background_color","","Background Color","This is some description");
					$row1->addChild("blog_single_post_author_info_background_color",$blog_single_post_author_info_background_color);

					$blog_single_post_author_info_border_width = new MikadoField("textsimple","blog_single_post_author_info_border_width","","Border width(px)","This is some description");
					$row1->addChild("blog_single_post_author_info_border_width",$blog_single_post_author_info_border_width);

					$blog_single_post_author_info_border_color = new MikadoField("colorsimple","blog_single_post_author_info_border_color","","Border Color","This is some description");
					$row1->addChild("blog_single_post_author_info_border_color",$blog_single_post_author_info_border_color);

				$row2 = new MikadoRow();
				$group1->addChild("row2",$row2);

					$blog_single_post_author_info_padding_top = new MikadoField("textsimple","blog_single_post_author_info_padding_top","","Padding Top (px)","This is some description");
					$row2->addChild("blog_single_post_author_info_padding_top",$blog_single_post_author_info_padding_top);

					$blog_single_post_author_info_padding_bottom = new MikadoField("textsimple","blog_single_post_author_info_padding_bottom","","Padding Bottom (px)","This is some description");
					$row2->addChild("blog_single_post_author_info_padding_bottom",$blog_single_post_author_info_padding_bottom);

					$blog_single_post_author_info_padding_left = new MikadoField("textsimple","blog_single_post_author_info_padding_left","","Padding Left (px)","This is some description");
					$row2->addChild("blog_single_post_author_info_padding_left",$blog_single_post_author_info_padding_left);

					$blog_single_post_author_info_padding_right = new MikadoField("textsimple","blog_single_post_author_info_padding_right","","Padding Right (px)","This is some description");
					$row2->addChild("blog_single_post_author_info_padding_right",$blog_single_post_author_info_padding_right);
			
			$group2 = new MikadoGroup("Blog Single Author Info Title Style","Set styles for author info title on single post pages");
			$enable_blog_author_info_container->addChild("group2",$group2);	
				
				$row1 = new MikadoRow();
				$group2->addChild("row1",$row1);
			
					$blog_single_post_author_info_title_color = new MikadoField("colorsimple","blog_single_post_author_info_title_color","","Text Color","This is some description");
					$row1->addChild("blog_single_post_author_info_title_color",$blog_single_post_author_info_title_color);
					
					$blog_single_post_author_info_title_font_family = new MikadoField("Fontsimple","blog_single_post_author_info_title_font_family","-1","Font Family","This is some description");
					$row1->addChild("blog_single_post_author_info_title_font_family",$blog_single_post_author_info_title_font_family);

					$blog_single_post_author_info_title_fontsize = new MikadoField("textsimple","blog_single_post_author_info_title_fontsize","","Font Size (px)","This is some description");
					$row1->addChild("blog_single_post_author_info_title_fontsize",$blog_single_post_author_info_title_fontsize);

					$blog_single_post_author_info_title_lineheight = new MikadoField("textsimple","blog_single_post_author_info_title_lineheight","","Line Height (px)","This is some description");
					$row1->addChild("blog_single_post_author_info_title_lineheight",$blog_single_post_author_info_title_lineheight);

				$row2 = new MikadoRow(true);
				$group2->addChild("row2",$row2);			

					$blog_single_post_author_info_title_fontstyle = new MikadoField("selectblanksimple","blog_single_post_author_info_title_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
					$row2->addChild("blog_single_post_author_info_title_fontstyle",$blog_single_post_author_info_title_fontstyle);

					$blog_single_post_author_info_title_fontweight = new MikadoField("selectblanksimple","blog_single_post_author_info_title_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
					$row2->addChild("blog_single_post_author_info_title_fontweight",$blog_single_post_author_info_title_fontweight);

					$blog_single_post_author_info_title_texttransform = new MikadoField("selectblanksimple","blog_single_post_author_info_title_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
					$row2->addChild("blog_single_post_author_info_title_texttransform",$blog_single_post_author_info_title_texttransform);

					$blog_single_post_author_info_title_letterspacing = new MikadoField("textsimple","blog_single_post_author_info_title_letterspacing","","Letter Spacing (px)","This is some description");
					$row2->addChild("blog_single_post_author_info_title_letterspacing",$blog_single_post_author_info_title_letterspacing);
					
				$row3 = new MikadoRow();
				$group2->addChild("row3",$row3);
				
					$blog_single_post_author_info_title_margin_bottom = new MikadoField("textsimple","blog_single_post_author_info_title_margin_bottom","","Margin Bottom for Author Info Title (px)","This is some description");
					$row3->addChild("blog_single_post_author_info_title_margin_bottom",$blog_single_post_author_info_title_margin_bottom);
			
			$group3 = new MikadoGroup("Blog Single Author Info Text Style","Set styles for author info text on single post pages");
			$enable_blog_author_info_container->addChild("group3",$group3);	
				
				$row1 = new MikadoRow();
				$group3->addChild("row1",$row1);
			
					$blog_single_post_author_info_text_color = new MikadoField("colorsimple","blog_single_post_author_info_text_color","","Text Color","This is some description");
					$row1->addChild("blog_single_post_author_info_text_color",$blog_single_post_author_info_text_color);
					
					$blog_single_post_author_info_text_font_family = new MikadoField("Fontsimple","blog_single_post_author_info_text_font_family","-1","Font Family","This is some description");
					$row1->addChild("blog_single_post_author_info_text_font_family",$blog_single_post_author_info_text_font_family);

					$blog_single_post_author_info_text_fontsize = new MikadoField("textsimple","blog_single_post_author_info_text_fontsize","","Font Size (px)","This is some description");
					$row1->addChild("blog_single_post_author_info_text_fontsize",$blog_single_post_author_info_text_fontsize);

					$blog_single_post_author_info_text_lineheight = new MikadoField("textsimple","blog_single_post_author_info_text_lineheight","","Line Height (px)","This is some description");
					$row1->addChild("blog_single_post_author_info_text_lineheight",$blog_single_post_author_info_text_lineheight);

				$row2 = new MikadoRow(true);
				$group3->addChild("row2",$row2);			

					$blog_single_post_author_info_text_fontstyle = new MikadoField("selectblanksimple","blog_single_post_author_info_text_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
					$row2->addChild("blog_single_post_author_info_text_fontstyle",$blog_single_post_author_info_text_fontstyle);

					$blog_single_post_author_info_text_fontweight = new MikadoField("selectblanksimple","blog_single_post_author_info_text_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
					$row2->addChild("blog_single_post_author_info_text_fontweight",$blog_single_post_author_info_text_fontweight);

					$blog_single_post_author_info_text_texttransform = new MikadoField("selectblanksimple","blog_single_post_author_info_text_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
					$row2->addChild("blog_single_post_author_info_text_texttransform",$blog_single_post_author_info_text_texttransform);

					$blog_single_post_author_info_text_letterspacing = new MikadoField("textsimple","blog_single_post_author_info_text_letterspacing","","Letter Spacing (px)","This is some description");
					$row2->addChild("blog_single_post_author_info_text_letterspacing",$blog_single_post_author_info_text_letterspacing);		

		    	
			$blog_single_show_comments = new MikadoField("yesno","blog_single_show_comments","yes","Show Comments","Enabling this option will show comments on Blog Single posts", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_enable_blog_comments_container"));
			$panel20->addChild("blog_single_show_comments",$blog_single_show_comments);

			$enable_blog_comments_container = new MikadoContainer("enable_blog_comments_container","blog_single_show_comments","no");
			$panel20->addChild("enable_blog_comments_container",$enable_blog_comments_container);
			
			$group1 = new MikadoGroup("Comments Box Style","Set styles for comments box on single post pages");
			$enable_blog_comments_container->addChild("group1",$group1);

				$row1 = new MikadoRow();
				$group1->addChild("row1",$row1);

					$blog_single_post_comments_background_color = new MikadoField("colorsimple","blog_single_post_comments_background_color","","Background Color","This is some description");
					$row1->addChild("blog_single_post_comments_background_color",$blog_single_post_comments_background_color);

					$blog_single_post_comments_border_width = new MikadoField("textsimple","blog_single_post_comments_border_width","","Border width(px)","This is some description");
					$row1->addChild("blog_single_post_comments_border_width",$blog_single_post_comments_border_width);

					$blog_single_post_comments_border_color = new MikadoField("colorsimple","blog_single_post_comments_border_color","","Border Color","This is some description");
					$row1->addChild("blog_single_post_comments_border_color",$blog_single_post_comments_border_color);

				$row2 = new MikadoRow();
				$group1->addChild("row2",$row2);

					$blog_single_post_comments_padding_top = new MikadoField("textsimple","blog_single_post_comments_padding_top","","Padding Top (px)","This is some description");
					$row2->addChild("blog_single_post_comments_padding_top",$blog_single_post_comments_padding_top);

					$blog_single_post_comments_padding_bottom = new MikadoField("textsimple","blog_single_post_comments_padding_bottom","","Padding Bottom (px)","This is some description");
					$row2->addChild("blog_single_post_comments_padding_bottom",$blog_single_post_comments_padding_bottom);

					$blog_single_post_comments_padding_left = new MikadoField("textsimple","blog_single_post_comments_padding_left","","Padding Left (px)","This is some description");
					$row2->addChild("blog_single_post_comments_padding_left",$blog_single_post_comments_padding_left);

					$blog_single_post_comments_padding_right = new MikadoField("textsimple","blog_single_post_comments_padding_right","","Padding Right (px)","This is some description");
					$row2->addChild("blog_single_post_comments_padding_right",$blog_single_post_comments_padding_right);
			
			$group2 = new MikadoGroup("Comments Color Style","Set styles for comments on single post pages");
			$enable_blog_comments_container->addChild("group2",$group2);
				
				$row1 = new MikadoRow();
				$group2->addChild("row1",$row1);
			
					$blog_single_post_comments_title_color = new MikadoField("colorsimple","blog_single_post_comments_title_color","","Title Color","This is some description");
					$row1->addChild("blog_single_post_comments_title_color",$blog_single_post_comments_title_color);
					
					$blog_single_post_comments_text_color = new MikadoField("colorsimple","blog_single_post_comments_text_color","","Text Color","This is some description");
					$row1->addChild("blog_single_post_comments_text_color",$blog_single_post_comments_text_color);
					
					$blog_single_post_comments_link_color = new MikadoField("colorsimple","blog_single_post_comments_link_color","","Link Color","This is some description");
					$row1->addChild("blog_single_post_comments_link_color",$blog_single_post_comments_link_color);	
					
					$blog_single_post_comments_date_color = new MikadoField("colorsimple","blog_single_post_comments_date_color","","Date Color","This is some description");
					$row1->addChild("blog_single_post_comments_date_color",$blog_single_post_comments_date_color);	

		// Advanced Options

		$panel_advanced_options = new MikadoPanel("Advanced Options","panel_advanced_options");
		$blogPage->addChild("panel_advanced_options",$panel_advanced_options);

		$blog_date_in_title_show_options = new MikadoField("yesno","blog_date_in_title_show_options","no","Show Date in Title Template Options","Editing these options will have affect on Post List & Single Post", array(),
		    array("dependence" => true,
		        "dependence_hide_on_yes" => "",
		        "dependence_show_on_yes" => "#mkdf_blog_date_in_title_post_lists"));
		$panel_advanced_options->addChild("blog_date_in_title_show_options",$blog_date_in_title_show_options);

		$blog_category_title_first_centered_show_options = new MikadoField("yesno","blog_category_title_first_centered_show_options","no","Show Category & Title First (Centered) Template Options","Editing these options will have affect on Post List & Single Post", array(),
		    array("dependence" => true,
		        "dependence_hide_on_yes" => "",
		        "dependence_show_on_yes" => "#mkdf_blog_category_title_first_centered_post_lists"));
		$panel_advanced_options->addChild("blog_category_title_first_centered_show_options", $blog_category_title_first_centered_show_options);

		$blog_post_info_vertical_content_show_options = new MikadoField("yesno","blog_post_info_vertical_content_show_options","no","Show Post Info Vertical - Content Template Options","Editing these options will have affect on Post List & Single Post", array(),
		    array("dependence" => true,
		        "dependence_hide_on_yes" => "",
		        "dependence_show_on_yes" => "#mkdf_blog_post_info_vertical_content_post_lists"));
		$panel_advanced_options->addChild("blog_post_info_vertical_content_show_options", $blog_post_info_vertical_content_show_options);

		$blog_image_with_icon_centered_show_options = new MikadoField("yesno","blog_image_with_icon_centered_show_options","no","Show Image with Icon (Centered) Template Options","Editing these options will have affect on Post List & Single Post", array(),
		    array("dependence" => true,
		        "dependence_hide_on_yes" => "",
		        "dependence_show_on_yes" => "#mkdf_blog_image_with_icon_centered_post_lists"));
		$panel_advanced_options->addChild("blog_image_with_icon_centered_show_options",$blog_image_with_icon_centered_show_options);

		$blog_title_date_first_show_options = new MikadoField("yesno","blog_title_date_first_show_options","no","Show Title & Date First Template Options","Editing these options will have affect on Post List & Single Post", array(),
		    array("dependence" => true,
		        "dependence_hide_on_yes" => "",
		        "dependence_show_on_yes" => "#mkdf_blog_title_date_first_post_lists"));
		$panel_advanced_options->addChild("blog_title_date_first_show_options",$blog_title_date_first_show_options);

		$blog_title_author_centered_show_options = new MikadoField("yesno","blog_title_author_centered_show_options","no","Show Title & Author (Centered) Template Options","Editing these options will have affect on Post List & Single Post", array(),
		    array("dependence" => true,
		        "dependence_hide_on_yes" => "",
		        "dependence_show_on_yes" => "#mkdf_blog_title_author_centered_post_lists"));
		$panel_advanced_options->addChild("blog_title_author_centered_show_options",$blog_title_author_centered_show_options);

		$blog_post_info_vertical_image_show_options = new MikadoField("yesno","blog_post_info_vertical_image_show_options","no","Show Post Info Vertical - Image Template Options","Editing these options will have affect on Post List & Single Post", array(),
		    array("dependence" => true,
		        "dependence_hide_on_yes" => "",
		        "dependence_show_on_yes" => "#mkdf_blog_post_info_vertical_image_post_lists"));
		$panel_advanced_options->addChild("blog_post_info_vertical_image_show_options",$blog_post_info_vertical_image_show_options);

		$blog_masonry_show_options = new MikadoField("yesno","blog_masonry_show_options","no","Show Masonry & Masonry Full Width Template Options","Editing these options will have affect on Post List & Single Post", array(),
		    array("dependence" => true,
		        "dependence_hide_on_yes" => "",
		        "dependence_show_on_yes" => "#mkdf_blog_masonry_post_lists"));
		$panel_advanced_options->addChild("blog_masonry_show_options", $blog_masonry_show_options);


		// Blog Post List - Blog: Date in Title
		$panel3 = new MikadoPanel("Blog List Template Options: Date in Title","blog_date_in_title_post_lists", "blog_date_in_title_show_options", "no");
		$blogPage->addChild("panel3",$panel3);


		$blog_date_in_title_number_of_chars = new MikadoField("text","blog_date_in_title_number_of_chars","45","Number of Words in Excerpt",' Enter a number of words in excerpt (article summary)', array(), array("col_width" => 3));
		$panel3->addChild("blog_date_in_title_number_of_chars",$blog_date_in_title_number_of_chars);

		$blog_date_in_title_read_more_button = new MikadoField("yesno","blog_date_in_title_read_more_button","no","Read More Button","Enable Read More Button");
		$panel3->addChild("blog_date_in_title_read_more_button",$blog_date_in_title_read_more_button);

		$blog_date_in_title_content_position = new MikadoField("select","blog_date_in_title_content_position","content_above_blog_list","Content Position","Choose content position for blog list template when sidebar is enabled. Note: This settings in only for template, not for archive pages", array(
			"content_above_blog_list" => "Content Above Blog List",
			"content_above_blog_list_and_sidebar" => "Content Above Blog List and Sidebar"
		));
		$panel3->addChild("blog_date_in_title_content_position",$blog_date_in_title_content_position);

		$blog_date_in_title_post_meta_data_section = new MikadoTitle("blog_date_in_title_post_meta_data_section", "Post Info Data Fields");
		$panel3->addChild("blog_date_in_title_post_meta_data_section", $blog_date_in_title_post_meta_data_section);

		$blog_date_in_title_show_categories = new MikadoField("yesno","blog_date_in_title_show_categories","yes","Show Categories","Enabling this option will Show Categories on Post List");
		$panel3->addChild("blog_date_in_title_show_categories",$blog_date_in_title_show_categories);

		$blog_date_in_title_show_comments = new MikadoField("yesno","blog_date_in_title_show_comments","yes","Show Comments","Enabling this option will Show Comments on Post List");
		$panel3->addChild("blog_date_in_title_show_comments",$blog_date_in_title_show_comments);

		$blog_date_in_title_show_author = new MikadoField("yesno","blog_date_in_title_show_author","yes","Show Author Name","Enabling this option will show author name on Post List and Blog Post Single");
		$panel3->addChild("blog_date_in_title_show_author",$blog_date_in_title_show_author);

		$blog_date_in_title_show_date = new MikadoField("yesno","blog_date_in_title_show_date","yes","Show Date","Enabling this option will show date on Post List");
		$panel3->addChild("blog_date_in_title_hide_date",$blog_date_in_title_show_date);

		$blog_date_in_title_show_share = new MikadoField("yesno","blog_date_in_title_show_share","no","Show Share","Enabling this option will show share on Post List", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_date_in_title_share_options_container"));
		$panel3->addChild("blog_date_in_title_show_share",$blog_date_in_title_show_share);

		$blog_date_in_title_share_options_container = new MikadoContainer("blog_date_in_title_share_options_container","blog_date_in_title_show_share","no");
		$panel3->addChild("blog_date_in_title_share_options_container",$blog_date_in_title_share_options_container);

		$blog_date_in_title_share_icon_color = new MikadoField("color","blog_date_in_title_share_icon_color","","Icon Color","Choose icon color for share dropdown");
		$blog_date_in_title_share_options_container->addChild("blog_date_in_title_share_icon_color",$blog_date_in_title_share_icon_color);

		$blog_date_in_title_share_icon_hover_color = new MikadoField("color","blog_date_in_title_share_icon_hover_color","","Icon Hover Color","Choose icon hover color for share dropdown");
		$blog_date_in_title_share_options_container->addChild("blog_date_in_title_share_icon_hover_color",$blog_date_in_title_share_icon_hover_color);

		$blog_date_in_title_share_background_color = new MikadoField("color","blog_date_in_title_share_background_color","","Background Color","Choose background color for share dropdown list field");
		$blog_date_in_title_share_options_container->addChild("blog_date_in_title_share_background_color",$blog_date_in_title_share_background_color);

		$blog_date_in_title_show_like = new MikadoField("yesno","blog_date_in_title_show_like","no","Show Likes",'Enabling this option will turn on "Likes"');
		$panel3->addChild("blog_date_in_title_show_like",$blog_date_in_title_show_like);

		$blog_date_in_title_post_design_style = new MikadoTitle("blog_date_in_title_post_design_style", "Post Design Style");
		$panel3->addChild("blog_date_in_title_post_design_style", $blog_date_in_title_post_design_style);

		$blog_date_in_title_enable_text_box = new MikadoField("yesno","blog_date_in_title_enable_text_box","no","Enable Boxed Styled Post Content","Enable post text boxed features", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_date_in_title_enable_text_box_container"));
		$panel3->addChild("blog_date_in_title_enable_text_box",$blog_date_in_title_enable_text_box);

		$blog_date_in_title_enable_text_box_container = new MikadoContainer("blog_date_in_title_enable_text_box_container","blog_date_in_title_enable_text_box","no");
		$panel3->addChild("blog_date_in_title_enable_text_box_container",$blog_date_in_title_enable_text_box_container);

		$blog_date_in_title_box_background_color = new MikadoField("color","blog_date_in_title_box_background_color","","Background Color","Choose background color for post text box");
		$blog_date_in_title_enable_text_box_container->addChild("blog_date_in_title_box_background_color",$blog_date_in_title_box_background_color);

		$blog_date_in_title_box_border_color = new MikadoField("color","blog_date_in_title_box_border_color","","Border Color","Choose border color for post text box");
		$blog_date_in_title_enable_text_box_container->addChild("blog_date_in_title_box_border_color",$blog_date_in_title_box_border_color);

		$blog_date_in_title_box_padding = new MikadoField("text","blog_date_in_title_box_padding","","Text box padding","Please insert padding in format (top right bottom left) i.e. 5px 5px 5px 5px", array(), array("col_width" => 3));
		$blog_date_in_title_enable_text_box_container->addChild("blog_date_in_title_box_padding",$blog_date_in_title_box_padding);

		$group1 = new MikadoGroup("Quote/Link Background","Set background of Quote/Link post type");
		$panel3->addChild("group1",$group1);

		$row1 = new MikadoRow();
		$group1->addChild("row1",$row1);

		$blog_date_in_title_ql_background_image = new MikadoField("yesnosimple","blog_date_in_title_ql_background_image","no","Background Image","Show Background Image");
		$row1->addChild("blog_date_in_title_ql_background_image",$blog_date_in_title_ql_background_image);

		$blog_date_in_title_ql_background_color = new MikadoField("colorsimple","blog_date_in_title_ql_background_color","","Background Color","Default color is #ffffff.");
		$row1->addChild("blog_date_in_title_ql_background_color",$blog_date_in_title_ql_background_color);

		$blog_date_in_title_ql_hover_background_color = new MikadoField("colorsimple","blog_date_in_title_ql_hover_background_color","","Background Hover Color","Default color is #e6ae48.");
		$row1->addChild("blog_date_in_title_ql_hover_background_color",$blog_date_in_title_ql_hover_background_color);

		$blog_date_in_title_show_ql_mark = new MikadoField("yesno","blog_date_in_title_show_ql_mark","yes","Enable Quote/Link Icon","Show Icons for Quote/Link Post Format", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_date_in_title_show_ql_mark_container"));
		$panel3->addChild("blog_date_in_title_show_ql_mark",$blog_date_in_title_show_ql_mark);

		$blog_date_in_title_show_ql_mark_container = new MikadoContainer("blog_date_in_title_show_ql_mark_container","blog_date_in_title_show_ql_mark","no");
		$panel3->addChild("blog_date_in_title_show_ql_mark_container",$blog_date_in_title_show_ql_mark_container);

		$row1 = new MikadoRow();
		$blog_date_in_title_show_ql_mark_container->addChild("row1",$row1);

		$blog_date_in_title_ql_mark_color = new MikadoField("color","blog_date_in_title_ql_mark_color","","Icon Color","Choose icon color for quote/link post.");
		$row1->addChild("blog_date_in_title_ql_mark_color",$blog_date_in_title_ql_mark_color);

		$blog_date_in_title_ql_mark_hover_color = new MikadoField("color","blog_date_in_title_ql_mark_hover_color","","Icon Hover Color","Choose hover icon color for quote/link post.");
		$row1->addChild("blog_date_in_title_ql_mark_hover_color",$blog_date_in_title_ql_mark_hover_color);

		$group7 = new MikadoGroup("Blog List Spacing","Set spacing for blog layouts");
		$panel3->addChild("group7",$group7);

		$row1 = new MikadoRow();
		$group7->addChild("row1",$row1);

		$blog_date_in_title_image_margin_bottom = new MikadoField("textsimple","blog_date_in_title_image_margin_bottom","","Margin Under Image (px)","This is some description");
		$row1->addChild("blog_date_in_title_image_margin_bottom",$blog_date_in_title_image_margin_bottom);

		$blog_date_in_title_title_margin_bottom = new MikadoField("textsimple","blog_date_in_title_title_margin_bottom","","Margin Under Title (px)","This is some description");
		$row1->addChild("blog_date_in_title_title_margin_bottom",$blog_date_in_title_title_margin_bottom);

		$blog_date_in_title_post_info_margin_top = new MikadoField("textsimple","blog_date_in_title_post_info_margin_top","","Margin Above Post Info (px)","This is some description");
		$row1->addChild("blog_date_in_title_post_info_margin_top",$blog_date_in_title_post_info_margin_top);

		$blog_date_in_title_article_margin_bottom = new MikadoField("textsimple","blog_date_in_title_article_margin_bottom","","Margin Between Articles (px)","This is some description");
		$row1->addChild("blog_date_in_title_article_margin_bottom",$blog_date_in_title_article_margin_bottom);

		$group8 = new MikadoGroup("Blog List Spacing for Quote and Link Post Type","Set spacing for blog layouts");
		$panel3->addChild("group8",$group8);

		$row1 = new MikadoRow();
		$group8->addChild("row1",$row1);

		$blog_date_in_title_ql_quote_author_margin_top = new MikadoField("textsimple","blog_date_in_title_ql_quote_author_margin_top","","Margin Above Quote Author (px)","This is some description");
		$row1->addChild("blog_date_in_title_ql_quote_author_margin_top",$blog_date_in_title_ql_quote_author_margin_top);

		$blog_date_in_title_ql_post_info_margin_top = new MikadoField("textsimple","blog_date_in_title_ql_post_info_margin_top","","Margin Above Post Info (px)","This is some description");
		$row1->addChild("blog_date_in_title_ql_post_info_margin_top",$blog_date_in_title_ql_post_info_margin_top);

		$post_text_styling= new MikadoTitle("post_text_styling", "Post Text Style");
		$panel3->addChild("post_text_styling", $post_text_styling);

		$group2 = new MikadoGroup("Post Title","Define title styles in this blog post template.");
		$panel3->addChild("group2",$group2);

		$row1 = new MikadoRow();
		$group2->addChild("row1",$row1);

		$blog_date_in_title_title_color = new MikadoField("colorsimple","blog_date_in_title_title_color","","Text Color","This is some description");
		$row1->addChild("blog_date_in_title_title_color",$blog_date_in_title_title_color);

		$blog_date_in_title_title_hover_color = new MikadoField("colorsimple","blog_date_in_title_title_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_date_in_title_title_hover_color",$blog_date_in_title_title_hover_color);

		$blog_date_in_title_title_date_color = new MikadoField("colorsimple","blog_date_in_title_title_date_color","","Date Color","This is some description");
		$row1->addChild("blog_date_in_title_title_date_color",$blog_date_in_title_title_date_color);

		$blog_date_in_title_title_fontsize = new MikadoField("textsimple","blog_date_in_title_title_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_date_in_title_title_fontsize",$blog_date_in_title_title_fontsize);


		$row2 = new MikadoRow(true);
		$group2->addChild("row2",$row2);

		$blog_date_in_title_title_lineheight = new MikadoField("textsimple","blog_date_in_title_title_lineheight","","Line Height (px)","This is some description");
		$row2->addChild("blog_date_in_title_title_lineheight",$blog_date_in_title_title_lineheight);

		$blog_date_in_title_title_google_fonts = new MikadoField("Fontsimple","blog_date_in_title_title_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_date_in_title_title_google_fonts",$blog_date_in_title_title_google_fonts);

		$blog_date_in_title_title_fontstyle = new MikadoField("selectblanksimple","blog_date_in_title_title_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_date_in_title_title_fontstyle",$blog_date_in_title_title_fontstyle);

		$blog_date_in_title_title_fontweight = new MikadoField("selectblanksimple","blog_date_in_title_title_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_date_in_title_title_fontweight",$blog_date_in_title_title_fontweight);

		$row3 = new MikadoRow(true);
		$group2->addChild("row3",$row3);

		$blog_date_in_title_title_texttransform = new MikadoField("selectblanksimple","blog_date_in_title_title_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row3->addChild("blog_date_in_title_title_texttransform",$blog_date_in_title_title_texttransform);

		$blog_date_in_title_title_letterspacing = new MikadoField("textsimple","blog_date_in_title_title_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_date_in_title_title_letterspacing",$blog_date_in_title_title_letterspacing);

		$group4 = new MikadoGroup("Post Info Data","Define post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list");
		$panel3->addChild("group4",$group4);

		$row1 = new MikadoRow();
		$group4->addChild("row1",$row1);

		$blog_date_in_title_info_color = new MikadoField("colorsimple","blog_date_in_title_info_color","","Text Color","This is some description");
		$row1->addChild("blog_date_in_title_info_color",$blog_date_in_title_info_color);

		$blog_date_in_title_info_link_color = new MikadoField("colorsimple","blog_date_in_title_info_link_color","","Link Color","This is some description");
		$row1->addChild("blog_date_in_title_info_link_color",$blog_date_in_title_info_link_color);

		$blog_date_in_title_info_hover_color = new MikadoField("colorsimple","blog_date_in_title_info_hover_color","","Link Hover Color","This is some description");
		$row1->addChild("blog_date_in_title_info_hover_color",$blog_date_in_title_info_hover_color);

		$blog_date_in_title_info_fontsize = new MikadoField("textsimple","blog_date_in_title_info_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_date_in_title_info_fontsize",$blog_date_in_title_info_fontsize);

		$row2 = new MikadoRow(true);
		$group4->addChild("row2",$row2);

		$blog_date_in_title_info_lineheight = new MikadoField("textsimple","blog_date_in_title_info_lineheight","","Line Height (px)","This is some description");
		$row2->addChild("blog_date_in_title_info_lineheight",$blog_date_in_title_info_lineheight);

		$blog_date_in_title_info_google_fonts = new MikadoField("Fontsimple","blog_date_in_title_info_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_date_in_title_info_google_fonts",$blog_date_in_title_info_google_fonts);

		$blog_date_in_title_info_fontstyle = new MikadoField("selectblanksimple","blog_date_in_title_info_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_date_in_title_info_fontstyle",$blog_date_in_title_info_fontstyle);

		$blog_date_in_title_info_fontweight = new MikadoField("selectblanksimple","blog_date_in_title_info_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_date_in_title_info_fontweight",$blog_date_in_title_info_fontweight);

		$row3 = new MikadoRow(true);
		$group4->addChild("row3",$row3);

		$blog_date_in_title_info_texttransform = new MikadoField("selectblanksimple","blog_date_in_title_info_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row3->addChild("blog_date_in_title_info_texttransform",$blog_date_in_title_info_texttransform);

		$blog_date_in_title_info_letterspacing = new MikadoField("textsimple","blog_date_in_title_info_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_date_in_title_info_letterspacing",$blog_date_in_title_info_letterspacing);

		$blog_date_in_title_info_border_color = new MikadoField("colorsimple","blog_date_in_title_info_border_color","","Border Color","This is some description");
		$row3->addChild("blog_date_in_title_info_border_color",$blog_date_in_title_info_border_color);

		$group3 = new MikadoGroup("Quote/Link Title Style","Define title styles for Quote/Link articles");
		$panel3->addChild("group3",$group3);

		$row1 = new MikadoRow();
		$group3->addChild("row1",$row1);

		$blog_date_in_title_ql_title_color = new MikadoField("colorsimple","blog_date_in_title_ql_title_color","","Text Color","This is some description");
		$row1->addChild("blog_date_in_title_ql_title_color",$blog_date_in_title_ql_title_color);

		$blog_date_in_title_ql_title_date_color = new MikadoField("colorsimple","blog_date_in_title_ql_title_date_color","","Date Color","This is some description");
		$row1->addChild("blog_date_in_title_ql_title_date_color",$blog_date_in_title_ql_title_date_color);

		$blog_date_in_title_ql_title_hover_color = new MikadoField("colorsimple","blog_date_in_title_ql_title_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_date_in_title_ql_title_hover_color",$blog_date_in_title_ql_title_hover_color);

		$blog_date_in_title_ql_title_fontsize = new MikadoField("textsimple","blog_date_in_title_ql_title_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_date_in_title_ql_title_font_size",$blog_date_in_title_ql_title_fontsize);


		$row2 = new MikadoRow(true);
		$group3->addChild("row2",$row2);


		$blog_date_in_title_ql_title_lineheight = new MikadoField("textsimple","blog_date_in_title_ql_title_lineheight","","Line Height (px)","This is some description");
		$row2->addChild("blog_date_in_title_ql_title_lineheight",$blog_date_in_title_ql_title_lineheight);

		$blog_date_in_title_ql_title_google_fonts = new MikadoField("Fontsimple","blog_date_in_title_ql_title_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_date_in_title_ql_title_google_fonts",$blog_date_in_title_ql_title_google_fonts);

		$blog_date_in_title_ql_title_fontstyle = new MikadoField("selectblanksimple","blog_date_in_title_ql_title_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_date_in_title_ql_title_fontstyle",$blog_date_in_title_ql_title_fontstyle);

		$blog_date_in_title_ql_title_fontweight = new MikadoField("selectblanksimple","blog_date_in_title_ql_title_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_date_in_title_ql_title_fontweight",$blog_date_in_title_ql_title_fontweight);

		$row3 = new MikadoRow(true);
		$group3->addChild("row3",$row3);

		$blog_date_in_title_ql_title_texttransform = new MikadoField("selectblanksimple","blog_date_in_title_ql_title_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row3->addChild("blog_date_in_title_ql_title_texttransform",$blog_date_in_title_ql_title_texttransform);

		$blog_date_in_title_ql_title_letterspacing = new MikadoField("textsimple","blog_date_in_title_ql_title_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_date_in_title_ql_title_letterspacing",$blog_date_in_title_ql_title_letterspacing);


		$group5 = new MikadoGroup("Quote/Link Post Info Data","Define quote/link post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list.");
		$panel3->addChild("group5",$group5);

		$row1 = new MikadoRow();
		$group5->addChild("row1",$row1);

		$blog_date_in_title_ql_info_color = new MikadoField("colorsimple","blog_date_in_title_ql_info_color","","Text Color","This is some description");
		$row1->addChild("blog_date_in_title_ql_info_color",$blog_date_in_title_ql_info_color);

		$blog_date_in_title_ql_info_link_color = new MikadoField("colorsimple","blog_date_in_title_ql_info_link_color","","Link Color","This is some description");
		$row1->addChild("blog_date_in_title_ql_info_link_color",$blog_date_in_title_ql_info_link_color);

		$blog_date_in_title_ql_info_hover_color = new MikadoField("colorsimple","blog_date_in_title_ql_info_hover_color","","Link Hover Color","This is some description");
		$row1->addChild("blog_date_in_title_ql_info_hover_color",$blog_date_in_title_ql_info_hover_color);

		$blog_date_in_title_ql_info_fontsize = new MikadoField("textsimple","blog_date_in_title_ql_info_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_date_in_title_ql_info_fontsize",$blog_date_in_title_ql_info_fontsize);



		$row2 = new MikadoRow(true);
		$group5->addChild("row2",$row2);

		$blog_date_in_title_ql_info_lineheight = new MikadoField("textsimple","blog_date_in_title_ql_info_lineheight","","Line Height (px)","This is some description");
		$row2->addChild("blog_date_in_title_ql_info_lineheight",$blog_date_in_title_ql_info_lineheight);

		$blog_date_in_title_ql_info_google_fonts = new MikadoField("Fontsimple","blog_date_in_title_ql_info_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_date_in_title_ql_info_google_fonts",$blog_date_in_title_ql_info_google_fonts);

		$blog_date_in_title_ql_info_fontstyle = new MikadoField("selectblanksimple","blog_date_in_title_ql_info_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_date_in_title_ql_info_fontstyle",$blog_date_in_title_ql_info_fontstyle);

		$blog_date_in_title_ql_info_fontweight = new MikadoField("selectblanksimple","blog_date_in_title_ql_info_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_date_in_title_ql_info_fontweight",$blog_date_in_title_ql_info_fontweight);

		$row3 = new MikadoRow(true);
		$group5->addChild("row3",$row3);

		$blog_date_in_title_ql_info_texttransform = new MikadoField("selectblanksimple","blog_date_in_title_ql_info_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row3->addChild("blog_date_in_title_ql_info_texttransform",$blog_date_in_title_ql_info_texttransform);

		$blog_date_in_title_ql_info_letterspacing = new MikadoField("textsimple","blog_date_in_title_ql_info_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_date_in_title_ql_info_letterspacing",$blog_date_in_title_ql_info_letterspacing);

		$blog_date_in_title_ql_info_border_color = new MikadoField("colorsimple","blog_date_in_title_ql_info_border_color","","Border Color","This is some description");
		$row3->addChild("blog_date_in_title_ql_info_border_color",$blog_date_in_title_ql_info_border_color);

		$blog_date_in_title_ql_info_border_hover_color = new MikadoField("colorsimple","blog_date_in_title_ql_info_border_hover_color","","Hover Border Color","This is some description");
		$row3->addChild("blog_date_in_title_ql_info_border_hover_color",$blog_date_in_title_ql_info_border_hover_color);


		$group6 = new MikadoGroup("Quote Author Style","Define author styles for Quote articles");
		$panel3->addChild("group6",$group6);

		$row1 = new MikadoRow();
		$group6->addChild("row1",$row1);


		$blog_date_in_title_ql_author_color = new MikadoField("colorsimple","blog_date_in_title_ql_author_color","","Text Color","This is some description");
		$row1->addChild("blog_date_in_title_ql_author_color",$blog_date_in_title_ql_author_color);

		$blog_date_in_title_ql_author_hover_color = new MikadoField("colorsimple","blog_date_in_title_ql_author_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_date_in_title_ql_author_hover_color",$blog_date_in_title_ql_author_hover_color);

		$blog_date_in_title_ql_author_fontsize = new MikadoField("textsimple","blog_date_in_title_ql_author_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_date_in_title_ql_author_font_size",$blog_date_in_title_ql_author_fontsize);

		$blog_date_in_title_ql_author_lineheight = new MikadoField("textsimple","blog_date_in_title_ql_author_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_date_in_title_ql_author_lineheight",$blog_date_in_title_ql_author_lineheight);

		$row2 = new MikadoRow(true);
		$group6->addChild("row2",$row2);

		$blog_date_in_title_ql_author_texttransform = new MikadoField("selectblanksimple","blog_date_in_title_ql_author_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_date_in_title_ql_author_texttransform",$blog_date_in_title_ql_author_texttransform);

		$blog_date_in_title_ql_author_google_fonts = new MikadoField("Fontsimple","blog_date_in_title_ql_author_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_date_in_title_ql_author_google_fonts",$blog_date_in_title_ql_author_google_fonts);

		$blog_date_in_title_ql_author_fontstyle = new MikadoField("selectblanksimple","blog_date_in_title_ql_author_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_date_in_title_ql_author_fontstyle",$blog_date_in_title_ql_author_fontstyle);

		$blog_date_in_title_ql_author_fontweight = new MikadoField("selectblanksimple","blog_date_in_title_ql_author_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_date_in_title_ql_author_fontweight",$blog_date_in_title_ql_author_fontweight);

		$row3 = new MikadoRow(true);
		$group6->addChild("row3",$row3);


		$blog_date_in_title_ql_author_letterspacing = new MikadoField("textsimple","blog_date_in_title_ql_author_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_date_in_title_ql_author_letterspacing",$blog_date_in_title_ql_author_letterspacing);

		// Blog Post List - Blog: Category & Title First (Centered)
		$panel4 = new MikadoPanel("Blog List Template Options: Category & Title First (Centered)","blog_category_title_first_centered_post_lists", "blog_category_title_first_centered_show_options", "no");
		$blogPage->addChild("panel4",$panel4);

		$blog_category_title_first_centered_number_of_chars = new MikadoField("text","blog_category_title_first_centered_number_of_chars","45","Number of Words in Excerpt",' Enter a number of words in excerpt (article summary)', array(), array("col_width" => 3));
		$panel4->addChild("blog_category_title_first_centered_number_of_chars",$blog_category_title_first_centered_number_of_chars);

		$blog_category_title_first_centered_read_more_button = new MikadoField("yesno","blog_category_title_first_centered_read_more_button","no","Read More Button","Enable Read More Button");
		$panel4->addChild("blog_category_title_first_centered_read_more_button",$blog_category_title_first_centered_read_more_button);

		$blog_category_title_first_centered_content_position = new MikadoField("select","blog_category_title_first_centered_content_position","content_above_blog_list","Content Position","Choose content position for blog list template when sidebar is enabled. Note: This settings in only for template, not for archive pages", array(
			"content_above_blog_list" => "Content Above Blog List",
			"content_above_blog_list_and_sidebar" => "Content Above Blog List and Sidebar"
		));
		$panel4->addChild("blog_category_title_first_centered_content_position", $blog_category_title_first_centered_content_position);

		$blog_category_title_first_centered_post_meta_data_section = new MikadoTitle("blog_category_title_first_centered_post_meta_data_section", "Post Info Data Fields");
		$panel4->addChild("blog_category_title_first_centered_post_meta_data_section", $blog_category_title_first_centered_post_meta_data_section);

		$blog_category_title_first_centered_show_categories = new MikadoField("yesno","blog_category_title_first_centered_show_categories","yes","Show Categories","Enabling this option will Show Categories on Post List");
		$panel4->addChild("blog_category_title_first_centered_show_categories",$blog_category_title_first_centered_show_categories);

		$blog_category_title_first_centered_show_comments = new MikadoField("yesno","blog_category_title_first_centered_show_comments","yes","Show Comments","Enabling this option will Show Comments on Post List");
		$panel4->addChild("blog_category_title_first_centered_show_comments",$blog_category_title_first_centered_show_comments);

		$blog_category_title_first_centered_show_author = new MikadoField("yesno","blog_category_title_first_centered_show_author","yes","Show Author Name","Enabling this option will show author name on Post List and Blog Post Single");
		$panel4->addChild("blog_category_title_first_centered_show_author",$blog_category_title_first_centered_show_author);

		$blog_category_title_first_centered_show_date = new MikadoField("yesno","blog_category_title_first_centered_show_date","yes","Show Date","Enabling this option will show date on Post List");
		$panel4->addChild("blog_category_title_first_centered_hide_date",$blog_category_title_first_centered_show_date);

		$blog_category_title_first_centered_show_share = new MikadoField("yesno","blog_category_title_first_centered_show_share","no","Show Share","Enabling this option will show share on Post List", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_category_title_first_centered_share_options_container"));
		$panel4->addChild("blog_category_title_first_centered_show_share",$blog_category_title_first_centered_show_share);

		$blog_category_title_first_centered_share_options_container = new MikadoContainer("blog_category_title_first_centered_share_options_container","blog_category_title_first_centered_show_share","no");
		$panel4->addChild("blog_category_title_first_centered_share_options_container",$blog_category_title_first_centered_share_options_container);

		$blog_category_title_first_centered_share_icon_color = new MikadoField("color","blog_category_title_first_centered_share_icon_color","","Icon Color","Choose icon color for share dropdown");
		$blog_category_title_first_centered_share_options_container->addChild("blog_category_title_first_centered_share_icon_color",$blog_category_title_first_centered_share_icon_color);

		$blog_category_title_first_centered_share_icon_hover_color = new MikadoField("color","blog_category_title_first_centered_share_icon_hover_color","","Icon Hover Color","Choose icon hover color for share dropdown");
		$blog_category_title_first_centered_share_options_container->addChild("blog_category_title_first_centered_share_icon_hover_color",$blog_category_title_first_centered_share_icon_hover_color);

		$blog_category_title_first_centered_share_background_color = new MikadoField("color","blog_category_title_first_centered_share_background_color","","Background Color","Choose background color for share dropdown list field");
		$blog_category_title_first_centered_share_options_container->addChild("blog_category_title_first_centered_share_background_color",$blog_category_title_first_centered_share_background_color);

		$blog_category_title_first_centered_like = new MikadoField("yesno","blog_category_title_first_centered_like","yes","Show Likes",'Enabling this option will turn on "Likes"');
		$panel4->addChild("blog_category_title_first_centered_like",$blog_category_title_first_centered_like);

		$blog_category_title_first_centered_post_design_style = new MikadoTitle("blog_category_title_first_centered_post_design_style", "Post Design Style");
		$panel4->addChild("blog_category_title_first_centered_post_design_style", $blog_category_title_first_centered_post_design_style);

		$group1 = new MikadoGroup("Separator","Define style for separator used in post between Category Name and Title");
		$panel4->addChild("group1",$group1);

		$row1 = new MikadoRow();
		$group1->addChild("row1",$row1);

		$blog_category_title_first_centered_separator_border_color = new MikadoField("colorsimple","blog_category_title_first_centered_separator_border_color","","Separator Color","This is some description");
		$row1->addChild("blog_category_title_first_centered_separator_border_color",$blog_category_title_first_centered_separator_border_color);

		$blog_category_title_first_centered_separator_width = new MikadoField("textsimple","blog_category_title_first_centered_separator_width","","Separator Width (px)","This is some description");
		$row1->addChild("blog_category_title_first_centered_separator_width", $blog_category_title_first_centered_separator_width);

		$blog_category_title_first_centered_separator_thickness = new MikadoField("textsimple","blog_category_title_first_centered_separator_thickness","","Separator Thickness (px)","This is some description");
		$row1->addChild("blog_category_title_first_centered_separator_thickness", $blog_category_title_first_centered_separator_thickness);

		$blog_category_title_first_centered_enable_text_box = new MikadoField("yesno","blog_category_title_first_centered_enable_text_box","no","Enable Boxed Styled Post Content","Enable post text boxed features", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_category_title_first_centered_enable_text_box_container"));
		$panel4->addChild("blog_category_title_first_centered_enable_text_box",$blog_category_title_first_centered_enable_text_box);

		$blog_category_title_first_centered_enable_text_box_container = new MikadoContainer("blog_category_title_first_centered_enable_text_box_container","blog_date_in_title_enable_text_box","no");
		$panel4->addChild("blog_category_title_first_centered_enable_text_box_container",$blog_category_title_first_centered_enable_text_box_container);

		$blog_category_title_first_centered_box_background_color = new MikadoField("color","blog_category_title_first_centered_box_background_color","","Background Color","Choose background color for post text box");
		$blog_category_title_first_centered_enable_text_box_container->addChild("blog_category_title_first_centered_box_background_color",$blog_category_title_first_centered_box_background_color);

		$blog_category_title_first_centered_box_border_color = new MikadoField("color","blog_category_title_first_centered_box_border_color","","Border Color","Choose border color for post text box");
		$blog_category_title_first_centered_enable_text_box_container->addChild("blog_category_title_first_centered_box_border_color",$blog_category_title_first_centered_box_border_color);

		$blog_category_title_first_centered_box_padding = new MikadoField("text","blog_category_title_first_centered_box_padding","","Text box padding","Please insert padding in format (top right bottom left) i.e. 5px 5px 5px 5px", array(), array("col_width" => 3));
		$blog_category_title_first_centered_enable_text_box_container->addChild("blog_category_title_first_centered_box_padding",$blog_category_title_first_centered_box_padding);

		$group2 = new MikadoGroup("Quote/Link Background","Set background of Quote/Link post type");
		$panel4->addChild("group2",$group2);

		$row1 = new MikadoRow();
		$group2->addChild("row1",$row1);

		$blog_category_title_first_centered_ql_background_image = new MikadoField("yesnosimple","blog_category_title_first_centered_ql_background_image","no","Background Image","");
		$row1->addChild("blog_category_title_first_centered_ql_background_image",$blog_category_title_first_centered_ql_background_image);

		$blog_category_title_first_centered_ql_background_color = new MikadoField("colorsimple","blog_category_title_first_centered_ql_background_color","","Background Color","Default color is #ffffff.");
		$row1->addChild("blog_category_title_first_centered_ql_background_color",$blog_category_title_first_centered_ql_background_color);

		$blog_category_title_first_centered_ql_hover_background_color = new MikadoField("colorsimple","blog_category_title_first_centered_ql_hover_background_color","","Background Hover Color","Default color is #e6ae48.");
		$row1->addChild("blog_category_title_first_centered_ql_hover_background_color",$blog_category_title_first_centered_ql_hover_background_color);

		$blog_category_title_first_centered_show_ql_mark = new MikadoField("yesno","blog_category_title_first_centered_show_ql_mark","yes","Enable Quote/Link Icon","Show Icons for Quote/Link Post Format", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_category_title_first_centered_show_ql_mark_container"));
		$panel4->addChild("blog_category_title_first_centered_show_ql_mark",$blog_category_title_first_centered_show_ql_mark);

		$blog_category_title_first_centered_show_ql_mark_container = new MikadoContainer("blog_category_title_first_centered_show_ql_mark_container","blog_category_title_first_centered_show_ql_mark","no");
		$panel4->addChild("blog_category_title_first_centered_show_ql_mark_container",$blog_category_title_first_centered_show_ql_mark_container);

		$row1 = new MikadoRow();
		$blog_category_title_first_centered_show_ql_mark_container->addChild("row1",$row1);

		$blog_category_title_first_centered_ql_mark_color = new MikadoField("color","blog_category_title_first_centered_ql_mark_color","","Icon Color","Choose icon color for quote/link post.");
		$row1->addChild("blog_category_title_first_centered_ql_mark_color",$blog_category_title_first_centered_ql_mark_color);

		$blog_category_title_first_centered_ql_mark_hover_color = new MikadoField("color","blog_category_title_first_centered_ql_mark_hover_color","","Icon Hover Color","Choose hover icon color for quote/link post.");
		$row1->addChild("blog_category_title_first_centered_ql_mark_hover_color",$blog_category_title_first_centered_ql_mark_hover_color);

		$group9 = new MikadoGroup("Blog List Spacing","Set spacing for blog layouts");
		$panel4->addChild("group9",$group9);

		$row1 = new MikadoRow();
		$group9->addChild("row1",$row1);

		$blog_category_title_first_centered_category_margin_bottom = new MikadoField("textsimple","blog_category_title_first_centered_category_margin_bottom","","Margin Under Category (px)","This is some description");
		$row1->addChild("blog_category_title_first_centered_category_margin_bottom",$blog_category_title_first_centered_category_margin_bottom);

		$blog_category_title_first_centered_image_margin_bottom = new MikadoField("textsimple","blog_category_title_first_centered_image_margin_bottom","","Margin Under Image (px)","This is some description");
		$row1->addChild("blog_category_title_first_centered_image_margin_bottom",$blog_category_title_first_centered_image_margin_bottom);

		$blog_category_title_first_centered_title_margin_bottom = new MikadoField("textsimple","blog_category_title_first_centered_title_margin_bottom","","Margin Under Title (px)","This is some description");
		$row1->addChild("blog_category_title_first_centered_title_margin_bottom",$blog_category_title_first_centered_title_margin_bottom);

		$blog_category_title_first_centered_post_info_margin_top = new MikadoField("textsimple","blog_category_title_first_centered_post_info_margin_top","","Margin Above Post Info (px)","This is some description");
		$row1->addChild("blog_category_title_first_centered_post_info_margin_top",$blog_category_title_first_centered_post_info_margin_top);

		$row2 = new MikadoRow();
		$group9->addChild("row2",$row2);

		$blog_category_title_first_centered_article_margin_bottom = new MikadoField("textsimple","blog_category_title_first_centered_article_margin_bottom","","Margin Between Articles (px)","This is some description");
		$row2->addChild("blog_category_title_first_centered_article_margin_bottom",$blog_category_title_first_centered_article_margin_bottom);

		$group10 = new MikadoGroup("Blog List Spacing for Quote and Link Post Type","Set spacing for blog layouts");
		$panel4->addChild("group10",$group10);

		$row1 = new MikadoRow();
		$group10->addChild("row1",$row1);

		$blog_category_title_first_centered_ql_quote_author_margin_top = new MikadoField("textsimple","blog_category_title_first_centered_ql_quote_author_margin_top","","Margin Above Quote Author (px)","This is some description");
		$row1->addChild("blog_category_title_first_centered_ql_quote_author_margin_top",$blog_category_title_first_centered_ql_quote_author_margin_top);

		$blog_category_title_first_centered_ql_icon_margin_top = new MikadoField("textsimple","blog_category_title_first_centered_ql_icon_margin_top","","Margin Above Post Info Link/Quote Icon (px)","This is some description");
		$row1->addChild("blog_category_title_first_centered_ql_icon_margin_top",$blog_category_title_first_centered_ql_icon_margin_top);

		$blog_category_title_first_centered_ql_post_info_margin_top = new MikadoField("textsimple","blog_category_title_first_centered_ql_post_info_margin_top","","Margin Above Post Info (px)","This is some description");
		$row1->addChild("blog_category_title_first_centered_ql_post_info_margin_top",$blog_category_title_first_centered_ql_post_info_margin_top);

		$post_text_styling= new MikadoTitle("post_text_styling", "Post Text Style");
		$panel4->addChild("post_text_styling", $post_text_styling);

		$group3 = new MikadoGroup("Post Title","Define title styles in this blog post template.");
		$panel4->addChild("group3",$group3);

		$row1 = new MikadoRow();
		$group3->addChild("row1",$row1);

		$blog_category_title_first_centered_title_color = new MikadoField("colorsimple","blog_category_title_first_centered_title_color","","Text Color","This is some description");
		$row1->addChild("blog_category_title_first_centered_title_color",$blog_category_title_first_centered_title_color);

		$blog_category_title_first_centered_title_hover_color = new MikadoField("colorsimple","blog_category_title_first_centered_title_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_category_title_first_centered_title_hover_color",$blog_category_title_first_centered_title_hover_color);

		$blog_category_title_first_centered_title_fontsize = new MikadoField("textsimple","blog_category_title_first_centered_title_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_category_title_first_centered_title_fontsize",$blog_category_title_first_centered_title_fontsize);

		$blog_category_title_first_centered_title_lineheight = new MikadoField("textsimple","blog_category_title_first_centered_title_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_category_title_first_centered_title_lineheight",$blog_category_title_first_centered_title_lineheight);

		$row2 = new MikadoRow(true);
		$group3->addChild("row2",$row2);

		$blog_category_title_first_centered_title_texttransform = new MikadoField("selectblanksimple","blog_category_title_first_centered_title_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_category_title_first_centered_title_texttransform",$blog_category_title_first_centered_title_texttransform);

		$blog_category_title_first_centered_title_google_fonts = new MikadoField("Fontsimple","blog_category_title_first_centered_title_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_category_title_first_centered_title_google_fonts",$blog_category_title_first_centered_title_google_fonts);

		$blog_category_title_first_centered_title_fontstyle = new MikadoField("selectblanksimple","blog_category_title_first_centered_title_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_category_title_first_centered_title_fontstyle",$blog_category_title_first_centered_title_fontstyle);

		$blog_category_title_first_centered_title_fontweight = new MikadoField("selectblanksimple","blog_category_title_first_centered_title_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_category_title_first_centered_title_fontweight",$blog_category_title_first_centered_title_fontweight);

		$row3 = new MikadoRow(true);
		$group3->addChild("row3",$row3);

		$blog_category_title_first_centered_title_letterspacing = new MikadoField("textsimple","blog_category_title_first_centered_title_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_category_title_first_centered_title_letterspacing",$blog_category_title_first_centered_title_letterspacing);

		$group4 = new MikadoGroup("Post Info Data","Define post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list");
		$panel4->addChild("group4",$group4);

		$row1 = new MikadoRow();
		$group4->addChild("row1",$row1);

		$blog_category_title_first_centered_info_color = new MikadoField("colorsimple","blog_category_title_first_centered_info_color","","Text Color","This is some description");
		$row1->addChild("blog_category_title_first_centered_info_color",$blog_category_title_first_centered_info_color);

		$blog_category_title_first_centered_info_link_color = new MikadoField("colorsimple","blog_category_title_first_centered_info_link_color","","Link Color","This is some description");
		$row1->addChild("blog_category_title_first_centered_info_link_color",$blog_category_title_first_centered_info_link_color);

		$blog_category_title_first_centered_info_hover_color = new MikadoField("colorsimple","blog_category_title_first_centered_info_hover_color","","Link Hover Color","This is some description");
		$row1->addChild("blog_category_title_first_centered_info_hover_color",$blog_category_title_first_centered_info_hover_color);


		$blog_category_title_first_centered_info_fontsize = new MikadoField("textsimple","blog_category_title_first_centered_info_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_category_title_first_centered_info_font_size",$blog_category_title_first_centered_info_fontsize);

		$row2 = new MikadoRow(true);
		$group4->addChild("row2",$row2);


		$blog_category_title_first_centered_info_lineheight = new MikadoField("textsimple","blog_category_title_first_centered_info_lineheight","","Line Height (px)","This is some description");
		$row2->addChild("blog_category_title_first_centered_info_lineheight",$blog_category_title_first_centered_info_lineheight);

		$blog_category_title_first_centered_info_google_fonts = new MikadoField("Fontsimple","blog_category_title_first_centered_info_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_category_title_first_centered_info_google_fonts",$blog_category_title_first_centered_info_google_fonts);

		$blog_category_title_first_centered_info_fontstyle = new MikadoField("selectblanksimple","blog_category_title_first_centered_info_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_category_title_first_centered_info_fontstyle",$blog_category_title_first_centered_info_fontstyle);

		$blog_category_title_first_centered_info_fontweight = new MikadoField("selectblanksimple","blog_category_title_first_centered_info_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_category_title_first_centered_info_fontweight",$blog_category_title_first_centered_info_fontweight);

		$row3 = new MikadoRow(true);
		$group4->addChild("row3",$row3);

		$blog_category_title_first_centered_info_texttransform = new MikadoField("selectblanksimple","blog_category_title_first_centered_info_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row3->addChild("blog_category_title_first_centered_info_texttransform",$blog_category_title_first_centered_info_texttransform);

		$blog_category_title_first_centered_info_letterspacing = new MikadoField("textsimple","blog_category_title_first_centered_info_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_category_title_first_centered_info_letterspacing",$blog_category_title_first_centered_info_letterspacing);

		$blog_category_title_first_centered_info_border_color = new MikadoField("colorsimple","blog_category_title_first_centered_info_border_color","","Border Color","This is some description");
		$row3->addChild("blog_category_title_first_centered_info_border_color",$blog_category_title_first_centered_info_border_color);

		$group5 = new MikadoGroup("Post Category","Define category styles in this blog post template.");
		$panel4->addChild("group5",$group5);

		$row1 = new MikadoRow();
		$group5->addChild("row1",$row1);

		$blog_category_title_first_centered_category_color = new MikadoField("colorsimple","blog_category_title_first_centered_category_color","","Text Color","This is some description");
		$row1->addChild("blog_category_title_first_centered_category_color",$blog_category_title_first_centered_category_color);

		$blog_category_title_first_centered_category_hover_color = new MikadoField("colorsimple","blog_category_title_first_centered_category_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_category_title_first_centered_category_hover_color",$blog_category_title_first_centered_category_hover_color);

		$blog_category_title_first_centered_category_fontsize = new MikadoField("textsimple","blog_category_title_first_centered_category_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_category_title_first_centered_category_fontsize",$blog_category_title_first_centered_category_fontsize);

		$blog_category_title_first_centered_category_lineheight = new MikadoField("textsimple","blog_category_title_first_centered_category_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_category_title_first_centered_category_lineheight",$blog_category_title_first_centered_category_lineheight);

		$row2 = new MikadoRow(true);
		$group5->addChild("row2",$row2);

		$blog_category_title_first_centered_category_texttransform = new MikadoField("selectblanksimple","blog_category_title_first_centered_category_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_category_title_first_centered_category_texttransform",$blog_category_title_first_centered_category_texttransform);

		$blog_category_title_first_centered_category_google_fonts = new MikadoField("Fontsimple","blog_category_title_first_centered_category_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_category_title_first_centered_category_google_fonts",$blog_category_title_first_centered_category_google_fonts);

		$blog_category_title_first_centered_category_fontstyle = new MikadoField("selectblanksimple","blog_category_title_first_centered_category_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_category_title_first_centered_category_fontstyle",$blog_category_title_first_centered_category_fontstyle);

		$blog_category_title_first_centered_category_fontweight = new MikadoField("selectblanksimple","blog_category_title_first_centered_category_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_category_title_first_centered_category_fontweight",$blog_category_title_first_centered_category_fontweight);

		$row3 = new MikadoRow(true);
		$group5->addChild("row3",$row3);

		$blog_category_title_first_centered_category_letterspacing = new MikadoField("textsimple","blog_category_title_first_centered_category_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_category_title_first_centered_category_letterspacing",$blog_category_title_first_centered_category_letterspacing);


		$group6 = new MikadoGroup("Quote/Link Title Style","Define title styles for Quote/Link articles");
		$panel4->addChild("group6",$group6);

		$row1 = new MikadoRow();
		$group6->addChild("row1",$row1);

		$blog_category_title_first_centered_ql_title_color = new MikadoField("colorsimple","blog_category_title_first_centered_ql_title_color","","Text Color","This is some description");
		$row1->addChild("blog_category_title_first_centered_ql_title_color",$blog_category_title_first_centered_ql_title_color);

		$blog_category_title_first_centered_ql_title_hover_color = new MikadoField("colorsimple","blog_category_title_first_centered_ql_title_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_category_title_first_centered_ql_title_hover_color",$blog_category_title_first_centered_ql_title_hover_color);

		$blog_category_title_first_centered_ql_title_fontsize = new MikadoField("textsimple","blog_category_title_first_centered_ql_title_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_category_title_first_centered_ql_title_fontsize",$blog_category_title_first_centered_ql_title_fontsize);

		$blog_category_title_first_centered_ql_title_lineheight = new MikadoField("textsimple","blog_category_title_first_centered_ql_title_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_category_title_first_centered_ql_title_lineheight",$blog_category_title_first_centered_ql_title_lineheight);

		$row2 = new MikadoRow(true);
		$group6->addChild("row2",$row2);

		$blog_category_title_first_centered_ql_title_texttransform = new MikadoField("selectblanksimple","blog_category_title_first_centered_ql_title_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_category_title_first_centered_ql_title_texttransform",$blog_category_title_first_centered_ql_title_texttransform);

		$blog_category_title_first_centered_ql_title_fontfamily = new MikadoField("Fontsimple","blog_category_title_first_centered_ql_title_fontfamily","-1","Font Family","This is some description");
		$row2->addChild("blog_category_title_first_centered_ql_title_fontfamily",$blog_category_title_first_centered_ql_title_fontfamily);

		$blog_category_title_first_centered_ql_title_fontstyle = new MikadoField("selectblanksimple","blog_category_title_first_centered_ql_title_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_category_title_first_centered_ql_title_fontstyle",$blog_category_title_first_centered_ql_title_fontstyle);

		$blog_category_title_first_centered_ql_title_fontweight = new MikadoField("selectblanksimple","blog_category_title_first_centered_ql_title_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_category_title_first_centered_ql_title_fontweight",$blog_category_title_first_centered_ql_title_fontweight);

		$row3 = new MikadoRow(true);
		$group6->addChild("row3",$row3);

		$blog_category_title_first_centered_ql_title_letterspacing = new MikadoField("textsimple","blog_category_title_first_centered_ql_title_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_category_title_first_centered_ql_title_letterspacing",$blog_category_title_first_centered_ql_title_letterspacing);

		$group7 = new MikadoGroup("Quote/Link Post Info Data","Define quote/link post info text styles (date, category names, etc.) Note: Single Posts will take the same styles as in list.");
		$panel4->addChild("group7",$group7);

		$row1 = new MikadoRow();
		$group7->addChild("row1",$row1);

		$blog_category_title_first_centered_ql_info_color = new MikadoField("colorsimple","blog_category_title_first_centered_ql_info_color","","Text Color","This is some description");
		$row1->addChild("blog_category_title_first_centered_ql_info_color",$blog_category_title_first_centered_ql_info_color);

		$blog_category_title_first_centered_ql_info_link_color = new MikadoField("colorsimple","blog_category_title_first_centered_ql_info_link_color","","Link Color","This is some description");
		$row1->addChild("blog_category_title_first_centered_ql_info_link_color",$blog_category_title_first_centered_ql_info_link_color);

		$blog_category_title_first_centered_ql_info_hover_color = new MikadoField("colorsimple","blog_category_title_first_centered_ql_info_hover_color","","Link Hover Color","This is some description");
		$row1->addChild("blog_category_title_first_centered_ql_info_info_color",$blog_category_title_first_centered_ql_info_hover_color);

		$blog_category_title_first_centered_ql_info_fontsize = new MikadoField("textsimple","blog_category_title_first_centered_ql_info_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_category_title_first_centered_ql_info_fontsize",$blog_category_title_first_centered_ql_info_fontsize);



		$row2 = new MikadoRow(true);
		$group7->addChild("row2",$row2);

		$blog_category_title_first_centered_ql_info_lineheight = new MikadoField("textsimple","blog_category_title_first_centered_ql_info_lineheight","","Line Height (px)","This is some description");
		$row2->addChild("blog_category_title_first_centered_ql_info_lineheight",$blog_category_title_first_centered_ql_info_lineheight);

		$blog_category_title_first_centered_ql_info_google_fonts = new MikadoField("Fontsimple","blog_category_title_first_centered_ql_info_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_category_title_first_centered_ql_info_google_fonts",$blog_category_title_first_centered_ql_info_google_fonts);

		$blog_category_title_first_centered_ql_info_fontstyle = new MikadoField("selectblanksimple","blog_category_title_first_centered_ql_info_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_category_title_first_centered_ql_info_fontstyle",$blog_category_title_first_centered_ql_info_fontstyle);

		$blog_category_title_first_centered_ql_info_fontweight = new MikadoField("selectblanksimple","blog_category_title_first_centered_ql_info_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_category_title_first_centered_ql_info_fontweight",$blog_category_title_first_centered_ql_info_fontweight);

		$row3 = new MikadoRow(true);
		$group7->addChild("row3",$row3);

		$blog_category_title_first_centered_ql_info_texttransform = new MikadoField("selectblanksimple","blog_category_title_first_centered_ql_info_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row3->addChild("blog_category_title_first_centered_ql_info_texttransform",$blog_category_title_first_centered_ql_info_texttransform);

		$blog_category_title_first_centered_ql_info_letterspacing = new MikadoField("textsimple","blog_category_title_first_centered_ql_info_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_category_title_first_centered_ql_info_letterspacing",$blog_category_title_first_centered_ql_info_letterspacing);

		$blog_category_title_first_centered_ql_info_border_color = new MikadoField("colorsimple","blog_category_title_first_centered_ql_info_border_color","","Border Color","This is some description");
		$row3->addChild("blog_category_title_first_centered_ql_info_border_color",$blog_category_title_first_centered_ql_info_border_color);

		$blog_category_title_first_centered_ql_info_border_hover_color = new MikadoField("colorsimple","blog_category_title_first_centered_ql_info_border_hover_color","","Border Hover Color","This is some description");
		$row3->addChild("blog_category_title_first_centered_ql_info_border_hover_color",$blog_category_title_first_centered_ql_info_border_hover_color);

		$group8 = new MikadoGroup("Quote Author Style","Define author styles for Quote articles");
		$panel4->addChild("group8",$group8);

		$row1 = new MikadoRow();
		$group8->addChild("row1",$row1);

		$blog_category_title_first_centered_ql_author_color = new MikadoField("colorsimple","blog_category_title_first_centered_ql_author_color","","Text Color","This is some description");
		$row1->addChild("blog_category_title_first_centered_ql_author_color",$blog_category_title_first_centered_ql_author_color);

		$blog_category_title_first_centered_ql_author_hover_color = new MikadoField("colorsimple","blog_category_title_first_centered_ql_author_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_category_title_first_centered_ql_author_hover_color",$blog_category_title_first_centered_ql_author_hover_color);

		$blog_category_title_first_centered_ql_author_fontsize = new MikadoField("textsimple","blog_category_title_first_centered_ql_author_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_category_title_first_centered_ql_author_fontsize",$blog_category_title_first_centered_ql_author_fontsize);

		$blog_category_title_first_centered_ql_author_lineheight = new MikadoField("textsimple","blog_category_title_first_centered_ql_author_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_category_title_first_centered_ql_author_lineheight",$blog_category_title_first_centered_ql_author_lineheight);

		$row2 = new MikadoRow(true);
		$group8->addChild("row2",$row2);

		$blog_category_title_first_centered_ql_author_texttransform = new MikadoField("selectblanksimple","blog_category_title_first_centered_ql_author_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_category_title_first_centered_ql_author_texttransform",$blog_category_title_first_centered_ql_author_texttransform);

		$blog_category_title_first_centered_ql_author_fontfamily = new MikadoField("Fontsimple","blog_category_title_first_centered_ql_author_fontfamily","-1","Font Family","This is some description");
		$row2->addChild("blog_category_title_first_centered_ql_author_fontfamily",$blog_category_title_first_centered_ql_author_fontfamily);

		$blog_category_title_first_centered_ql_author_fontstyle = new MikadoField("selectblanksimple","blog_category_title_first_centered_ql_author_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_category_title_first_centered_ql_author_fontstyle",$blog_category_title_first_centered_ql_author_fontstyle);

		$blog_category_title_first_centered_ql_author_fontweight = new MikadoField("selectblanksimple","blog_category_title_first_centered_ql_author_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_category_title_first_centered_ql_author_fontweight",$blog_category_title_first_centered_ql_author_fontweight);

		$row3 = new MikadoRow(true);
		$group8->addChild("row3",$row3);

		$blog_category_title_first_centered_ql_author_letterspacing = new MikadoField("textsimple","blog_category_title_first_centered_ql_author_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_category_title_first_centered_ql_author_letterspacing",$blog_category_title_first_centered_ql_author_letterspacing);

		// Blog Post List - Blog: Post Info Vertical - Content
		$panel5 = new MikadoPanel("Blog List Template Options: Post Info Vertical - Content","blog_post_info_vertical_content_post_lists", "blog_post_info_vertical_content_show_options", "no");
		$blogPage->addChild("panel5",$panel5);

		$blog_post_info_vertical_content_number_of_chars = new MikadoField("text","blog_post_info_vertical_content_number_of_chars","45","Number of Words in Excerpt",' Enter a number of words in excerpt (article summary)', array(), array("col_width" => 3));
		$panel5->addChild("blog_post_info_vertical_content_number_of_chars",$blog_post_info_vertical_content_number_of_chars);

		$blog_post_info_vertical_content_read_more_button = new MikadoField("yesno","blog_post_info_vertical_content_read_more_button","no","Read More Button","Enable Read More Button");
		$panel5->addChild("blog_post_info_vertical_content_read_more_button",$blog_post_info_vertical_content_read_more_button);

		$blog_post_info_vertical_content_content_position = new MikadoField("select","blog_post_info_vertical_content_content_position","content_above_blog_list","Content Position","Choose content position for blog list template when sidebar is enabled. Note: This settings in only for template, not for archive pages", array(
			"content_above_blog_list" => "Content Above Blog List",
			"content_above_blog_list_and_sidebar" => "Content Above Blog List and Sidebar"
		));
		$panel5->addChild("blog_post_info_vertical_content_content_position", $blog_post_info_vertical_content_content_position);

		$blog_post_info_vertical_content_post_meta_data_section = new MikadoTitle("blog_post_info_vertical_content_post_meta_data_section", "Post Info Data Fields");
		$panel5->addChild("blog_post_info_vertical_content_post_meta_data_section", $blog_post_info_vertical_content_post_meta_data_section);

		$blog_post_info_vertical_content_show_categories = new MikadoField("yesno","blog_post_info_vertical_content_show_categories","yes","Show Categories","Enabling this option will Show Categories on Post List");
		$panel5->addChild("blog_post_info_vertical_content_show_categories",$blog_post_info_vertical_content_show_categories);

		$blog_post_info_vertical_content_show_comments = new MikadoField("yesno","blog_post_info_vertical_content_show_comments","yes","Show Comments","Enabling this option will Show Comments on Post List");
		$panel5->addChild("blog_post_info_vertical_content_show_comments",$blog_post_info_vertical_content_show_comments);

		$blog_post_info_vertical_content_show_author = new MikadoField("yesno","blog_post_info_vertical_content_show_author","yes","Show Author Name","Enabling this option will show author name on Post List and Blog Post Single");
		$panel5->addChild("blog_post_info_vertical_content_show_author",$blog_post_info_vertical_content_show_author);

		$blog_post_info_vertical_content_show_date = new MikadoField("yesno","blog_post_info_vertical_content_show_date","yes","Show Date","Enabling this option will show date on Post List");
		$panel5->addChild("blog_post_info_vertical_content_hide_date",$blog_post_info_vertical_content_show_date);

		$blog_post_info_vertical_content_show_share = new MikadoField("yesno","blog_post_info_vertical_content_show_share","no","Show Share","Enabling this option will show share on Post List", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_post_info_vertical_content_share_options_container"));
		$panel5->addChild("blog_post_info_vertical_content_show_share",$blog_post_info_vertical_content_show_share);

		$blog_post_info_vertical_content_share_options_container = new MikadoContainer("blog_post_info_vertical_content_share_options_container","blog_post_info_vertical_content_show_share","no");
		$panel5->addChild("blog_post_info_vertical_content_share_options_container",$blog_post_info_vertical_content_share_options_container);

		$blog_post_info_vertical_content_share_icon_color = new MikadoField("color","blog_post_info_vertical_content_share_icon_color","","Icon Color","Choose icon color for share dropdown");
		$blog_post_info_vertical_content_share_options_container->addChild("blog_post_info_vertical_content_share_icon_color",$blog_post_info_vertical_content_share_icon_color);

		$blog_post_info_vertical_content_share_icon_hover_color = new MikadoField("color","blog_post_info_vertical_content_share_icon_hover_color","","Icon Hover Color","Choose icon hover color for share dropdown");
		$blog_post_info_vertical_content_share_options_container->addChild("blog_post_info_vertical_content_share_icon_hover_color",$blog_post_info_vertical_content_share_icon_hover_color);

		$blog_post_info_vertical_content_share_background_color = new MikadoField("color","blog_post_info_vertical_content_share_background_color","","Background Color","Choose background color for share dropdown list field");
		$blog_post_info_vertical_content_share_options_container->addChild("blog_post_info_vertical_content_share_background_color",$blog_post_info_vertical_content_share_background_color);

		$blog_post_info_vertical_content_show_like = new MikadoField("yesno","blog_post_info_vertical_content_show_like","yes","Show Likes",'Enabling this option will turn on "Likes"');
		$panel5->addChild("blog_post_info_vertical_content_show_like",$blog_post_info_vertical_content_show_like);

		$blog_post_info_vertical_content_post_design_style = new MikadoTitle("blog_post_info_vertical_content_post_design_style", "Post Design Style");
		$panel5->addChild("blog_post_info_vertical_content_post_design_style", $blog_post_info_vertical_content_post_design_style);

		$blog_post_info_vertical_content_enable_text_box = new MikadoField("yesno","blog_post_info_vertical_content_enable_text_box","no","Enable Boxed Styled Post Content","Enable post text boxed features", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_post_info_vertical_content_enable_text_box_container"));
		$panel5->addChild("blog_post_info_vertical_content_enable_text_box",$blog_post_info_vertical_content_enable_text_box);

		$blog_post_info_vertical_content_enable_text_box_container = new MikadoContainer("blog_post_info_vertical_content_enable_text_box_container","blog_post_info_vertical_content_enable_text_box","no");
		$panel5->addChild("blog_post_info_vertical_content_enable_text_box_container",$blog_post_info_vertical_content_enable_text_box_container);

		$blog_post_info_vertical_content_box_background_color = new MikadoField("color","blog_post_info_vertical_content_box_background_color","","Background Color","Choose background color for post text box");
		$blog_post_info_vertical_content_enable_text_box_container->addChild("blog_post_info_vertical_content_box_background_color",$blog_post_info_vertical_content_box_background_color);

		$blog_post_info_vertical_content_box_border_color = new MikadoField("color","blog_post_info_vertical_content_box_border_color","","Border Color","Choose border color for post text box");
		$blog_post_info_vertical_content_enable_text_box_container->addChild("blog_post_info_vertical_content_box_border_color",$blog_post_info_vertical_content_box_border_color);

		$blog_post_info_vertical_content_box_padding = new MikadoField("text","blog_post_info_vertical_content_box_padding","","Text box padding","Please insert padding in format (top right bottom left) i.e. 5px 5px 5px 5px", array(), array("col_width" => 3));
		$blog_post_info_vertical_content_enable_text_box_container->addChild("blog_post_info_vertical_content_box_padding",$blog_post_info_vertical_content_box_padding);

		$group1 = new MikadoGroup("Quote/Link Background","Set background of Quote/Link post type");
		$panel5->addChild("group1",$group1);

		$row1 = new MikadoRow();
		$group1->addChild("row1",$row1);

		$blog_post_info_vertical_content_ql_background_image = new MikadoField("yesnosimple","blog_post_info_vertical_content_ql_background_image","no","Background Image","");
		$row1->addChild("blog_post_info_vertical_content_ql_background_image",$blog_post_info_vertical_content_ql_background_image);

		$blog_post_info_vertical_content_ql_background_color = new MikadoField("colorsimple","blog_post_info_vertical_content_ql_background_color","","Background Color","Default color is #ffffff.");
		$row1->addChild("blog_post_info_vertical_content_ql_background_color",$blog_post_info_vertical_content_ql_background_color);

		$blog_post_info_vertical_content_ql_hover_background_color = new MikadoField("colorsimple","blog_post_info_vertical_content_ql_hover_background_color","","Background Hover Color","Default color is #e6ae48.");
		$row1->addChild("blog_post_info_vertical_content_ql_hover_background_color",$blog_post_info_vertical_content_ql_hover_background_color);

		$blog_post_info_vertical_content_show_ql_mark = new MikadoField("yesno","blog_post_info_vertical_content_show_ql_mark","yes","Enable Quote/Link Icon","Show Icons for Quote/Link Post Format", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_post_info_vertical_content_show_ql_mark_container"));
		$panel5->addChild("blog_post_info_vertical_content_show_ql_mark",$blog_post_info_vertical_content_show_ql_mark);

		$blog_post_info_vertical_content_show_ql_mark_container = new MikadoContainer("blog_post_info_vertical_content_show_ql_mark_container","blog_post_info_vertical_content_show_ql_mark","no");
		$panel5->addChild("blog_post_info_vertical_content_show_ql_mark_container",$blog_post_info_vertical_content_show_ql_mark_container);

		$row1 = new MikadoRow();
		$blog_post_info_vertical_content_show_ql_mark_container->addChild("row1",$row1);

		$blog_post_info_vertical_content_ql_mark_color = new MikadoField("color","blog_post_info_vertical_content_ql_mark_color","","Icon Color","Choose icon color for quote/link post.");
		$row1->addChild("blog_post_info_vertical_content_ql_mark_color",$blog_post_info_vertical_content_ql_mark_color);

		$blog_post_info_vertical_content_ql_mark_hover_color = new MikadoField("color","blog_post_info_vertical_content_ql_mark_hover_color","","Icon Hover Color","Choose hover icon color for quote/link post.");
		$row1->addChild("blog_post_info_vertical_content_ql_mark_hover_color",$blog_post_info_vertical_content_ql_mark_hover_color);

		$group2 = new MikadoGroup("Post Info Date Box","Set style for Post Info Date Box");
		$panel5->addChild("group2",$group2);

		$row1 = new MikadoRow();
		$group2->addChild("row1",$row1);

		$blog_post_info_vertical_content_date_box_background_color = new MikadoField("colorsimple","blog_post_info_vertical_content_date_box_background_color","","Background Color","Default color is #ffffff.");
		$row1->addChild("blog_post_info_vertical_content_date_box_background_color",$blog_post_info_vertical_content_date_box_background_color);

		$blog_post_info_vertical_content_date_box_color = new MikadoField("colorsimple","blog_post_info_vertical_content_date_box_color","","Color","Default color is #e6ae48.");
		$row1->addChild("blog_post_info_vertical_content_date_box_color",$blog_post_info_vertical_content_date_box_color);

		$group3 = new MikadoGroup("Post Info Like Box","Set style for Post Info Like Box");
		$panel5->addChild("group3",$group3);

		$row1 = new MikadoRow();
		$group3->addChild("row1",$row1);

		$blog_post_info_vertical_content_like_box_background_color = new MikadoField("colorsimple","blog_post_info_vertical_content_like_box_background_color","","Background Color","Default color is #ffffff.");
		$row1->addChild("blog_post_info_vertical_content_like_box_background_color",$blog_post_info_vertical_content_like_box_background_color);

		$blog_post_info_vertical_content_like_box_color = new MikadoField("colorsimple","blog_post_info_vertical_content_like_box_color","","Color","Default color is #e6ae48.");
		$row1->addChild("blog_post_info_vertical_content_like_box_color",$blog_post_info_vertical_content_like_box_color);

		$blog_post_info_vertical_content_like_box_hover_color = new MikadoField("colorsimple","blog_post_info_vertical_content_like_box_hover_color","","Hover Color","");
		$row1->addChild("blog_post_info_vertical_content_like_box_hover_color",$blog_post_info_vertical_content_like_box_hover_color);

		$group4 = new MikadoGroup("Post Info Share Box","Set style for Post Info Share Box");
		$panel5->addChild("group4",$group4);

		$row1 = new MikadoRow();
		$group4->addChild("row1",$row1);

		$blog_post_info_vertical_content_share_box_background_color = new MikadoField("colorsimple","blog_post_info_vertical_content_share_box_background_color","","Background Color","Default color is #ffffff.");
		$row1->addChild("blog_post_info_vertical_content_share_box_background_color",$blog_post_info_vertical_content_share_box_background_color);

		$blog_post_info_vertical_content_share_box_color = new MikadoField("colorsimple","blog_post_info_vertical_content_share_box_color","","Color","Default color is #e6ae48.");
		$row1->addChild("blog_post_info_vertical_content_share_box_color",$blog_post_info_vertical_content_share_box_color);

		$blog_post_info_vertical_content_share_box_hover_color = new MikadoField("colorsimple","blog_post_info_vertical_content_share_box_hover_color","","Hover Color","Default color is #e6ae48.");
		$row1->addChild("blog_post_info_vertical_content_share_box_hover_color",$blog_post_info_vertical_content_share_box_hover_color);

		$group10 = new MikadoGroup("Blog List Spacing","Set spacing for blog layouts");
		$panel5->addChild("group10",$group10);

		$row1 = new MikadoRow();
		$group10->addChild("row1",$row1);

		$blog_post_info_vertical_content_image_margin_bottom = new MikadoField("textsimple","blog_post_info_vertical_content_image_margin_bottom","","Margin Under Image (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_content_image_margin_bottom",$blog_post_info_vertical_content_image_margin_bottom);

		$blog_post_info_vertical_content_title_margin_bottom = new MikadoField("textsimple","blog_post_info_vertical_content_title_margin_bottom","","Margin Under Title (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_content_title_margin_bottom",$blog_post_info_vertical_content_title_margin_bottom);

		$blog_post_info_vertical_content_post_info_margin_bottom = new MikadoField("textsimple","blog_post_info_vertical_content_post_info_margin_bottom","","Margin Under Post Info (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_content_post_info_margin_bottom",$blog_post_info_vertical_content_post_info_margin_bottom);

		$blog_post_info_vertical_content_article_margin_bottom = new MikadoField("textsimple","blog_post_info_vertical_content_article_margin_bottom","","Margin Between Articles (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_content_article_margin_bottom",$blog_post_info_vertical_content_article_margin_bottom);

		$group11 = new MikadoGroup("Blog List Spacing for Quote and Link Post Type","Set spacing for blog layouts");
		$panel5->addChild("group11",$group11);

		$row1 = new MikadoRow();
		$group11->addChild("row1",$row1);

		$blog_post_info_vertical_content_ql_quote_author_margin_top = new MikadoField("textsimple","blog_post_info_vertical_content_ql_quote_author_margin_top","","Margin Above Quote Author (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_content_ql_quote_author_margin_top",$blog_post_info_vertical_content_ql_quote_author_margin_top);

		$blog_post_info_vertical_content_ql_post_info_margin_top = new MikadoField("textsimple","blog_post_info_vertical_content_ql_post_info_margin_top","","Margin Above Post Info (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_content_ql_post_info_margin_top",$blog_post_info_vertical_content_ql_post_info_margin_top);

		$post_text_styling= new MikadoTitle("post_text_styling", "Post Text Style");
		$panel5->addChild("post_text_styling", $post_text_styling);

		$group5 = new MikadoGroup("Post Title","Define title styles in this blog post template.");
		$panel5->addChild("group5",$group5);

		$row1 = new MikadoRow();
		$group5->addChild("row1",$row1);

		$blog_post_info_vertical_content_title_color = new MikadoField("colorsimple","blog_post_info_vertical_content_title_color","","Text Color","This is some description");
		$row1->addChild("blog_post_info_vertical_content_title_color",$blog_post_info_vertical_content_title_color);

		$blog_post_info_vertical_content_title_hover_color = new MikadoField("colorsimple","blog_post_info_vertical_content_title_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_post_info_vertical_content_title_hover_color",$blog_post_info_vertical_content_title_hover_color);

		$blog_post_info_vertical_content_title_fontsize = new MikadoField("textsimple","blog_post_info_vertical_content_title_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_content_title_fontsize",$blog_post_info_vertical_content_title_fontsize);

		$blog_post_info_vertical_content_title_lineheight = new MikadoField("textsimple","blog_post_info_vertical_content_title_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_content_title_lineheight",$blog_post_info_vertical_content_title_lineheight);

		$row2 = new MikadoRow(true);
		$group5->addChild("row2",$row2);

		$blog_post_info_vertical_content_title_texttransform = new MikadoField("selectblanksimple","blog_post_info_vertical_content_title_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_post_info_vertical_content_title_texttransform",$blog_post_info_vertical_content_title_texttransform);

		$blog_post_info_vertical_content_title_google_fonts = new MikadoField("Fontsimple","blog_post_info_vertical_content_title_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_post_info_vertical_content_title_google_fonts",$blog_post_info_vertical_content_title_google_fonts);

		$blog_post_info_vertical_content_title_fontstyle = new MikadoField("selectblanksimple","blog_post_info_vertical_content_title_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_post_info_vertical_content_title_fontstyle",$blog_post_info_vertical_content_title_fontstyle);

		$blog_post_info_vertical_content_title_fontweight = new MikadoField("selectblanksimple","blog_post_info_vertical_content_title_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_post_info_vertical_content_title_fontweight",$blog_post_info_vertical_content_title_fontweight);

		$row3 = new MikadoRow(true);
		$group5->addChild("row3",$row3);

		$blog_post_info_vertical_content_title_letterspacing = new MikadoField("textsimple","blog_post_info_vertical_content_title_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_post_info_vertical_content_title_letterspacing",$blog_post_info_vertical_content_title_letterspacing);

		$group7 = new MikadoGroup("Post Info Data","Define post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list");
		$panel5->addChild("group7",$group7);

		$row1 = new MikadoRow();
		$group7->addChild("row1",$row1);

		$blog_post_info_vertical_content_info_color = new MikadoField("colorsimple","blog_post_info_vertical_content_info_color","","Text Color","This is some description");
		$row1->addChild("blog_post_info_vertical_content_info_color",$blog_post_info_vertical_content_info_color);

		$blog_post_info_vertical_content_info_link_color = new MikadoField("colorsimple","blog_post_info_vertical_content_info_link_color","","Link Color","This is some description");
		$row1->addChild("blog_post_info_vertical_content_info_link_color",$blog_post_info_vertical_content_info_link_color);

		$blog_post_info_vertical_content_info_hover_color = new MikadoField("colorsimple","blog_post_info_vertical_content_info_hover_color","","Link Hover Color","This is some description");
		$row1->addChild("blog_post_info_vertical_content_info_hover_color",$blog_post_info_vertical_content_info_hover_color);

		$blog_post_info_vertical_content_info_fontsize = new MikadoField("textsimple","blog_post_info_vertical_content_info_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_content_info_fontsize",$blog_post_info_vertical_content_info_fontsize);



		$row2 = new MikadoRow(true);
		$group7->addChild("row2",$row2);

		$blog_post_info_vertical_content_info_lineheight = new MikadoField("textsimple","blog_post_info_vertical_content_info_lineheight","","Line Height (px)","This is some description");
		$row2->addChild("blog_post_info_vertical_content_info_lineheight",$blog_post_info_vertical_content_info_lineheight);

		$blog_post_info_vertical_content_info_google_fonts = new MikadoField("Fontsimple","blog_post_info_vertical_content_info_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_post_info_vertical_content_info_google_fonts",$blog_post_info_vertical_content_info_google_fonts);

		$blog_post_info_vertical_content_info_fontstyle = new MikadoField("selectblanksimple","blog_post_info_vertical_content_info_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_post_info_vertical_content_info_fontstyle",$blog_post_info_vertical_content_info_fontstyle);

		$blog_post_info_vertical_content_info_fontweight = new MikadoField("selectblanksimple","blog_post_info_vertical_content_info_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_post_info_vertical_content_info_fontweight",$blog_post_info_vertical_content_info_fontweight);

		$row3 = new MikadoRow(true);
		$group7->addChild("row3",$row3);

		$blog_post_info_vertical_content_info_texttransform = new MikadoField("selectblanksimple","blog_post_info_vertical_content_info_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row3->addChild("blog_post_info_vertical_content_info_texttransform",$blog_post_info_vertical_content_info_texttransform);

		$blog_post_info_vertical_content_info_letterspacing = new MikadoField("textsimple","blog_post_info_vertical_content_info_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_post_info_vertical_content_info_letterspacing",$blog_post_info_vertical_content_info_letterspacing);

		$group6 = new MikadoGroup("Quote/Link Title Style","Define title styles for Quote/Link articles");
		$panel5->addChild("group6",$group6);

		$row1 = new MikadoRow();
		$group6->addChild("row1",$row1);

		$blog_post_info_vertical_content_ql_title_color = new MikadoField("colorsimple","blog_post_info_vertical_content_ql_title_color","","Text Color","This is some description");
		$row1->addChild("blog_post_info_vertical_content_ql_title_color",$blog_post_info_vertical_content_ql_title_color);

		$blog_post_info_vertical_content_ql_title_hover_color = new MikadoField("colorsimple","blog_post_info_vertical_content_ql_title_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_post_info_vertical_content_ql_title_hover_color",$blog_post_info_vertical_content_ql_title_hover_color);

		$blog_post_info_vertical_content_ql_title_fontsize = new MikadoField("textsimple","blog_post_info_vertical_content_ql_title_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_content_ql_title_font_size",$blog_post_info_vertical_content_ql_title_fontsize);

		$blog_post_info_vertical_content_ql_title_lineheight = new MikadoField("textsimple","blog_post_info_vertical_content_ql_title_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_content_ql_title_lineheight",$blog_post_info_vertical_content_ql_title_lineheight);


		$row2 = new MikadoRow(true);
		$group6->addChild("row2",$row2);

		$blog_post_info_vertical_content_ql_title_texttransform = new MikadoField("selectblanksimple","blog_post_info_vertical_content_ql_title_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_post_info_vertical_content_ql_title_texttransform",$blog_post_info_vertical_content_ql_title_texttransform);

		$blog_post_info_vertical_content_ql_title_google_fonts = new MikadoField("Fontsimple","blog_post_info_vertical_content_ql_title_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_post_info_vertical_content_ql_title_google_fonts",$blog_post_info_vertical_content_ql_title_google_fonts);

		$blog_post_info_vertical_content_ql_title_fontstyle = new MikadoField("selectblanksimple","blog_post_info_vertical_content_ql_title_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_post_info_vertical_content_ql_title_fontstyle",$blog_post_info_vertical_content_ql_title_fontstyle);

		$blog_post_info_vertical_content_ql_title_fontweight = new MikadoField("selectblanksimple","blog_post_info_vertical_content_ql_title_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_post_info_vertical_content_ql_title_fontweight",$blog_post_info_vertical_content_ql_title_fontweight);

		$row3 = new MikadoRow(true);
		$group6->addChild("row3",$row3);

		$blog_post_info_vertical_content_ql_title_letterspacing = new MikadoField("textsimple","blog_post_info_vertical_content_ql_title_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_post_info_vertical_content_ql_title_letterspacing",$blog_post_info_vertical_content_ql_title_letterspacing);

		$group8 = new MikadoGroup("Quote/Link Post Info Data","Define quote/link post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list.");
		$panel5->addChild("group8",$group8);

		$row1 = new MikadoRow();
		$group8->addChild("row1",$row1);

		$blog_post_info_vertical_content_ql_info_color = new MikadoField("colorsimple","blog_post_info_vertical_content_ql_info_color","","Text Color","This is some description");
		$row1->addChild("blog_post_info_vertical_content_ql_info_color",$blog_post_info_vertical_content_ql_info_color);

		$blog_post_info_vertical_content_ql_info_link_color = new MikadoField("colorsimple","blog_post_info_vertical_content_ql_info_link_color","","Link Color","This is some description");
		$row1->addChild("blog_post_info_vertical_content_ql_info_link_color",$blog_post_info_vertical_content_ql_info_link_color);

		$blog_post_info_vertical_content_ql_info_hover_color = new MikadoField("colorsimple","blog_post_info_vertical_content_ql_info_hover_color","","Hover Color","This is some description");
		$row1->addChild("blog_post_info_vertical_content_ql_info_hover_color",$blog_post_info_vertical_content_ql_info_hover_color);


		$blog_post_info_vertical_content_ql_info_fontsize = new MikadoField("textsimple","blog_post_info_vertical_content_ql_info_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_content_ql_info_fontsize",$blog_post_info_vertical_content_ql_info_fontsize);


		$row2 = new MikadoRow(true);
		$group8->addChild("row2",$row2);


		$blog_post_info_vertical_content_ql_info_lineheight = new MikadoField("textsimple","blog_post_info_vertical_content_ql_info_lineheight","","Line Height (px)","This is some description");
		$row2->addChild("blog_post_info_vertical_content_ql_info_lineheight",$blog_post_info_vertical_content_ql_info_lineheight);

		$blog_post_info_vertical_content_ql_info_google_fonts = new MikadoField("Fontsimple","blog_post_info_vertical_content_ql_info_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_post_info_vertical_content_ql_info_google_fonts",$blog_post_info_vertical_content_ql_info_google_fonts);

		$blog_post_info_vertical_content_ql_info_fontstyle = new MikadoField("selectblanksimple","blog_post_info_vertical_content_ql_info_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_post_info_vertical_content_ql_info_fontstyle",$blog_post_info_vertical_content_ql_info_fontstyle);

		$blog_post_info_vertical_content_ql_info_fontweight = new MikadoField("selectblanksimple","blog_post_info_vertical_content_ql_info_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_post_info_vertical_content_ql_info_fontweight",$blog_post_info_vertical_content_ql_info_fontweight);

		$row3 = new MikadoRow(true);
		$group8->addChild("row3",$row3);

		$blog_post_info_vertical_content_ql_info_texttransform = new MikadoField("selectblanksimple","blog_post_info_vertical_content_ql_info_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row3->addChild("blog_post_info_vertical_content_ql_info_texttransform",$blog_post_info_vertical_content_ql_info_texttransform);

		$blog_post_info_vertical_content_ql_info_letterspacing = new MikadoField("textsimple","blog_post_info_vertical_content_ql_info_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_post_info_vertical_content_ql_info_letterspacing",$blog_post_info_vertical_content_ql_info_letterspacing);

		$group9 = new MikadoGroup("Quote Author Style","Define author styles for Quote articles");
		$panel5->addChild("group9",$group9);

		$row1 = new MikadoRow();
		$group9->addChild("row1",$row1);

		$blog_post_info_vertical_content_ql_author_color = new MikadoField("colorsimple","blog_post_info_vertical_content_ql_author_color","","Text Color","This is some description");
		$row1->addChild("blog_post_info_vertical_content_ql_author_color",$blog_post_info_vertical_content_ql_author_color);

		$blog_post_info_vertical_content_ql_author_hover_color = new MikadoField("colorsimple","blog_post_info_vertical_content_ql_author_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_post_info_vertical_content_ql_author_hover_color",$blog_post_info_vertical_content_ql_author_hover_color);

		$blog_post_info_vertical_content_ql_author_fontsize = new MikadoField("textsimple","blog_post_info_vertical_content_ql_author_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_content_ql_author_font_size",$blog_post_info_vertical_content_ql_author_fontsize);

		$blog_post_info_vertical_content_ql_author_lineheight = new MikadoField("textsimple","blog_post_info_vertical_content_ql_author_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_content_ql_author_lineheight",$blog_post_info_vertical_content_ql_author_lineheight);


		$row2 = new MikadoRow(true);
		$group9->addChild("row2",$row2);

		$blog_post_info_vertical_content_ql_author_texttransform = new MikadoField("selectblanksimple","blog_post_info_vertical_content_ql_author_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_post_info_vertical_content_ql_author_texttransform",$blog_post_info_vertical_content_ql_author_texttransform);

		$blog_post_info_vertical_content_ql_author_google_fonts = new MikadoField("Fontsimple","blog_post_info_vertical_content_ql_author_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_post_info_vertical_content_ql_author_google_fonts",$blog_post_info_vertical_content_ql_author_google_fonts);

		$blog_post_info_vertical_content_ql_author_fontstyle = new MikadoField("selectblanksimple","blog_post_info_vertical_content_ql_author_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_post_info_vertical_content_ql_author_fontstyle",$blog_post_info_vertical_content_ql_author_fontstyle);

		$blog_post_info_vertical_content_ql_author_fontweight = new MikadoField("selectblanksimple","blog_post_info_vertical_content_ql_author_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_post_info_vertical_content_ql_author_fontweight",$blog_post_info_vertical_content_ql_author_fontweight);

		$row3 = new MikadoRow(true);
		$group9->addChild("row3",$row3);

		$blog_post_info_vertical_content_ql_author_letterspacing = new MikadoField("textsimple","blog_post_info_vertical_content_ql_author_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_post_info_vertical_content_ql_author_letterspacing",$blog_post_info_vertical_content_ql_author_letterspacing);

		// Blog Post List - Blog: Image with Icon (Centered)
		$panel6 = new MikadoPanel("Blog List Template Options: Image with Icon (Centered)","blog_image_with_icon_centered_post_lists", "blog_image_with_icon_centered_show_options", "no");
		$blogPage->addChild("panel6",$panel6);

		$blog_image_with_icon_centered_number_of_chars = new MikadoField("text","blog_post_info_vertical_content_number_of_chars","45","Number of Words in Excerpt",' Enter a number of words in excerpt (article summary)', array(), array("col_width" => 3));
		$panel6->addChild("blog_post_info_vertical_content_number_of_chars",$blog_post_info_vertical_content_number_of_chars);

		$blog_image_with_icon_centered_read_more_button = new MikadoField("yesno","blog_image_with_icon_centered_read_more_button","no","Read More Button","Enable Read More Button");
		$panel6->addChild("blog_image_with_icon_centered_read_more_button",$blog_image_with_icon_centered_read_more_button);

		$blog_image_with_icon_centered_content_position = new MikadoField("select","blog_image_with_icon_centered_content_position","content_above_blog_list","Content Position","Choose content position for blog list template when sidebar is enabled. Note: This settings in only for template, not for archive pages", array(
			"content_above_blog_list" => "Content Above Blog List",
			"content_above_blog_list_and_sidebar" => "Content Above Blog List and Sidebar"
		));
		$panel6->addChild("blog_image_with_icon_centered_content_position", $blog_image_with_icon_centered_content_position);

		$blog_image_with_icon_centered_post_meta_data_section = new MikadoTitle("blog_image_with_icon_centered_post_meta_data_section", "Post Info Data Fields");
		$panel6->addChild("blog_image_with_icon_centered_post_meta_data_section", $blog_image_with_icon_centered_post_meta_data_section);

		$blog_image_with_icon_centered_show_categories = new MikadoField("yesno","blog_image_with_icon_centered_show_categories","yes","Show Categories","Enabling this option will Show Categories on Post List");
		$panel6->addChild("blog_image_with_icon_centered_show_categories",$blog_image_with_icon_centered_show_categories);

		$blog_image_with_icon_centered_show_comments = new MikadoField("yesno","blog_image_with_icon_centered_show_comments","no","Show Comments","Enabling this option will Show Comments on Post List");
		$panel6->addChild("blog_image_with_icon_centered_show_comments",$blog_image_with_icon_centered_show_comments);

		$blog_image_with_icon_centered_show_author = new MikadoField("yesno","blog_image_with_icon_centered_show_author","no","Show Author Name","Enabling this option will show author name on Post List and Blog Post Single");
		$panel6->addChild("blog_image_with_icon_centered_show_author",$blog_image_with_icon_centered_show_author);

		$blog_image_with_icon_centered_show_date = new MikadoField("yesno","blog_image_with_icon_centered_show_date","no","Show Date","Enabling this option will show date on Post List");
		$panel6->addChild("blog_image_with_icon_centered_hide_date",$blog_image_with_icon_centered_show_date);

		$blog_image_with_icon_centered_show_share = new MikadoField("yesno","blog_image_with_icon_centered_show_share","no","Show Share","Enabling this option will show share on Post List", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_image_with_icon_centered_share_options_container"));
		$panel6->addChild("blog_image_with_icon_centered_show_share",$blog_image_with_icon_centered_show_share);

		$blog_image_with_icon_centered_share_options_container = new MikadoContainer("blog_image_with_icon_centered_share_options_container","blog_image_with_icon_centered_show_share","no");
		$panel6->addChild("blog_image_with_icon_centered_share_options_container",$blog_image_with_icon_centered_share_options_container);

		$blog_image_with_icon_centered_share_icon_color = new MikadoField("color","blog_image_with_icon_centered_share_icon_color","","Icon Color","Choose icon color for share dropdown");
		$blog_image_with_icon_centered_share_options_container->addChild("blog_image_with_icon_centered_share_icon_color",$blog_image_with_icon_centered_share_icon_color);

		$blog_image_with_icon_centered_share_icon_hover_color = new MikadoField("color","blog_image_with_icon_centered_share_icon_hover_color","","Icon Hover Color","Choose icon hover color for share dropdown");
		$blog_image_with_icon_centered_share_options_container->addChild("blog_image_with_icon_centered_share_icon_hover_color",$blog_image_with_icon_centered_share_icon_hover_color);

		$blog_image_with_icon_centered_share_background_color = new MikadoField("color","blog_image_with_icon_centered_share_background_color","","Background Color","Choose background color for share dropdown list field");
		$blog_image_with_icon_centered_share_options_container->addChild("blog_image_with_icon_centered_share_background_color",$blog_image_with_icon_centered_share_background_color);

		$blog_image_with_icon_centered_like = new MikadoField("yesno","blog_image_with_icon_centered_show_like","no","Show Likes",'Enabling this option will turn on "Likes"');
		$panel6->addChild("blog_image_with_icon_centered_show_like",$blog_image_with_icon_centered_like);

		$blog_image_with_icon_centered_post_design_style = new MikadoTitle("blog_image_with_icon_centered_post_design_style", "Post Design Style");
		$panel6->addChild("blog_image_with_icon_centered_post_design_style", $blog_image_with_icon_centered_post_design_style);

		$group1 = new MikadoGroup("Separator","Define style for separator used in the bottom of the post.");
		$panel6->addChild("group1",$group1);

		$row1 = new MikadoRow();
		$group1->addChild("row1",$row1);

		$blog_image_with_icon_centered_separator_border_color = new MikadoField("colorsimple","blog_image_with_icon_centered_separator_border_color","","Separator Color","This is some description");
		$row1->addChild("blog_image_with_icon_centered_separator_border_color",$blog_image_with_icon_centered_separator_border_color);

		$blog_image_with_icon_centered_separator_width = new MikadoField("textsimple","blog_image_with_icon_centered_separator_width","","Separator Width (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_separator_width", $blog_image_with_icon_centered_separator_width);

		$blog_image_with_icon_centered_separator_thickness = new MikadoField("textsimple","blog_image_with_icon_centered_separator_thickness","","Separator Thickness (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_separator_thickness", $blog_image_with_icon_centered_separator_thickness);

		$blog_image_with_icon_centered_enable_text_box = new MikadoField("yesno","blog_image_with_icon_centered_enable_text_box","no","Enable Boxed Styled Post Content","Enable post text boxed features", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_image_with_icon_centered_enable_text_box_container"));
		$panel6->addChild("blog_image_with_icon_centered_enable_text_box",$blog_image_with_icon_centered_enable_text_box);

		$blog_image_with_icon_centered_enable_text_box_container = new MikadoContainer("blog_image_with_icon_centered_enable_text_box_container","blog_image_with_icon_centered_enable_text_box","no");
		$panel6->addChild("blog_image_with_icon_centered_enable_text_box_container",$blog_image_with_icon_centered_enable_text_box_container);

		$blog_image_with_icon_centered_box_background_color = new MikadoField("color","blog_image_with_icon_centered_box_background_color","","Background Color","Choose background color for post text box");
		$blog_image_with_icon_centered_enable_text_box_container->addChild("blog_image_with_icon_centered_box_background_color",$blog_image_with_icon_centered_box_background_color);

		$blog_image_with_icon_centered_box_border_color = new MikadoField("color","blog_image_with_icon_centered_box_border_color","","Border Color","Choose border color for post text box");
		$blog_image_with_icon_centered_enable_text_box_container->addChild("blog_image_with_icon_centered_box_border_color",$blog_image_with_icon_centered_box_border_color);

		$blog_image_with_icon_centered_box_padding = new MikadoField("text","blog_image_with_icon_centered_box_padding","","Text box padding","Please insert padding in format (top right bottom left) i.e. 5px 5px 5px 5px", array(), array("col_width" => 3));
		$blog_image_with_icon_centered_enable_text_box_container->addChild("blog_image_with_icon_centered_box_padding",$blog_image_with_icon_centered_box_padding);

		$group2 = new MikadoGroup("Quote/Link Background","Set background of Quote/Link post type");
		$panel6->addChild("group2",$group2);

		$row1 = new MikadoRow();
		$group2->addChild("row1",$row1);

		$blog_image_with_icon_centered_ql_background_image = new MikadoField("yesnosimple","blog_image_with_icon_centered_ql_background_image","no","Background Image","");
		$row1->addChild("blog_image_with_icon_centered_ql_background_image",$blog_image_with_icon_centered_ql_background_image);

		$blog_image_with_icon_centered_ql_background_color = new MikadoField("colorsimple","blog_image_with_icon_centered_ql_background_color","","Background Color","Default color is #ffffff.");
		$row1->addChild("blog_image_with_icon_centered_ql_background_color",$blog_image_with_icon_centered_ql_background_color);

		$blog_image_with_icon_centered_ql_hover_background_color = new MikadoField("colorsimple","blog_image_with_icon_centered_ql_hover_background_color","","Background Hover Color","Default color is #e6ae48.");
		$row1->addChild("blog_image_with_icon_centered_ql_hover_background_color",$blog_image_with_icon_centered_ql_hover_background_color);

		$group3 = new MikadoGroup("Border & Icon Color","Set Color for Border and Circle Icons for each Post Format");
		$panel6->addChild("group3",$group3);

		$row1 = new MikadoRow();
		$group3->addChild("row1",$row1);

		$blog_image_with_icon_centered_ql_border_icon_color_standard = new MikadoField("colorsimple","blog_image_with_icon_centered_ql_border_icon_color_standard","","Standard","Choose icon color for post format Standard.");
		$row1->addChild("blog_image_with_icon_centered_ql_border_icon_color_standard",$blog_image_with_icon_centered_ql_border_icon_color_standard);

		$blog_image_with_icon_centered_ql_border_icon_color_gallery = new MikadoField("colorsimple","blog_image_with_icon_centered_ql_border_icon_color_gallery","","Gallery","Choose icon color for post format Gallery.");
		$row1->addChild("blog_image_with_icon_centered_ql_border_icon_color_gallery",$blog_image_with_icon_centered_ql_border_icon_color_gallery);

		$blog_image_with_icon_centered_ql_border_icon_color_quote = new MikadoField("colorsimple","blog_image_with_icon_centered_ql_border_icon_color_quote","","Quote","Choose icon color for post format Quote.");
		$row1->addChild("blog_image_with_icon_centered_ql_border_icon_color_quote",$blog_image_with_icon_centered_ql_border_icon_color_quote);

		$blog_image_with_icon_centered_ql_border_icon_color_link = new MikadoField("colorsimple","blog_image_with_icon_centered_ql_border_icon_color_link","","Link","Choose icon color for post format Link.");
		$row1->addChild("blog_image_with_icon_centered_ql_border_icon_color_link",$blog_image_with_icon_centered_ql_border_icon_color_link);

		$row2 = new MikadoRow();
		$group3->addChild("row2",$row2);

		$blog_image_with_icon_centered_ql_border_icon_color_audio = new MikadoField("colorsimple","blog_image_with_icon_centered_ql_border_icon_color_audio","","Audio","Choose icon color for post format Audio.");
		$row2->addChild("blog_image_with_icon_centered_ql_border_icon_color_audio",$blog_image_with_icon_centered_ql_border_icon_color_audio);

		$group11 = new MikadoGroup("Blog List Spacing","Set spacing for blog layouts");
		$panel6->addChild("group11",$group11);

		$row1 = new MikadoRow();
		$group11->addChild("row1",$row1);

		$blog_image_with_icon_centered_image_margin_bottom = new MikadoField("textsimple","blog_image_with_icon_centered_image_margin_bottom","","Margin Under Image (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_image_margin_bottom",$blog_image_with_icon_centered_image_margin_bottom);

		$blog_image_with_icon_centered_category_margin_bottom = new MikadoField("textsimple","blog_image_with_icon_centered_category_margin_bottom","","Margin Under Category (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_category_margin_bottom",$blog_image_with_icon_centered_category_margin_bottom);

		$blog_image_with_icon_centered_title_margin_bottom = new MikadoField("textsimple","blog_image_with_icon_centered_title_margin_bottom","","Margin Under Title (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_title_margin_bottom",$blog_image_with_icon_centered_title_margin_bottom);

		$blog_image_with_icon_centered_post_info_margin_top = new MikadoField("textsimple","blog_image_with_icon_centered_post_info_margin_top","","Margin Above Post Info (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_post_info_margin_top",$blog_image_with_icon_centered_post_info_margin_top);

		$row2 = new MikadoRow();
		$group11->addChild("row2",$row2);

		$blog_image_with_icon_centered_separator_margin_top = new MikadoField("textsimple","blog_image_with_icon_centered_separator_margin_top","","Margin Above Separator (px)","This is some description");
		$row2->addChild("blog_image_with_icon_centered_separator_margin_top",$blog_image_with_icon_centered_separator_margin_top);

		$blog_image_with_icon_centered_separator_margin_bottom = new MikadoField("textsimple","blog_image_with_icon_centered_separator_margin_bottom","","Margin Under Separator (px)","This is some description");
		$row2->addChild("blog_image_with_icon_centered_separator_margin_bottom",$blog_image_with_icon_centered_separator_margin_bottom);

		$blog_image_with_icon_centered_article_margin_bottom = new MikadoField("textsimple","blog_image_with_icon_centered_article_margin_bottom","","Margin Between Articles (px)","This is some description");
		$row2->addChild("blog_image_with_icon_centered_article_margin_bottom",$blog_image_with_icon_centered_article_margin_bottom);

		$group12 = new MikadoGroup("Blog List Spacing for Quote and Link Post Type","Set spacing for blog layouts");
		$panel6->addChild("group12",$group12);

		$row1 = new MikadoRow();
		$group12->addChild("row1",$row1);

		$blog_image_with_icon_centered_ql_category_margin_bottom = new MikadoField("textsimple","blog_image_with_icon_centered_ql_category_margin_bottom","","Margin Under Category (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_ql_category_margin_bottom",$blog_image_with_icon_centered_ql_category_margin_bottom);

		$blog_image_with_icon_centered_ql_quote_author_margin_top = new MikadoField("textsimple","blog_image_with_icon_centered_ql_quote_author_margin_top","","Margin Above Quote Author (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_ql_quote_author_margin_top",$blog_image_with_icon_centered_ql_quote_author_margin_top);

		$blog_image_with_icon_centered_ql_post_info_margin_top = new MikadoField("textsimple","blog_image_with_icon_centered_ql_post_info_margin_top","","Margin Above Post Info (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_ql_post_info_margin_top",$blog_image_with_icon_centered_ql_post_info_margin_top);

		$post_text_styling= new MikadoTitle("post_text_styling", "Post Text Style");
		$panel6->addChild("post_text_styling", $post_text_styling);

		$group4 = new MikadoGroup("Post Title","Define title styles in this blog post template.");
		$panel6->addChild("group4",$group4);

		$row1 = new MikadoRow();
		$group4->addChild("row1",$row1);

		$blog_image_with_icon_centered_title_color = new MikadoField("colorsimple","blog_image_with_icon_centered_title_color","","Text Color","This is some description");
		$row1->addChild("blog_image_with_icon_centered_title_color",$blog_image_with_icon_centered_title_color);

		$blog_image_with_icon_centered_title_hover_color = new MikadoField("colorsimple","blog_image_with_icon_centered_title_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_image_with_icon_centered_title_hover_color",$blog_image_with_icon_centered_title_hover_color);

		$blog_image_with_icon_centered_title_fontsize = new MikadoField("textsimple","blog_image_with_icon_centered_title_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_title_fontsize",$blog_image_with_icon_centered_title_fontsize);

		$blog_image_with_icon_centered_title_lineheight = new MikadoField("textsimple","blog_image_with_icon_centered_title_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_title_lineheight",$blog_image_with_icon_centered_title_lineheight);

		$row2 = new MikadoRow(true);
		$group4->addChild("row2",$row2);

		$blog_image_with_icon_centered_title_texttransform = new MikadoField("selectblanksimple","blog_image_with_icon_centered_title_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_image_with_icon_centered_title_texttransform",$blog_image_with_icon_centered_title_texttransform);

		$blog_image_with_icon_centered_title_google_fonts = new MikadoField("Fontsimple","blog_image_with_icon_centered_title_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_image_with_icon_centered_title_google_fonts",$blog_image_with_icon_centered_title_google_fonts);

		$blog_image_with_icon_centered_title_fontstyle = new MikadoField("selectblanksimple","blog_image_with_icon_centered_title_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_image_with_icon_centered_title_fontstyle",$blog_image_with_icon_centered_title_fontstyle);

		$blog_image_with_icon_centered_title_fontweight = new MikadoField("selectblanksimple","blog_image_with_icon_centered_title_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_image_with_icon_centered_title_fontweight",$blog_image_with_icon_centered_title_fontweight);

		$row3 = new MikadoRow(true);
		$group4->addChild("row3",$row3);

		$blog_image_with_icon_centered_title_letterspacing = new MikadoField("textsimple","blog_image_with_icon_centered_title_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_image_with_icon_centered_title_letterspacing",$blog_image_with_icon_centered_title_letterspacing);

		$group5 = new MikadoGroup("Post Info Data","Define post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list");
		$panel6->addChild("group5",$group5);

		$row1 = new MikadoRow();
		$group5->addChild("row1",$row1);

		$blog_image_with_icon_centered_info_color = new MikadoField("colorsimple","blog_image_with_icon_centered_info_color","","Text Color","This is some description");
		$row1->addChild("blog_image_with_icon_centered_info_color",$blog_image_with_icon_centered_info_color);

		$bblog_image_with_icon_centered_info_link_color = new MikadoField("colorsimple","blog_image_with_icon_centered_info_link_color","","Link Color","This is some description");
		$row1->addChild("blog_image_with_icon_centered_info_link_color",$bblog_image_with_icon_centered_info_link_color);

		$blog_image_with_icon_centered_info_hover_color = new MikadoField("colorsimple","blog_image_with_icon_centered_info_hover_color","","Link Hover Color","This is some description");
		$row1->addChild("blog_image_with_icon_centered_info_hover_color",$blog_image_with_icon_centered_info_hover_color);

		$blog_image_with_icon_centered_info_fontsize = new MikadoField("textsimple","blog_image_with_icon_centered_info_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_info_fontsize",$blog_image_with_icon_centered_info_fontsize);



		$row2 = new MikadoRow(true);
		$group5->addChild("row2",$row2);

		$blog_image_with_icon_centered_info_lineheight = new MikadoField("textsimple","blog_image_with_icon_centered_info_lineheight","","Line Height (px)","This is some description");
		$row2->addChild("blog_image_with_icon_centered_info_lineheight",$blog_image_with_icon_centered_info_lineheight);

		$blog_image_with_icon_centered_info_google_fonts = new MikadoField("Fontsimple","blog_image_with_icon_centered_info_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_image_with_icon_centered_info_google_fonts",$blog_image_with_icon_centered_info_google_fonts);

		$blog_image_with_icon_centered_info_fontstyle = new MikadoField("selectblanksimple","blog_image_with_icon_centered_info_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_image_with_icon_centered_info_fontstyle",$blog_image_with_icon_centered_info_fontstyle);

		$blog_image_with_icon_centered_info_fontweight = new MikadoField("selectblanksimple","blog_image_with_icon_centered_info_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_image_with_icon_centered_info_fontweight",$blog_image_with_icon_centered_info_fontweight);

		$row3 = new MikadoRow(true);
		$group5->addChild("row3",$row3);

		$blog_image_with_icon_centered_info_texttransform = new MikadoField("selectblanksimple","blog_image_with_icon_centered_info_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row3->addChild("blog_image_with_icon_centered_info_texttransform",$blog_image_with_icon_centered_info_texttransform);

		$blog_image_with_icon_centered_info_letterspacing = new MikadoField("textsimple","blog_image_with_icon_centered_info_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_image_with_icon_centered_info_letterspacing",$blog_image_with_icon_centered_info_letterspacing);

		$group6 = new MikadoGroup("Post Category","Define category styles in this blog post template.");
		$panel6->addChild("group6",$group6);

		$row1 = new MikadoRow();
		$group6->addChild("row1",$row1);

		$blog_image_with_icon_centered_category_color = new MikadoField("colorsimple","blog_image_with_icon_centered_category_color","","Text Color","This is some description");
		$row1->addChild("blog_image_with_icon_centered_category_color",$blog_image_with_icon_centered_category_color);

		$blog_image_with_icon_centered_category_hover_color = new MikadoField("colorsimple","blog_image_with_icon_centered_category_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_image_with_icon_centered_category_hover_color",$blog_image_with_icon_centered_category_hover_color);

		$blog_image_with_icon_centered_category_fontsize = new MikadoField("textsimple","blog_image_with_icon_centered_category_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_category_fontsize",$blog_image_with_icon_centered_category_fontsize);

		$blog_image_with_icon_centered_category_lineheight = new MikadoField("textsimple","blog_image_with_icon_centered_category_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_category_lineheight",$blog_image_with_icon_centered_category_lineheight);

		$row2 = new MikadoRow(true);
		$group6->addChild("row2",$row2);

		$blog_image_with_icon_centered_category_texttransform = new MikadoField("selectblanksimple","blog_image_with_icon_centered_category_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_image_with_icon_centered_category_texttransform",$blog_image_with_icon_centered_category_texttransform);

		$blog_image_with_icon_centered_category_google_fonts = new MikadoField("Fontsimple","blog_image_with_icon_centered_category_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_image_with_icon_centered_category_google_fonts",$blog_image_with_icon_centered_category_google_fonts);

		$blog_image_with_icon_centered_category_fontstyle = new MikadoField("selectblanksimple","blog_image_with_icon_centered_category_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_image_with_icon_centered_category_fontstyle",$blog_image_with_icon_centered_category_fontstyle);

		$blog_image_with_icon_centered_category_fontweight = new MikadoField("selectblanksimple","blog_image_with_icon_centered_category_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_image_with_icon_centered_category_fontweight",$blog_image_with_icon_centered_category_fontweight);

		$row3 = new MikadoRow(true);
		$group6->addChild("row3",$row3);

		$blog_image_with_icon_centered_category_letterspacing = new MikadoField("textsimple","blog_image_with_icon_centered_category_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_image_with_icon_centered_category_letterspacing",$blog_image_with_icon_centered_category_letterspacing);

		$group7 = new MikadoGroup("Quote/Link Title Style","Define title styles for Quote/Link articles");
		$panel6->addChild("group7",$group7);

		$row1 = new MikadoRow();
		$group7->addChild("row1",$row1);

		$blog_image_with_icon_centered_ql_title_color = new MikadoField("colorsimple","blog_image_with_icon_centered_ql_title_color","","Text Color","This is some description");
		$row1->addChild("blog_image_with_icon_centered_ql_title_color",$blog_image_with_icon_centered_ql_title_color);

		$blog_image_with_icon_centered_ql_title_hover_color = new MikadoField("colorsimple","blog_image_with_icon_centered_ql_title_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_image_with_icon_centered_ql_title_hover_color",$blog_image_with_icon_centered_ql_title_hover_color);

		$blog_image_with_icon_centered_ql_title_fontsize = new MikadoField("textsimple","blog_image_with_icon_centered_ql_title_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_ql_title_font_size",$blog_image_with_icon_centered_ql_title_fontsize);

		$blog_image_with_icon_centered_ql_title_lineheight = new MikadoField("textsimple","blog_image_with_icon_centered_ql_title_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_ql_title_lineheight",$blog_image_with_icon_centered_ql_title_lineheight);

		$row2 = new MikadoRow(true);
		$group7->addChild("row2",$row2);

		$blog_image_with_icon_centered_ql_title_texttransform = new MikadoField("selectblanksimple","blog_image_with_icon_centered_ql_title_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_image_with_icon_centered_ql_title_texttransform",$blog_image_with_icon_centered_ql_title_texttransform);

		$blog_image_with_icon_centered_ql_title_google_fonts = new MikadoField("Fontsimple","blog_image_with_icon_centered_ql_title_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_image_with_icon_centered_ql_title_google_fonts",$blog_image_with_icon_centered_ql_title_google_fonts);

		$blog_image_with_icon_centered_ql_title_fontstyle = new MikadoField("selectblanksimple","blog_image_with_icon_centered_ql_title_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_image_with_icon_centered_ql_title_fontstyle",$blog_image_with_icon_centered_ql_title_fontstyle);

		$blog_image_with_icon_centered_ql_title_fontweight = new MikadoField("selectblanksimple","blog_image_with_icon_centered_ql_title_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_image_with_icon_centered_ql_title_fontweight",$blog_image_with_icon_centered_ql_title_fontweight);

		$row3 = new MikadoRow(true);
		$group7->addChild("row3",$row3);

		$blog_image_with_icon_centered_ql_title_letterspacing = new MikadoField("textsimple","blog_image_with_icon_centered_ql_title_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_image_with_icon_centered_ql_title_letterspacing",$blog_image_with_icon_centered_ql_title_letterspacing);

		$group8 = new MikadoGroup("Quote/Link Post Info Data","Define quote/link post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list.");
		$panel6->addChild("group8",$group8);

		$row1 = new MikadoRow();
		$group8->addChild("row1",$row1);

		$blog_image_with_icon_centered_ql_info_color = new MikadoField("colorsimple","blog_image_with_icon_centered_ql_info_color","","Text Color","This is some description");
		$row1->addChild("blog_image_with_icon_centered_ql_info_color",$blog_image_with_icon_centered_ql_info_color);

		$blog_image_with_icon_centered_ql_info_link_color = new MikadoField("colorsimple","blog_image_with_icon_centered_ql_info_link_color","","Link Color","This is some description");
		$row1->addChild("blog_image_with_icon_centered_ql_info_link_color",$blog_image_with_icon_centered_ql_info_link_color);

		$blog_image_with_icon_centered_ql_info_hover_color = new MikadoField("colorsimple","blog_image_with_icon_centered_ql_info_hover_color","","Hover Color","This is some description");
		$row1->addChild("blog_image_with_icon_centered_ql_info_hover_color",$blog_image_with_icon_centered_ql_info_hover_color);

		$blog_image_with_icon_centered_ql_info_fontsize = new MikadoField("textsimple","blog_image_with_icon_centered_ql_info_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_ql_info_fontsize",$blog_image_with_icon_centered_ql_info_fontsize);


		$row2 = new MikadoRow(true);
		$group8->addChild("row2",$row2);

		$blog_image_with_icon_centered_ql_info_lineheight = new MikadoField("textsimple","blog_image_with_icon_centered_ql_info_lineheight","","Line Height (px)","This is some description");
		$row2->addChild("blog_image_with_icon_centered_ql_info_lineheight",$blog_image_with_icon_centered_ql_info_lineheight);

		$blog_image_with_icon_centered_ql_info_google_fonts = new MikadoField("Fontsimple","blog_image_with_icon_centered_ql_info_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_image_with_icon_centered_ql_info_google_fonts",$blog_image_with_icon_centered_ql_info_google_fonts);

		$blog_image_with_icon_centered_ql_info_fontstyle = new MikadoField("selectblanksimple","blog_image_with_icon_centered_ql_info_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_image_with_icon_centered_ql_info_fontstyle",$blog_image_with_icon_centered_ql_info_fontstyle);

		$blog_image_with_icon_centered_ql_info_fontweight = new MikadoField("selectblanksimple","blog_image_with_icon_centered_ql_info_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_image_with_icon_centered_ql_info_fontweight",$blog_image_with_icon_centered_ql_info_fontweight);

		$row3 = new MikadoRow(true);
		$group8->addChild("row3",$row3);

		$blog_image_with_icon_centered_ql_info_texttransform = new MikadoField("selectblanksimple","blog_image_with_icon_centered_ql_info_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row3->addChild("blog_image_with_icon_centered_ql_info_texttransform",$blog_image_with_icon_centered_ql_info_texttransform);

		$blog_image_with_icon_centered_ql_info_letterspacing = new MikadoField("textsimple","blog_image_with_icon_centered_ql_info_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_image_with_icon_centered_ql_info_letterspacing",$blog_image_with_icon_centered_ql_info_letterspacing);

		$group9 = new MikadoGroup("Quote/Link Post Category","Define quote/link post category styles Note: Single Posts will take the same styles as in list.");
		$panel6->addChild("group9",$group9);

		$row1 = new MikadoRow();
		$group9->addChild("row1",$row1);

		$blog_image_with_icon_centered_ql_category_color = new MikadoField("colorsimple","blog_image_with_icon_centered_ql_category_color","","Text Color","This is some description");
		$row1->addChild("blog_image_with_icon_centered_ql_category_color",$blog_image_with_icon_centered_ql_category_color);

		$blog_image_with_icon_centered_ql_category_hover_color = new MikadoField("colorsimple","blog_image_with_icon_centered_ql_category_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_image_with_icon_centered_ql_category_hover_color",$blog_image_with_icon_centered_ql_category_hover_color);

		$blog_image_with_icon_centered_ql_category_fontsize = new MikadoField("textsimple","blog_image_with_icon_centered_ql_category_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_ql_category_fontsize",$blog_image_with_icon_centered_ql_category_fontsize);

		$blog_image_with_icon_centered_ql_category_lineheight = new MikadoField("textsimple","blog_image_with_icon_centered_ql_category_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_ql_category_lineheight",$blog_image_with_icon_centered_ql_category_lineheight);

		$row2 = new MikadoRow(true);
		$group9->addChild("row2",$row2);

		$blog_image_with_icon_centered_ql_category_texttransform = new MikadoField("selectblanksimple","blog_image_with_icon_centered_ql_category_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_image_with_icon_centered_ql_category_texttransform",$blog_image_with_icon_centered_ql_category_texttransform);

		$blog_image_with_icon_centered_ql_category_google_fonts = new MikadoField("Fontsimple","blog_image_with_icon_centered_ql_category_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_image_with_icon_centered_ql_category_google_fonts",$blog_image_with_icon_centered_ql_category_google_fonts);

		$blog_image_with_icon_centered_ql_category_fontstyle = new MikadoField("selectblanksimple","blog_image_with_icon_centered_ql_category_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_image_with_icon_centered_ql_category_fontstyle",$blog_image_with_icon_centered_ql_category_fontstyle);

		$blog_image_with_icon_centered_ql_category_fontweight = new MikadoField("selectblanksimple","blog_image_with_icon_centered_ql_category_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_image_with_icon_centered_ql_category_fontweight",$blog_image_with_icon_centered_ql_category_fontweight);

		$row3 = new MikadoRow(true);
		$group9->addChild("row3",$row3);

		$blog_image_with_icon_centered_ql_category_letterspacing = new MikadoField("textsimple","blog_image_with_icon_centered_ql_category_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_image_with_icon_centered_ql_category_letterspacing",$blog_image_with_icon_centered_ql_category_letterspacing);

		$group10 = new MikadoGroup("Quote Author Style","Define author styles for Quote articles");
		$panel6->addChild("group10",$group10);

		$row1 = new MikadoRow();
		$group10->addChild("row1",$row1);

		$blog_image_with_icon_centered_ql_author_color = new MikadoField("colorsimple","blog_image_with_icon_centered_ql_author_color","","Text Color","This is some description");
		$row1->addChild("blog_image_with_icon_centered_ql_author_color",$blog_image_with_icon_centered_ql_author_color);

		$blog_image_with_icon_centered_ql_author_hover_color = new MikadoField("colorsimple","blog_image_with_icon_centered_ql_author_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_image_with_icon_centered_ql_author_hover_color",$blog_image_with_icon_centered_ql_author_hover_color);

		$blog_image_with_icon_centered_ql_author_fontsize = new MikadoField("textsimple","blog_image_with_icon_centered_ql_author_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_ql_author_font_size",$blog_image_with_icon_centered_ql_author_fontsize);

		$blog_image_with_icon_centered_ql_author_lineheight = new MikadoField("textsimple","blog_image_with_icon_centered_ql_author_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_image_with_icon_centered_ql_author_lineheight",$blog_image_with_icon_centered_ql_author_lineheight);

		$row2 = new MikadoRow(true);
		$group10->addChild("row2",$row2);

		$blog_image_with_icon_centered_ql_author_texttransform = new MikadoField("selectblanksimple","blog_image_with_icon_centered_ql_author_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_image_with_icon_centered_ql_author_texttransform",$blog_image_with_icon_centered_ql_author_texttransform);

		$blog_image_with_icon_centered_ql_author_google_fonts = new MikadoField("Fontsimple","blog_image_with_icon_centered_ql_author_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_image_with_icon_centered_ql_author_google_fonts",$blog_image_with_icon_centered_ql_author_google_fonts);

		$blog_image_with_icon_centered_ql_author_fontstyle = new MikadoField("selectblanksimple","blog_image_with_icon_centered_ql_author_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_image_with_icon_centered_ql_author_fontstyle",$blog_image_with_icon_centered_ql_author_fontstyle);

		$blog_image_with_icon_centered_ql_author_fontweight = new MikadoField("selectblanksimple","blog_image_with_icon_centered_ql_author_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_image_with_icon_centered_ql_author_fontweight",$blog_image_with_icon_centered_ql_author_fontweight);

		$row3 = new MikadoRow(true);
		$group10->addChild("row3",$row3);

		$blog_image_with_icon_centered_ql_author_letterspacing = new MikadoField("textsimple","blog_image_with_icon_centered_ql_author_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_image_with_icon_centered_ql_author_letterspacing",$blog_image_with_icon_centered_ql_author_letterspacing);

		// Blog Post List - Blog: Title & Date First
		$panel7 = new MikadoPanel("Blog List Template Options: Title & Date First","blog_title_date_first_post_lists", "blog_title_date_first_show_options", "no");
		$blogPage->addChild("panel7",$panel7);

		$blog_title_date_first_number_of_chars = new MikadoField("text","blog_title_date_first_number_of_chars","45","Number of Words in Excerpt",' Enter a number of words in excerpt (article summary)', array(), array("col_width" => 3));
		$panel7->addChild("blog_title_date_first_number_of_chars",$blog_title_date_first_number_of_chars);

		$blog_title_date_first_read_more_button = new MikadoField("yesno","blog_title_date_first_read_more_button","no","Read More Button","Enable Read More Button");
		$panel7->addChild("blog_title_date_first_read_more_button",$blog_title_date_first_read_more_button);

		$blog_title_date_first_content_position = new MikadoField("select","blog_title_date_first_content_position","content_above_blog_list","Content Position","Choose content position for blog list template when sidebar is enabled. Note: This settings in only for template, not for archive pages", array(
			"content_above_blog_list" => "Content Above Blog List",
			"content_above_blog_list_and_sidebar" => "Content Above Blog List and Sidebar"
		));
		$panel7->addChild("blog_title_date_first_content_position", $blog_title_date_first_content_position);

		$blog_title_date_first_post_meta_data_section = new MikadoTitle("blog_title_date_first_post_meta_data_section", "Post Info Data Fields");
		$panel7->addChild("blog_title_date_first_post_meta_data_section", $blog_title_date_first_post_meta_data_section);

		$blog_title_date_first_show_categories = new MikadoField("yesno","blog_title_date_first_show_categories","no","Show Categories","Enabling this option will Show Categories on Post List");
		$panel7->addChild("blog_title_date_first_show_categories",$blog_title_date_first_show_categories);

		$blog_title_date_first_show_comments = new MikadoField("yesno","blog_title_date_first_show_comments","no","Show Comments","Enabling this option will Show Comments on Post List");
		$panel7->addChild("blog_title_date_first_show_comments",$blog_title_date_first_show_comments);

		$blog_title_date_first_show_author = new MikadoField("yesno","blog_title_date_first_show_author","no","Show Author Name","Enabling this option will show author name on Post List and Blog Post Single");
		$panel7->addChild("blog_title_date_first_show_author",$blog_title_date_first_show_author);

		$blog_title_date_first_show_date = new MikadoField("yesno","blog_title_date_first_show_date","yes","Show Date","Enabling this option will show date on Post List");
		$panel7->addChild("blog_title_date_first_show_date",$blog_title_date_first_show_date);

		$blog_title_date_first_show_share = new MikadoField("yesno","blog_title_date_first_show_share","yes","Show Share","Enabling this option will show share on Post List", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_title_date_first_share_options_container"));
		$panel7->addChild("blog_title_date_first_show_share",$blog_title_date_first_show_share);

			$blog_title_date_first_share_options_container = new MikadoContainer("blog_title_date_first_share_options_container","blog_title_date_first_show_share","yes");
			$panel7->addChild("blog_title_date_first_share_options_container",$blog_title_date_first_share_options_container);
			
				$blog_title_date_first_share_icon_color = new MikadoField("color","blog_title_date_first_share_icon_color","","Icon Color","Choose icon color for share dropdown");
				$blog_title_date_first_share_options_container->addChild("blog_title_date_first_share_icon_color",$blog_title_date_first_share_icon_color);

				$blog_title_date_first_share_icon_hover_color = new MikadoField("color","blog_title_date_first_share_icon_hover_color","","Icon Hover Color","Choose icon hover color for share dropdown");
				$blog_title_date_first_share_options_container->addChild("blog_title_date_first_share_icon_hover_color",$blog_title_date_first_share_icon_hover_color);

				$blog_title_date_first_share_background_color = new MikadoField("color","blog_title_date_first_share_background_color","","Background Color","Choose background color for share dropdown list field");
				$blog_title_date_first_share_options_container->addChild("blog_title_date_first_share_background_color",$blog_title_date_first_share_background_color);
				
		$blog_title_date_first_like = new MikadoField("yesno","blog_title_date_first_like","yes","Show Likes",'Enabling this option will turn on "Likes"');
		$panel7->addChild("blog_title_date_first_like",$blog_title_date_first_like);

		$blog_title_date_first_post_design_style = new MikadoTitle("blog_title_date_first_post_design_style", "Post Design Style");
		$panel7->addChild("blog_title_date_first_post_design_style", $blog_title_date_first_post_design_style);

		$group1 = new MikadoGroup("Separator Style","Define style for separator used in the bottom of the post.");
		$panel7->addChild("group1",$group1);

		$row1 = new MikadoRow();
		$group1->addChild("row1",$row1);

		$blog_title_date_first_separator_color = new MikadoField("colorsimple","blog_title_date_first_separator_color","","Color","Default color is #2f2a27.");
		$row1->addChild("blog_title_date_first_separator_color",$blog_title_date_first_separator_color);

		$blog_title_date_first_separator_width = new MikadoField("textsimple","blog_title_date_first_separator_width","","Width","Default value is 29px.");
		$row1->addChild("blog_title_date_first_separator_width",$blog_title_date_first_separator_width);

		$blog_title_date_first_separator_thickness = new MikadoField("textsimple","blog_title_date_first_separator_thickness","","Thickness","Default value is 1px.");
		$row1->addChild("blog_title_date_first_separator_thickness",$blog_title_date_first_separator_thickness);

		$blog_title_date_first_enable_text_box = new MikadoField("yesno","blog_title_date_first_enable_text_box","no","Enable Boxed Styled Post Content","Enable post text boxed features", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_title_date_first_enable_text_box_container"));
		$panel7->addChild("blog_title_date_first_enable_text_box",$blog_title_date_first_enable_text_box);

		$blog_title_date_first_enable_text_box_container = new MikadoContainer("blog_title_date_first_enable_text_box_container","blog_title_date_first_enable_text_box","no");
		$panel7->addChild("blog_title_date_first_enable_text_box_container",$blog_title_date_first_enable_text_box_container);

		$blog_title_date_first_box_background_color = new MikadoField("color","blog_title_date_first_box_background_color","","Background Color","Choose background color for post text box");
		$blog_title_date_first_enable_text_box_container->addChild("blog_title_date_first_box_background_color",$blog_title_date_first_box_background_color);

		$blog_title_date_first_box_border_color = new MikadoField("color","blog_title_date_first_box_border_color","","Border Color","Choose border color for post text box");
		$blog_title_date_first_enable_text_box_container->addChild("blog_title_date_first_box_border_color",$blog_title_date_first_box_border_color);

		$blog_title_date_first_box_padding = new MikadoField("text","blog_title_date_first_box_padding","","Text box padding","Please insert padding in format (top right bottom left) i.e. 5px 5px 5px 5px", array(), array("col_width" => 3));
		$blog_title_date_first_enable_text_box_container->addChild("blog_title_date_first_box_padding",$blog_title_date_first_box_padding);

		$group2 = new MikadoGroup("Quote/Link Background","Set background of Quote/Link post type");
		$panel7->addChild("group2",$group2);

		$row1 = new MikadoRow();
		$group2->addChild("row1",$row1);


		$blog_title_date_first_ql_background_image = new MikadoField("yesnosimple","blog_title_date_first_ql_background_image","no","Background Image","");
		$row1->addChild("blog_title_date_first_ql_background_image",$blog_title_date_first_ql_background_image);

		$blog_title_date_first_ql_background_color = new MikadoField("colorsimple","blog_title_date_first_ql_background_color","","Background Color","Default color is #ffffff.");
		$row1->addChild("blog_title_date_first_ql_background_color",$blog_title_date_first_ql_background_color);

		$blog_title_date_first_ql_hover_background_color = new MikadoField("colorsimple","blog_title_date_first_ql_hover_background_color","","Background Hover Color","Default color is #e6ae48.");
		$row1->addChild("blog_title_date_first_ql_hover_background_color",$blog_title_date_first_ql_hover_background_color);

		$blog_title_date_first_show_ql_mark = new MikadoField("yesno","blog_title_date_first_show_ql_mark","yes","Enable Quote/Link Icon","Show Icons for Quote/Link Post Format", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_title_date_first_show_ql_mark_container"));
		$panel7->addChild("blog_title_date_first_show_ql_mark",$blog_title_date_first_show_ql_mark);

		$blog_title_date_first_show_ql_mark_container = new MikadoContainer("blog_title_date_first_show_ql_mark_container","blog_title_date_first_show_ql_mark","no");
		$panel7->addChild("blog_title_date_first_show_ql_mark_container",$blog_title_date_first_show_ql_mark_container);

		$row1 = new MikadoRow();
		$blog_title_date_first_show_ql_mark_container->addChild("row1",$row1);

		$blog_title_date_first_ql_mark_color = new MikadoField("color","blog_title_date_first_ql_mark_color","","Icon Color","Choose icon color for quote/link post.");
		$row1->addChild("blog_title_date_first_ql_mark_color",$blog_title_date_first_ql_mark_color);

		$blog_title_date_first_ql_mark_hover_color = new MikadoField("color","blog_title_date_first_ql_mark_hover_color","","Icon Hover Color","Choose hover icon color for quote/link post.");
		$row1->addChild("blog_title_date_first_ql_mark_hover_color",$blog_title_date_first_ql_mark_hover_color);

		$group9 = new MikadoGroup("Blog List Spacing","Set spacing for blog layouts");
		$panel7->addChild("group9",$group9);

		$row1 = new MikadoRow();
		$group9->addChild("row1",$row1);

		$blog_title_date_first_title_margin_bottom = new MikadoField("textsimple","blog_title_date_first_title_margin_bottom","","Margin Under Title (px)","This is some description");
		$row1->addChild("blog_title_date_first_title_margin_bottom",$blog_title_date_first_title_margin_bottom);

		$blog_title_date_first_date_margin_bottom = new MikadoField("textsimple","blog_title_date_first_date_margin_bottom","","Margin Under Date (px)","This is some description");
		$row1->addChild("blog_title_date_first_date_margin_bottom",$blog_title_date_first_date_margin_bottom);

		$blog_title_date_first_image_margin_bottom = new MikadoField("textsimple","blog_title_date_first_image_margin_bottom","","Margin Under Image (px)","This is some description");
		$row1->addChild("blog_title_date_first_image_margin_bottom",$blog_title_date_first_image_margin_bottom);

		$blog_title_date_first_post_info_margin_top = new MikadoField("textsimple","blog_title_date_first_post_info_margin_top","","Margin Above Post Info (px)","This is some description");
		$row1->addChild("blog_title_date_first_post_info_margin_top",$blog_title_date_first_post_info_margin_top);

		$row2 = new MikadoRow();
		$group9->addChild("row2",$row2);

		$blog_title_date_first_separator_margin_top = new MikadoField("textsimple","blog_title_date_first_separator_margin_top","","Margin Above Separator (px)","This is some description");
		$row2->addChild("blog_title_date_first_separator_margin_top",$blog_title_date_first_separator_margin_top);

		$blog_title_date_first_article_margin_bottom = new MikadoField("textsimple","blog_title_date_first_article_margin_bottom","","Margin Between Articles (px)","This is some description");
		$row2->addChild("blog_title_date_first_article_margin_bottom",$blog_title_date_first_article_margin_bottom);

		$group10 = new MikadoGroup("Blog List Spacing for Quote and Link Post Type","Set spacing for blog layouts");
		$panel7->addChild("group10",$group10);

		$row1 = new MikadoRow();
		$group10->addChild("row1",$row1);

		$blog_title_date_first_ql_quote_author_margin_top = new MikadoField("textsimple","blog_title_date_first_ql_quote_author_margin_top","","Margin Above Quote Author (px)","This is some description");
		$row1->addChild("blog_title_date_first_ql_quote_author_margin_top",$blog_title_date_first_ql_quote_author_margin_top);

		$blog_title_date_first_ql_post_info_margin_top = new MikadoField("textsimple","blog_title_date_first_ql_post_info_margin_top","","Margin Above Post Info (px)","This is some description");
		$row1->addChild("blog_title_date_first_ql_post_info_margin_top",$blog_title_date_first_ql_post_info_margin_top);

		$post_text_styling= new MikadoTitle("post_text_styling", "Post Text Style");
		$panel7->addChild("post_text_styling", $post_text_styling);

		$group3 = new MikadoGroup("Post Title","Define title styles in this blog post template.");
		$panel7->addChild("group3",$group3);

		$row1 = new MikadoRow();
		$group3->addChild("row1",$row1);

		$blog_title_date_first_title_color = new MikadoField("colorsimple","blog_title_date_first_title_color","","Text Color","This is some description");
		$row1->addChild("blog_title_date_first_title_color",$blog_title_date_first_title_color);

		$blog_title_date_first_title_hover_color = new MikadoField("colorsimple","blog_title_date_first_title_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_title_date_first_title_hover_color",$blog_title_date_first_title_hover_color);

		$blog_title_date_first_title_fontsize = new MikadoField("textsimple","blog_title_date_first_title_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_title_date_first_title_fontsize",$blog_title_date_first_title_fontsize);

		$blog_title_date_first_title_lineheight = new MikadoField("textsimple","blog_title_date_first_title_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_title_date_first_title_lineheight",$blog_title_date_first_title_lineheight);

		$row2 = new MikadoRow(true);
		$group3->addChild("row2",$row2);

		$blog_title_date_first_title_texttransform = new MikadoField("selectblanksimple","blog_title_date_first_title_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_title_date_first_title_texttransform",$blog_title_date_first_title_texttransform);

		$blog_title_date_first_title_google_fonts = new MikadoField("Fontsimple","blog_title_date_first_title_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_title_date_first_title_google_fonts",$blog_title_date_first_title_google_fonts);

		$blog_title_date_first_title_fontstyle = new MikadoField("selectblanksimple","blog_title_date_first_title_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_title_date_first_title_fontstyle",$blog_title_date_first_title_fontstyle);

		$blog_title_date_first_title_fontweight = new MikadoField("selectblanksimple","blog_title_date_first_title_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_title_date_first_title_fontweight",$blog_title_date_first_title_fontweight);

		$row3 = new MikadoRow(true);
		$group3->addChild("row3",$row3);

		$blog_title_date_first_title_letterspacing = new MikadoField("textsimple","blog_title_date_first_title_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_title_date_first_title_letterspacing",$blog_title_date_first_title_letterspacing);

		$group4 = new MikadoGroup("Post Info Data","Define post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list");
		$panel7->addChild("group4",$group4);

		$row1 = new MikadoRow();
		$group4->addChild("row1",$row1);

		$blog_title_date_first_info_color = new MikadoField("colorsimple","blog_title_date_first_info_color","","Text Color","This is some description");
		$row1->addChild("blog_title_date_first_info_color",$blog_title_date_first_info_color);

		$blog_title_date_first_info_link_color = new MikadoField("colorsimple","blog_title_date_first_info_link_color","","Link Color","This is some description");
		$row1->addChild("blog_title_date_first_info_link_color",$blog_title_date_first_info_link_color);

		$blog_title_date_first_info_hover_color = new MikadoField("colorsimple","blog_title_date_first_info_hover_color","","Link Hover Color","This is some description");
		$row1->addChild("blog_title_date_first_info_hover_color",$blog_title_date_first_info_hover_color);

		$blog_title_date_first_info_fontsize = new MikadoField("textsimple","blog_title_date_first_info_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_title_date_first_info_fontsize",$blog_title_date_first_info_fontsize);

		$row2 = new MikadoRow(true);
		$group4->addChild("row2",$row2);


		$blog_title_date_first_info_lineheight = new MikadoField("textsimple","blog_title_date_first_info_lineheight","","Line Height (px)","This is some description");
		$row2->addChild("blog_title_date_first_info_lineheight",$blog_title_date_first_info_lineheight);

		$blog_title_date_first_info_google_fonts = new MikadoField("Fontsimple","blog_title_date_first_info_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_title_date_first_info_google_fonts",$blog_title_date_first_info_google_fonts);

		$blog_title_date_first_info_fontstyle = new MikadoField("selectblanksimple","blog_title_date_first_info_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_title_date_first_info_fontstyle",$blog_title_date_first_info_fontstyle);

		$blog_title_date_first_info_fontweight = new MikadoField("selectblanksimple","blog_title_date_first_info_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_title_date_first_info_fontweight",$blog_title_date_first_info_fontweight);

		$row3 = new MikadoRow(true);
		$group4->addChild("row3",$row3);

		$blog_title_date_first_info_texttransform = new MikadoField("selectblanksimple","blog_title_date_first_info_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row3->addChild("blog_title_date_first_info_texttransform",$blog_title_date_first_info_texttransform);

		$blog_title_date_first_info_letterspacing = new MikadoField("textsimple","blog_title_date_first_info_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_title_date_first_info_letterspacing",$blog_title_date_first_info_letterspacing);

		$group5 = new MikadoGroup("Post Date","Define date styles in this blog post template.");
		$panel7->addChild("group5",$group5);

		$row1 = new MikadoRow();
		$group5->addChild("row1",$row1);

		$blog_title_date_first_date_color = new MikadoField("colorsimple","blog_title_date_first_date_color","","Text Color","This is some description");
		$row1->addChild("blog_title_date_first_date_color",$blog_title_date_first_date_color);

		$blog_title_date_first_date_fontsize = new MikadoField("textsimple","blog_title_date_first_date_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_title_date_first_date_fontsize",$blog_title_date_first_date_fontsize);

		$blog_title_date_first_date_lineheight = new MikadoField("textsimple","blog_title_date_first_date_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_title_date_first_date_lineheight",$blog_title_date_first_date_lineheight);

		$row2 = new MikadoRow(true);
		$group5->addChild("row2",$row2);

		$blog_title_date_first_date_texttransform = new MikadoField("selectblanksimple","blog_title_date_first_date_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_title_date_first_date_texttransform",$blog_title_date_first_date_texttransform);

		$blog_title_date_first_date_google_fonts = new MikadoField("Fontsimple","blog_title_date_first_date_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_title_date_first_date_google_fonts",$blog_title_date_first_date_google_fonts);

		$blog_title_date_first_date_fontstyle = new MikadoField("selectblanksimple","blog_title_date_first_date_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_title_date_first_date_fontstyle",$blog_title_date_first_date_fontstyle);

		$blog_title_date_first_date_fontweight = new MikadoField("selectblanksimple","blog_title_date_first_date_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_title_date_first_date_fontweight",$blog_title_date_first_date_fontweight);

		$row3 = new MikadoRow(true);
		$group5->addChild("row3",$row3);

		$blog_title_date_first_date_letterspacing = new MikadoField("textsimple","blog_title_date_first_date_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_title_date_first_date_letterspacing",$blog_title_date_first_date_letterspacing);


		$group6 = new MikadoGroup("Quote/Link Title Style","Define title styles for Quote/Link articles");
		$panel7->addChild("group6",$group6);

		$row1 = new MikadoRow();
		$group6->addChild("row1",$row1);

		$blog_title_date_first_ql_title_color = new MikadoField("colorsimple","blog_title_date_first_ql_title_color","","Text Color","This is some description");
		$row1->addChild("blog_title_date_first_ql_title_color",$blog_title_date_first_ql_title_color);

		$blog_title_date_first_ql_title_hover_color = new MikadoField("colorsimple","blog_title_date_first_ql_title_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_title_date_first_ql_title_hover_color",$blog_title_date_first_ql_title_hover_color);

		$blog_title_date_first_ql_title_fontsize = new MikadoField("textsimple","blog_title_date_first_ql_title_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_title_date_first_ql_title_font_size",$blog_title_date_first_ql_title_fontsize);

		$blog_title_date_first_ql_title_lineheight = new MikadoField("textsimple","blog_title_date_first_ql_title_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_title_date_first_ql_title_lineheight",$blog_title_date_first_ql_title_lineheight);

		$row2 = new MikadoRow(true);
		$group6->addChild("row2",$row2);

		$blog_title_date_first_ql_title_texttransform = new MikadoField("selectblanksimple","blog_title_date_first_ql_title_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_title_date_first_ql_title_texttransform",$blog_title_date_first_ql_title_texttransform);

		$blog_title_date_first_ql_title_google_fonts = new MikadoField("Fontsimple","blog_title_date_first_ql_title_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_title_date_first_ql_title_google_fonts",$blog_title_date_first_ql_title_google_fonts);

		$blog_title_date_first_ql_title_fontstyle = new MikadoField("selectblanksimple","blog_title_date_first_ql_title_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_title_date_first_ql_title_fontstyle",$blog_title_date_first_ql_title_fontstyle);

		$blog_title_date_first_ql_title_fontweight = new MikadoField("selectblanksimple","blog_title_date_first_ql_title_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_title_date_first_ql_title_fontweight",$blog_title_date_first_ql_title_fontweight);

		$row3 = new MikadoRow(true);
		$group6->addChild("row3",$row3);

		$blog_title_date_first_ql_title_letterspacing = new MikadoField("textsimple","blog_title_date_first_ql_title_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_title_date_first_ql_title_letterspacing",$blog_title_date_first_ql_title_letterspacing);

		$group7 = new MikadoGroup("Quote/Link Post Info Data","Define quote/link post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list.");
		$panel7->addChild("group7",$group7);

		$row1 = new MikadoRow();
		$group7->addChild("row1",$row1);

		$blog_title_date_first_ql_info_color = new MikadoField("colorsimple","blog_title_date_first_ql_info_color","","Text Color","This is some description");
		$row1->addChild("blog_title_date_first_ql_info_color",$blog_title_date_first_ql_info_color);

		$blog_title_date_first_ql_info_link_color = new MikadoField("colorsimple","blog_title_date_first_ql_info_link_color","","Link Color","This is some description");
		$row1->addChild("blog_title_date_first_ql_info_link_color",$blog_title_date_first_ql_info_link_color);

		$blog_title_date_first_ql_info_hover_color = new MikadoField("colorsimple","blog_title_date_first_ql_info_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_title_date_first_ql_info_hover_color",$blog_title_date_first_ql_info_hover_color);

		$blog_title_date_first_ql_info_fontsize = new MikadoField("textsimple","blog_title_date_first_ql_info_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_title_date_first_ql_info_fontsize",$blog_title_date_first_ql_info_fontsize);



		$row2 = new MikadoRow(true);
		$group7->addChild("row2",$row2);

		$blog_title_date_first_ql_info_lineheight = new MikadoField("textsimple","blog_title_date_first_ql_info_lineheight","","Line Height (px)","This is some description");
		$row2->addChild("blog_title_date_first_ql_info_lineheight",$blog_title_date_first_ql_info_lineheight);

		$blog_title_date_first_ql_info_google_fonts = new MikadoField("Fontsimple","blog_title_date_first_ql_info_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_title_date_first_ql_info_google_fonts",$blog_title_date_first_ql_info_google_fonts);

		$blog_title_date_first_ql_info_fontstyle = new MikadoField("selectblanksimple","blog_title_date_first_ql_info_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_title_date_first_ql_info_fontstyle",$blog_title_date_first_ql_info_fontstyle);

		$blog_title_date_first_ql_info_fontweight = new MikadoField("selectblanksimple","blog_title_date_first_ql_info_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_title_date_first_ql_info_fontweight",$blog_title_date_first_ql_info_fontweight);

		$row3 = new MikadoRow(true);
		$group7->addChild("row3",$row3);


		$blog_title_date_first_ql_info_texttransform = new MikadoField("selectblanksimple","blog_title_date_first_ql_info_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row3->addChild("blog_title_date_first_ql_info_texttransform",$blog_title_date_first_ql_info_texttransform);

		$blog_title_date_first_ql_info_letterspacing = new MikadoField("textsimple","blog_title_date_first_ql_info_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_title_date_first_ql_info_letterspacing",$blog_title_date_first_ql_info_letterspacing);


		$group8 = new MikadoGroup("Quote Author Style","Define author style for Quote articles");
		$panel7->addChild("group8",$group8);

		$row1 = new MikadoRow();
		$group8->addChild("row1",$row1);

		$blog_title_date_first_ql_author_color = new MikadoField("colorsimple","blog_title_date_first_ql_author_color","","Text Color","This is some description");
		$row1->addChild("blog_title_date_first_ql_author_color",$blog_title_date_first_ql_author_color);

		$blog_title_date_first_ql_author_hover_color = new MikadoField("colorsimple","blog_title_date_first_ql_author_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_title_date_first_ql_author_hover_color",$blog_title_date_first_ql_author_hover_color);

		$blog_title_date_first_ql_author_fontsize = new MikadoField("textsimple","blog_title_date_first_ql_author_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_title_date_first_ql_author_font_size",$blog_title_date_first_ql_author_fontsize);

		$blog_title_date_first_ql_author_lineheight = new MikadoField("textsimple","blog_title_date_first_ql_author_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_title_date_first_ql_author_lineheight",$blog_title_date_first_ql_author_lineheight);

		$row2 = new MikadoRow(true);
		$group8->addChild("row2",$row2);

		$blog_title_date_first_ql_author_texttransform = new MikadoField("selectblanksimple","blog_title_date_first_ql_author_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_title_date_first_ql_author_texttransform",$blog_title_date_first_ql_author_texttransform);

		$blog_title_date_first_ql_author_google_fonts = new MikadoField("Fontsimple","blog_title_date_first_ql_author_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_title_date_first_ql_author_google_fonts",$blog_title_date_first_ql_author_google_fonts);

		$blog_title_date_first_ql_author_fontstyle = new MikadoField("selectblanksimple","blog_title_date_first_ql_author_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_title_date_first_ql_author_fontstyle",$blog_title_date_first_ql_author_fontstyle);

		$blog_title_date_first_ql_author_fontweight = new MikadoField("selectblanksimple","blog_title_date_first_ql_author_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_title_date_first_ql_author_fontweight",$blog_title_date_first_ql_author_fontweight);

		$row3 = new MikadoRow(true);
		$group8->addChild("row3",$row3);

		$blog_title_date_first_ql_author_letterspacing = new MikadoField("textsimple","blog_title_date_first_ql_author_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_title_date_first_ql_author_letterspacing",$blog_title_date_first_ql_author_letterspacing);

		// Blog Post List - Blog:TITLE & AUTHOR (CENTERED)
		$panel8 = new MikadoPanel("Blog List Template Options: Title & Author (Centered)","blog_title_author_centered_post_lists", "blog_title_author_centered_show_options", "no");
		$blogPage->addChild("panel8",$panel8);

		$blog_title_author_centered_number_of_chars = new MikadoField("text","blog_title_author_centered_number_of_chars","45","Number of Words in Excerpt",' Enter a number of words in excerpt (article summary)', array(), array("col_width" => 3));
		$panel8->addChild("blog_title_author_centered_number_of_chars",$blog_title_author_centered_number_of_chars);

		$blog_title_author_centered_read_more_button = new MikadoField("yesno","blog_title_author_centered_read_more_button","no","Read More Button","Enable Read More Button");
		$panel8->addChild("blog_title_author_centered_read_more_button",$blog_title_author_centered_read_more_button);

		$blog_title_author_centered_content_position = new MikadoField("select","blog_title_author_centered_content_position","content_above_blog_list","Content Position","Choose content position for blog list template when sidebar is enabled. Note: This settings in only for template, not for archive pages", array(
			"content_above_blog_list" => "Content Above Blog List",
			"content_above_blog_list_and_sidebar" => "Content Above Blog List and Sidebar"
		));
		$panel8->addChild("blog_title_author_centered_content_position",$blog_title_author_centered_content_position);

		$blog_title_author_centered_post_meta_data_section = new MikadoTitle("blog_title_author_centered_post_meta_data_section", "Post Info Data Fields");
		$panel8->addChild("blog_title_author_centered_post_meta_data_section", $blog_title_author_centered_post_meta_data_section);

		$blog_title_author_centered_show_categories = new MikadoField("yesno","blog_title_author_centered_show_categories","no","Show Categories","Enabling this option will Show Categories on Post List");
		$panel8->addChild("blog_title_author_centered_show_categories",$blog_title_author_centered_show_categories);

		$blog_title_author_centered_show_comments = new MikadoField("yesno","blog_title_author_centered_show_comments","no","Show Comments","Enabling this option will Show Comments on Post List");
		$panel8->addChild("blog_title_author_centered_show_comments",$blog_title_author_centered_show_comments);

		$blog_title_author_centered_show_author = new MikadoField("yesno","blog_title_author_centered_show_author","yes","Show Author Name","Enabling this option will show author name on Post List and Blog Post Single");
		$panel8->addChild("blog_title_author_centered_show_author",$blog_title_author_centered_show_author);

		$blog_title_author_centered_show_date = new MikadoField("yesno","blog_title_author_centered_show_date","no","Show Date","Enabling this option will show date on Post List");
		$panel8->addChild("blog_title_author_centered_hide_date",$blog_title_author_centered_show_date);

		$blog_title_author_centered_show_share = new MikadoField("yesno","blog_title_author_centered_show_share","yes","Show Share","Enabling this option will show share on Post List",array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_title_author_centered_share_options_container"));
		$panel8->addChild("blog_title_author_centered_show_share",$blog_title_author_centered_show_share);

		$blog_title_author_centered_share_options_container = new MikadoContainer("blog_title_author_centered_share_options_container","blog_title_author_centered_show_share","no");
		$panel8->addChild("blog_title_author_centered_share_options_container",$blog_title_author_centered_share_options_container);

		$blog_title_author_centered_share_icon_color = new MikadoField("color","blog_title_author_centered_share_icon_color","","Icon Color","Choose icon color for share dropdown");
		$blog_title_author_centered_share_options_container->addChild("blog_title_author_centered_share_icon_color",$blog_title_author_centered_share_icon_color);

		$blog_title_author_centered_share_icon_hover_color = new MikadoField("color","blog_title_author_centered_share_icon_hover_color","","Icon Hover Color","Choose icon hover color for share dropdown");
		$blog_title_author_centered_share_options_container->addChild("blog_title_author_centered_share_icon_hover_color",$blog_title_author_centered_share_icon_hover_color);

		$blog_title_author_centered_share_background_color = new MikadoField("color","blog_title_author_centered_share_background_color","","Background Color","Choose background color for share dropdown list field");
		$blog_title_author_centered_share_options_container->addChild("blog_title_author_centered_share_background_color",$blog_title_author_centered_share_background_color);

		$blog_title_author_centered_like = new MikadoField("yesno","blog_title_author_centered_like","yes","Show Likes",'Enabling this option will turn on "Likes"');
		$panel8->addChild("blog_title_author_centered_like",$blog_title_author_centered_like);

		$blog_title_author_centered_post_design_style = new MikadoTitle("blog_title_author_centered_post_design_style", "Post Design Style");
		$panel8->addChild("blog_title_author_centered_post_design_style", $blog_title_author_centered_post_design_style);

		$group1 = new MikadoGroup("Separator Style","Set separator styles");
		$panel8->addChild("group1",$group1);

		$row1 = new MikadoRow();
		$group1->addChild("row1",$row1);

		$blog_title_author_centered_separator_color = new MikadoField("colorsimple","blog_title_author_centered_separator_color","","Color","Default color is #2f2a27.");
		$row1->addChild("blog_title_author_centered_separator_color",$blog_title_author_centered_separator_color);

		$blog_title_author_centered_separator_width = new MikadoField("textsimple","blog_title_author_centered_separator_width","","Width","Default value is 29px.");
		$row1->addChild("blog_title_author_centered_separator_width",$blog_title_author_centered_separator_width);

		$blog_title_author_centered_separator_thickness = new MikadoField("textsimple","blog_title_author_centered_separator_thickness","","Thickness","Default value is 1px.");
		$row1->addChild("blog_title_author_centered_separator_thickness",$blog_title_author_centered_separator_thickness);

		$blog_title_author_centered_enable_text_box = new MikadoField("yesno","blog_title_author_centered_enable_text_box","no","Enable Boxed Styled Post Content","Enable post text boxed features", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_title_author_centered_enable_text_box_container"));
		$panel8->addChild("blog_title_author_centered_enable_text_box",$blog_title_author_centered_enable_text_box);

		$blog_title_author_centered_enable_text_box_container = new MikadoContainer("blog_title_author_centered_enable_text_box_container","blog_title_author_centered_enable_text_box","no");
		$panel8->addChild("blog_title_author_centered_enable_text_box_container",$blog_title_author_centered_enable_text_box_container);

		$blog_title_author_centered_box_background_color = new MikadoField("color","blog_title_author_centered_box_background_color","","Background Color","Choose background color for post text box");
		$blog_title_author_centered_enable_text_box_container->addChild("blog_title_author_centered_box_background_color",$blog_title_author_centered_box_background_color);

		$blog_title_author_centered_box_border_color = new MikadoField("color","blog_title_author_centered_box_border_color","","Border Color","Choose border color for post text box");
		$blog_title_author_centered_enable_text_box_container->addChild("blog_title_author_centered_box_border_color",$blog_title_author_centered_box_border_color);

		$blog_title_author_centered_box_padding = new MikadoField("text","blog_title_author_centered_box_padding","","Text box padding","Please insert padding in format (top right bottom left) i.e. 5px 5px 5px 5px", array(), array("col_width" => 3));
		$blog_title_author_centered_enable_text_box_container->addChild("blog_title_author_centered_box_padding",$blog_title_author_centered_box_padding);

		$group2 = new MikadoGroup("Quote/Link Background","Set background of Quote/Link post type");
		$panel8->addChild("group2",$group2);

		$row1 = new MikadoRow();
		$group2->addChild("row1",$row1);

		$blog_title_author_centered_ql_background_image = new MikadoField("yesnosimple","blog_title_author_centered_ql_background_image","no","Background Image","");
		$row1->addChild("blog_title_author_centered_ql_background_image",$blog_title_author_centered_ql_background_image);

		$blog_title_author_centered_ql_background_color = new MikadoField("colorsimple","blog_title_author_centered_ql_background_color","","Background Color","Default color is #ffffff.");
		$row1->addChild("blog_title_author_centered_ql_background_color",$blog_title_author_centered_ql_background_color);

		$blog_title_author_centered_ql_hover_background_color = new MikadoField("colorsimple","blog_title_author_centered_ql_hover_background_color","","Background Hover Color","Default color is #e6ae48.");
		$row1->addChild("blog_title_author_centered_ql_hover_background_color",$blog_title_author_centered_ql_hover_background_color);

		$blog_title_author_centered_show_ql_mark = new MikadoField("yesno","blog_title_author_centered_show_ql_mark","yes","Enable Quote/Link Icon","Show Icons for Quote/Link Post Format", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_title_author_centered_show_ql_mark_container"));
		$panel8->addChild("blog_title_author_centered_show_ql_mark",$blog_title_author_centered_show_ql_mark);

		$blog_title_author_centered_show_ql_mark_container = new MikadoContainer("blog_title_author_centered_show_ql_mark_container","blog_title_author_centered_show_ql_mark","no");
		$panel8->addChild("blog_title_author_centered_show_ql_mark_container",$blog_title_author_centered_show_ql_mark_container);

		$row1 = new MikadoRow();
		$blog_title_author_centered_show_ql_mark_container->addChild("row1",$row1);

		$blog_title_author_centered_ql_mark_color = new MikadoField("color","blog_title_author_centered_ql_mark_color","","Icon Color","Choose icon color for quote/link post.");
		$row1->addChild("blog_title_author_centered_ql_mark_color",$blog_title_author_centered_ql_mark_color);

		$blog_title_author_centered_ql_mark_hover_color = new MikadoField("color","blog_title_author_centered_ql_mark_hover_color","","Icon Hover Color","Choose hover icon color for quote/link post.");
		$row1->addChild("blog_title_author_centered_ql_mark_hover_color",$blog_title_author_centered_ql_mark_hover_color);

		$group9 = new MikadoGroup("Blog List Spacing","Set spacing for blog layouts");
		$panel8->addChild("group9",$group9);

		$row1 = new MikadoRow();
		$group9->addChild("row1",$row1);

		$blog_title_author_centered_image_margin_bottom = new MikadoField("textsimple","blog_title_author_centered_image_margin_bottom","","Margin Under Image (px)","This is some description");
		$row1->addChild("blog_title_author_centered_image_margin_bottom",$blog_title_author_centered_image_margin_bottom);

		$blog_title_author_centered_title_margin_bottom = new MikadoField("textsimple","blog_title_author_centered_title_margin_bottom","","Margin Under Title (px)","This is some description");
		$row1->addChild("blog_title_author_centered_title_margin_bottom",$blog_title_author_centered_title_margin_bottom);

		$blog_title_author_centered_author_margin_top = new MikadoField("textsimple","blog_title_author_centered_author_margin_top","","Margin Above Author (px)","This is some description");
		$row1->addChild("blog_title_author_centered_author_margin_top",$blog_title_author_centered_author_margin_top);

		$blog_title_author_centered_author_margin_bottom = new MikadoField("textsimple","blog_title_author_centered_author_margin_bottom","","Margin Under Author (px)","This is some description");
		$row1->addChild("blog_title_author_centered_author_margin_bottom",$blog_title_author_centered_author_margin_bottom);

		$row2 = new MikadoRow();
		$group9->addChild("row2",$row2);

		$blog_title_author_centered_post_info_margin_top = new MikadoField("textsimple","blog_title_author_centered_post_info_margin_top","","Margin Above Post Info (px)","This is some description");
		$row2->addChild("blog_title_author_centered_post_info_margin_top",$blog_title_author_centered_post_info_margin_top);

		$blog_title_author_centered_article_margin_bottom = new MikadoField("textsimple","blog_title_author_centered_article_margin_bottom","","Margin Between Articles (px)","This is some description");
		$row2->addChild("blog_title_author_centered_article_margin_bottom",$blog_title_author_centered_article_margin_bottom);

		$group10 = new MikadoGroup("Blog List Spacing for Quote and Link Post Type","Set spacing for blog layouts");
		$panel8->addChild("group10",$group10);

		$row1 = new MikadoRow();
		$group10->addChild("row1",$row1);

		$blog_title_author_centered_ql_quote_author_margin_top = new MikadoField("textsimple","blog_title_author_centered_ql_quote_author_margin_top","","Margin Above Quote Author (px)","This is some description");
		$row1->addChild("blog_title_author_centered_ql_quote_author_margin_top",$blog_title_author_centered_ql_quote_author_margin_top);

		$blog_title_author_centered_ql_icon_margin_top = new MikadoField("textsimple","blog_title_author_centered_ql_icon_margin_top","","Margin Above Quote Quote/Link Icon (px)","This is some description");
		$row1->addChild("blog_title_author_centered_ql_icon_margin_top",$blog_title_author_centered_ql_icon_margin_top);

		$blog_title_author_centered_ql_post_info_margin_top = new MikadoField("textsimple","blog_title_author_centered_ql_post_info_margin_top","","Margin Above Post Info (px)","This is some description");
		$row1->addChild("blog_title_author_centered_ql_post_info_margin_top",$blog_title_author_centered_ql_post_info_margin_top);

		$post_text_styling= new MikadoTitle("post_text_styling", "Post Text Style");
		$panel8->addChild("post_text_styling", $post_text_styling);

		$group3 = new MikadoGroup("Post Title","Define title styles in this blog post template.");
		$panel8->addChild("group3",$group3);

		$row1 = new MikadoRow();
		$group3->addChild("row1",$row1);

		$blog_title_author_centered_title_color = new MikadoField("colorsimple","blog_title_author_centered_title_color","","Text Color","This is some description");
		$row1->addChild("blog_title_author_centered_title_color",$blog_title_author_centered_title_color);

		$blog_title_author_centered_title_hover_color = new MikadoField("colorsimple","blog_title_author_centered_title_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_title_author_centered_title_hover_color",$blog_title_author_centered_title_hover_color);

		$blog_title_author_centered_title_fontsize = new MikadoField("textsimple","blog_title_author_centered_title_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_title_author_centered_title_fontsize",$blog_title_author_centered_title_fontsize);

		$blog_title_author_centered_title_lineheight = new MikadoField("textsimple","blog_title_author_centered_title_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_title_author_centered_title_lineheight",$blog_title_author_centered_title_lineheight);

		$row2 = new MikadoRow(true);
		$group3->addChild("row2",$row2);

		$blog_title_author_centered_title_texttransform = new MikadoField("selectblanksimple","blog_title_author_centered_title_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_title_author_centered_title_texttransform",$blog_title_author_centered_title_texttransform);

		$blog_title_author_centered_title_google_fonts = new MikadoField("Fontsimple","blog_title_author_centered_title_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_title_author_centered_title_google_fonts",$blog_title_author_centered_title_google_fonts);

		$blog_title_author_centered_title_fontstyle = new MikadoField("selectblanksimple","blog_title_author_centered_title_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_title_author_centered_title_fontstyle",$blog_title_author_centered_title_fontstyle);

		$blog_title_author_centered_title_fontweight = new MikadoField("selectblanksimple","blog_title_author_centered_title_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_title_author_centered_title_fontweight",$blog_title_author_centered_title_fontweight);

		$row3 = new MikadoRow(true);
		$group3->addChild("row3",$row3);

		$blog_title_author_centered_title_letterspacing = new MikadoField("textsimple","blog_title_author_centered_title_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_title_author_centered_title_letterspacing",$blog_title_author_centered_title_letterspacing);

		$group4 = new MikadoGroup("Post Info Data","Define post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list");
		$panel8->addChild("group4",$group4);

		$row1 = new MikadoRow();
		$group4->addChild("row1",$row1);

		$blog_title_author_centered_info_color = new MikadoField("colorsimple","blog_title_author_centered_info_color","","Text Color","This is some description");
		$row1->addChild("blog_title_author_centered_info_color",$blog_title_author_centered_info_color);

		$blog_title_author_centered_info_link_color = new MikadoField("colorsimple","blog_title_author_centered_info_link_color","","Link Color","This is some description");
		$row1->addChild("blog_title_author_centered_info_link_color",$blog_title_author_centered_info_link_color);

		$blog_title_author_centered_info_hover_color = new MikadoField("colorsimple","blog_title_author_centered_info_hover_color","","Link Hover Color","This is some description");
		$row1->addChild("blog_title_author_centered_info_hover_color",$blog_title_author_centered_info_hover_color);

		$blog_title_author_centered_info_fontsize = new MikadoField("textsimple","blog_title_author_centered_info_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_title_author_centered_info_fontsize",$blog_title_author_centered_info_fontsize);

		$row2 = new MikadoRow(true);
		$group4->addChild("row2",$row2);

		$blog_title_author_centered_info_lineheight = new MikadoField("textsimple","blog_title_author_centered_info_lineheight","","Line Height (px)","This is some description");
		$row2->addChild("blog_title_author_centered_info_lineheight",$blog_title_author_centered_info_lineheight);

		$blog_title_author_centered_info_google_fonts = new MikadoField("Fontsimple","blog_title_author_centered_info_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_title_author_centered_info_google_fonts",$blog_title_author_centered_info_google_fonts);

		$blog_title_author_centered_info_fontstyle = new MikadoField("selectblanksimple","blog_title_author_centered_info_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_title_author_centered_info_fontstyle",$blog_title_author_centered_info_fontstyle);

		$blog_title_author_centered_info_fontweight = new MikadoField("selectblanksimple","blog_title_author_centered_info_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_title_author_centered_info_fontweight",$blog_title_author_centered_info_fontweight);

		$row3 = new MikadoRow(true);
		$group4->addChild("row3",$row3);

		$blog_title_author_centered_info_letterspacing = new MikadoField("textsimple","blog_title_author_centered_info_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_title_author_centered_info_letterspacing",$blog_title_author_centered_info_letterspacing);

		$blog_title_author_centered_info_texttransform = new MikadoField("selectblanksimple","blog_title_author_centered_info_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row3->addChild("blog_title_author_centered_info_texttransform",$blog_title_author_centered_info_texttransform);


		$group5 = new MikadoGroup("Post Author","Define author styles in this blog post template.");
		$panel8->addChild("group5",$group5);

		$row1 = new MikadoRow();
		$group5->addChild("row1",$row1);

		$blog_title_author_centered_author_color = new MikadoField("colorsimple","blog_title_author_centered_author_color","","Text Color","This is some description");
		$row1->addChild("blog_title_author_centered_author_color",$blog_title_author_centered_author_color);

		$blog_title_author_centered_author_link_color = new MikadoField("colorsimple","blog_title_author_centered_author_link_color","","Link Color","This is some description");
		$row1->addChild("blog_title_author_centered_author_link_color",$blog_title_author_centered_author_link_color);

		$blog_title_author_centered_author_hover_color = new MikadoField("colorsimple","blog_title_author_centered_author_hover_color","","Link Hover Color","This is some description");
		$row1->addChild("blog_title_author_centered_author_hover_color",$blog_title_author_centered_author_hover_color);

		$blog_title_author_centered_author_fontsize = new MikadoField("textsimple","blog_title_author_centered_author_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_title_author_centered_author_fontsize",$blog_title_author_centered_author_fontsize);


		$row2 = new MikadoRow(true);
		$group5->addChild("row2",$row2);

		$blog_title_author_centered_author_lineheight = new MikadoField("textsimple","blog_title_author_centered_author_lineheight","","Line Height (px)","This is some description");
		$row2->addChild("blog_title_author_centered_author_lineheight",$blog_title_author_centered_author_lineheight);


		$blog_title_author_centered_author_google_fonts = new MikadoField("Fontsimple","blog_title_author_centered_author_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_title_author_centered_author_google_fonts",$blog_title_author_centered_author_google_fonts);

		$blog_title_author_centered_author_fontstyle = new MikadoField("selectblanksimple","blog_title_author_centered_author_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_title_author_centered_author_fontstyle",$blog_title_author_centered_author_fontstyle);

		$blog_title_author_centered_author_fontweight = new MikadoField("selectblanksimple","blog_title_author_centered_author_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_title_author_centered_author_fontweight",$blog_title_author_centered_author_fontweight);

		$row3 = new MikadoRow(true);
		$group5->addChild("row3",$row3);

		$blog_title_author_centered_author_texttransform = new MikadoField("selectblanksimple","blog_title_author_centered_author_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row3->addChild("blog_title_author_centered_author_texttransform",$blog_title_author_centered_author_texttransform);

		$blog_title_author_centered_author_letterspacing = new MikadoField("textsimple","blog_title_author_centered_author_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_title_author_centered_author_letterspacing",$blog_title_author_centered_author_letterspacing);

		$group6 = new MikadoGroup("Quote/Link Title Style","Define title styles for Quote/Link articles");
		$panel8->addChild("group6",$group6);

		$row1 = new MikadoRow();
		$group6->addChild("row1",$row1);

		$blog_title_author_centered_ql_title_color = new MikadoField("colorsimple","blog_title_author_centered_ql_title_color","","Text Color","This is some description");
		$row1->addChild("blog_title_author_centered_ql_title_color",$blog_title_author_centered_ql_title_color);

		$blog_title_author_centered_ql_title_hover_color = new MikadoField("colorsimple","blog_title_author_centered_ql_title_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_title_author_centered_ql_title_hover_color",$blog_title_author_centered_ql_title_hover_color);

		$blog_title_author_centered_ql_title_fontsize = new MikadoField("textsimple","blog_title_author_centered_ql_title_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_title_author_centered_ql_title_font_size",$blog_title_author_centered_ql_title_fontsize);

		$blog_title_author_centered_ql_title_lineheight = new MikadoField("textsimple","blog_title_author_centered_ql_title_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_title_author_centered_ql_title_lineheight",$blog_title_author_centered_ql_title_lineheight);


		$row2 = new MikadoRow(true);
		$group6->addChild("row2",$row2);

		$blog_title_author_centered_ql_title_texttransform = new MikadoField("selectblanksimple","blog_title_author_centered_ql_title_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_title_author_centered_ql_title_texttransform",$blog_title_author_centered_ql_title_texttransform);

		$blog_title_author_centered_ql_title_google_fonts = new MikadoField("Fontsimple","blog_title_author_centered_ql_title_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_title_author_centered_ql_title_google_fonts",$blog_title_author_centered_ql_title_google_fonts);

		$blog_title_author_centered_ql_title_fontstyle = new MikadoField("selectblanksimple","blog_title_author_centered_ql_title_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_title_author_centered_ql_title_fontstyle",$blog_title_author_centered_ql_title_fontstyle);

		$blog_title_author_centered_ql_title_fontweight = new MikadoField("selectblanksimple","blog_title_author_centered_ql_title_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_title_author_centered_ql_title_fontweight",$blog_title_author_centered_ql_title_fontweight);

		$row3 = new MikadoRow(true);
		$group6->addChild("row3",$row3);

		$blog_title_author_centered_ql_title_letterspacing = new MikadoField("textsimple","blog_title_author_centered_ql_title_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_title_author_centered_ql_title_letterspacing",$blog_title_author_centered_ql_title_letterspacing);

		$group7 = new MikadoGroup("Quote/Link Post Info Data","Define quote/link post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list.");
		$panel8->addChild("group7",$group7);

		$row1 = new MikadoRow();
		$group7->addChild("row1",$row1);

		$blog_title_author_centered_ql_info_color = new MikadoField("colorsimple","blog_title_author_centered_ql_info_color","","Text Color","This is some description");
		$row1->addChild("blog_title_author_centered_ql_info_color",$blog_title_author_centered_ql_info_color);

		$blog_title_author_centered_ql_info_hover_color = new MikadoField("colorsimple","blog_title_author_centered_ql_info_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_title_author_centered_ql_info_hover_color",$blog_title_author_centered_ql_info_hover_color);

		$blog_title_author_centered_ql_info_fontsize = new MikadoField("textsimple","blog_title_author_centered_ql_info_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_title_author_centered_ql_info_fontsize",$blog_title_author_centered_ql_info_fontsize);

		$blog_title_author_centered_ql_info_lineheight = new MikadoField("textsimple","blog_title_author_centered_ql_info_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_title_author_centered_ql_info_lineheight",$blog_title_author_centered_ql_info_lineheight);

		$row2 = new MikadoRow(true);
		$group7->addChild("row2",$row2);

		$blog_title_author_centered_ql_info_texttransform = new MikadoField("selectblanksimple","blog_title_author_centered_ql_info_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_title_author_centered_ql_info_texttransform",$blog_title_author_centered_ql_info_texttransform);

		$blog_title_author_centered_ql_info_google_fonts = new MikadoField("Fontsimple","blog_title_author_centered_ql_info_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_title_author_centered_ql_info_google_fonts",$blog_title_author_centered_ql_info_google_fonts);

		$blog_title_author_centered_ql_info_fontstyle = new MikadoField("selectblanksimple","blog_title_author_centered_ql_info_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_title_author_centered_ql_info_fontstyle",$blog_title_author_centered_ql_info_fontstyle);

		$blog_title_author_centered_ql_info_fontweight = new MikadoField("selectblanksimple","blog_title_author_centered_ql_info_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_title_author_centered_ql_info_fontweight",$blog_title_author_centered_ql_info_fontweight);

		$row3 = new MikadoRow(true);
		$group7->addChild("row3",$row3);

		$blog_title_author_centered_ql_info_letterspacing = new MikadoField("textsimple","blog_title_author_centered_ql_info_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_title_author_centered_ql_info_letterspacing",$blog_title_author_centered_ql_info_letterspacing);

		$group8 = new MikadoGroup("Quote Author Style","Define author styles for Quote articles");
		$panel8->addChild("group8",$group8);

		$row1 = new MikadoRow();
		$group8->addChild("row1",$row1);

		$blog_title_author_centered_ql_author_color = new MikadoField("colorsimple","blog_title_author_centered_ql_author_color","","Text Color","This is some description");
		$row1->addChild("blog_title_author_centered_ql_author_color",$blog_title_author_centered_ql_author_color);

		$blog_title_author_centered_ql_author_hover_color = new MikadoField("colorsimple","blog_title_author_centered_ql_author_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_title_author_centered_ql_author_hover_color",$blog_title_author_centered_ql_author_hover_color);

		$blog_title_author_centered_ql_author_fontsize = new MikadoField("textsimple","blog_title_author_centered_ql_author_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_title_author_centered_ql_author_font_size",$blog_title_author_centered_ql_author_fontsize);

		$blog_title_author_centered_ql_author_lineheight = new MikadoField("textsimple","blog_title_author_centered_ql_author_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_title_author_centered_ql_author_lineheight",$blog_title_author_centered_ql_author_lineheight);


		$row2 = new MikadoRow(true);
		$group8->addChild("row2",$row2);

		$blog_title_author_centered_ql_author_texttransform = new MikadoField("selectblanksimple","blog_title_author_centered_ql_author_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_title_author_centered_ql_author_texttransform",$blog_title_author_centered_ql_author_texttransform);

		$blog_title_author_centered_ql_author_google_fonts = new MikadoField("Fontsimple","blog_title_author_centered_ql_author_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_title_author_centered_ql_author_google_fonts",$blog_title_author_centered_ql_author_google_fonts);

		$blog_title_author_centered_ql_author_fontstyle = new MikadoField("selectblanksimple","blog_title_author_centered_ql_author_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_title_author_centered_ql_author_fontstyle",$blog_title_author_centered_ql_author_fontstyle);

		$blog_title_author_centered_ql_author_fontweight = new MikadoField("selectblanksimple","blog_title_author_centered_ql_author_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_title_author_centered_ql_author_fontweight",$blog_title_author_centered_ql_author_fontweight);

		$row3 = new MikadoRow(true);
		$group8->addChild("row3",$row3);

		$blog_title_author_centered_ql_author_letterspacing = new MikadoField("textsimple","blog_title_author_centered_ql_author_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_title_author_centered_ql_author_letterspacing",$blog_title_author_centered_ql_author_letterspacing);

		// Blog Post List - Blog: POST INFO VERTICAL IMAGE
		$panel9 = new MikadoPanel("Blog List Template Options: Post Info Vertical - Image","blog_post_info_vertical_image_post_lists", "blog_post_info_vertical_image_show_options", "no");
		$blogPage->addChild("panel9",$panel9);

		$blog_post_info_vertical_image_number_of_chars = new MikadoField("text","blog_post_info_vertical_image_number_of_chars","45","Number of Words in Excerpt",' Enter a number of words in excerpt (article summary)', array(), array("col_width" => 3));
		$panel9->addChild("blog_post_info_vertical_image_number_of_chars",$blog_post_info_vertical_image_number_of_chars);

		$blog_post_info_vertical_image_read_more_button = new MikadoField("yesno","blog_post_info_vertical_image_read_more_button","no","Read More Button","Enable Read More Button");
		$panel9->addChild("blog_post_info_vertical_image_read_more_button",$blog_post_info_vertical_image_read_more_button);

		$blog_post_info_vertical_image_content_position = new MikadoField("select","blog_post_info_vertical_image_content_position","content_above_blog_list","Content Position","Choose content position for blog list template when sidebar is enabled. Note: This settings in only for template, not for archive pages", array(
			"content_above_blog_list" => "Content Above Blog List",
			"content_above_blog_list_and_sidebar" => "Content Above Blog List and Sidebar"
		));
		$panel9->addChild("blog_post_info_vertical_image_content_position", $blog_post_info_vertical_image_content_position);

		$blog_post_info_vertical_image_post_meta_data_section = new MikadoTitle("blog_post_info_vertical_image_post_meta_data_section", "Post Info Data Fields");
		$panel9->addChild("blog_post_info_vertical_image_post_meta_data_section", $blog_post_info_vertical_image_post_meta_data_section);

		$blog_post_info_vertical_image_show_categories = new MikadoField("yesno","blog_post_info_vertical_image_show_categories","no","Show Categories","Enabling this option will Show Categories on Post List");
		$panel9->addChild("blog_post_info_vertical_image_show_categories",$blog_post_info_vertical_image_show_categories);

		$blog_post_info_vertical_image_show_comments = new MikadoField("yesno","blog_post_info_vertical_image_show_comments","no","Show Comments","Enabling this option will Show Comments on Post List");
		$panel9->addChild("blog_post_info_vertical_image_show_comments",$blog_post_info_vertical_image_show_comments);

		$blog_post_info_vertical_image_show_author = new MikadoField("yesno","blog_post_info_vertical_image_show_author","no","Show Author Name","Enabling this option will show author name on Post List and Blog Post Single");
		$panel9->addChild("blog_post_info_vertical_image_show_author",$blog_post_info_vertical_image_show_author);

		$blog_post_info_vertical_image_show_date = new MikadoField("yesno","blog_post_info_vertical_image_show_date","yes","Show Date","Enabling this option will show date on Post List");
		$panel9->addChild("blog_post_info_vertical_image_show_date",$blog_post_info_vertical_image_show_date);

		$blog_post_info_vertical_image_show_share = new MikadoField("yesno","blog_post_info_vertical_image_show_share","no","Show Share","Enabling this option will show share on Post List", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_post_info_vertical_image_share_options_container"));
		$panel9->addChild("blog_post_info_vertical_image_show_share",$blog_post_info_vertical_image_show_share);

		$blog_post_info_vertical_image_share_options_container = new MikadoContainer("blog_post_info_vertical_image_share_options_container","blog_post_info_vertical_image_show_share","no");
		$panel9->addChild("blog_post_info_vertical_image_share_options_container",$blog_post_info_vertical_image_share_options_container);

		$blog_post_info_vertical_image_share_icon_color = new MikadoField("color","blog_post_info_vertical_image_share_icon_color","","Icon Color","Choose icon color for share dropdown");
		$blog_post_info_vertical_image_share_options_container->addChild("blog_post_info_vertical_image_share_icon_color",$blog_post_info_vertical_image_share_icon_color);

		$blog_post_info_vertical_image_share_icon_hover_color = new MikadoField("color","blog_post_info_vertical_image_share_icon_hover_color","","Icon Hover Color","Choose icon hover color for share dropdown");
		$blog_post_info_vertical_image_share_options_container->addChild("blog_post_info_vertical_image_share_icon_hover_color",$blog_post_info_vertical_image_share_icon_hover_color);

		$blog_post_info_vertical_image_share_background_color = new MikadoField("color","blog_post_info_vertical_image_share_background_color","","Background Color","Choose background color for share dropdown list field");
		$blog_post_info_vertical_image_share_options_container->addChild("blog_post_info_vertical_image_share_background_color",$blog_post_info_vertical_image_share_background_color);

		$blog_post_info_vertical_image_like = new MikadoField("yesno","blog_post_info_vertical_image_like","yes","Show Likes",'Enabling this option will turn on "Likes"');
		$panel9->addChild("blog_post_info_vertical_image_like",$blog_post_info_vertical_image_like);

		$blog_post_info_vertical_image_post_design_style = new MikadoTitle("blog_post_info_vertical_image_post_design_style", "Post Design Style");
		$panel9->addChild("blog_post_info_vertical_image_post_design_style", $blog_post_info_vertical_image_post_design_style);

		$blog_post_info_vertical_image_enable_text_box = new MikadoField("yesno","blog_post_info_vertical_image_enable_text_box","no","Enable Boxed Styled Post Content","Enable post text boxed features", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_post_info_vertical_image_enable_text_box_container"));
		$panel9->addChild("blog_post_info_vertical_image_enable_text_box",$blog_post_info_vertical_image_enable_text_box);

		$blog_post_info_vertical_image_enable_text_box_container = new MikadoContainer("blog_post_info_vertical_image_enable_text_box_container","blog_post_info_vertical_image_enable_text_box","no");
		$panel9->addChild("blog_post_info_vertical_image_enable_text_box_container",$blog_post_info_vertical_image_enable_text_box_container);

		$blog_post_info_vertical_image_box_background_color = new MikadoField("color","blog_post_info_vertical_image_box_background_color","","Background Color","Choose background color for post text box");
		$blog_post_info_vertical_image_enable_text_box_container->addChild("blog_post_info_vertical_image_box_background_color",$blog_post_info_vertical_image_box_background_color);

		$blog_post_info_vertical_image_box_border_color = new MikadoField("color","blog_post_info_vertical_image_box_border_color","","Border Color","Choose border color for post text box");
		$blog_post_info_vertical_image_enable_text_box_container->addChild("blog_post_info_vertical_image_box_border_color",$blog_post_info_vertical_image_box_border_color);

		$blog_post_info_vertical_image_box_padding = new MikadoField("text","blog_post_info_vertical_image_box_padding","","Text box padding","Please insert padding in format (top right bottom left) i.e. 5px 5px 5px 5px", array(), array("col_width" => 3));
		$blog_post_info_vertical_image_enable_text_box_container->addChild("blog_post_info_vertical_image_box_padding",$blog_post_info_vertical_image_box_padding);

		$group1 = new MikadoGroup("Quote/Link Background","Set background of Quote/Link post type");
		$panel9->addChild("group1",$group1);

		$row1 = new MikadoRow();
		$group1->addChild("row1",$row1);

		$blog_post_info_vertical_image_ql_background_image = new MikadoField("yesnosimple","blog_post_info_vertical_image_ql_background_image","no","Background Image","");
		$row1->addChild("blog_post_info_vertical_image_ql_background_image",$blog_post_info_vertical_image_ql_background_image);

		$blog_post_info_vertical_image_ql_background_color = new MikadoField("colorsimple","blog_post_info_vertical_image_ql_background_color","","Background Color","Default color is #ffffff.");
		$row1->addChild("blog_post_info_vertical_image_ql_background_color",$blog_post_info_vertical_image_ql_background_color);

		$blog_post_info_vertical_image_ql_hover_background_color = new MikadoField("colorsimple","blog_post_info_vertical_image_ql_hover_background_color","","Background Hover Color","Default color is #e6ae48.");
		$row1->addChild("blog_post_info_vertical_image_ql_hover_background_color",$blog_post_info_vertical_image_ql_hover_background_color);

		$blog_post_info_vertical_image_show_ql_mark = new MikadoField("yesno","blog_post_info_vertical_image_show_ql_mark","yes","Enable Quote/Link Icon","Show Icons for Quote/Link Post Format", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_post_info_vertical_image_show_ql_mark_container"));
		$panel9->addChild("blog_post_info_vertical_image_show_ql_mark",$blog_post_info_vertical_image_show_ql_mark);

		$blog_post_info_vertical_image_show_ql_mark_container = new MikadoContainer("blog_post_info_vertical_image_show_ql_mark_container","blog_post_info_vertical_image_show_ql_mark","no");
		$panel9->addChild("blog_post_info_vertical_image_show_ql_mark_container",$blog_post_info_vertical_image_show_ql_mark_container);

		$row1 = new MikadoRow();
		$blog_post_info_vertical_image_show_ql_mark_container->addChild("row1",$row1);

		$blog_post_info_vertical_image_ql_mark_color = new MikadoField("color","blog_post_info_vertical_image_ql_mark_color","","Icon Color","Choose icon color for quote/link post.");
		$row1->addChild("blog_post_info_vertical_image_ql_mark_color",$blog_post_info_vertical_image_ql_mark_color);

		$blog_post_info_vertical_image_ql_mark_hover_color = new MikadoField("color","blog_post_info_vertical_image_ql_mark_hover_color","","Icon Hover Color","Choose hover icon color for quote/link post.");
		$row1->addChild("blog_post_info_vertical_image_ql_mark_hover_color",$blog_post_info_vertical_image_ql_mark_hover_color);

		$group2 = new MikadoGroup("Post Info Vertical Color","Set color for post info icons (date, like and share).");
		$panel9->addChild("group2",$group2);

		$row1 = new MikadoRow();
		$group2->addChild("row1",$row1);

		$blog_post_info_vertical_image_date_like_share_color = new MikadoField("colorsimple","blog_post_info_vertical_image_date_like_share_color","","Date, Like & Share Color","Default color is #232a29.");
		$row1->addChild("blog_post_info_vertical_image_date_like_share_color",$blog_post_info_vertical_image_date_like_share_color);

		$group9 = new MikadoGroup("Blog List Spacing","Set spacing for blog layouts");
		$panel9->addChild("group9",$group9);

		$row1 = new MikadoRow();
		$group9->addChild("row1",$row1);

		$blog_post_info_vertical_image_image_margin_bottom = new MikadoField("textsimple","blog_post_info_vertical_image_image_margin_bottom","","Margin Under Image (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_image_image_margin_bottom",$blog_post_info_vertical_image_image_margin_bottom);

		$blog_post_info_vertical_image_title_margin_bottom = new MikadoField("textsimple","blog_post_info_vertical_image_title_margin_bottom","","Margin Under Title (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_image_title_margin_bottom",$blog_post_info_vertical_image_title_margin_bottom);

		$blog_post_info_vertical_image_post_info_margin_top = new MikadoField("textsimple","blog_post_info_vertical_image_post_info_margin_top","","Margin Above Post Info (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_image_post_info_margin_top",$blog_post_info_vertical_image_post_info_margin_top);

		$blog_post_info_vertical_image_article_margin_bottom = new MikadoField("textsimple","blog_post_info_vertical_image_article_margin_bottom","","Margin Between Articles (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_image_article_margin_bottom",$blog_post_info_vertical_image_article_margin_bottom);

		$group10 = new MikadoGroup("Blog List Spacing for Quote and Link Post Type","Set spacing for blog layouts");
		$panel9->addChild("group10",$group10);

		$row1 = new MikadoRow();
		$group10->addChild("row1",$row1);

		$blog_post_info_vertical_image_ql_quote_author_margin_top = new MikadoField("textsimple","blog_post_info_vertical_image_ql_quote_author_margin_top","","Margin Above Quote Author (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_image_ql_quote_author_margin_top",$blog_post_info_vertical_image_ql_quote_author_margin_top);

		$blog_post_info_vertical_image_ql_post_info_margin_top = new MikadoField("textsimple","blog_post_info_vertical_image_ql_post_info_margin_top","","Margin Above Post Info (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_image_ql_post_info_margin_top",$blog_post_info_vertical_image_ql_post_info_margin_top);

		$post_text_styling= new MikadoTitle("post_text_styling", "Post Text Style");
		$panel9->addChild("post_text_styling", $post_text_styling);

		$group3 = new MikadoGroup("Post Title","Define title styles in this blog post template.");
		$panel9->addChild("group3",$group3);

		$row1 = new MikadoRow();
		$group3->addChild("row1",$row1);

		$blog_post_info_vertical_image_title_color = new MikadoField("colorsimple","blog_post_info_vertical_image_title_color","","Text Color","This is some description");
		$row1->addChild("blog_post_info_vertical_image_title_color",$blog_post_info_vertical_image_title_color);

		$blog_post_info_vertical_image_title_hover_color = new MikadoField("colorsimple","blog_post_info_vertical_image_title_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_post_info_vertical_image_title_hover_color",$blog_post_info_vertical_image_title_hover_color);

		$blog_post_info_vertical_image_title_fontsize = new MikadoField("textsimple","blog_post_info_vertical_image_title_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_image_title_fontsize",$blog_post_info_vertical_image_title_fontsize);

		$blog_post_info_vertical_image_title_lineheight = new MikadoField("textsimple","blog_post_info_vertical_image_title_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_image_title_lineheight",$blog_post_info_vertical_image_title_lineheight);

		$row2 = new MikadoRow(true);
		$group3->addChild("row2",$row2);

		$blog_post_info_vertical_image_title_texttransform = new MikadoField("selectblanksimple","blog_post_info_vertical_image_title_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_post_info_vertical_image_title_texttransform",$blog_post_info_vertical_image_title_texttransform);

		$blog_post_info_vertical_image_title_google_fonts = new MikadoField("Fontsimple","blog_post_info_vertical_image_title_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_post_info_vertical_image_title_google_fonts",$blog_post_info_vertical_image_title_google_fonts);

		$blog_post_info_vertical_image_title_fontstyle = new MikadoField("selectblanksimple","blog_post_info_vertical_image_title_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_post_info_vertical_image_title_fontstyle",$blog_post_info_vertical_image_title_fontstyle);

		$blog_post_info_vertical_image_title_fontweight = new MikadoField("selectblanksimple","blog_post_info_vertical_image_title_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_post_info_vertical_image_title_fontweight",$blog_post_info_vertical_image_title_fontweight);

		$row3 = new MikadoRow(true);
		$group3->addChild("row3",$row3);

		$blog_post_info_vertical_image_title_letterspacing = new MikadoField("textsimple","blog_post_info_vertical_image_title_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_post_info_vertical_image_title_letterspacing",$blog_post_info_vertical_image_title_letterspacing);

		$group5 = new MikadoGroup("Post Info Data","Define post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list");
		$panel9->addChild("group5",$group5);

		$row1 = new MikadoRow();
		$group5->addChild("row1",$row1);

		$blog_post_info_vertical_image_info_color = new MikadoField("colorsimple","blog_post_info_vertical_image_info_color","","Text Color","This is some description");
		$row1->addChild("blog_post_info_vertical_image_info_color",$blog_post_info_vertical_image_info_color);

		$blog_post_info_vertical_image_info_link_color = new MikadoField("colorsimple","blog_post_info_vertical_image_info_link_color","","Link Color","This is some description");
		$row1->addChild("blog_post_info_vertical_image_info_link_color",$blog_post_info_vertical_image_info_link_color);

		$blog_post_info_vertical_image_info_hover_color = new MikadoField("colorsimple","blog_post_info_vertical_image_info_hover_color","","Link Hover Color","This is some description");
		$row1->addChild("blog_post_info_vertical_image_info_hover_color",$blog_post_info_vertical_image_info_hover_color);

		$blog_post_info_vertical_image_info_fontsize = new MikadoField("textsimple","blog_post_info_vertical_image_info_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_image_info_fontsize",$blog_post_info_vertical_image_info_fontsize);

		$row2 = new MikadoRow(true);
		$group5->addChild("row2",$row2);

		$blog_post_info_vertical_image_info_lineheight = new MikadoField("textsimple","blog_post_info_vertical_image_info_lineheight","","Line Height (px)","This is some description");
		$row2->addChild("blog_post_info_vertical_image_info_lineheight",$blog_post_info_vertical_image_info_lineheight);

		$blog_post_info_vertical_image_info_google_fonts = new MikadoField("Fontsimple","blog_post_info_vertical_image_info_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_post_info_vertical_image_info_google_fonts",$blog_post_info_vertical_image_info_google_fonts);

		$blog_post_info_vertical_image_info_fontstyle = new MikadoField("selectblanksimple","blog_post_info_vertical_image_info_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_post_info_vertical_image_info_fontstyle",$blog_post_info_vertical_image_info_fontstyle);

		$blog_post_info_vertical_image_info_fontweight = new MikadoField("selectblanksimple","blog_post_info_vertical_image_info_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_post_info_vertical_image_info_fontweight",$blog_post_info_vertical_image_info_fontweight);

		$row3 = new MikadoRow(true);
		$group5->addChild("row3",$row3);


		$blog_post_info_vertical_image_info_texttransform = new MikadoField("selectblanksimple","blog_post_info_vertical_image_info_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row3->addChild("blog_post_info_vertical_image_info_texttransform",$blog_post_info_vertical_image_info_texttransform);

		$blog_post_info_vertical_image_info_letterspacing = new MikadoField("textsimple","blog_post_info_vertical_image_info_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_post_info_vertical_image_info_letterspacing",$blog_post_info_vertical_image_info_letterspacing);

		$group4 = new MikadoGroup("Quote/Link Title Style","Define title styles for Quote/Link articles");
		$panel9->addChild("group4",$group4);

		$row1 = new MikadoRow();
		$group4->addChild("row1",$row1);

		$blog_post_info_vertical_image_ql_title_color = new MikadoField("colorsimple","blog_post_info_vertical_image_ql_title_color","","Text Color","This is some description");
		$row1->addChild("blog_post_info_vertical_image_ql_title_color",$blog_post_info_vertical_image_ql_title_color);

		$blog_post_info_vertical_image_ql_title_hover_color = new MikadoField("colorsimple","blog_post_info_vertical_image_ql_title_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_post_info_vertical_image_ql_title_hover_color",$blog_post_info_vertical_image_ql_title_hover_color);

		$blog_post_info_vertical_image_ql_title_fontsize = new MikadoField("textsimple","blog_post_info_vertical_image_ql_title_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_image_ql_title_font_size",$blog_post_info_vertical_image_ql_title_fontsize);

		$blog_post_info_vertical_image_ql_title_lineheight = new MikadoField("textsimple","blog_post_info_vertical_image_ql_title_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_image_ql_title_lineheight",$blog_post_info_vertical_image_ql_title_lineheight);

		$row2 = new MikadoRow(true);
		$group4->addChild("row2",$row2);

		$blog_post_info_vertical_image_ql_title_texttransform = new MikadoField("selectblanksimple","blog_post_info_vertical_image_ql_title_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_post_info_vertical_image_ql_title_texttransform",$blog_post_info_vertical_image_ql_title_texttransform);

		$blog_post_info_vertical_image_ql_title_google_fonts = new MikadoField("Fontsimple","blog_post_info_vertical_image_ql_title_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_post_info_vertical_image_ql_title_google_fonts",$blog_post_info_vertical_image_ql_title_google_fonts);

		$blog_post_info_vertical_image_ql_title_fontstyle = new MikadoField("selectblanksimple","blog_post_info_vertical_image_ql_title_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_post_info_vertical_image_ql_title_fontstyle",$blog_post_info_vertical_image_ql_title_fontstyle);

		$blog_post_info_vertical_image_ql_title_fontweight = new MikadoField("selectblanksimple","blog_post_info_vertical_image_ql_title_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_post_info_vertical_image_ql_title_fontweight",$blog_post_info_vertical_image_ql_title_fontweight);

		$row3 = new MikadoRow(true);
		$group4->addChild("row3",$row3);

		$blog_post_info_vertical_image_ql_title_letterspacing = new MikadoField("textsimple","blog_post_info_vertical_image_ql_title_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_post_info_vertical_image_ql_title_letterspacing",$blog_post_info_vertical_image_ql_title_letterspacing);

		$group6 = new MikadoGroup("Quote/Link Post Info Data","Define quote/link post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list.");
		$panel9->addChild("group6",$group6);

		$row1 = new MikadoRow();
		$group6->addChild("row1",$row1);

		$blog_post_info_vertical_image_ql_info_color = new MikadoField("colorsimple","blog_post_info_vertical_image_ql_info_color","","Text Color","This is some description");
		$row1->addChild("blog_post_info_vertical_image_ql_info_color",$blog_post_info_vertical_image_ql_info_color);

		$blog_post_info_vertical_image_ql_info_link_color = new MikadoField("colorsimple","blog_post_info_vertical_image_ql_info_link_color","","Link Color","This is some description");
		$row1->addChild("blog_post_info_vertical_image_ql_info_link_color",$blog_post_info_vertical_image_ql_info_link_color);

		$blog_post_info_vertical_image_ql_info_hover_color = new MikadoField("colorsimple","blog_post_info_vertical_image_ql_info_hover_color","","Hover Color","This is some description");
		$row1->addChild("blog_post_info_vertical_image_ql_info_hover_color",$blog_post_info_vertical_image_ql_info_hover_color);

		$blog_post_info_vertical_image_ql_info_fontsize = new MikadoField("textsimple","blog_post_info_vertical_image_ql_info_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_image_ql_info_fontsize",$blog_post_info_vertical_image_ql_info_fontsize);


		$row2 = new MikadoRow(true);
		$group6->addChild("row2",$row2);

		$blog_post_info_vertical_image_ql_info_lineheight = new MikadoField("textsimple","blog_post_info_vertical_image_ql_info_lineheight","","Line Height (px)","This is some description");
		$row2->addChild("blog_post_info_vertical_image_ql_info_lineheight",$blog_post_info_vertical_image_ql_info_lineheight);

		$blog_post_info_vertical_image_ql_info_google_fonts = new MikadoField("Fontsimple","blog_post_info_vertical_image_ql_info_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_post_info_vertical_image_ql_info_google_fonts",$blog_post_info_vertical_image_ql_info_google_fonts);

		$blog_post_info_vertical_image_ql_info_fontstyle = new MikadoField("selectblanksimple","blog_post_info_vertical_image_ql_info_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_post_info_vertical_image_ql_info_fontstyle",$blog_post_info_vertical_image_ql_info_fontstyle);

		$blog_post_info_vertical_image_ql_info_fontweight = new MikadoField("selectblanksimple","blog_post_info_vertical_image_ql_info_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_post_info_vertical_image_ql_info_fontweight",$blog_post_info_vertical_image_ql_info_fontweight);

		$row3 = new MikadoRow(true);
		$group6->addChild("row3",$row3);

		$blog_post_info_vertical_image_ql_info_texttransform = new MikadoField("selectblanksimple","blog_post_info_vertical_image_ql_info_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row3->addChild("blog_post_info_vertical_image_ql_info_texttransform",$blog_post_info_vertical_image_ql_info_texttransform);

		$blog_post_info_vertical_image_ql_info_letterspacing = new MikadoField("textsimple","blog_post_info_vertical_image_ql_info_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_post_info_vertical_image_ql_info_letterspacing",$blog_post_info_vertical_image_ql_info_letterspacing);

		$group7 = new MikadoGroup("Quote Author Style","Define author styles for Quote articles");
		$panel9->addChild("group7",$group7);

		$row1 = new MikadoRow();
		$group7->addChild("row1",$row1);

		$blog_post_info_vertical_image_ql_author_color = new MikadoField("colorsimple","blog_post_info_vertical_image_ql_author_color","","Text Color","This is some description");
		$row1->addChild("blog_post_info_vertical_image_ql_author_color",$blog_post_info_vertical_image_ql_author_color);

		$blog_post_info_vertical_image_ql_author_hover_color = new MikadoField("colorsimple","blog_post_info_vertical_image_ql_author_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_post_info_vertical_image_ql_author_hover_color",$blog_post_info_vertical_image_ql_author_hover_color);

		$blog_post_info_vertical_image_ql_author_fontsize = new MikadoField("textsimple","blog_post_info_vertical_image_ql_author_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_image_ql_author_font_size",$blog_post_info_vertical_image_ql_author_fontsize);

		$blog_post_info_vertical_image_ql_author_lineheight = new MikadoField("textsimple","blog_post_info_vertical_image_ql_author_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_post_info_vertical_image_ql_author_lineheight",$blog_post_info_vertical_image_ql_author_lineheight);

		$row2 = new MikadoRow(true);
		$group7->addChild("row2",$row2);

		$blog_post_info_vertical_image_ql_author_texttransform = new MikadoField("selectblanksimple","blog_post_info_vertical_image_ql_author_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_post_info_vertical_image_ql_author_texttransform",$blog_post_info_vertical_image_ql_author_texttransform);

		$blog_post_info_vertical_image_ql_author_google_fonts = new MikadoField("Fontsimple","blog_post_info_vertical_image_ql_author_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_post_info_vertical_image_ql_author_google_fonts",$blog_post_info_vertical_image_ql_author_google_fonts);

		$blog_post_info_vertical_image_ql_author_fontstyle = new MikadoField("selectblanksimple","blog_post_info_vertical_image_ql_author_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_post_info_vertical_image_ql_author_fontstyle",$blog_post_info_vertical_image_ql_author_fontstyle);

		$blog_post_info_vertical_image_ql_author_fontweight = new MikadoField("selectblanksimple","blog_post_info_vertical_image_ql_author_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_post_info_vertical_image_ql_author_fontweight",$blog_post_info_vertical_image_ql_author_fontweight);

		$row3 = new MikadoRow(true);
		$group7->addChild("row3",$row3);

		$blog_post_info_vertical_image_ql_author_letterspacing = new MikadoField("textsimple","blog_post_info_vertical_image_ql_author_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_post_info_vertical_image_ql_author_letterspacing",$blog_post_info_vertical_image_ql_author_letterspacing);

		// Blog Post List - Blog: Masonry
		$panel10 = new MikadoPanel("Blog List Templates Options: Masonry & Masonry Full Width","blog_masonry_post_lists", "blog_masonry_show_options", "no");
		$blogPage->addChild("panel10",$panel10);

		$blog_masonry_number_of_chars = new MikadoField("text","blog_masonry_number_of_chars","45","Number of Words in Excerpt",' Enter a number of words in excerpt (article summary)', array(), array("col_width" => 3));
		$panel10->addChild("blog_masonry_number_of_chars",$blog_masonry_number_of_chars);

		$blog_masonry_read_more_button = new MikadoField("yesno","blog_masonry_read_more_button","no","Read More Button","Enable Read More Button");
		$panel10->addChild("blog_masonry_read_more_button",$blog_masonry_read_more_button);

		$blog_masonry_content_position = new MikadoField("select","blog_masonry_content_position","content_above_blog_list","Content Position","Choose content position for blog list template when sidebar is enabled. Note: This settings in only for template, not for archive pages", array(
			"content_above_blog_list" => "Content Above Blog List",
			"content_above_blog_list_and_sidebar" => "Content Above Blog List and Sidebar"
		));
		$panel10->addChild("blog_masonry_content_position", $blog_masonry_content_position);

		$pagination_masonry = new MikadoField("select","pagination_masonry","pagination","Pagination on Masonry",'Choose a pagination style for "Masonry" Blog List', array(
				"pagination" => "Pagination",
				"load_more" => "Load More",
				"infinite_scroll" => "Infinite Scroll"
		      ));
		$panel10->addChild("pagination_masonry",$pagination_masonry);

		$blog_masonry_filter = new MikadoField("yesno","blog_masonry_filter","no","Show Category Filter on Masonry",'Enabling this option will display a Category Filter on "Masonry" Blog List', array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_masonry_filter_container"));
		$panel10->addChild("blog_masonry_filter",$blog_masonry_filter);

		$blog_masonry_filter_container = new MikadoContainer("blog_masonry_filter_container","blog_masonry_filter","no");
		$panel10->addChild("blog_masonry_filter_container",$blog_masonry_filter_container);


		    // Blog Masonry Filter
		    $blog_masonry_filter_background_color = new MikadoField("color","blog_masonry_filter_background_color","","Background Color","Choose color for background of filter area",array(), array("col_width" => 3));
		    $blog_masonry_filter_container->addChild("blog_masonry_filter_background_color",$blog_masonry_filter_background_color);

		    $blog_masonry_filter_height = new MikadoField("text","blog_masonry_filter_height","","Height (px)","Enter height for filter area",array(), array("col_width" => 3));
		    $blog_masonry_filter_container->addChild("blog_masonry_filter_height", $blog_masonry_filter_height);

		    $blog_masonry_filter_margin_bottom = new MikadoField("text","blog_masonry_filter_margin_bottom","","Bottom Margin (px)","Enter bottom margin for filter area. Default value is 36",array(), array("col_width" => 3));
		    $blog_masonry_filter_container->addChild("blog_masonry_filter_margin_bottom",$blog_masonry_filter_margin_bottom);

		    $blog_masonry_filter_alignment = new MikadoField("select","blog_masonry_filter_alignment","","Horizontal Alignment","Choose filter alignment", array(
		        "left" => "Left",
		        "center" => "Center",
		        "right" => "Right"
		    ));
		    $blog_masonry_filter_container->addChild("blog_masonry_filter_alignment",$blog_masonry_filter_alignment);


		    $blog_masonry_enable_filter_title = new MikadoField("yesno","blog_masonry_enable_filter_title","no","Enable Filter Title","Enabling this option will show category filter title");
		    $blog_masonry_filter_container->addChild("blog_masonry_enable_filter_title",$blog_masonry_enable_filter_title);

		    $group1 = new MikadoGroup("Title","Define text styles for filter title");
		    $blog_masonry_filter_container->addChild("group1",$group1);

		        $row1 = new MikadoRow();
		        $group1->addChild("row1",$row1);
		        $blog_masonry_filter_title_color = new MikadoField("colorsimple","blog_masonry_filter_title_color","","Text Color","This is some description");
		        $row1->addChild("blog_masonry_filter_title_color",$blog_masonry_filter_title_color);
		        $blog_masonry_filter_title_font_size = new MikadoField("textsimple","blog_masonry_filter_title_font_size","","Font Size (px)","This is some description");
		        $row1->addChild("blog_masonry_filter_title_font_size",$blog_masonry_filter_title_font_size);
		        $blog_masonry_filter_title_line_height = new MikadoField("textsimple","blog_masonry_filter_title_line_height","","Line Height (px)","This is some description");
		        $row1->addChild("blog_masonry_filter_title_line_height",$blog_masonry_filter_title_line_height);
		        $blog_masonry_filter_title_text_transform = new MikadoField("selectblanksimple","blog_masonry_filter_title_text_transform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		        $row1->addChild("blog_masonry_filter_title_text_transform",$blog_masonry_filter_title_text_transform);

		        $row2 = new MikadoRow(true);
		        $group1->addChild("row2",$row2);
		        $blog_masonry_filter_title_font_family = new MikadoField("Fontsimple","blog_masonry_filter_title_font_family","-1","Font Family","This is some description");
		        $row2->addChild("blog_masonry_filter_title_font_family",$blog_masonry_filter_title_font_family);
		        $blog_masonry_filter_title_font_style = new MikadoField("selectblanksimple","blog_masonry_filter_title_font_style","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		        $row2->addChild("blog_masonry_filter_title_font_style",$blog_masonry_filter_title_font_style);
		        $blog_masonry_filter_title_font_weight = new MikadoField("selectblanksimple","blog_masonry_filter_title_font_weight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		        $row2->addChild("blog_masonry_filter_title_font_weight",$blog_masonry_filter_title_font_weight);
		        $blog_masonry_filter_title_letter_spacing = new MikadoField("textsimple","blog_masonry_filter_title_letter_spacing","","Letter Spacing (px)","This is some description");
		        $row2->addChild("blog_masonry_filter_title_letter_spacing",$blog_masonry_filter_title_letter_spacing);

		    $group2 = new MikadoGroup("Categories","Define text styles for filter categories");
		    $blog_masonry_filter_container->addChild("group2",$group2);

		        $row1 = new MikadoRow();
		        $group2->addChild("row1",$row1);
		        $blog_masonry_filter_color = new MikadoField("colorsimple","blog_masonry_filter_color","","Text Color","This is some description");
		        $row1->addChild("blog_masonry_filter_color",$blog_masonry_filter_color);
		        $blog_masonry_filter_hovercolor = new MikadoField("colorsimple","blog_masonry_filter_hovercolor","","Hover/Active Color","This is some description");
		        $row1->addChild("blog_masonry_filter_hovercolor",$blog_masonry_filter_hovercolor);
		        $blog_masonry_filter_font_size = new MikadoField("textsimple","blog_masonry_filter_font_size","","Font Size (px)","This is some description");
		        $row1->addChild("blog_masonry_filter_font_size",$blog_masonry_filter_font_size);
		        $blog_masonry_filter_line_height = new MikadoField("textsimple","blog_masonry_filter_line_height","","Line Height (px)","This is some description");
		        $row1->addChild("blog_masonry_filter_line_height",$blog_masonry_filter_line_height);

		        $row2 = new MikadoRow(true);
		        $group2->addChild("row2",$row2);
		        $blog_masonry_filter_font_family = new MikadoField("Fontsimple","blog_masonry_filter_font_family","-1","Font Family","This is some description");
		        $row2->addChild("blog_masonry_filter_font_family",$blog_masonry_filter_font_family);
		        $blog_masonry_filter_font_style = new MikadoField("selectblanksimple","blog_masonry_filter_font_style","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		        $row2->addChild("blog_masonry_filter_font_style",$blog_masonry_filter_font_style);
		        $blog_masonry_filter_font_weight = new MikadoField("selectblanksimple","blog_masonry_filter_font_weight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		        $row2->addChild("blog_masonry_filter_font_weight",$blog_masonry_filter_font_weight);
		        $blog_masonry_filter_text_transform = new MikadoField("selectblanksimple","blog_masonry_filter_text_transform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		        $row2->addChild("blog_masonry_filter_text_transform",$blog_masonry_filter_text_transform);

		        $row3 = new MikadoRow(true);
		        $group2->addChild("row3",$row3);
		        $blog_masonry_filter_letter_spacing = new MikadoField("textsimple","blog_masonry_filter_letter_spacing","","Letter Spacing (px)","This is some description");
		        $row3->addChild("blog_masonry_filter_letter_spacing",$blog_masonry_filter_letter_spacing);

		    $blog_masonry_filter_disable_separator = new MikadoField("yesno","blog_masonry_filter_disable_separator","yes","Disable Separator Between Categories","Disabling this option will remove separator between filter categories.");
		    $blog_masonry_filter_container->addChild("blog_masonry_filter_disable_separator",$blog_masonry_filter_disable_separator);


		$blog_masonry_post_meta_data_section = new MikadoTitle("blog_masonry_post_meta_data_section", "Post Info Data Fields");
		$panel10->addChild("blog_masonry_post_meta_data_section", $blog_masonry_post_meta_data_section);

		$blog_masonry_show_categories= new MikadoField("yesno","blog_masonry_show_categories","yes","Show Categories","Enabling this option will Show Categories on Post List");
		$panel10->addChild("blog_masonry_show_categories",$blog_masonry_show_categories);

		$blog_masonry_show_comments = new MikadoField("yesno","blog_masonry_show_comments","yes","Show Comments","Enabling this option will Show Comments on Post List");
		$panel10->addChild("blog_masonry_show_comments",$blog_masonry_show_comments);

		$blog_masonry_show_author = new MikadoField("yesno","blog_masonry_show_author","yes","Show Author Name","Enabling this option will show author name on Post List and Blog Post Single");
		$panel10->addChild("blog_masonry_show_author",$blog_masonry_show_author);

		$blog_masonry_show_date = new MikadoField("yesno","blog_masonry_show_date","yes","Show Date","Enabling this option will show date on Post List");
		$panel10->addChild("blog_masonry_hide_date",$blog_masonry_show_date);

		$blog_masonry_show_share = new MikadoField("yesno","blog_masonry_show_share","no","Show Share","Enabling this option will show share on Post List", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_masonry_share_options_container"));
		$panel10->addChild("blog_masonry_show_share",$blog_masonry_show_share);

		$blog_masonry_share_options_container = new MikadoContainer("blog_masonry_share_options_container","blog_masonry_show_share","no");
		$panel10->addChild("blog_masonry_share_options_container",$blog_masonry_share_options_container);

		$blog_masonry_share_icon_color = new MikadoField("color","blog_masonry_share_icon_color","","Icon Color","Choose icon color for share dropdown");
		$blog_masonry_share_options_container->addChild("blog_masonry_share_icon_color",$blog_masonry_share_icon_color);

		$blog_masonry_share_icon_hover_color = new MikadoField("color","blog_masonry_share_icon_hover_color","","Icon Hover Color","Choose icon hover color for share dropdown");
		$blog_masonry_share_options_container->addChild("blog_masonry_share_icon_hover_color",$blog_masonry_share_icon_hover_color);

		$blog_masonry_share_background_color = new MikadoField("color","blog_masonry_share_background_color","","Background Color","Choose background color for share dropdown list field");
		$blog_masonry_share_options_container->addChild("blog_masonry_share_background_color",$blog_masonry_share_background_color);

		$blog_masonry_show_like = new MikadoField("yesno","blog_masonry_show_like","no","Show Likes",'Enabling this option will turn on "Likes"');
		$panel10->addChild("blog_masonry_show_like",$blog_masonry_show_like);

		$blog_masonry_post_design_style = new MikadoTitle("blog_masonry_post_design_style", "Post Design Style");
		$panel10->addChild("blog_masonry_post_design_style", $blog_masonry_post_design_style);

		$blog_masonry_post_alignment = new MikadoField("select","blog_masonry_post_alignment","","Post Alignment","Choose alignment for whole post",array(
		    "left" => "Left",
		    "center" => "Center",
		    "right" => "Right"
		));
		$panel10->addChild("blog_masonry_post_alignment",$blog_masonry_post_alignment);

		$blog_masonry_enable_text_box = new MikadoField("yesno","blog_masonry_enable_text_box","no","Enable Boxed Styled Post Content","Enable post text boxed features", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_masonry_enable_text_box_container"));
		$panel10->addChild("blog_masonry_enable_text_box",$blog_masonry_enable_text_box);

		$blog_masonry_enable_text_box_container = new MikadoContainer("blog_masonry_enable_text_box_container","blog_masonry_enable_text_box","no");
		$panel10->addChild("blog_masonry_enable_text_box_container",$blog_masonry_enable_text_box_container);

		$blog_masonry_box_background_color = new MikadoField("color","blog_masonry_box_background_color","","Background Color","Choose background color for post text box");
		$blog_masonry_enable_text_box_container->addChild("blog_masonry_box_background_color",$blog_masonry_box_background_color);

		$blog_masonry_box_border_color = new MikadoField("color","blog_masonry_box_border_color","","Border Color","Choose border color for post text box");
		$blog_masonry_enable_text_box_container->addChild("blog_masonry_box_border_color",$blog_masonry_box_border_color);

		$blog_masonry_box_padding = new MikadoField("text","blog_masonry_box_padding","","Text box padding","Please insert padding in format (top right bottom left) i.e. 5px 5px 5px 5px", array(), array("col_width" => 3));
		$blog_masonry_enable_text_box_container->addChild("blog_masonry_box_padding",$blog_masonry_box_padding);

		$blog_masonry_enable_top_bottom_border_box = new MikadoField("yesno","blog_masonry_enable_top_bottom_border_box","yes","Post Info Data Border","Enable top&bottom border around post info data", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_masonry_enable_top_bottom_border_container"));
		$panel10->addChild("blog_masonry_enable_top_bottom_border_box",$blog_masonry_enable_top_bottom_border_box);

		$blog_masonry_enable_top_bottom_border_container = new MikadoContainer("blog_masonry_enable_top_bottom_border_container","blog_masonry_enable_top_bottom_border_box","no");
		$panel10->addChild("blog_masonry_enable_top_bottom_border_container",$blog_masonry_enable_top_bottom_border_container);

		$blog_masonry_top_border_box= new MikadoField("yesno","blog_masonry_top_border_box","yes","Enable Top Border","");
		$blog_masonry_enable_top_bottom_border_container->addChild("blog_masonry_top_border_box",$blog_masonry_top_border_box);

		$blog_masonry_bottom_border_box= new MikadoField("yesno","blog_masonry_bottom_border_box","yes","Enable Bottom Border","");
		$blog_masonry_enable_top_bottom_border_container->addChild("blog_masonry_bottom_border_box",$blog_masonry_bottom_border_box);

		$blog_masonry_top_botom_border_padding = new MikadoField("text","blog_masonry_top_botom_border_padding","","Padding (px)","Enter padding around post info data in format (top right bottom left) i.e. 5px 5px 5px 5px", array(), array("col_width" => 3));
		$blog_masonry_enable_top_bottom_border_container->addChild("blog_masonry_top_botom_border_padding",$blog_masonry_top_botom_border_padding);

		$group1 = new MikadoGroup("Quote/Link Background","Set background of Quote/Link post type");
		$panel10->addChild("group1",$group1);

		$row1 = new MikadoRow();
		$group1->addChild("row1",$row1);

		$blog_masonry_ql_background_image = new MikadoField("yesnosimple","blog_masonry_ql_background_image","no","Background Image","");
		$row1->addChild("blog_masonry_ql_background_image",$blog_masonry_ql_background_image);

		$blog_masonry_ql_background_color = new MikadoField("colorsimple","blog_masonry_ql_background_color","","Background Color","Default color is #ffffff.");
		$row1->addChild("blog_masonry_ql_background_color",$blog_masonry_ql_background_color);

		$blog_masonry_ql_hover_background_color = new MikadoField("colorsimple","blog_masonry_ql_hover_background_color","","Background Hover Color","Default color is #e6ae48.");
		$row1->addChild("blog_masonry_ql_hover_background_color",$blog_masonry_ql_hover_background_color);

		$blog_masonry_show_ql_mark = new MikadoField("yesno","blog_masonry_show_ql_mark","yes","Enable Quote/Link Icon","Show Icons for quote/link post format", array(), array("dependence" => true, "dependence_hide_on_yes" => "", "dependence_show_on_yes" => "#mkdf_blog_masonry_show_ql_mark_container"));
		$panel10->addChild("blog_masonry_show_ql_mark",$blog_masonry_show_ql_mark);

		$blog_masonry_show_ql_mark_container = new MikadoContainer("blog_masonry_show_ql_mark_container","blog_masonry_show_ql_mark","no");
		$panel10->addChild("blog_masonry_show_ql_mark_container",$blog_masonry_show_ql_mark_container);

		$row1 = new MikadoRow();
		$blog_masonry_show_ql_mark_container->addChild("row1",$row1);

		$blog_masonry_ql_mark_color = new MikadoField("color","blog_masonry_ql_mark_color","","Icon Color","Choose icon color for quote/link post");
		$row1->addChild("blog_masonry_ql_mark_color",$blog_masonry_ql_mark_color);

		$blog_masonry_ql_mark_background_color = new MikadoField("color","blog_masonry_ql_mark_background_color","","Icon Background Color","Choose background icon color for quote/link post.");
		$row1->addChild("blog_masonry_ql_mark_background_color",$blog_masonry_ql_mark_background_color);

		$blog_masonry_ql_mark_hover_color = new MikadoField("color","blog_masonry_ql_mark_hover_color","","Icon Hover Color","Choose hover icon color for quote/link post.");
		$row1->addChild("blog_masonry_ql_mark_hover_color",$blog_masonry_ql_mark_hover_color);

		$blog_masonry_ql_mark_background_hover_color = new MikadoField("color","blog_masonry_ql_mark_background_hover_color","","Icon Background Hover Color","Choose hover background icon color for quote/link post.");
		$row1->addChild("blog_masonry_ql_mark_background_hover_color",$blog_masonry_ql_mark_background_hover_color);

		$group7 = new MikadoGroup("Blog List Spacing","Set spacing for blog layouts");
		$panel10->addChild("group7",$group7);

		$row1 = new MikadoRow();
		$group7->addChild("row1",$row1);

		$blog_masonry_image_margin_bottom = new MikadoField("textsimple","blog_masonry_image_margin_bottom","","Margin Under Image (px)","This is some description");
		$row1->addChild("blog_masonry_image_margin_bottom",$blog_masonry_image_margin_bottom);

		$blog_masonry_title_margin_bottom = new MikadoField("textsimple","blog_masonry_title_margin_bottom","","Margin Under Title (px)","This is some description");
		$row1->addChild("blog_masonry_title_margin_bottom",$blog_masonry_title_margin_bottom);

		$blog_masonry_post_info_margin_top = new MikadoField("textsimple","blog_masonry_post_info_margin_top","","Margin Above Post Info (px)","This is some description");
		$row1->addChild("blog_masonry_post_info_margin_top",$blog_masonry_post_info_margin_top);

		$blog_masonry_article_margin_bottom = new MikadoField("textsimple","blog_masonry_article_margin_bottom","","Margin Between Articles (px)","This is some description");
		$row1->addChild("blog_masonry_article_margin_bottom",$blog_masonry_article_margin_bottom);

		$group8 = new MikadoGroup("Blog List Spacing for Quote and Link Post Type","Set spacing for blog layouts");
		$panel10->addChild("group8",$group8);

		$row1 = new MikadoRow();
		$group8->addChild("row1",$row1);

		$blog_masonry_ql_quote_author_margin_top = new MikadoField("textsimple","blog_masonry_ql_quote_author_margin_top","","Margin Above Quote Author (px)","This is some description");
		$row1->addChild("blog_masonry_ql_quote_author_margin_top",$blog_masonry_ql_quote_author_margin_top);

		$blog_masonry_ql_post_info_margin_top = new MikadoField("textsimple","blog_masonry_ql_post_info_margin_top","","Margin Above Post Info (px)","This is some description");
		$row1->addChild("blog_masonry_ql_post_info_margin_top",$blog_masonry_ql_post_info_margin_top);

		$post_text_styling= new MikadoTitle("post_text_styling", "Post Text Style");
		$panel10->addChild("post_text_styling", $post_text_styling);

		$group2 = new MikadoGroup("Post Title","Define title styles in this blog post template.");
		$panel10->addChild("group2",$group2);

		$row1 = new MikadoRow();
		$group2->addChild("row1",$row1);

		$blog_masonry_title_color = new MikadoField("colorsimple","blog_masonry_title_color","","Text Color","This is some description");
		$row1->addChild("blog_masonry_title_color",$blog_masonry_title_color);

		$blog_masonry_title_hover_color = new MikadoField("colorsimple","blog_masonry_title_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_masonry_title_hover_color",$blog_masonry_title_hover_color);

		$blog_masonry_title_date_color = new MikadoField("colorsimple","blog_masonry_title_date_color","","Date Color","This is some description");
		$row1->addChild("blog_masonry_title_date_color",$blog_masonry_title_date_color);

		$blog_masonry_title_fontsize = new MikadoField("textsimple","blog_masonry_title_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_masonry_title_fontsize",$blog_masonry_title_fontsize);


		$row2 = new MikadoRow(true);
		$group2->addChild("row2",$row2);


		$blog_masonry_title_lineheight = new MikadoField("textsimple","blog_masonry_title_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_masonry_title_lineheight",$blog_masonry_title_lineheight);


		$blog_masonry_title_google_fonts = new MikadoField("Fontsimple","blog_masonry_title_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_masonry_title_google_fonts",$blog_masonry_title_google_fonts);

		$blog_masonry_title_fontstyle = new MikadoField("selectblanksimple","blog_masonry_title_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_masonry_title_fontstyle",$blog_masonry_title_fontstyle);

		$blog_masonry_title_fontweight = new MikadoField("selectblanksimple","blog_masonry_title_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_masonry_title_fontweight",$blog_masonry_title_fontweight);

		$row3 = new MikadoRow(true);
		$group2->addChild("row3",$row3);


		$blog_masonry_title_texttransform = new MikadoField("selectblanksimple","blog_masonry_title_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_masonry_title_texttransform",$blog_masonry_title_texttransform);

		$blog_masonry_title_letterspacing = new MikadoField("textsimple","blog_masonry_title_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_masonry_title_letterspacing",$blog_masonry_title_letterspacing);

		$group4 = new MikadoGroup("Post Info Data","Define post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list");
		$panel10->addChild("group4",$group4);

		$row1 = new MikadoRow();
		$group4->addChild("row1",$row1);

		$blog_masonry_info_color = new MikadoField("colorsimple","blog_masonry_info_color","","Text Color","This is some description");
		$row1->addChild("blog_masonry_info_color",$blog_masonry_info_color);

		$blog_masonry_info_link_color = new MikadoField("colorsimple","blog_masonry_info_link_color","","Link Color","This is some description");
		$row1->addChild("blog_masonry_info_link_color",$blog_masonry_info_link_color);

		$blog_masonry_info_hover_color = new MikadoField("colorsimple","blog_masonry_info_hover_color","","Link Hover Color","This is some description");
		$row1->addChild("blog_masonry_info_hover_color",$blog_masonry_info_hover_color);

		$blog_masonry_info_fontsize = new MikadoField("textsimple","blog_masonry_info_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_masonry_info_fontsize",$blog_masonry_info_fontsize);

		$row2 = new MikadoRow(true);
		$group4->addChild("row2",$row2);


		$blog_masonry_info_lineheight = new MikadoField("textsimple","blog_masonry_info_lineheight","","Line Height (px)","This is some description");
		$row2->addChild("blog_masonry_info_lineheight",$blog_masonry_info_lineheight);

		$blog_masonry_info_google_fonts = new MikadoField("Fontsimple","blog_masonry_info_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_masonry_info_google_fonts",$blog_masonry_info_google_fonts);

		$blog_masonry_info_fontstyle = new MikadoField("selectblanksimple","blog_masonry_info_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_masonry_info_fontstyle",$blog_masonry_info_fontstyle);

		$blog_masonry_info_fontweight = new MikadoField("selectblanksimple","blog_masonry_info_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_masonry_info_fontweight",$blog_masonry_info_fontweight);

		$row3 = new MikadoRow(true);
		$group4->addChild("row3",$row3);

		$blog_masonry_info_texttransform = new MikadoField("selectblanksimple","blog_masonry_info_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row3->addChild("blog_masonry_info_texttransform",$blog_masonry_info_texttransform);

		$blog_masonry_info_letterspacing = new MikadoField("textsimple","blog_masonry_info_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_masonry_info_letterspacing",$blog_masonry_info_letterspacing);

		$blog_masonry_info_margin = new MikadoField("textsimple","blog_masonry_info_margin","","Margin (px)","This is some description");
		$row3->addChild("blog_masonry_info_margin",$blog_masonry_info_margin);

		$blog_masonry_info_border_color = new MikadoField("colorsimple","blog_masonry_info_border_color","","Border Color","This is some description");
		$row3->addChild("blog_masonry_info_border_color",$blog_masonry_info_border_color);

		$group3 = new MikadoGroup("Quote/Link Title Style","Define title styles for Quote/Link articles");
		$panel10->addChild("group3",$group3);

		$row1 = new MikadoRow();
		$group3->addChild("row1",$row1);

		$blog_masonry_ql_title_color = new MikadoField("colorsimple","blog_masonry_ql_title_color","","Text Color","This is some description");
		$row1->addChild("blog_masonry_ql_title_color",$blog_masonry_ql_title_color);

		$blog_masonry_ql_title_hover_color = new MikadoField("colorsimple","blog_masonry_ql_title_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_masonry_ql_title_hover_color",$blog_masonry_ql_title_hover_color);

		$blog_masonry_ql_title_fontsize = new MikadoField("textsimple","blog_masonry_ql_title_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_masonry_ql_title_font_size",$blog_masonry_ql_title_fontsize);

		$blog_masonry_ql_title_lineheight = new MikadoField("textsimple","blog_masonry_ql_title_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_masonry_ql_title_lineheight",$blog_masonry_ql_title_lineheight);

		$row2 = new MikadoRow(true);
		$group3->addChild("row2",$row2);

		$blog_masonry_ql_title_texttransform = new MikadoField("selectblanksimple","blog_masonry_ql_title_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_masonry_ql_title_texttransform",$blog_masonry_ql_title_texttransform);

		$blog_masonry_ql_title_google_fonts = new MikadoField("Fontsimple","blog_masonry_ql_title_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_masonry_ql_title_google_fonts",$blog_masonry_ql_title_google_fonts);

		$blog_masonry_ql_title_fontstyle = new MikadoField("selectblanksimple","blog_masonry_ql_title_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_masonry_ql_title_fontstyle",$blog_masonry_ql_title_fontstyle);

		$blog_masonry_ql_title_fontweight = new MikadoField("selectblanksimple","blog_masonry_ql_title_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_masonry_ql_title_fontweight",$blog_masonry_ql_title_fontweight);

		$row3 = new MikadoRow(true);
		$group3->addChild("row3",$row3);

		$blog_masonry_ql_title_letterspacing = new MikadoField("textsimple","blog_masonry_ql_title_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_masonry_ql_title_letterspacing",$blog_masonry_ql_title_letterspacing);


		$group5 = new MikadoGroup("Quote/Link Post Info Data","Define quote/link post info text styles (date, category names etc.) Note: Single Posts will take the same styles as in list.");
		$panel10->addChild("group5",$group5);

		$row1 = new MikadoRow();
		$group5->addChild("row1",$row1);

		$blog_masonry_ql_info_color = new MikadoField("colorsimple","blog_masonry_ql_info_color","","Text Color","This is some description");
		$row1->addChild("blog_masonry_ql_info_color",$blog_masonry_ql_info_color);

		$blog_masonry_ql_info_link_color = new MikadoField("colorsimple","blog_masonry_ql_info_link_color","","Link Color","This is some description");
		$row1->addChild("blog_masonry_ql_info_link_color",$blog_masonry_ql_info_link_color);

		$blog_masonry_ql_info_hover_color = new MikadoField("colorsimple","blog_masonry_ql_info_hover_color","","Hover Color","This is some description");
		$row1->addChild("blog_masonry_ql_info_hover_color",$blog_masonry_ql_info_hover_color);

		$blog_masonry_ql_info_fontsize = new MikadoField("textsimple","blog_masonry_ql_info_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_masonry_ql_info_fontsize",$blog_masonry_ql_info_fontsize);

		$row2 = new MikadoRow(true);
		$group5->addChild("row2",$row2);


		$blog_masonry_ql_info_lineheight = new MikadoField("textsimple","blog_masonry_ql_info_lineheight","","Line Height (px)","This is some description");
		$row2->addChild("blog_masonry_ql_info_lineheight",$blog_masonry_ql_info_lineheight);

		$blog_masonry_ql_info_google_fonts = new MikadoField("Fontsimple","blog_masonry_ql_info_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_masonry_ql_info_google_fonts",$blog_masonry_ql_info_google_fonts);

		$blog_masonry_ql_info_fontstyle = new MikadoField("selectblanksimple","blog_masonry_ql_info_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_masonry_ql_info_fontstyle",$blog_masonry_ql_info_fontstyle);

		$blog_masonry_ql_info_fontweight = new MikadoField("selectblanksimple","blog_masonry_ql_info_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_masonry_ql_info_fontweight",$blog_masonry_ql_info_fontweight);

		$row3 = new MikadoRow(true);
		$group5->addChild("row3",$row3);

		$blog_masonry_ql_info_texttransform = new MikadoField("selectblanksimple","blog_masonry_ql_info_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row3->addChild("blog_masonry_ql_info_texttransform",$blog_masonry_ql_info_texttransform);

		$blog_masonry_ql_info_letterspacing = new MikadoField("textsimple","blog_masonry_ql_info_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_masonry_ql_info_letterspacing",$blog_masonry_ql_info_letterspacing);

		$blog_masonry_ql_info_border_color = new MikadoField("colorsimple","blog_masonry_ql_info_border_color","","Border Color","This is some description");
		$row3->addChild("blog_masonry_ql_info_border_color",$blog_masonry_ql_info_border_color);

		$blog_masonry_ql_info_border_hover_color = new MikadoField("colorsimple","blog_masonry_ql_info_border_hover_color","","Border Hover Color","This is some description");
		$row3->addChild("blog_masonry_ql_info_border_hover_color",$blog_masonry_ql_info_border_hover_color);

		$group6 = new MikadoGroup("Quote Author Style","Define author styles for Quote articles");
		$panel10->addChild("group6",$group6);

		$row1 = new MikadoRow();
		$group6->addChild("row1",$row1);

		$blog_masonry_ql_author_color = new MikadoField("colorsimple","blog_masonry_ql_author_color","","Text Color","This is some description");
		$row1->addChild("blog_masonry_ql_author_color",$blog_masonry_ql_author_color);

		$blog_masonry_ql_author_hover_color = new MikadoField("colorsimple","blog_masonry_ql_author_hover_color","","Text Hover Color","This is some description");
		$row1->addChild("blog_masonry_ql_author_hover_color",$blog_masonry_ql_author_hover_color);

		$blog_masonry_ql_author_fontsize = new MikadoField("textsimple","blog_masonry_ql_author_fontsize","","Font Size (px)","This is some description");
		$row1->addChild("blog_masonry_ql_author_font_size",$blog_masonry_ql_author_fontsize);

		$blog_masonry_ql_author_lineheight = new MikadoField("textsimple","blog_masonry_ql_author_lineheight","","Line Height (px)","This is some description");
		$row1->addChild("blog_masonry_ql_author_lineheight",$blog_masonry_ql_author_lineheight);

		$row2 = new MikadoRow(true);
		$group6->addChild("row2",$row2);

		$blog_masonry_ql_author_texttransform = new MikadoField("selectblanksimple","blog_masonry_ql_author_texttransform","","Text Transform","This is some description",mikado_one_mikado_options_text_transform());
		$row2->addChild("blog_masonry_ql_author_texttransform",$blog_masonry_ql_author_texttransform);

		$blog_masonry_ql_author_google_fonts = new MikadoField("Fontsimple","blog_masonry_ql_author_google_fonts","-1","Font Family","This is some description");
		$row2->addChild("blog_masonry_ql_author_google_fonts",$blog_masonry_ql_author_google_fonts);

		$blog_masonry_ql_author_fontstyle = new MikadoField("selectblanksimple","blog_masonry_ql_author_fontstyle","","Font Style","This is some description",mikado_one_mikado_options_font_style());
		$row2->addChild("blog_masonry_ql_author_fontstyle",$blog_masonry_ql_author_fontstyle);

		$blog_masonry_ql_author_fontweight = new MikadoField("selectblanksimple","blog_masonry_ql_author_fontweight","","Font Weight","This is some description",mikado_one_mikado_options_font_weight());
		$row2->addChild("blog_masonry_ql_author_fontweight",$blog_masonry_ql_author_fontweight);

		$row3 = new MikadoRow(true);
		$group6->addChild("row3",$row3);

		$blog_masonry_ql_author_letterspacing = new MikadoField("textsimple","blog_masonry_ql_author_letterspacing","","Letter Spacing (px)","This is some description");
		$row3->addChild("blog_masonry_ql_author_letterspacing",$blog_masonry_ql_author_letterspacing);

	}

	add_action('mikado_one_mikado_action_options', 'mikado_one_core_blog_options_map', 9);
}