<?php
/*
Template Name: Blog Masonry Full Width
*/
?>
<?php get_header(); ?>
<?php

$page_object = get_post( mikado_one_mikado_get_page_id() );
$mkd_content = $page_object->post_content;



if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_background_color", true) != ""){
	$background_color = 'background-color:'.get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_background_color", true);
}else{
	$background_color = "";
}

$content_style = "";
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_content-top-padding", true) != ""){
	if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_content-top-padding-mobile", true) == 'yes'){
		$content_style = "padding-top:".esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_content-top-padding", true))."px !important";
	}else{
		$content_style = "padding-top:".esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_content-top-padding", true))."px";
	}
}

if(isset($mkd_options['number_of_chars_masonry'])&& ($mkd_options['number_of_chars_masonry'] != "")) {
	mikado_one_mikado_set_blog_word_count(esc_attr($mkd_options['number_of_chars_masonry']));
}
$category_filter = "no";
if(isset($mkd_options['blog_masonry_filter'])){
	$category_filter = esc_attr($mkd_options['blog_masonry_filter']);
}
$container_inner_class = "";
if($category_filter == "yes"){
	$container_inner_class = " full_page_container_inner";
}

?>

	<?php if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_scroll_amount_for_sticky", true)) { ?>
		<script>
		var page_scroll_amount_for_sticky = <?php echo esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_scroll_amount_for_sticky", true)); ?>;
		</script>
	<?php } ?>
		<?php get_template_part( 'title' ); ?>

	<?php
		$revslider = get_post_meta(mikado_one_mikado_get_page_id(), "mkd_revolution-slider", true);
		if (!empty($revslider)){ ?>
			<div class="mkd_slider"><div class="mkd_slider_inner">
			<?php echo do_shortcode($revslider); ?>
			</div></div>
		<?php
		}
		?>
	<?php
		if(isset($mkd_options['blog_page_range']) && $mkd_options['blog_page_range'] != ""){
			$blog_page_range = esc_attr($mkd_options['blog_page_range']);
		} else{
			$blog_page_range = mikado_one_mikado_get_max_number_of_pages();
		}
	?>
	<div class="full_width"<?php mikado_one_mikado_style_attr($background_color); ?>>
		<div class="full_width_inner clearfix <?php echo esc_attr($container_inner_class); ?>" <?php mikado_one_mikado_style_attr($content_style); ?>>
			<?php
				echo apply_filters( 'the_content', $mkd_content );
				get_template_part('templates/blog/blog', 'structure');
			?>
		</div>
	</div>
<?php get_footer(); ?>