<?php

include_once get_template_directory() . '/theme-includes.php';

if(!function_exists('mikado_one_mikado_setup_theme')) {
    /**
     * Function that adds theme support and register image sizes
     */
    function mikado_one_mikado_setup_theme() {
        //add support for feed links
        add_theme_support( 'automatic-feed-links' );

        //add support for post formats
        add_theme_support('post-formats', array('gallery', 'link', 'quote', 'video', 'audio'));

        //add theme support for post thumbnails
        add_theme_support( 'post-thumbnails' );

        if(function_exists('_wp_render_title_tag')) {
            add_theme_support('title-tag');
        }

        //define thumbnail sizes
        add_image_size( 'mikado-portfolio-square', 550, 550, true );
        add_image_size( 'mikado-portfolio-landscape', 800, 600, true );// This size is also for Latest Posts shortcode, "Boxes" type
        add_image_size( 'mikado-portfolio-portrait', 600, 800, true );// This size is also for Latest Posts shortcode, "Post Over Image" type
        add_image_size( 'mikado-portfolio-masonry-wide', 1000, 500, true );
        add_image_size( 'mikado-portfolio-masonry-tall', 500, 1000, true );
        add_image_size( 'mikado-portfolio-masonry-large', 1000, 1000, true ); // This size is also for Latest Post shortcode, "Image With Date" type
        add_image_size( 'mikado-portfolio-masonry-with-space', 700);
        add_image_size( 'mikado-blog-image-format-link-quote', 1100, 500, true);

	    load_theme_textdomain( 'mikado1', get_template_directory().'/languages' );
    }

    add_action('after_setup_theme', 'mikado_one_mikado_setup_theme');
}


if (!function_exists('mikado_one_mikado_styles')) {
	/**
	 * Function that includes theme's core styles
	 */
	function mikado_one_mikado_styles() {
		global $wp_styles;
		$mkd_options = mikado_one_mikado_return_global_options();

		//init variables
		$responsiveness = 'yes';
		$vertical_area 	= "no";
		$vertical_area_hidden = '';

		wp_enqueue_style( 'wp-mediaelement' );

		wp_register_style("mikado-one-mikado-blog", MIKADO_CSS_ROOT . "/blog.min.css");
		wp_register_style("mikado-one-mikado-slider", MIKADO_CSS_ROOT . "/mkd_slider.min.css");
		wp_register_style("mikado-one-mikado-portfolio", MIKADO_CSS_ROOT . "/mkd_portfolio.min.css");
		wp_register_style("mikado-one-mikado-testimonials", MIKADO_CSS_ROOT . "/mkd_testimonials.min.css");
		wp_register_style("mikado-one-mikado-carousel", MIKADO_CSS_ROOT . "/mkd_carousel.min.css");

		//include theme's core styles
		wp_enqueue_style("mikado-one-mikado-default-style", MIKADO_ROOT . "/style.css");
		wp_enqueue_style("mikado-one-mikado-stylesheet", MIKADO_CSS_ROOT . "/stylesheet.min.css");

		wp_enqueue_style( 'mikado-one-mikado-ie9-style', MIKADO_ROOT . '/css/ie9_stylesheet.cs' );
		$wp_styles->add_data( 'mikado-one-mikado-ie9-style', 'conditional', 'IE 9' );

		//is ajax enabled or is current page post or blog template
		//or posts page or current page has latest posts shortcode?
		if( mikado_one_mikado_is_ajax_enabled() || mikado_one_mikado_is_blog_template() || is_home()
		    || is_single() || mikado_one_mikado_has_shortcode('no_blog_list') || mikado_one_mikado_has_shortcode('no_blog_slider') || is_archive() || is_search() || mikado_one_mikado_has_blog_widget()) {
			wp_enqueue_style('mikado-one-mikado-blog');
		}

        if(mikado_one_mikado_load_portfolio_assets()) {
            wp_enqueue_style('mikado-one-mikado-portfolio');
        }

        if(mikado_one_mikado_load_slider_assets()) {
            wp_enqueue_style('mikado-one-mikado-slider');
        }

        if(mikado_one_mikado_load_testimonials_assets()) {
            wp_enqueue_style('mikado-one-mikado-testimonials');
        }

        if(mikado_one_mikado_load_carousel_assets()) {
            wp_enqueue_style('mikado-one-mikado-carousel');
        }

		if( mikado_one_mikado_buddy_press_installed() && ( mikado_one_mikado_is_ajax_enabled() || mikado_one_mikado_is_buddy_press_page() || mikado_one_mikado_has_buddy_press_shortcode())){
			wp_enqueue_style("mikado-one-mikado-buddypress-style", MIKADO_CSS_ROOT . "/mkd_buddypress.min.css");
			wp_enqueue_style("mikado-one-mikado-buddypress-responsive-style", MIKADO_CSS_ROOT . "/mkd_buddypress_responsive.min.css");
		}

		//define files afer which style dynamic needs to be included. It should be included last so it can override other files
		$style_dynamic_deps_array = array();
		if(mikado_one_mikado_load_woo_assets()) {
			$style_dynamic_deps_array = array('mikado-one-mikado-woocommerce', 'mikado-one-mikado-woocommerce-responsive');
		}

        if ( file_exists(MIKADO_CSS_ROOT_DIR . "/style_dynamic.css") && mikado_one_mikado_is_css_folder_writable() && !is_multisite()) {
            wp_enqueue_style("mikado-one-mikado-style-dynamic", MIKADO_CSS_ROOT . "/style_dynamic.css", $style_dynamic_deps_array, filemtime(MIKADO_CSS_ROOT_DIR . "/style_dynamic.css") ); //it must be included after woocommerce styles so it can override it
        } else if ( file_exists( MIKADO_CSS_ROOT_DIR . '/style_dynamic_ms_id_' . mikado_one_mikado_get_multisite_blog_id() . '.css' ) && mikado_one_mikado_is_css_folder_writable() && is_multisite() ) {
        	wp_enqueue_style( 'mikado-one-mikado-style-dynamic', MIKADO_CSS_ROOT . '/style_dynamic_ms_id_' . mikado_one_mikado_get_multisite_blog_id() . '.css', array(), filemtime(MIKADO_CSS_ROOT_DIR . '/style_dynamic_ms_id_' . mikado_one_mikado_get_multisite_blog_id() . '.css') );
        } else {
            wp_enqueue_style("mikado-one-mikado-style-dynamic", MIKADO_CSS_ROOT . "/style_dynamic_callback.php", $style_dynamic_deps_array); //it must be included after woocommerce styles so it can override it
        }

		do_action( 'mikado_one_mikado_action_enqueue_before_main_css' );

		//does responsive option exists?
		if (isset($mkd_options['responsiveness'])) {
			$responsiveness = esc_attr($mkd_options['responsiveness']);
		}

		//is responsive option turned on?
		if ($responsiveness != "no") {
			//include proper styles
			wp_enqueue_style("mikado-one-mikado-responsive", MIKADO_CSS_ROOT . "/responsive.min.css");

            if ( file_exists(MIKADO_CSS_ROOT_DIR . "/style_dynamic_responsive.css") && mikado_one_mikado_is_css_folder_writable() && !is_multisite()){
                wp_enqueue_style("mikado-one-mikado-style-dynamic-responsive", MIKADO_CSS_ROOT . "/style_dynamic_responsive.css", array(), filemtime(MIKADO_CSS_ROOT_DIR . "/style_dynamic_responsive.css"));
            } else if ( file_exists( MIKADO_CSS_ROOT_DIR . '/style_dynamic_responsive_ms_id_' . mikado_one_mikado_get_multisite_blog_id() . '.css' ) && mikado_one_mikado_is_css_folder_writable() && is_multisite() ) {

	            wp_enqueue_style( 'mikado-one-mikado-style-dynamic-responsive', MIKADO_CSS_ROOT . '/style_dynamic_responsive_ms_id_' . mikado_one_mikado_get_multisite_blog_id() . '.css', array(), filemtime( MIKADO_CSS_ROOT_DIR . '/style_dynamic_responsive_ms_id_' . mikado_one_mikado_get_multisite_blog_id() . '.css' ) );
            } else {
                wp_enqueue_style("mikado-one-mikado-style-dynamic-responsive", MIKADO_CSS_ROOT . "/style_dynamic_responsive_callback.php");
            }
		}

		//does left menu option exists?
		if (isset($mkd_options['vertical_area'])){
			$vertical_area = esc_attr($mkd_options['vertical_area']);
		}

		//is hidden menu enabled?
		if (isset($mkd_options['vertical_area_type'])){
			$vertical_area_hidden = esc_attr($mkd_options['vertical_area_type']);
		}

		//is left menu activated and is responsive turned on?
		if($vertical_area == "yes" && $responsiveness != "no" && $vertical_area_hidden!='hidden'){
			wp_enqueue_style("mikado-one-mikado-vertical-responsive", MIKADO_CSS_ROOT . "/vertical_responsive.min.css");
		}

		$custom_css = $mkd_options['custom_css'];

		if ( ! empty( $custom_css ) ) {
			if ( $responsiveness != "no" ) {
				wp_add_inline_style( 'mikado-one-mikado-style-dynamic', $custom_css );
			} else {
				wp_add_inline_style( 'mikado-one-mikado-style-dynamic-responsive', $custom_css );
			}
		}

		//is toolbar turned on?
		if ( mikado_one_mikado_get_toolbar_param() === true) {
			//include toolbar specific styles
			wp_enqueue_style("mikado-one-mikado-toolbar", MIKADO_CSS_ROOT . "/toolbar.css");
		}

        //is demo landing turned on?
        if ( mikado_one_mikado_get_demo_landing_param() === true) {
            //include demo page specific styles
            wp_enqueue_style("mikado-one-mikado-demo-landing", get_home_url() . "/demo-files/landing/css/demo_landing_stylesheet.css");

        }

		//include Visual Composer styles
		if (class_exists('WPBakeryVisualComposerAbstract')) {
			wp_enqueue_style( 'js_composer_front' );
		}
	}

	add_action('wp_enqueue_scripts', 'mikado_one_mikado_styles');
}


if(!function_exists( 'mikado_one_mikado_browser_specific_styles' )) {
	/**
	 * Function that includes browser specific styles. Works for Chrome on Mac and for webkit browsers
	 */
	function mikado_one_mikado_browser_specific_styles() {
		global $is_chrome;
		global $is_safari;

		//check Chrome version
		preg_match( "#Chrome/(.+?)\.#", getenv('HTTP_USER_AGENT'), $match );
		if(!empty($match)) {
			$chrome_version = $match[1];
		} else{
			$chrome_version = 0;
		}

		//is Mac OS X?
		$mac_os = strpos( getenv('HTTP_USER_AGENT'), "Macintosh; Intel Mac OS X" );

		//is Chrome on Mac with version greater than 21
		if($is_chrome && ($mac_os !== false) && ($chrome_version > 21)) {
			//include mac specific styles
			wp_enqueue_style("mkd-mac-stylesheet", MIKADO_CSS_ROOT . "/mac_stylesheet.css");
		}

		//is Chrome or Safari?
		if($is_chrome || $is_safari) {
			//include style for webkit browsers only
			wp_enqueue_style("mkd_webkit", MIKADO_CSS_ROOT . "/webkit_stylesheet.css");
		}
	}

	add_action('wp_enqueue_scripts', 'mikado_one_mikado_browser_specific_styles');
}

if(!function_exists( 'mikado_one_mikado_google_fonts_styles' )) {
	/**
	 * Function that includes google fonts defined anywhere in the theme
	 */
	function mikado_one_mikado_google_fonts_styles() {
        $mkd_options = mikado_one_mikado_return_global_options();;

        $font_weight_str = '100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic';
		$font_subset_str = 'latin-ext';
        $available_font_options = array(
            'google_fonts',
            'menu_google_fonts',
            'dropdown_google_fonts',
            'dropdown_wide_google_fonts',
            'dropdown_google_fonts_thirdlvl',
            'fixed_google_fonts',
            'sticky_google_fonts',
            'mobile_google_fonts',
            'h1_google_fonts',
            'h2_google_fonts',
            'h3_google_fonts',
            'h4_google_fonts',
            'h5_google_fonts',
            'h6_google_fonts',
            'text_google_fonts',
            'blockquote_font_family',
            'page_title_google_fonts',
            'page_subtitle_google_fonts',
            'page_breadcrumb_google_fonts',
            'blog_date_in_title_title_google_fonts',
            'blog_date_in_title_info_google_fonts',
            'blog_date_in_title_ql_title_google_fonts',
            'blog_date_in_title_ql_info_google_fonts',
            'blog_date_in_title_ql_author_google_fonts',
            'blog_category_title_first_centered_title_google_fonts',
            'blog_category_title_first_centered_info_google_fonts',
            'blog_category_title_first_centered_category_google_fonts',
            'blog_category_title_first_centered_ql_title_fontfamily',
            'blog_category_title_first_centered_ql_info_google_fonts',
            'blog_category_title_first_centered_ql_author_fontfamily',
            'blog_post_info_vertical_content_title_google_fonts',
            'blog_post_info_vertical_content_info_google_fonts',
            'blog_post_info_vertical_content_ql_title_google_fonts',
            'blog_post_info_vertical_content_ql_info_google_fonts',
            'blog_post_info_vertical_content_ql_author_google_fonts',
            'blog_image_with_icon_centered_title_google_fonts',
            'blog_image_with_icon_centered_info_google_fonts',
            'blog_image_with_icon_centered_category_google_fonts',
            'blog_image_with_icon_centered_ql_title_google_fonts',
            'blog_image_with_icon_centered_ql_info_google_fonts',
            'blog_image_with_icon_centered_ql_category_google_fonts',
            'blog_image_with_icon_centered_ql_author_google_fonts',
            'blog_title_date_first_title_google_fonts',
            'blog_title_date_first_info_google_fonts',
            'blog_title_date_first_date_google_fonts',
            'blog_title_date_first_ql_title_google_fonts',
            'blog_title_date_first_ql_info_google_fonts',
            'blog_title_date_first_ql_author_google_fonts',
            'blog_title_author_centered_title_google_fonts',
            'blog_title_author_centered_info_google_fonts',
            'blog_title_author_centered_author_google_fonts',
            'blog_title_author_centered_ql_title_google_fonts',
            'blog_title_author_centered_ql_info_google_fonts',
            'blog_title_author_centered_ql_author_google_fonts',
            'blog_post_info_vertical_image_title_google_fonts',
            'blog_post_info_vertical_image_info_google_fonts',
            'blog_post_info_vertical_image_ql_title_google_fonts',
            'blog_post_info_vertical_image_ql_info_google_fonts',
            'blog_post_info_vertical_image_ql_author_google_fonts',
            'blog_masonry_filter_title_font_family',
            'blog_masonry_filter_font_family',
            'blog_masonry_title_google_fonts',
            'blog_masonry_info_google_fonts',
            'blog_masonry_ql_title_google_fonts',
            'blog_masonry_ql_info_google_fonts',
            'blog_masonry_ql_author_google_fonts',
			'blog_single_post_author_info_title_font_family',
			'blog_single_post_author_info_text_font_family',
            'pricing_tables_active_text_font_family',
            'pricing_tables_title_font_family',
            'pricing_tables_period_font_family',
            'pricing_tables_price_font_family',
            'pricing_tables_currency_font_family',
            'pricing_tables_button_font_family',
            'counters_font_family',
            'message_title_google_fonts',
            'pagination_font_family',
            'button_title_google_fonts',
            'testimonials_text_font_family',
            'testimonials_author_font_family',
            'tabs_nav_font_family',
            'footer_top_text_font_family',
            'footer_top_link_font_family',
            'footer_bottom_text_font_family',
            'footer_bottom_link_font_family',
            'footer_title_font_family',
            'sidebar_title_font_family',
            'sidebar_link_font_family',
            'side_area_title_google_fonts',
            'sidearea_link_font_family',
            'vertical_menu_google_fonts',
            'vertical_dropdown_google_fonts',
            'vertical_dropdown_google_fonts_thirdlvl',
            'popup_menu_google_fonts',
            'popup_menu_google_fonts_2nd',
            'popup_menu_3rd_font_family',
            'portfolio_single_big_title_font_family',
            'portfolio_single_small_title_font_family',
            'portfolio_single_meta_title_font_family',
            'top_header_text_font_family',
            'portfolio_filter_title_font_family',
            'portfolio_filter_font_family',
            'portfolio_title_standard_list_font_family',
            'portfolio_category_standard_list_font_family',
            'portfolio_title_list_font_family',
            'portfolio_category_list_font_family',
            'expandable_label_font_family',
            '404_title_font_family',
            '404_text_font_family',
            'back_to_top_text_fontfamily',
            'woo_products_category_font_family',
            'woo_products_title_font_family',
            'woo_products_price_font_family',
            'woo_products_sale_font_family',
            'woo_products_out_of_stock_font_family',
            'woo_products_sorting_result_font_family',
            'woo_products_list_add_to_cart_font_family',
            'woo_product_single_meta_title_font_family',
            'woo_product_single_meta_info_font_family',
            'woo_product_single_title_font_family',
            'woo_products_single_add_to_cart_font_family',
            'woo_product_single_price_font_family',
            'woo_product_single_related_font_family',
            'cf7_custom_style_1_element_font_family',
            'cf7_custom_style_2_element_font_family',
            'cf7_custom_style_3_element_font_family',
            'cf7_custom_style_1_button_font_family',
            'cf7_custom_style_2_button_font_family',
            'cf7_custom_style_3_button_font_family',
            'content_menu_text_google_fonts',
            'buddy_press_button_title_google_fonts',
            'buddy_press_header_button_title_google_fonts',
            'buddy_press_first_level_menu_title_google_fonts',
            'buddy_press_second_level_menu_title_google_fonts',
            'buddy_press_element_font_family',
            'buddy_press_pagination_text_google_fonts',
            'buddy_press_text_google_fonts',
            'buddy_press_link_google_fonts'
        );

        //define available font options array
        $fonts_array = array();
        foreach ($available_font_options as $font_option) {
            //is font set and not set to default and not empty?
            if (isset($mkd_options[$font_option]) && $mkd_options[$font_option] !== '-1' && $mkd_options[$font_option] !== '' && !mikado_one_mikado_is_native_font($mkd_options[$font_option])) {
                $font_option_string = $mkd_options[$font_option] . ':' . $font_weight_str;
                if (!in_array($font_option_string, $fonts_array)) {
                    $fonts_array[] = $font_option_string;
                }
            }
        }

        if(mikado_one_mikado_load_slider_assets()) {
            //add google fonts set in slider
            $args = array('post_type' => 'slides', 'posts_per_page' => -1);
            $loop = new WP_Query($args);

            //for each slide defined
            while ($loop->have_posts()) : $loop->the_post();

                //is font family for title option chosen?
                if (get_post_meta(get_the_ID(), "mkd_slide-title-font-family", true) != "") {
                    $slide_title_font_string = esc_attr(get_post_meta(get_the_ID(), "mkd_slide-title-font-family", true)) . ":" . $font_weight_str;
                    if (!in_array($slide_title_font_string, $fonts_array)) {
                        //include that font
                        array_push($fonts_array, $slide_title_font_string);
                    }
                }

                //is font family defined for slide's text?
                if (get_post_meta(get_the_ID(), "mkd_slide-text-font-family", true) != "") {
                    $slide_text_font_string = esc_attr(get_post_meta(get_the_ID(), "mkd_slide-text-font-family", true)) . ":" . $font_weight_str;
                    if (!in_array($slide_text_font_string, $fonts_array)) {
                        //include that font
                        array_push($fonts_array, $slide_text_font_string);
                    }
                }

                //is font family defined for slide's subtitle?
                if (get_post_meta(get_the_ID(), "mkd_slide-subtitle-font-family", true) != "") {
                    $slide_subtitle_font_string = esc_attr(get_post_meta(get_the_ID(), "mkd_slide-subtitle-font-family", true)) . ":" . $font_weight_str;
                    if (!in_array($slide_subtitle_font_string, $fonts_array)) {
                        //include that font
                        array_push($fonts_array, $slide_subtitle_font_string);
                    }
                }
            endwhile;

	        wp_reset_postdata();
        }

        $fonts_array = array_diff($fonts_array, array("-1:" . $font_weight_str));
		$google_fonts_string = implode( '|', $fonts_array );

		$protocol = is_ssl() ? 'https:' : 'http:';

		//default fonts
		$default_font_family = array(
			'Open Sans',
			'Ubuntu'
		);

		$modified_default_font_family = array();
		foreach ( $default_font_family as $default_font ) {
			$modified_default_font_family[] = $default_font . ':' . str_replace( ' ', '', $font_weight_str );
		}

		$default_font_string = implode( '|', $modified_default_font_family );

        //is google font option checked anywhere in theme?
        if (count($fonts_array) > 0) {

	        //include all checked fonts
	        $fonts_full_list      = $default_font_string . '|' . str_replace( '+', ' ', $google_fonts_string );
	        $fonts_full_list_args = array(
		        'family' => urlencode( $fonts_full_list ),
		        'subset' => urlencode( $font_subset_str ),
	        );

	        $oaza_mikado_global_fonts = add_query_arg( $fonts_full_list_args, $protocol . '//fonts.googleapis.com/css' );
	        wp_enqueue_style( 'mikado-one-mikado-google-fonts', esc_url_raw( $oaza_mikado_global_fonts ), array(), '1.0.0' );

        } else {

	        //include default google font that theme is using
	        $default_fonts_args          = array(
		        'family' => urlencode( $default_font_string ),
		        'subset' => urlencode( $font_subset_str ),
	        );
	        $oaza_mikado_global_fonts = add_query_arg( $default_fonts_args, $protocol . '//fonts.googleapis.com/css' );
	        wp_enqueue_style( 'mikado-one-mikado-google-fonts', esc_url_raw( $oaza_mikado_global_fonts ), array(), '1.0.0' );
        }
    }

	add_action('wp_enqueue_scripts', 'mikado_one_mikado_google_fonts_styles');
}


if (!function_exists( 'mikado_one_mikado_scripts' )) {
	/**
	 * Function that includes all necessary scripts
	 */
	function mikado_one_mikado_scripts() {
		$mkd_options = mikado_one_mikado_return_global_options();;
		global $wp_scripts;

		//init variables
		$smooth_scroll 	= true;
		$has_ajax 		= false;
		$mkd_animation = "";

		//is smooth scroll option turned on?
		if(isset($mkd_options['smooth_scroll']) && $mkd_options['smooth_scroll'] == "no"){
			$smooth_scroll = false;
		}

        //register optional scripts
        wp_register_script("ajax", MIKADO_JS_ROOT . "/ajax.min.js",array('jquery'),false,true);
        wp_register_script("lemmonSlider", MIKADO_JS_ROOT . "/plugins/lemmon-slider.js", array('jquery'), false, true);
        wp_register_script("carouFredSel", MIKADO_JS_ROOT . "/plugins/jquery.carouFredSel-6.2.1.js",array('jquery'), false, true);
        wp_register_script("one_page_scroll", MIKADO_JS_ROOT . "/plugins/jquery.fullPage.min.js",array('jquery'), false, true);
		wp_register_script("touchSwipe", MIKADO_JS_ROOT . "/plugins/jquery.touchSwipe.min.js",array('jquery'),false,true);

        wp_register_script('mikado-one-mikado-blog', MIKADO_JS_ROOT . "/blog.min.js", array('jquery'), false, true);
        wp_register_script("mikado-one-mikado-buddypress-script", MIKADO_JS_ROOT . "/mkd_buddypress.js",array('jquery'),false,true);
        wp_register_script("mikado-one-mikado-select2", MIKADO_JS_ROOT . "/select2.min.js",array('jquery'),false,true);
        wp_register_script('mikado-one-mikado-portfolio', MIKADO_JS_ROOT . "/mkd_portfolio.js", array('jquery'), false, true);
        wp_register_script('mikado-one-mikado-slider', MIKADO_JS_ROOT . "/mkd_slider.js", array('jquery'), false, true);
        wp_register_script('mikado-one-mikado-testimonials', MIKADO_JS_ROOT . "/mkd_testimonials.min.js", array('jquery'), false, true);
        wp_register_script('mikado-one-mikado-carousel', MIKADO_JS_ROOT . "/mkd_carousel.min.js", array('jquery'), false, true);

		//init theme core scripts

		wp_enqueue_script( 'doubletaptogo', MIKADO_JS_ROOT . '/plugins/doubletaptogo.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'modernizr', MIKADO_JS_ROOT . '/plugins/modernizr.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'appear', MIKADO_JS_ROOT . '/plugins/jquery.appear.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'hoverIntent' );

		wp_enqueue_script( 'jquery-ui-core');
		wp_enqueue_script( 'jquery-ui-widget');
		wp_enqueue_script( 'jquery-ui-mouse');
		wp_enqueue_script( 'jquery-ui-draggable');
		wp_enqueue_script( 'jquery-ui-droppable');
		wp_enqueue_script( 'jquery-ui-resizable');
		wp_enqueue_script( 'jquery-ui-selectable');
		wp_enqueue_script( 'jquery-ui-sortable');
		wp_enqueue_script( 'jquery-ui-effect');
		wp_enqueue_script( 'jquery-ui-accordion');
		wp_enqueue_script( 'jquery-ui-autocomplete');
		wp_enqueue_script( 'jquery-ui-button');
		wp_enqueue_script( 'jquery-ui-datepicker');
		wp_enqueue_script( 'jquery-ui-dialog');
		wp_enqueue_script( 'jquery-ui-effect-blind');
		wp_enqueue_script( 'jquery-ui-effect-bounce');
		wp_enqueue_script( 'jquery-ui-effect-clip');
		wp_enqueue_script( 'jquery-ui-effect-drop');
		wp_enqueue_script( 'jquery-ui-effect-explode');
		wp_enqueue_script( 'jquery-ui-effect-fade');
		wp_enqueue_script( 'jquery-ui-effect-fold');
		wp_enqueue_script( 'jquery-ui-effect-highlight');
		wp_enqueue_script( 'jquery-ui-effect-pulsate');
		wp_enqueue_script( 'jquery-ui-effect-scale');
		wp_enqueue_script( 'jquery-ui-effect-shake');
		wp_enqueue_script( 'jquery-ui-effect-slide');
		wp_enqueue_script( 'jquery-ui-effect-transfer');
		wp_enqueue_script( 'jquery-ui-menu');
		wp_enqueue_script( 'jquery-ui-position');
		wp_enqueue_script( 'jquery-ui-progressbar');
		wp_enqueue_script( 'jquery-ui-slider');
		wp_enqueue_script( 'jquery-ui-spinner');
		wp_enqueue_script( 'jquery-ui-tabs');
		wp_enqueue_script( 'jquery-ui-tooltip');
		wp_enqueue_script( 'jquery-form' );
		wp_enqueue_script( 'wp-mediaelement' );

		wp_enqueue_script( 'easypiechart', MIKADO_JS_ROOT . '/plugins/easypiechart.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'nicescroll', MIKADO_JS_ROOT . '/plugins/jquery.nicescroll.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'prettyphoto', MIKADO_JS_ROOT . '/plugins/jquery.prettyPhoto.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'fitvids', MIKADO_JS_ROOT . '/plugins/jquery.fitvids.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'flexslider', MIKADO_JS_ROOT . '/plugins/jquery.flexslider-min.js', array( 'jquery' ), false, true );
		//wp_enqueue_script( 'mediaelement', MIKADO_JS_ROOT . '/plugins/mediaelement-and-player.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'waitforimages', MIKADO_JS_ROOT . '/plugins/jquery.waitforimages.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'infinitescroll', MIKADO_JS_ROOT . '/plugins/infinitescroll.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'waypoints', MIKADO_JS_ROOT . '/plugins/waypoints.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'jplayer', MIKADO_JS_ROOT . '/plugins/jplayer.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'bootstrap-carousel', MIKADO_JS_ROOT . '/plugins/bootstrap.carousel.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'skrollr', MIKADO_JS_ROOT . '/plugins/skrollr.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'Chart', MIKADO_JS_ROOT . '/plugins/Chart.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'jquery-easing-1.3', MIKADO_JS_ROOT . '/plugins/jquery.easing.1.3.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'jquery-blob', MIKADO_JS_ROOT . '/plugins/jquery.blob.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'jquery-countdown', MIKADO_JS_ROOT . '/plugins/jquery.countdown.min.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'jquery-multiscroll', MIKADO_JS_ROOT . '/plugins/jquery.multiscroll.min.js', array( 'jquery' ), false, true );


		wp_enqueue_script("mousewheel", MIKADO_JS_ROOT . "/plugins/jquery.mousewheel.min.js",array('jquery'), false, true);
		wp_enqueue_script("isotope", MIKADO_JS_ROOT . "/plugins/jquery.isotope.min.js", array('jquery'),false,true);


		if ( mikado_one_mikado_get_demo_landing_param() !== true) {
            wp_enqueue_script("mixitup", MIKADO_JS_ROOT . "/plugins/jquery.mixitup.min.js", array(), false, true);
        }

        if( mikado_one_mikado_is_ajax_enabled() ||
            ( mikado_one_mikado_has_shortcode('no_blog_slider') || mikado_one_mikado_has_shortcode('no_portfolio_slider') || mikado_one_mikado_has_shortcode('no_carousel') || mkd_has_mkd_slider_shortcode())) {
            wp_enqueue_script("carouFredSel");
        }

        if( mikado_one_mikado_is_ajax_enabled() || mikado_one_mikado_is_full_screen_template()) {
            wp_enqueue_script("one_page_scroll");
        }

        if( mikado_one_mikado_is_ajax_enabled() || mikado_one_mikado_has_shortcode('no_image_slider_no_space')) {
            wp_enqueue_script("lemmonSlider");
        }

        if(mikado_one_mikado_load_slider_assets()) {
            wp_enqueue_script("touchSwipe");
        }

        //include google map api script
        if( (isset($mkd_options['google_maps_api_key']) && $mkd_options['google_maps_api_key'] != "")) {

            $google_maps_api_key = $mkd_options['google_maps_api_key'];
            wp_enqueue_script("google_map_api", "https://maps.googleapis.com/maps/api/js?key=" . $google_maps_api_key,array('jquery'),false,true);
        }

		if( mikado_one_mikado_buddy_press_installed() && ( mikado_one_mikado_is_ajax_enabled() || mikado_one_mikado_is_buddy_press_page() || mikado_one_mikado_has_buddy_press_shortcode())) {
			wp_enqueue_script("mikado-one-mikado-buddypress-script");
			wp_enqueue_script("select2");
		}

        if ( file_exists(MIKADO_JS_ROOT_DIR ."/default_dynamic.js") && mikado_one_mikado_is_js_folder_writable() && !is_multisite()) {
            wp_enqueue_script("mikado-one-mikado-default-dynamic", MIKADO_JS_ROOT."/default_dynamic.js",array('jquery'), filemtime(MIKADO_JS_ROOT_DIR ."/default_dynamic.js"),true);
        } else if ( file_exists( MIKADO_JS_ROOT_DIR . '/default_dynamic_ms_id_' . mikado_one_mikado_get_multisite_blog_id() . '.js' ) && mikado_one_mikado_is_css_folder_writable() && is_multisite() ) {
	        wp_enqueue_script( 'mikado-one-mikado-default-dynamic', MIKADO_JS_ROOT . '/default_dynamic_ms_id_' . mikado_one_mikado_get_multisite_blog_id() . '.js', array('jquery'), filemtime( MIKADO_JS_ROOT_DIR . '/default_dynamic_ms_id_' . mikado_one_mikado_get_multisite_blog_id() . '.js' ) );
        } else {
            wp_enqueue_script("mikado-one-mikado-default-dynamic", MIKADO_JS_ROOT . "/default_dynamic_callback.php", array('jquery'), false, true);
        }

		if(mikado_one_mikado_load_portfolio_assets()) {
            wp_enqueue_script('mikado-one-mikado-portfolio'); //has to be before default.js because of parallax init
        }

		if(mikado_one_mikado_load_testimonials_assets()) {
            wp_enqueue_script('mikado-one-mikado-testimonials'); //has to be before default.js because of parallax init
        }

        if(mikado_one_mikado_load_carousel_assets()) {
            wp_enqueue_script('mikado-one-mikado-carousel'); //has to be before default.js because of parallax init
        }

        wp_enqueue_script("mikado-one-mikado-default", MIKADO_JS_ROOT . "/default.min.js", array('jquery'), false, true);

		$custom_js = $mkd_options['custom_js'];
		if ( ! empty( $custom_js ) ) {
			wp_add_inline_script( 'mikado-one-mikado-default', $custom_js );
		}

        if( mikado_one_mikado_is_ajax_enabled() || mikado_one_mikado_is_blog_template() || is_home()
            || is_single() || mikado_one_mikado_has_shortcode('no_blog_list') || mikado_one_mikado_has_shortcode('no_blog_slider') || is_archive() || is_search() || mikado_one_mikado_has_blog_widget()) {
            wp_enqueue_script('mikado-one-mikado-blog');
        }

        if(mikado_one_mikado_load_slider_assets()) {
            wp_enqueue_script('mikado-one-mikado-slider');
        }

        //is smooth scroll enabled enabled and not Mac device?
        $mac_os = strpos( getenv('HTTP_USER_AGENT'), "Macintosh; Intel Mac OS X" );
        if($smooth_scroll && $mac_os == false){
            wp_enqueue_script("TweenLite", MIKADO_JS_ROOT . "/plugins/TweenLite.min.js",array('jquery'),false,true);
            wp_enqueue_script("ScrollToPlugin", MIKADO_JS_ROOT . "/plugins/ScrollToPlugin.min.js",array('jquery'),false,true);
            wp_enqueue_script("smoothPageScroll", MIKADO_JS_ROOT . "/plugins/smoothPageScroll.js",array('jquery'),false,true);
        }

		//include comment reply script
		$wp_scripts->add_data('comment-reply', 'group', 1 );
		if (is_singular()) {
			wp_enqueue_script( "comment-reply");
		}

		//is ajax set in session?
		if (isset($_SESSION['mkd_cayman_page_transitions'])) {
			$mkd_animation = $_SESSION['mkd_cayman_page_transitions'];
		}
		if (($mkd_options['page_transitions'] != "0") && (empty($mkd_animation) || ($mkd_animation != "no"))) {
			$has_ajax = true;
		} elseif (!empty($mkd_animation) && ($mkd_animation != "no"))
			$has_ajax = true;

		if ($has_ajax) {
			wp_enqueue_script("mikado-one-mikado-ajax");
		}

		//include Visual Composer script
		if (class_exists('WPBakeryVisualComposerAbstract')) {
			wp_enqueue_script( 'wpb_composer_front_js' );
		}

			//is toolbar enabled?
		if ( mikado_one_mikado_get_toolbar_param() === true) {
			//include toolbar specific script
			wp_enqueue_script("mikado-one-mikado-toolbar", MIKADO_JS_ROOT . "/toolbar.js",array('jquery'),false,true);
		}

        //is demo landing enabled?
		if ( mikado_one_mikado_get_demo_landing_param() === true) {
            wp_enqueue_script("mikado-one-mikado-demo-mixitup", get_home_url() . "/demo-files/landing/js/jquery.mixitup.js", array('jquery'), false, true);
            wp_enqueue_script("mikado-one-mikado-demo-mixitup-pagination", get_home_url() . "/demo-files/landing/js/jquery.mixitup-pagination.js", array('jquery'), false, true);
            wp_enqueue_script("mikado-one-mikado-demo-landing", get_home_url() . "/demo-files/landing/js/demo_landing_default.js",array('jquery'),false,true);
        }

	}

	add_action('wp_enqueue_scripts', 'mikado_one_mikado_scripts');
}

if(!function_exists('mikado_one_mikado_browser_specific_scripts')) {
	/**
	 * Function that loads browser specific scripts
	 */
	function mikado_one_mikado_browser_specific_scripts() {
		global $is_IE;

		//is ie?
		if ($is_IE) {
			wp_enqueue_script("html5", MIKADO_JS_ROOT . "/html5.js",array('jquery'),false,false);
		}
	}

	add_action('wp_enqueue_scripts', 'mikado_one_mikado_browser_specific_scripts');
}

if(!function_exists( 'mikado_one_mikado_woocommerce_assets' )) {
	/**
	 * Function that includes all necessary scripts for WooCommerce if installed
	 */
	function mikado_one_mikado_woocommerce_assets() {
		$mkd_options = mikado_one_mikado_return_global_options();;

		//is woocommerce installed?
		if(mikado_one_mikado_is_woocommerce_installed()) {
			if(mikado_one_mikado_load_woo_assets()) {
				//get woocommerce specific scripts
				wp_enqueue_script("mikado-one-mikado-woocommerce-script", MIKADO_JS_ROOT . "/woocommerce.js",array('jquery'),false,true);
				wp_enqueue_script("select2", MIKADO_JS_ROOT . "/select2.min.js",array('jquery'),false,true);

				//include theme's woocommerce styles
				wp_enqueue_style("mikado-one-mikado-woocommerce", MIKADO_CSS_ROOT . "/woocommerce.css");

				//is responsive option turned on?
				if($mkd_options['responsiveness'] == 'yes') {
					//include theme's woocommerce responsive styles
					wp_enqueue_style("mikado-one-mikado-woocommerce-responsive", MIKADO_CSS_ROOT . "/woocommerce_responsive.min.css");
				}
			}
		}
	}

	add_action('wp_enqueue_scripts', 'mikado_one_mikado_woocommerce_assets');
}

if(!function_exists( 'mikado_one_mikado_load_woo_assets' )) {
    /**
     * Function that checks whether WooCommerce assets needs to be loaded.
     *
     * @see mikado_one_mikado_is_ajax_enabled()
     * @see mikado_one_mikado_is_woocommerce_page()
     * @see mikado_one_mikado_has_woocommerce_shortcode()
     * @see mikado_one_mikado_has_woocommerce_widgets()
     * @return bool
     */

    function mikado_one_mikado_load_woo_assets() {
        return mikado_one_mikado_is_woocommerce_installed() && ( mikado_one_mikado_is_ajax_enabled() || mikado_one_mikado_is_woocommerce_page() ||
                                                   mikado_one_mikado_has_woocommerce_shortcode() || mikado_one_mikado_has_woocommerce_widgets());
    }
}



if(!function_exists( 'mikado_one_mikado_localize_no_ajax_pages' )) {
	/**
	 * Function that outputs no_ajax_obj javascript variable that is used default_dynamic.php.
	 * It is used for no ajax pages functionality
	 *
	 * Function hooks to wp_enqueue_scripts and uses wp_localize_script
	 *
	 * @see https://codex.wordpress.org/Function_Reference/wp_localize_script
	 *
	 * @uses mkd_get_posts_without_ajax()
	 * @uses mkd_get_pages_without_ajax()
	 * @uses mikado_one_mikado_get_wpml_pages_for_current_page()
	 * @uses mikado_one_mikado_get_woocommerce_pages()
	 *
	 * @version 0.1
	 */
	function mikado_one_mikado_localize_no_ajax_pages() {
		$mkd_options = mikado_one_mikado_return_global_options();;

		//is ajax enabled?
		if(mikado_one_mikado_is_ajax_enabled()) {
			$no_ajax_pages = array();

			//get posts that have ajax disabled and merge with main array
			$no_ajax_pages = array_merge($no_ajax_pages, mikado_one_mikado_get_objects_without_ajax());

			//is wpml installed?
			if(mikado_one_mikado_is_wpml_installed()) {
				//get translation pages for current page and merge with main array
				$no_ajax_pages = array_merge($no_ajax_pages, mikado_one_mikado_get_wpml_pages_for_current_page());
			}

			//is woocommerce installed?
			if(mikado_one_mikado_is_woocommerce_installed()) {
				//get all woocommerce pages and products and merge with main array
				$no_ajax_pages = array_merge($no_ajax_pages, mikado_one_mikado_get_woocommerce_pages());
			}

			//is buddy press installed?
			if(mikado_one_mikado_buddy_press_installed()) {
				//get all buddy press pages and merge with main array
				$no_ajax_pages = array_merge($no_ajax_pages, mikado_one_mikado_get_buddy_press_pages());
			}

			//do we have some internal pages that won't to be without ajax?
			if (isset($mkd_options['internal_no_ajax_links'])) {
				//get array of those pages
				$options_no_ajax_pages_array = explode(',', $mkd_options['internal_no_ajax_links']);

				if(is_array($options_no_ajax_pages_array) && count($options_no_ajax_pages_array)) {
					$no_ajax_pages = array_merge($no_ajax_pages, $options_no_ajax_pages_array);
				}
			}

			//add logout url to main array
			$no_ajax_pages[] = wp_specialchars_decode(wp_logout_url());

			//finally localize script so we can use it in default_dynamic
			wp_localize_script( 'mikado-one-mikado-default-dynamic', 'no_ajax_obj', array(
				'no_ajax_pages' => $no_ajax_pages
			));
		}
	}

	add_action('wp_enqueue_scripts', 'mikado_one_mikado_localize_no_ajax_pages');
}


if(!function_exists( 'mikado_one_mikado_get_woocommerce_pages' )) {
    /**
     * Function that returns all url woocommerce pages
     * @return array array of WooCommerce pages
     *
     * @version 0.1
     */
    function mikado_one_mikado_get_woocommerce_pages() {
        $woo_pages_array = array();

        if(mikado_one_mikado_is_woocommerce_installed()) {
            if(get_option('woocommerce_shop_page_id') != ''){ $woo_pages_array[] = get_permalink(get_option('woocommerce_shop_page_id')); }
			if(get_option('woocommerce_cart_page_id') != ''){ $woo_pages_array[] = get_permalink(get_option('woocommerce_cart_page_id')); }
			if(get_option('woocommerce_checkout_page_id') != ''){ $woo_pages_array[] = get_permalink(get_option('woocommerce_checkout_page_id')); }
			if(get_option('woocommerce_pay_page_id') != ''){ $woo_pages_array[] = get_permalink(get_option(' woocommerce_pay_page_id ')); }
			if(get_option('woocommerce_thanks_page_id') != ''){ $woo_pages_array[] = get_permalink(get_option(' woocommerce_thanks_page_id ')); }
			if(get_option('woocommerce_myaccount_page_id') != ''){ $woo_pages_array[] = get_permalink(get_option(' woocommerce_myaccount_page_id ')); }
			if(get_option('woocommerce_edit_address_page_id') != ''){ $woo_pages_array[] = get_permalink(get_option(' woocommerce_edit_address_page_id ')); }
			if(get_option('woocommerce_view_order_page_id') != ''){ $woo_pages_array[] = get_permalink(get_option(' woocommerce_view_order_page_id ')); }
			if(get_option('woocommerce_terms_page_id') != ''){ $woo_pages_array[] = get_permalink(get_option(' woocommerce_terms_page_id ')); }

            $woo_products = get_posts(array('post_type' => 'product','post_status' => 'publish', 'posts_per_page' => '-1') );

            foreach($woo_products as $product) {
                $woo_pages_array[] = get_permalink($product->ID);
            }
        }

        return $woo_pages_array;
    }
}

if ( ! function_exists( 'mikado_one_mikado_enqueue_editor_customizer_styles' ) ) {
	/**
	 * Enqueue supplemental block editor styles
	 */

	function mikado_one_mikado_enqueue_editor_customizer_styles() {
		$protocol = is_ssl() ? 'https:' : 'http:';
		//include default google font that theme is using
		$default_fonts_args          = array(
			'family' => urlencode( 'Open Sans:300,400,600,700' ),
			'subset' => urlencode( 'latin-ext' ),
		);
		$mikado_one_global_fonts = add_query_arg( $default_fonts_args, $protocol . '//fonts.googleapis.com/css' );
		wp_enqueue_style( 'mikado-one-editor-google-fonts', esc_url_raw( $mikado_one_global_fonts ) );

		wp_enqueue_style( 'mikado-one-editor-customizer-style', MIKADO_ROOT . '/mkdinc/admin/assets/css/editor-customizer-style.css' );
		wp_enqueue_style( 'mikado-one-editor-blocks-style', MIKADO_ROOT . '/mkdinc/admin/assets/css/editor-blocks-style.css' );
	}

	add_action( 'enqueue_block_editor_assets', 'mikado_one_mikado_enqueue_editor_customizer_styles' );
}

if ( ! function_exists( 'mikado_one_mikado_is_gutenberg_installed' ) ) {
	/**
	 * Function that checks if Gutenberg plugin installed
	 * @return bool
	 */
	function mikado_one_mikado_is_gutenberg_installed() {
		return function_exists( 'is_gutenberg_page' ) && is_gutenberg_page();
	}
}

if ( ! function_exists( 'mikado_one_mikado_is_wp_gutenberg_installed' ) ) {
	/**
	 * Function that checks if WordPress 5.x with Gutenberg editor installed
	 * @return bool
	 */
	function mikado_one_mikado_is_wp_gutenberg_installed() {
		return class_exists( 'WP_Block_Type' );
	}
}

