<?php

if ( ! function_exists( 'mikado_one_mikado_ajax_classes' ) ) {
	/**
	 * Function that adds classes on body for ajax transitions
	 */
	function mikado_one_mikado_ajax_classes( $classes ) {
		$mkd_options = mikado_one_mikado_return_global_options();;

		//init variables
		$mkd_animation = "";

		//is ajax set in session
		if ( isset( $_SESSION['mkd_animation'] ) ) {
			$mkd_animation = $_SESSION['mkd_animation'];
		}

		//is ajax animation turned off in options or in session?
		if ( ( $mkd_options['page_transitions'] === "0" ) && ( $mkd_animation == "no" ) ) {
			$classes[] = '';
		} //is up down animation type set?
		elseif ( $mkd_options['page_transitions'] === "1" && ( empty( $mkd_animation ) || ( $mkd_animation != "no" ) ) ) {
			$classes[] = 'ajax_updown';
			$classes[] = 'page_not_loaded';
		} //is fade animation type set?
		elseif ( $mkd_options['page_transitions'] === "2" && ( empty( $mkd_animation ) || ( $mkd_animation != "no" ) ) ) {
			$classes[] = 'ajax_fade';
			$classes[] = 'page_not_loaded';
		} //is up down fade animation type set?
		elseif ( $mkd_options['page_transitions'] === "3" && ( empty( $mkd_animation ) || ( $mkd_animation != "no" ) ) ) {
			$classes[] = 'ajax_updown_fade';
			$classes[] = 'page_not_loaded';
		} //is left / right animation type set?
		elseif ( $mkd_options['page_transitions'] === "4" && ( empty( $mkd_animation ) || ( $mkd_animation != "no" ) ) ) {
			$classes[] = 'ajax_leftright';
			$classes[] = 'page_not_loaded';
		} //is animation set only in session?
		elseif ( ! empty( $mkd_animation ) && $mkd_animation != "no" ) {
			$classes[] = 'page_not_loaded';
		} //animation is turned off both in options nad in session
		else {
			$classes[] = "";
		}

		return $classes;
	}

	add_filter( 'body_class', 'mikado_one_mikado_ajax_classes' );
}

if ( ! function_exists( 'mikado_one_mikado_boxed_class' ) ) {
	/**
	 * Function that adds classes on body for boxed layout
	 */
	function mikado_one_mikado_boxed_class( $classes ) {
		$mkd_options = mikado_one_mikado_return_global_options();;

		$transparent_content = false;
		if ( isset( $mkd_options['transparent_content'] ) && $mkd_options['transparent_content'] == 'yes' ) {
			$transparent_content = true;
		}

		//is boxed layout turned on?
		if ( isset( $mkd_options['boxed'] ) && $mkd_options['boxed'] == "yes" && ! $transparent_content ) {
			$classes[] = 'boxed';
		} else {
			$classes[] = "";
		}

		return $classes;
	}

	add_filter( 'body_class', 'mikado_one_mikado_boxed_class' );
}


if (!function_exists( 'mikado_one_mikado_theme_version_class' )) {
	/**
	 * Function that adds classes on body for version of theme
	 */
	function mikado_one_mikado_theme_version_class($classes) {
		$current_theme = wp_get_theme();

		//is child theme activated?
		if($current_theme->parent()) {
			//add child theme version
			$classes[] = 'mkd-child-theme-ver-'.$current_theme->get('Version');

			//get parent theme
			$current_theme = $current_theme->parent();
		}

		if($current_theme->exists() && $current_theme->get('Version') != "") {
			$classes[] = 'mkd-theme-ver-'.$current_theme->get('Version');
		}

		return $classes;
	}

	add_filter('body_class','mikado_one_mikado_theme_version_class');
}

if (!function_exists( 'mikado_one_mikado_vertical_menu_class' )) {
	/**
	 * Function that adds classes on body element for left menu area
	 */
	function mikado_one_mikado_vertical_menu_class($classes) {
		$mkd_options = mikado_one_mikado_return_global_options();;

		$enable_paspartu = false;
		if(isset($mkd_options['paspartu']) && $mkd_options['paspartu'] == 'yes'){
			$enable_paspartu = true;
		}

		//is left menu area turned on?
		if(isset($mkd_options['vertical_area']) && $mkd_options['vertical_area'] =='yes' && !$enable_paspartu) {
			$classes[] = 'vertical_menu_enabled';

			//left menu type class?
			if(isset($mkd_options['vertical_area_type']) && $mkd_options['vertical_area_type'] != '') {
				switch ($mkd_options['vertical_area_type']) {
					case 'hidden':
						$classes[] = ' vertical_menu_hidden';

						if(isset($mkd_options['vertical_logo_bottom']) && $mkd_options['vertical_logo_bottom'] !== '') {
							$classes[] = 'vertical_menu_hidden_with_logo';
						}
						break;
				}
			}

			if(isset($mkd_options['vertical_area_position']) && $mkd_options['vertical_area_position'] == 'right') {
				$classes[] = ' vertical_menu_right';
			}

			if(isset($mkd_options['vertical_area_width']) && $mkd_options['vertical_area_width']=='width_350'){
				$classes[] = ' vertical_menu_width_350';
			}
			elseif(isset($mkd_options['vertical_area_width']) && $mkd_options['vertical_area_width']=='width_400'){
				$classes[] = ' vertical_menu_width_400';
			}
			else{
				$classes[] = ' vertical_menu_width_290';
			}
		}

		//get current page id
		$id = mikado_one_mikado_get_page_id();

		if(isset($mkd_options['vertical_area_transparency']) && $mkd_options['vertical_area_transparency'] =='yes' && get_post_meta($id, "mkd_page_vertical_area_transparency", true) != "no" && isset($mkd_options['vertical_area_dropdown_showing']) && $mkd_options['vertical_area_dropdown_showing'] != "side"){
			$classes[] = ' vertical_menu_transparency vertical_menu_transparency_on';
		}else if(get_post_meta($id, "mkd_page_vertical_area_transparency", true) == "yes" && isset($mkd_options['vertical_area_dropdown_showing']) && $mkd_options['vertical_area_dropdown_showing'] != "side"){
			$classes[] = ' vertical_menu_transparency vertical_menu_transparency_on';
		}
		return $classes;
	}

	add_filter('body_class','mikado_one_mikado_vertical_menu_class');
}


if (!function_exists( 'mikado_one_mikado_smooth_scroll_class' )) {
	/**
	 * Function that adds classes on body for smooth scroll
	 */
	function mikado_one_mikado_smooth_scroll_class($classes) {
		$mkd_options = mikado_one_mikado_return_global_options();;

		//is smooth_scroll turned on?
		if(isset($mkd_options['smooth_scroll']) && $mkd_options['smooth_scroll'] == "yes") {
			$classes[] = 'smooth_scroll';
		} else {
			$classes[] ="";
		}

		return $classes;
	}

	add_filter('body_class','mikado_one_mikado_smooth_scroll_class');
}


if (!function_exists( 'mikado_one_mikado_elements_animation_on_touch_class' )) {
	/**
	 * Function that adds classes on body when touch is disabled on touch devices
	 * @param $classes array classes array
	 * @return array array with added classes
	 */
	function mikado_one_mikado_elements_animation_on_touch_class($classes) {
		$mkd_options = mikado_one_mikado_return_global_options();;

		//check if current client is on mobile
		$isMobile = (bool)preg_match('#\b(ip(hone|od|ad)|android|opera m(ob|in)i|windows (phone|ce)|blackberry|tablet'.
		                             '|s(ymbian|eries60|amsung)|p(laybook|alm|rofile/midp|laystation portable)|nokia|fennec|htc[\-_]'.
		                             '|mobile|up\.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\b#i', getenv('HTTP_USER_AGENT') );

		//are animations turned off on touch and client is on mobile?
		if(isset($mkd_options['elements_animation_on_touch']) && $mkd_options['elements_animation_on_touch'] == "no" && $isMobile == true) {
			$classes[] = 'no_animation_on_touch';
		} else {
			$classes[] ="";
		}

		return $classes;
	}

	add_filter('body_class','mikado_one_mikado_elements_animation_on_touch_class');
}

if(!function_exists( 'mikado_one_mikado_side_menu_body_class' )) {
	/**
	 * Function that adds side area classes to body.
	 * Opening animations and initial styling are working based on classes set here.
	 * @param $classes array of body classes
	 * @return array array with side area body classes added
	 */
	function mikado_one_mikado_side_menu_body_class($classes) {
		$mkd_options = mikado_one_mikado_return_global_options();;

		if(isset($mkd_options['enable_side_area']) && $mkd_options['enable_side_area'] == 'yes') {
			if(isset($mkd_options['side_area_type']) && $mkd_options['side_area_type'] == 'side_menu_slide_from_right') {
				$classes[] = 'side_menu_slide_from_right';
			}
			else if(isset($mkd_options['side_area_type']) && $mkd_options['side_area_type'] == 'side_menu_slide_with_content') {
				$classes[] = 'side_menu_slide_with_content';
			}
		}

		return $classes;
	}

	add_filter('body_class', 'mikado_one_mikado_side_menu_body_class');
}

if(!function_exists( 'mikado_one_mikado_paspartu_body_class' )) {
	/**
	 * Function that adds side area classes to body.
	 * Opening animations and initial styling are working based on classes set here.
	 * @param $classes array of body classes
	 * @return array array with side area body classes added
	 */
	function mikado_one_mikado_paspartu_body_class($classes) {
		$mkd_options = mikado_one_mikado_return_global_options();;

		if(isset($mkd_options['paspartu']) && $mkd_options['paspartu'] == 'yes') {
			$classes[] = 'paspartu_enabled';
		}

		return $classes;
	}

	add_filter('body_class', 'mikado_one_mikado_paspartu_body_class');
}

if(!function_exists( 'mikado_one_mikado_transparent_content_body_class' )) {
	/**
	 * Function that adds transparent content class to body.
	 * @param $classes array of body classes
	 * @return array with transparent content body class added
	 */
	function mikado_one_mikado_transparent_content_body_class($classes) {
		$mkd_options = mikado_one_mikado_return_global_options();;

		if(isset($mkd_options['transparent_content']) && $mkd_options['transparent_content'] == 'yes') {
			$classes[] = 'transparent_content';
		}

		return $classes;
	}

	add_filter('body_class', 'mikado_one_mikado_transparent_content_body_class');
}


if(!function_exists( 'mikado_one_mikado_wp_title_text' )) {
	/**
	 * Function that sets page's title. Hooks to wp_title filter
	 * @param $title string current page title
	 * @param $sep string title separator
	 * @return string changed title text if SEO plugins aren't installed
	 * @version 0.2
	 */
	function mikado_one_mikado_wp_title_text($title, $sep) {
		$mkd_options = mikado_one_mikado_return_global_options();;

		//is SEO plugin installed?
		if(mikado_one_mikado_seo_plugin_installed()) {
			//don't do anything, seo plugin will take care of it
		} else {
			//get current post id
			$id = mikado_one_mikado_get_page_id();
			$sep = ' | ';
			$title_prefix = get_bloginfo('name');
			$title_suffix = '';

			//is WooCommerce installed and is current page shop page?
			if(mikado_one_mikado_is_woocommerce_installed() && mikado_one_mikado_is_woocommerce_shop()) {
				//get shop page id
				$id = mikado_one_mikado_get_woo_shop_page_id();
			}


			if(function_exists('_wp_render_title_tag')) {
				//set unchanged title variable so we can use it later
				$title_array = explode($sep, $title);
				$unchanged_title = array_shift($title_array);
			} else {
				//set unchanged title variable so we can use it later
				$unchanged_title = $title;
			}

			//is mkd seo enabled?
			if(isset($mkd_options['disable_mkd_seo']) && $mkd_options['disable_mkd_seo'] !== 'yes') {
				//get current post seo title
				$seo_title = esc_attr(get_post_meta($id, "seo_title", true));
				//is current post seo title set?
				if($seo_title !== '') {
					$title_suffix = $seo_title;
				}
			}

			//title suffix is empty, which means that it wasn't set by mkd seo
			if(empty($title_suffix)) {
				//if current page is front page append site description, else take original title string
				$title_suffix = is_front_page() ? get_bloginfo('description') : $unchanged_title;
			}

			//concatenate title string
			$title  = $title_prefix.$sep.$title_suffix;

			//return generated title string
			return $title;
		}
	}

	add_filter('wp_title', 'mikado_one_mikado_wp_title_text', 10, 2);
}
