<?php

if(!function_exists( 'mikado_one_mikado_get_native_fonts_list' )) {
	/**
	 * Function that defines array of native fonts.
	 * @return array array of native fonts
	 */
	function mikado_one_mikado_get_native_fonts_list(){

		return apply_filters( 'mikado_one_mikado_filter_get_native_fonts_list', array(
			'Arial',
			'Arial Black',
			'Comic Sans MS',
			'Courier New',
			'Georgia',
			'Impact',
			'Lucida Console',
			'Lucida Sans Unicode',
			'Palatino Linotype',
			'Tahoma',
			'Times New Roman',
			'Trebuchet MS',
			'Verdana'
		) );

	}
}

if(!function_exists( 'mikado_one_mikado_get_native_fonts_array' )) {
	/**
	 * Function that formats native font list so it can be used in global fonts array in options
	 * @return array formatted array of fonts
	 */
	function mikado_one_mikado_get_native_fonts_array(){
		$native_fonts_list = mikado_one_mikado_get_native_fonts_list();
		$native_font_index = 0;
		$native_fonts_array = array();
		foreach($native_fonts_list as $native_font){
			$native_fonts_array[$native_font_index] = array('family' => $native_font);
			$native_font_index++;
		}

		return $native_fonts_array;
	}
}

if(!function_exists( 'mikado_one_mikado_is_native_font' )) {
	/**
	 * Function that checks if given font is native font
	 * @param $font_family string
	 * @return bool
	 */
	function mikado_one_mikado_is_native_font($font_family) {
		return  in_array(str_replace('+', ' ', $font_family), mikado_one_mikado_get_native_fonts_list());
	}
}


if(!function_exists( 'mikado_one_merge_fonts' )) {
	/**
	 * Function that merge google and native fonts
	 * Hooks to admin init hook
	 * @return array merged array of native fonts and Google fonts
	 */
	function mikado_one_merge_fonts() {
		global $fontArrays;

		$native_fonts = mikado_one_mikado_get_native_fonts_array();

		if(!is_array($fontArrays) || count($fontArrays) === 0){
			$fontArrays = array();
		}

		if(is_array($native_fonts) && count($native_fonts)){
			$fontArrays = array_merge($native_fonts, $fontArrays);
		}
	}

	add_action('admin_init', 'mikado_one_merge_fonts');
}
