<?php


if(!function_exists( 'mikado_one_mikado_has_shortcode' )) {
	/**
	 * Function that checks whether shortcode exists on current page / post
	 * @param string shortcode to find
	 * @param string content to check. If isn't passed current post content will be used
	 * @return bool whether content has shortcode or not
	 */
	function mikado_one_mikado_has_shortcode($shortcode, $content = '') {
		$has_shortcode = false;

		if ($shortcode) {
			//if content variable isn't past
			if($content == '') {
				//take content from current post
				$page_id = mikado_one_mikado_get_page_id();
				if(!empty($page_id)) {
					$current_post = get_post($page_id);

					if(is_object($current_post) && property_exists($current_post, 'post_content')) {
						$content = $current_post->post_content;
					}

				}
			}

			//does content has shortcode added?
			if (stripos($content, '[' . $shortcode) !== false) {
				$has_shortcode = true;
			}
		}

		return $has_shortcode;
	}
}


if(!function_exists( 'mikado_one_mikado_has_shortcodes' )) {
	/**
	 * Function that check that at least one of given shortcodes exists in current page content
	 * @param $shortcodes array array of shortcodes strings.
	 * @return bool whether at least one shortcode exists on current page or not
	 */
	function mikado_one_mikado_has_shortcodes($shortcodes) {
		if(is_array($shortcodes) && count($shortcodes)) {
			foreach ($shortcodes as $shortcode) {
				$has_shortcode = mikado_one_mikado_has_shortcode($shortcode);

				if($has_shortcode) {
					return true;
				}
			}
		}

		return false;
	}
}

if(!function_exists('mkd_has_mkd_slider_shortcode')) {
	/**
	 * Function that checks if mkd slider shortcode is added to proper custom field
	 * @return bool
	 */
	function mkd_has_mkd_slider_shortcode() {
		$page_id = mikado_one_mikado_get_page_id();

		if($page_id) {
			$slider_field = esc_attr(get_post_meta($page_id, 'mkd_revolution-slider', true));

			if($slider_field) {
				return true;
			}
		}

		return false;
	}
}

if(!function_exists( 'mikado_one_mikado_load_slider_assets' )) {
	/**
	 * Function that checks if mkd slider assets should be loaded. It checks if ajax is enabled or if slider
	 * shortcode is added to custom field
	 *
	 * @see mikado_one_mikado_is_ajax_enabled()
	 * @see mkd_has_mkd_slider_shortcode()
	 *
	 * @return bool
	 */
	function mikado_one_mikado_load_slider_assets() {
		return mikado_one_mikado_core_installed() && ( mikado_one_mikado_is_ajax_enabled() || mkd_has_mkd_slider_shortcode());
	}
}

if(!function_exists( 'mikado_one_mikado_load_portfolio_assets' )) {
	/**
	 * Function that checks if portfolio assets should be loaded.
	 * Returns true if ajax is enabled or portfolio shortcodes exists on page
	 * or if current page is portfolio single page
	 *
	 * @see mikado_one_mikado_is_ajax_enabled()
	 * @see mkd_has_portfolio_shortcodes()
	 * @see is_singular()
	 *
	 * @return bool
	 */
	function mikado_one_mikado_load_portfolio_assets() {
		return mikado_one_mikado_core_installed() && ( mikado_one_mikado_is_ajax_enabled() || mkd_has_portfolio_shortcodes() || is_singular
				('portfolio_page'));
	}
}

if(!function_exists('mkd_has_portfolio_shortcodes')) {
	/**
	 * Function that checks if at least one portfolio shortcode exists on current page
	 *
	 * @see mikado_one_mikado_has_shortcodes()
	 * @return bool
	 */
	function mkd_has_portfolio_shortcodes() {
		$shortcodes = array(
			'no_portfolio_list',
			'no_portfolio_slider'
		);

		return mikado_one_mikado_has_shortcodes($shortcodes);
	}
}

if(!function_exists( 'mikado_one_mikado_load_testimonials_assets' )) {
	/**
	 * Function that checks if testimonials assets should be loaded.
	 * It checks if ajax is enabled or if testimonials shortcode exists on a page
	 *
	 * @return bool
	 *
	 * @see mikado_one_mikado_is_ajax_enabled()
	 * @see mikado_one_mikado_has_shortcode()
	 */
	function mikado_one_mikado_load_testimonials_assets() {
		return mikado_one_mikado_core_installed() && ( mikado_one_mikado_is_ajax_enabled() || mikado_one_mikado_has_shortcode('no_testimonials'));
	}
}

if(!function_exists( 'mikado_one_mikado_load_carousel_assets' )) {
	/**
	 * Function that checks if carousel assets should be loaded.
	 * It checks if ajax is enabled or if carousel shortcode exists on a page
	 *
	 * @return bool
	 *
	 * @see mikado_one_mikado_is_ajax_enabled()
	 * @see mikado_one_mikado_has_shortcode()
	 */
	function mikado_one_mikado_load_carousel_assets() {
		return mikado_one_mikado_core_installed() && ( mikado_one_mikado_is_ajax_enabled() || mikado_one_mikado_has_shortcode('no_carousel'));
	}
}

