var $j = jQuery.noConflict();

$j(document).ready(function() {
	"use strict";

	initPortfolioBlurEffect();
	initPortfolioLoadMore();
});

$j(window).load(function() {
	"use strict";

	initPortfolio();
	initPortfolioZIndex();
	initPortfolioMasonry();
	initPortfolioMasonryFilter();
	initPortfolioSlider();
});

/*
 **	Init Portfolio list and Portfolio Filter
 */
function initPortfolio(){
	"use strict";

	if($j('.projects_holder_outer:not(.masonry_with_space)').length){
		$j('.projects_holder_outer').each(function(){

			$j('.filter_holder .filter').on('click',function(){
				var $this = $j(this).text();
				var dropLabels = $j('.filter_holder').find('.label span');
				dropLabels.each(function(){
					$j(this).text($this);
				});
			});

			var currentPortfolio = $j(this).find('.projects_holder');
            var acc;

			currentPortfolio.mixitup({
				showOnLoad: 'all',
				transitionSpeed: 600,
				minHeight: 150,
				onMixLoad: function(){
					$j('.projects_holder').addClass('hideItems');
					$j('.projects_holder article').css('visibility','visible');

					if(currentPortfolio.hasClass('portfolio_one_by_one')) {
						currentPortfolio.find('article').each(function(l) {
							var currentPortfolioItem = $j(this);
							if($j('.vertical_split_slider').length){
								acc = 0;
							}else{
								acc = -150;
							}

							setTimeout(function() {
								currentPortfolioItem.addClass('show');
							}, 100*l);
						});
					}
				}
			});
		});
	}
}

/*
 **	Init z-index for portfolio items
 */
function initPortfolioZIndex(){
	"use strict";

	if($j('.projects_holder_outer.portfolio_no_space').length){
		$j('.no_space.hover_text article').each(function(i){
			$j(this).css('z-index', i +10);
		});
	}
}

function initPortfolioMasonry(){
	"use strict";

	if($j('.projects_masonry_holder, .masonry_with_space').length){

		$j('.projects_masonry_holder, .masonry_with_space .projects_holder').each(function(){
			var $window = jQuery(window);
			var $this = $j(this);
			$this.waitForImages(function(){
				$this.animate({opacity:1});
				if($j('.projects_masonry_holder').length){
					resizeMasonry($this);
				}
				$this.isotope({
					itemSelector: '.portfolio_masonry_item, .masonry_with_space .mix',
					layoutMode: 'masonry'
				});

				if($j('.projects_masonry_holder').length){
					setPortfolioMasZIndex();
					$window.resize(function() {resizeMasonry($this); setPortfolioMasZIndex();});
				}
			});
		});
	}
}

var portfolio_width;
function resizeMasonry(container){
	"use strict";

	var $window = jQuery(window);

	if($j('.full_width').length){
		if($j('body').hasClass('vertical_menu_enabled') && $window_width > 1000){
			if($j('body').hasClass('vertical_menu_hidden')){
				portfolio_width = $window.innerWidth() - 40; // 40 is width of side hidden menu
			} else {
				portfolio_width = $window.innerWidth() -  $j('.vertical_menu_area').innerWidth();
			}
		} else {
			portfolio_width = $window.innerWidth();
		}

	}else{
		var closest_container =  container.closest('.container_inner');
		if(closest_container.has('.column_inner').length) {
			portfolio_width =  container.closest('.column_inner').innerWidth();
		} else {
			portfolio_width = closest_container.innerWidth();
		}
	}

	container.width(portfolio_width);

	var $cols = 5;
	if(portfolio_width > 1600){
		$cols = 5;
	}else if(portfolio_width <= 1600 && portfolio_width > 1300){
		$cols = 4;
	}else if(portfolio_width <= 1300 && portfolio_width > 1000){
		$cols = 3;
	}else if(portfolio_width <= 1000 && portfolio_width > 480){
		$cols = 2;
	}else if(portfolio_width <= 480){
		$cols = 1;
	}

	var largeItemHeight;
	if(container.find('article[class*="default"]:first img').height()){
		largeItemHeight = container.find('article[class*="default"]:first img').height();
	}else if(container.find('article[class*="large_width"]:not(.large_width_height):first img').height()){
		largeItemHeight = container.find('article[class*="large_width"]:not(.large_width_height):first img').height();
	}else{
		largeItemHeight = (container.find('article[class*="large_width_height"]:first img').height()) ? (container.find('article[class*="large_width_height"]:first img').height())/2 : (container.find('article[class*="large_height"]:first img').height())/2;
	}
	var double = ($window.innerWidth() > 480) ? 2 : 1 ;
	container.find('article[class*="large_width_height"] img, article[class*="large_height"] img').css('height',(largeItemHeight*double));

	container.isotope({
		masonry: { columnWidth: portfolio_width / parseInt($cols)}
	});
}

function initPortfolioMasonryFilter(){
	"use strict";

	var portfolioIsotopeAnimation = null;
	$j('.filter:first').addClass('current');
	$j('.filter').on('click',function(){

		clearTimeout(portfolioIsotopeAnimation);
		$j('.isotope, .isotope .isotope-item').css('transition-duration','0.8s');
		portfolioIsotopeAnimation = setTimeout(function(){  $j('.isotope, .isotope .isotope-item').css('transition-duration','0s'); },700);

		var selector = $j(this).attr('data-filter');
		$j('.projects_masonry_holder, .masonry_with_space .projects_holder').isotope({ filter: selector });

		$j(".filter").removeClass("current");
		$j(this).addClass("current");

		setTimeout(setPortfolioMasZIndex(),700);

		return false;
	});

}

function setPortfolioMasZIndex(){
	"use strict";

	var $elemXPos = {};
	var $elemZIndex = {};

	$j('.projects_masonry_holder article').each(function(){
		$elemXPos[$j(this).index()] = getPortfolioXPos($j(this).css('left'));
	});

	var $elemXPosArray = $j.map($elemXPos, function (value) { return value; });
	$elemXPosArray = cleanPortfolioMasXArray($elemXPosArray);
	$elemXPosArray.sort(function(x,y){return x-y;});

	for(var i = 0; i < $elemXPosArray.length; i++){
		$elemZIndex[$elemXPosArray[i]] = i*10;
	}

	$j.each($elemXPos,function(key,val){

		var $zi;
		var $bgd = val;
		$j.each($elemZIndex,function(key,val){
			if($bgd == key) {
				$zi = val;
			}
		});

		$j('.projects_masonry_holder article:eq('+key+')').css('z-index',$zi);
	});
}

function getPortfolioXPos(css) {
	//return css.substr(7, css.length - 8).split(', ')[4];
	return css.substr(0, css.length - 2);
}

function cleanPortfolioMasXArray($elemXPosArray) {
	var i;
	var length = $elemXPosArray.length;
	var $elemXPosOutArray = [];
	var tmp = {};

	for (i = 0; i < length; i++) {
		tmp[$elemXPosArray[i]] = 0;
	}
	tmp.forEach(function (i) {
        $elemXPosOutArray.push(i);
    });

	return $elemXPosOutArray;
}

/*
 **	Load more portfolios
 */
function initPortfolioLoadMore(){
	"use strict";

	var i = 1;

	$j('.load_more a').on('click', function(e)  {
		e.preventDefault();

		var link = $j(this).attr('href');
		var $content = '.projects_holder';
		var $anchor = '.portfolio_paging .load_more a';
		var $elem = '.mix';
		var $next_href = $j($anchor).attr('href'); // Get URL for the next set of posts
		var filler_num = $j('.projects_holder .filler').length;
		var load_more_holder = $j('.portfolio_paging');
		var loading_holder   = $j('.portfolio_paging_loading');

		load_more_holder.hide();
		loading_holder.show();
		$j.get(link+'', function(data){
			$j('.projects_holder .filler').slice(-filler_num).remove();

			var $new_content = $j($content, data).wrapInner('').html(); // Grab just the content
			$next_href = $j($anchor, data).attr('href'); // Get the new href

			$j($content, data).waitForImages(function() {

				$j('article.mix:last').after($new_content); // Append the new content

				$j('.projects_holder article').css('visibility','visible');
                $j('article:not(.show)').each(function(l){
                    $j(this).addClass('show');
                });

				if($j('.masonry_with_space').length){
					$j('.masonry_with_space .projects_holder').isotope('reloadItems').isotope();
				}else{
					var min_height = $j('article.mix:first').height();
					$j('article.mix').css('min-height',min_height);
					$j('.projects_holder').mixitup('remix','all');
				}

                setTimeout(function() { //wait for portfolios to rearange and call necesary functions
                    prettyPhoto();
                    initParallax(); //reinitialize parallax and set new image positions
                }, 800); //800 is arbitrarily

				if($j('.load_more').data('rel') > i) {
					$j('.load_more a').attr('href', $next_href); // Change the next URL
				} else {
					$j('.load_more').remove();
				}
				$j('.projects_holder .portfolio_paging:last').remove(); // Remove the original navigation
				$j('article.mix').css('min-height',0);
				load_more_holder.show();
				loading_holder.hide();
			});
		});
		i++;
	});
}

/*
 **	Portfolio blur effect
 */

function initPortfolioBlurEffect(){
	"use strict";

	var  $projectItemHolder = $j('.prominent_blur_hover');

	$projectItemHolder .on('mouseenter', function( event ) {
		$projectItemHolder.addClass('active');
		$projectItemHolder.not($j(this)).removeClass('active').addClass('blur');
	});

	$projectItemHolder .on('mouseleave', function( event ) {
		$projectItemHolder.removeClass('blur');
		$projectItemHolder.removeClass('active');

	});
}

/*
 ** Init Portfolio Slider
 */
function initPortfolioSlider(){
	"use strict";

	if($j('.portfolio_slider').length){

		$j('.portfolio_slider').each(function(){
			var maxItems = ($j(this).parents('.grid_section').length == 1) ? 3 : 'auto';
			var itemWidth = ($j(this).parents('.grid_section').length == 1) ? 353 : 500;

			$j('.portfolio_slides').carouFredSel({
				circular: true,
				responsive: true,
				scroll: 1,
				prev : {
					button : function() {
						return $j(this).parent().siblings('.caroufredsel-direction-nav').find('#caroufredsel-prev');
					}
				},
				next : {
					button : function() {
						return $j(this).parent().siblings('.caroufredsel-direction-nav').find('#caroufredsel-next');
					}
				},
				items: {
					width: itemWidth,
					visible: {
						min: 1,
						max: maxItems
					}
				},
				auto: false,
				mousewheel: false,
				swipe: {
					onMouse: true,
					onTouch: true
				}
			}).animate({'opacity': 1},1000);
		});

		calculateHeights();

		$j('.portfolio_slider .flex-direction-nav a').on('click',function(e){
			e.preventDefault();
			e.stopImmediatePropagation();
			e.stopPropagation();
		});
	}
}