var $j = jQuery.noConflict();

$j(document).ready(function() {
	initMikadoSlider();
	initSliderHeaderStylesDisable();
});

$j(window).scroll(function() {
	initSliderHeaderStylesDisable();
});

function initSliderHeaderStylesDisable() {
	//set control class for Mikado Slider in order to change header style
	if($j('.mkd_slider .carousel').length) {
		if($j('.carousel').height() < $scroll){
			$j('.carousel').addClass('disable_slider_header_style_changing');
		}else{
			$j('.carousel').removeClass('disable_slider_header_style_changing');
			checkSliderForHeaderStyle($j('.mkd_slider .carousel .active'),$j('.mkd_slider .carousel').hasClass('header_effect'));
		}
	}
}

function initMikadoSlider(){
	"use strict";

	var image_regex = /url\(["']?([^'")]+)['"]?\)/;
	default_header_style = "";
	if($j('header.page_header').hasClass('light')){ default_header_style = 'light';}
	if($j('header.page_header').hasClass('dark')){ default_header_style = 'dark';}

	if($j('.carousel').length){
		$j('.carousel').each(function(){
			var $this = $j(this);
			var mobile_header = $window_width < 1000 ? $j('header.page_header').height() : 0;
			var header_height_add_for_paspartu = $window_width > 1000 && !$j('header.page_header').hasClass('transparent') ? $j('header.page_header').height() : 0;
			var paspartu_amount_with_top_bottom = $j('.paspartu_outer:not(.disable_top_paspartu):not(.paspartu_on_bottom_slider)').length > 0 ? Math.round($window_width*paspartu_width*2 + header_height_add_for_paspartu) : 0; // paspartu_width * 2 times top and bottom paspartu
			var paspartu_amount_with_bottom = $j('.paspartu_outer.paspartu_on_bottom_slider').length > 0 ? Math.round($window_width*paspartu_width) : 0;
			var slider_graphic_coefficient;
			var slider_title_coefficient;
			var slider_subtitle_coefficient;
			var slider_text_coefficient;
			var slider_button_coefficient;

			var responsive_breakpoint_set = [1600,1200,900,650,500,320];
			if($this.data('mkd_responsive_breakpoints')){
				if($this.data('mkd_responsive_breakpoints') == 'set2'){
					responsive_breakpoint_set = [1600,1300,1000,768,567,320];
				}
			}

			var coefficients_graphic_array = $this.data('mkd_responsive_graphic_coefficients').split(',');
			var coefficients_title_array = $this.data('mkd_responsive_title_coefficients').split(',');
			var coefficients_subtitle_array = $this.data('mkd_responsive_subtitle_coefficients').split(',');
			var coefficients_text_array = $this.data('mkd_responsive_text_coefficients').split(',');
			var coefficients_button_array = $this.data('mkd_responsive_button_coefficients').split(',');

			//calculate heights for slider holder and slide item, depending on size, but only if slider is set to be responsive and not full screen
			function setSliderHeight($this, $def_height){
				var slider_height = $def_height;
				if($window_width > responsive_breakpoint_set[0]){
					slider_height = $def_height;
				}else if($window_width > responsive_breakpoint_set[1]){
					slider_height = $def_height * 0.75;
				}else if($window_width > responsive_breakpoint_set[2]){
					slider_height = $def_height * 0.6;
				}else if($window_width > responsive_breakpoint_set[3]){
					slider_height = $def_height * 0.55;
				}else if($window_width <= responsive_breakpoint_set[3]){
					slider_height = $def_height * 0.45;
				}

				$this.css({'height': (slider_height) + 'px'});
				$this.find('.mkd_slider_preloader').css({'height': (slider_height) + 'px'});
				$this.find('.mkd_slider_preloader .ajax_loader').css({'display': 'block'});
				$this.find('.item').css({'height': (slider_height) + 'px'});
			}

			function resetSliderHeight($def_height){
				$this.css({'height': ($def_height) + 'px'});
				$this.find('.mkd_slider_preloader').css({'height': ($def_height) + 'px'});
				$this.find('.mkd_slider_preloader .ajax_loader').css({'display': 'block'});
				$this.find('.item').css({'height': ($def_height) + 'px'});
			}

			function setSliderInitialElementsSize($item,i){
				window["slider_graphic_" + i] = [];
				window["slider_title_" + i] = [];
				window["slider_subtitle_" + i] = [];
				window["slider_text_" + i] = [];
				window["slider_button1_" + i] = [];
                window["slider_button2_" + i] = [];
				window["slider_top_separator_" + i] = [];
				window["slider_bottom_separator_" + i] = [];

				//graphic size
				window["slider_graphic_" + i].push(parseFloat($item.find('.thumb img').data("width")));

				// font-size (0)
				window["slider_title_" + i].push(parseFloat($item.find('.mkd_slide_title').css("font-size")));
				window["slider_subtitle_" + i].push(parseFloat($item.find('.mkd_slide_subtitle').css("font-size")));
				window["slider_text_" + i].push(parseFloat($item.find('.mkd_slide_text').css("font-size")));
                window["slider_button1_" + i].push(parseFloat($item.find('.qbutton:eq(0)').css("font-size")));
                window["slider_button2_" + i].push(parseFloat($item.find('.qbutton:eq(1)').css("font-size")));

				// line-height (1)
				window["slider_title_" + i].push(parseFloat($item.find('.mkd_slide_title').css("line-height")));
				window["slider_subtitle_" + i].push(parseFloat($item.find('.mkd_slide_subtitle').css("line-height")));
				window["slider_text_" + i].push(parseFloat($item.find('.mkd_slide_text').css("line-height")));
                window["slider_button1_" + i].push(parseFloat($item.find('.qbutton:eq(0)').css("line-height")));
                window["slider_button2_" + i].push(parseFloat($item.find('.qbutton:eq(1)').css("line-height")));

				// letter-spacing (2)
				window["slider_title_" + i].push(parseFloat($item.find('.mkd_slide_title').css("letter-spacing")));
				window["slider_subtitle_" + i].push(parseFloat($item.find('.mkd_slide_subtitle').css("letter-spacing")));
				window["slider_text_" + i].push(parseFloat($item.find('.mkd_slide_text').css("letter-spacing")));
                window["slider_button1_" + i].push(parseFloat($item.find('.qbutton:eq(0)').css("letter-spacing")));
                window["slider_button2_" + i].push(parseFloat($item.find('.qbutton:eq(1)').css("letter-spacing")));

				// margin-bottom (3)
				window["slider_title_" + i].push(parseFloat($item.find('.mkd_slide_title').css("margin-bottom")));
				window["slider_subtitle_" + i].push(parseFloat($item.find('.mkd_slide_subtitle').css("margin-bottom")));

				// slider_button height(3), width(4), padding(5)
                window["slider_button1_" + i].push(parseFloat($item.find('.qbutton:eq(0)').css("height")));
                window["slider_button2_" + i].push(parseFloat($item.find('.qbutton:eq(1)').css("height")));
                if(parseFloat($item.find('.qbutton:eq(0)').css("width")) != 0){
                    window["slider_button1_" + i].push(parseFloat($item.find('.qbutton:eq(0)').css("width")));
                }else{
                    window["slider_button1_" + i].push(0);
                }
                if(parseFloat($item.find('.qbutton:eq(1)').css("width")) != 0){
                    window["slider_button2_" + i].push(parseFloat($item.find('.qbutton:eq(1)').css("width")));
                }else{
                    window["slider_button2_" + i].push(0);
                }
                window["slider_button1_" + i].push(parseFloat($item.find('.qbutton:eq(0)').css("padding-left")));
                window["slider_button2_" + i].push(parseFloat($item.find('.qbutton:eq(1)').css("padding-left")));

				// margin separator top margin top(0), margin bottom(1)
				window["slider_top_separator_" + i].push(parseFloat($item.find('.separator_top').css("margin-top")));
				window["slider_top_separator_" + i].push(parseFloat($item.find('.separator_top').css("margin-bottom")));

				// margin separator bottom margin top(0), margin bottom(1)
				window["slider_bottom_separator_" + i].push(parseFloat($item.find('.separator_bottom').css("margin-top")));
				window["slider_bottom_separator_" + i].push(parseFloat($item.find('.separator_bottom').css("margin-bottom")));
			}

			//calculate size for slider title, subtitle and text, depending on window size
			function setSliderElementsSize($item,i){

				if($window_width > responsive_breakpoint_set[0]) {
					slider_graphic_coefficient = coefficients_graphic_array[0];
					slider_title_coefficient = coefficients_title_array[0];
					slider_subtitle_coefficient = coefficients_subtitle_array[0];
					slider_text_coefficient = coefficients_text_array[0];
					slider_button_coefficient = coefficients_button_array[0];
				}else if($window_width > responsive_breakpoint_set[1]){
					slider_graphic_coefficient = coefficients_graphic_array[1];
					slider_title_coefficient = coefficients_title_array[1];
					slider_subtitle_coefficient = coefficients_subtitle_array[1];
					slider_text_coefficient = coefficients_text_array[1];
					slider_button_coefficient = coefficients_button_array[1];
				}else if($window_width > responsive_breakpoint_set[2]){
					slider_graphic_coefficient = coefficients_graphic_array[2];
					slider_title_coefficient = coefficients_title_array[2];
					slider_subtitle_coefficient = coefficients_subtitle_array[2];
					slider_text_coefficient = coefficients_text_array[2];
					slider_button_coefficient = coefficients_button_array[2];
				}else if($window_width > responsive_breakpoint_set[3]){
					slider_graphic_coefficient = coefficients_graphic_array[3];
					slider_title_coefficient = coefficients_title_array[3];
					slider_subtitle_coefficient = coefficients_subtitle_array[3];
					slider_text_coefficient = coefficients_text_array[3];
					slider_button_coefficient = coefficients_button_array[3];
				}else if ($window_width > responsive_breakpoint_set[4]) {
					slider_graphic_coefficient = coefficients_graphic_array[4];
					slider_title_coefficient = coefficients_title_array[4];
					slider_subtitle_coefficient = coefficients_subtitle_array[4];
					slider_text_coefficient = coefficients_text_array[4];
					slider_button_coefficient = coefficients_button_array[4];
				}else if ($window_width > responsive_breakpoint_set[5]){
					slider_graphic_coefficient = coefficients_graphic_array[5];
					slider_title_coefficient = coefficients_title_array[5];
					slider_subtitle_coefficient = coefficients_subtitle_array[5];
					slider_text_coefficient = coefficients_text_array[5];
					slider_button_coefficient = coefficients_button_array[5];
				}
				else{
					slider_graphic_coefficient = coefficients_graphic_array[6];
					slider_title_coefficient = coefficients_title_array[6];
					slider_subtitle_coefficient = coefficients_subtitle_array[6];
					slider_text_coefficient = coefficients_text_array[6];
					slider_button_coefficient = coefficients_button_array[6];
				}

				// lettre-spacing decrease quicker
				var slider_title_coefficient_letter_spacing = slider_title_coefficient;
				var slider_subtitle_coefficient_letter_spacing = slider_subtitle_coefficient;
				var slider_text_coefficient_letter_spacing = slider_text_coefficient;
				if($window_width <= responsive_breakpoint_set[0]) {
					slider_title_coefficient_letter_spacing = slider_title_coefficient/2;
					slider_subtitle_coefficient_letter_spacing = slider_subtitle_coefficient/2;
					slider_text_coefficient_letter_spacing = slider_text_coefficient/2;
				}

				$item.find('.thumb img').css({"width": Math.round(window["slider_graphic_" + i][0]*slider_graphic_coefficient) + 'px'});

				$item.find('.mkd_slide_title').css({"font-size": Math.round(window["slider_title_" + i][0]*slider_title_coefficient) + 'px'});
				$item.find('.mkd_slide_title').css({"line-height": Math.round(window["slider_title_" + i][1]*slider_title_coefficient) + 'px'});
				$item.find('.mkd_slide_title').css({"letter-spacing": Math.round(window["slider_title_" + i][2]*slider_title_coefficient_letter_spacing) + 'px'});
				$item.find('.mkd_slide_title').css({"margin-bottom": Math.round(window["slider_title_" + i][3]*slider_title_coefficient) + 'px'});

				$item.find('.mkd_slide_subtitle').css({"font-size": Math.round(window["slider_subtitle_" + i][0]*slider_subtitle_coefficient) + 'px'});
				$item.find('.mkd_slide_subtitle').css({"line-height": Math.round(window["slider_subtitle_" + i][1]*slider_subtitle_coefficient) + 'px'});
				$item.find('.mkd_slide_subtitle').css({"letter-spacing": Math.round(window["slider_subtitle_" + i][2]*slider_subtitle_coefficient_letter_spacing) + 'px'});
				$item.find('.mkd_slide_subtitle').css({"margin-bottom": Math.round(window["slider_subtitle_" + i][3]*slider_subtitle_coefficient) + 'px'});

				$item.find('.mkd_slide_text').css({"font-size": Math.round(window["slider_text_" + i][0]*slider_text_coefficient) + 'px'});
				$item.find('.mkd_slide_text').css({"line-height": Math.round(window["slider_text_" + i][1]*slider_text_coefficient) + 'px'});
				$item.find('.mkd_slide_text').css({"letter-spacing": Math.round(window["slider_text_" + i][2]*slider_text_coefficient_letter_spacing) + 'px'});

                $item.find('.qbutton:eq(0)').css({"font-size": Math.round(window["slider_button1_" + i][0]*slider_button_coefficient) + 'px'});
                $item.find('.qbutton:eq(1)').css({"font-size": Math.round(window["slider_button2_" + i][0]*slider_button_coefficient) + 'px'});
                $item.find('.qbutton:eq(0)').css({"line-height": Math.round(window["slider_button1_" + i][1]*slider_button_coefficient) + 'px'});
                $item.find('.qbutton:eq(1)').css({"line-height": Math.round(window["slider_button2_" + i][1]*slider_button_coefficient) + 'px'});
                $item.find('.qbutton:eq(0)').css({"letter-spacing": Math.round(window["slider_button1_" + i][2]*slider_button_coefficient) + 'px'});
                $item.find('.qbutton:eq(1)').css({"letter-spacing": Math.round(window["slider_button2_" + i][2]*slider_button_coefficient) + 'px'});
                $item.find('.qbutton:eq(0)').css({"height": Math.round(window["slider_button1_" + i][3]*slider_button_coefficient) + 'px'});
                $item.find('.qbutton:eq(1)').css({"height": Math.round(window["slider_button2_" + i][3]*slider_button_coefficient) + 'px'});
                if(window["slider_button1_" + i][4] != 0) {
                    $item.find('.qbutton:eq(0)').css({"width": Math.round(window["slider_button1_" + i][4]*slider_button_coefficient) + 'px'});
                }else{
                    $item.find('.qbutton:eq(0)').css({"width": 'auto'});
                }
                if(window["slider_button2_" + i][4] != 0) {
                    $item.find('.qbutton:eq(1)').css({"width": Math.round(window["slider_button2_" + i][4]*slider_button_coefficient) + 'px'});
                }else{
                    $item.find('.qbutton:eq(1)').css({"width": 'auto'});
                }
                $item.find('.qbutton:eq(0)').css({"padding-left": Math.round(window["slider_button1_" + i][5]*slider_button_coefficient) + 'px'});
                $item.find('.qbutton:eq(1)').css({"padding-left": Math.round(window["slider_button2_" + i][5]*slider_button_coefficient) + 'px'});
                $item.find('.qbutton:eq(0)').css({"padding-right": Math.round(window["slider_button1_" + i][5]*slider_button_coefficient) + 'px'});
                $item.find('.qbutton:eq(1)').css({"padding-right": Math.round(window["slider_button2_" + i][5]*slider_button_coefficient) + 'px'});

				$item.find('.separator_top').css({"margin-top": Math.round(window["slider_top_separator_" + i][0]*slider_title_coefficient) + 'px'});
				$item.find('.separator_top').css({"margin-bottom": Math.round(window["slider_top_separator_" + i][1]*slider_title_coefficient) + 'px'});

				$item.find('.separator_bottom').css({"margin-top": Math.round(window["slider_bottom_separator_" + i][0]*slider_title_coefficient) + 'px'});
				$item.find('.separator_bottom').css({"margin-bottom": Math.round(window["slider_bottom_separator_" + i][1]*slider_title_coefficient) + 'px'});

			}

			function removeSliderElementsSize($item,i){
				$item.find('.thumb img').css({"width": Math.round(window["slider_graphic_" + i][0]) + 'px'});

				$item.find('.mkd_slide_title').css({"font-size": Math.round(window["slider_title_" + i][0]) + 'px'});
				$item.find('.mkd_slide_title').css({"line-height": Math.round(window["slider_title_" + i][1]) + 'px'});
				$item.find('.mkd_slide_title').css({"letter-spacing": Math.round(window["slider_title_" + i][2]) + 'px'});
				$item.find('.mkd_slide_title').css({"margin-bottom": Math.round(window["slider_title_" + i][3]) + 'px'});

				$item.find('.mkd_slide_subtitle').css({"font-size": Math.round(window["slider_subtitle_" + i][0]) + 'px'});
				$item.find('.mkd_slide_subtitle').css({"line-height": Math.round(window["slider_subtitle_" + i][1]) + 'px'});
				$item.find('.mkd_slide_subtitle').css({"letter-spacing": Math.round(window["slider_subtitle_" + i][2]) + 'px'});
				$item.find('.mkd_slide_subtitle').css({"margin-bottom": Math.round(window["slider_subtitle_" + i][3]) + 'px'});

				$item.find('.mkd_slide_text').css({"font-size": Math.round(window["slider_text_" + i][0]) + 'px'});
				$item.find('.mkd_slide_text').css({"line-height": Math.round(window["slider_text_" + i][1]) + 'px'});
				$item.find('.mkd_slide_text').css({"letter-spacing": Math.round(window["slider_text_" + i][2]) + 'px'});

                $item.find('.qbutton:eq(0)').css({"font-size": Math.round(window["slider_button1_" + i][0]) + 'px'});
                $item.find('.qbutton:eq(1)').css({"font-size": Math.round(window["slider_button2_" + i][0]) + 'px'});
                $item.find('.qbutton:eq(0)').css({"line-height": Math.round(window["slider_button1_" + i][1]) + 'px'});
                $item.find('.qbutton:eq(1)').css({"line-height": Math.round(window["slider_button2_" + i][1]) + 'px'});
                $item.find('.qbutton:eq(0)').css({"letter-spacing": Math.round(window["slider_button1_" + i][2]) + 'px'});
                $item.find('.qbutton:eq(1)').css({"letter-spacing": Math.round(window["slider_button2_" + i][2]) + 'px'});
                $item.find('.qbutton:eq(0)').css({"height": Math.round(window["slider_button1_" + i][3]) + 'px'});
                $item.find('.qbutton:eq(1)').css({"height": Math.round(window["slider_button2_" + i][3]) + 'px'});
                if(window["slider_button1_" + i][4] != 0) {
                    $item.find('.qbutton:eq(0)').css({"width": Math.round(window["slider_button1_" + i][4]) + 'px'});
                }else{
                    $item.find('.qbutton:eq(0)').css({"width": 'auto'});
                }
                if(window["slider_button2_" + i][4] != 0) {
                    $item.find('.qbutton:eq(1)').css({"width": Math.round(window["slider_button2_" + i][4]) + 'px'});
                }else{
                    $item.find('.qbutton:eq(1)').css({"width": 'auto'});
                }
                $item.find('.qbutton:eq(0)').css({"padding-left": Math.round(window["slider_button1_" + i][5]) + 'px'});
                $item.find('.qbutton:eq(1)').css({"padding-left": Math.round(window["slider_button2_" + i][5]) + 'px'});
                $item.find('.qbutton:eq(0)').css({"padding-right": Math.round(window["slider_button1_" + i][5]) + 'px'});
                $item.find('.qbutton:eq(1)').css({"padding-right": Math.round(window["slider_button2_" + i][5]) + 'px'});

				$item.find('.separator_top').css({"margin-top": Math.round(window["slider_top_separator_" + i][0]) + 'px'});
				$item.find('.separator_top').css({"margin-bottom": Math.round(window["slider_top_separator_" + i][1]) + 'px'});

				$item.find('.separator_bottom').css({"margin-top": Math.round(window["slider_bottom_separator_" + i][0]) + 'px'});
				$item.find('.separator_bottom').css({"margin-bottom": Math.round(window["slider_bottom_separator_" + i][1]) + 'px'});
			}

			var $def_height;

			if($this.hasClass('full_screen')){
				$this.css({'height': ($j(window).height() - mobile_header - paspartu_amount_with_top_bottom - paspartu_amount_with_bottom) + 'px'});
				$this.find('.mkd_slider_preloader').css({'height': ($j(window).height() - mobile_header - paspartu_amount_with_top_bottom - paspartu_amount_with_bottom) + 'px'});
				$this.find('.mkd_slider_preloader .ajax_loader').css({'display': 'block'});
				$this.find('.item').css({'height': ($j(window).height() - mobile_header - paspartu_amount_with_top_bottom - paspartu_amount_with_bottom) + 'px'});
				if($j('.paspartu_outer:not(.disable_top_paspartu):not(.paspartu_on_bottom_slider)').length){
					$this.closest('.mkd_slider').css('padding-top', Math.round(header_height_add_for_paspartu + $window_width * paspartu_width));
					$this.closest('.mkd_slider').css('padding-bottom', Math.round($window_width * paspartu_width));
				}
				if($j('.paspartu_outer.paspartu_on_bottom_slider').length){
					$this.closest('.mkd_slider').css('padding-bottom', Math.round($window_width * paspartu_width));
				}

				$j(window).resize(function() {
					mobile_header = $j(window).width() < 1000 ? $j('header.page_header').height() : 0;
					header_height_add_for_paspartu = $window_width > 1000 && !$j('header.page_header').hasClass('transparent') ? $j('header.page_header').height() : 0;
					paspartu_amount_with_top_bottom = $j('.paspartu_outer:not(.disable_top_paspartu):not(.paspartu_on_bottom_slider)').length > 0 ? Math.round($window_width*paspartu_width*2 + header_height_add_for_paspartu) : 0; // paspartu_width * 2 times top and bottom paspartu
					paspartu_amount_with_bottom = $j('.paspartu_outer.paspartu_on_bottom_slider').length > 0 ? Math.round($window_width*paspartu_width) : 0;
					$this.css({'height': ($j(window).height() - mobile_header - paspartu_amount_with_top_bottom - paspartu_amount_with_bottom) + 'px'});
					$this.find('.mkd_slider_preloader').css({'height': ($j(window).height() - mobile_header - paspartu_amount_with_top_bottom - paspartu_amount_with_bottom) + 'px'});
					$this.find('.item').css({'height': ($j(window).height() - mobile_header - paspartu_amount_with_top_bottom - paspartu_amount_with_bottom) + 'px'});
					if($j('.paspartu_outer:not(.disable_top_paspartu):not(.paspartu_on_bottom_slider)').length){
						$this.closest('.mkd_slider').css('padding-top', Math.round(header_height_add_for_paspartu + $window_width * paspartu_width));
						$this.closest('.mkd_slider').css('padding-bottom', Math.round($window_width * paspartu_width));
					}
					if($j('.paspartu_outer.paspartu_on_bottom_slider').length){
						$this.closest('.mkd_slider').css('padding-bottom', Math.round($window_width * paspartu_width));
					}
					$this.find('.item').each(function(i){
						setSliderElementsSize($j(this),i);
					});
				});
			}else if($this.hasClass('responsive_height')){
				$def_height = $this.data('height');

				$this.find('.mkd_slider_preloader').css({'height': ($this.height() - mobile_header - paspartu_amount_with_top_bottom - paspartu_amount_with_bottom) + 'px', 'display': 'block'});
				if($j('.paspartu_outer:not(.disable_top_paspartu):not(.paspartu_on_bottom_slider)').length){
					$this.closest('.mkd_slider').css('padding-top', Math.round(header_height_add_for_paspartu + $window_width * paspartu_width));
					$this.closest('.mkd_slider').css('padding-bottom', Math.round($window_width * paspartu_width));
				}
				if($j('.paspartu_outer.paspartu_on_bottom_slider').length){
					$this.closest('.mkd_slider').css('padding-bottom', Math.round($window_width * paspartu_width));
				}
				setSliderHeight($this, $def_height);

				$j(window).resize(function() {
					if($j('.paspartu_outer:not(.disable_top_paspartu):not(.paspartu_on_bottom_slider)').length){
						header_height_add_for_paspartu = $window_width > 1000 && !$j('header.page_header').hasClass('transparent') ? $j('header.page_header').height() : 0;
						$this.closest('.mkd_slider').css('padding-top', Math.round(header_height_add_for_paspartu + $window_width * paspartu_width));
						$this.closest('.mkd_slider').css('padding-bottom', Math.round($window_width * paspartu_width));
					}
					if($j('.paspartu_outer.paspartu_on_bottom_slider').length){
						$this.closest('.mkd_slider').css('padding-bottom', Math.round($window_width * paspartu_width));
					}
					setSliderHeight($this, $def_height);
					$this.find('.item').each(function(i){
						setSliderElementsSize($j(this),i);
					});
				});
			}else {
				$def_height = $this.data('height');

				$this.find('.mkd_slider_preloader').css({'height': ($this.height() - mobile_header - paspartu_amount_with_top_bottom - paspartu_amount_with_bottom) + 'px', 'display': 'block'});
				$this.find('.mkd_slider_preloader .ajax_loader').css({'display': 'block'});
				if($j('.paspartu_outer:not(.disable_top_paspartu):not(.paspartu_on_bottom_slider)').length){
					$this.closest('.mkd_slider').css('padding-top', Math.round(header_height_add_for_paspartu + $window_width * paspartu_width));
					$this.closest('.mkd_slider').css('padding-bottom', Math.round($window_width * paspartu_width));
				}
				if($j('.paspartu_outer.paspartu_on_bottom_slider').length){
					$this.closest('.mkd_slider').css('padding-bottom', Math.round($window_width * paspartu_width));
				}
				$this.find('.item').each(function(i){
					setSliderInitialElementsSize($j(this),i);
					setSliderElementsSize($j(this),i);
				});
				if($window_width < 1000) {
                    setSliderHeight($this, $def_height);
                } else {
                    resetSliderHeight($def_height);
                }
				$j(window).resize(function() {
					if($j('.paspartu_outer:not(.disable_top_paspartu):not(.paspartu_on_bottom_slider)').length){
						header_height_add_for_paspartu = $window_width > 1000 && !$j('header.page_header').hasClass('transparent') ? $j('header.page_header').height() : 0;
						$this.closest('.mkd_slider').css('padding-top', Math.round(header_height_add_for_paspartu + $window_width * paspartu_width));
						$this.closest('.mkd_slider').css('padding-bottom', Math.round($window_width * paspartu_width));
					}
					if($j('.paspartu_outer.paspartu_on_bottom_slider').length){
						$this.closest('.mkd_slider').css('padding-bottom', Math.round($window_width * paspartu_width));
					}
					if($window_width < 1000){
						setSliderHeight($this, $def_height);
						$this.find('.item').each(function(i){
							setSliderElementsSize($j(this),i);
						});
					}else{
						resetSliderHeight($def_height);
						$this.find('.item').each(function(i){
							removeSliderElementsSize($j(this),i);
						});
					}
				});
			}

			if($j('body:not(.boxed):not(.vertical_menu_transparency):not(.vertical_menu_hidden):not(.page-template-landing_page-php)').hasClass('vertical_menu_enabled') && $window_width > 1000){
				var vertical_menu_width = 290;
				if($j('.vertical_menu_width_350').length){ vertical_menu_width = 350; }
				if($j('.vertical_menu_width_400').length){ vertical_menu_width = 400; }
				$this.find('.carousel-inner').width($window_width - vertical_menu_width);
				$j(window).resize(function() {
					if($j(window).width() > 1000){
						$this.find('.carousel-inner').width($window_width - vertical_menu_width);
					} else {
						$this.find('.carousel-inner').css('width','100%');
					}
				});
			}

			if($j('body:not(.boxed):not(.vertical_menu_transparency):not(.page-template-landing_page-php)').hasClass('vertical_menu_hidden') && $window_width > 1000){
				$this.find('.carousel-inner').width($window_width - 40);
				$j(window).resize(function() {
					if($j(window).width() > 1000){
						$this.find('.carousel-inner').width($window_width - 40);
					} else {
						$this.find('.carousel-inner').css('width','100%');
					}
				});
			}

			$j(window).scroll(function(){
				if($this.hasClass('full_screen') && $scroll > $window_height && $window_width > 1000){
					$this.find('.carousel-inner, .carousel-indicators, button').hide();
				}else if(!$this.hasClass('full_screen') && $scroll > $this.height() && $window_width > 1000){
					$this.find('.carousel-inner, .carousel-indicators, button').hide();
				}else{
					$this.find('.carousel-inner, .carousel-indicators, button').show();
				}
			});

			var $slide_animation = $this.data('slide_animation');
			if($slide_animation === ""){
				$slide_animation = 6000;
			}

			// function for setting prev/next numbers on arrows
			var all_items_count = $j('div.item').length;
			function setPrevNextNumbers(curr_item, all_items_count){
				if(curr_item == 1){
					$this.find('.left.carousel-control .prev').html(all_items_count);
					$this.find('.right.carousel-control .next').html(curr_item + 1);
				}else if(curr_item == all_items_count){
					$this.find('.left.carousel-control .prev').html(curr_item - 1);
					$this.find('.right.carousel-control .next').html(1);
				}else{
					$this.find('.left.carousel-control .prev').html(curr_item - 1);
					$this.find('.right.carousel-control .next').html(curr_item + 1);
				}
			}

			function initSlider(){
				//set active class on first item
				$this.find('.carousel-inner .item:first-child').addClass('active');
				checkSliderForHeaderStyle($j('.carousel .active'), $this.hasClass('header_effect'));

				if($this.hasClass('slider_thumbs')){
					// initial state of prev/next numbers
					setPrevNextNumbers(1, all_items_count);

					//set prev and next thumb on load
					if($this.find('.active').next('div').find('.image').length){
						src = image_regex.exec($this.find('.active').next('div').find('.image').attr('style'));
						next_image = new Image();
						next_image.src = src[1];
					}else{
						next_image = $this.find('.active').next('div').find('> .video').clone();
						next_image.find('.video-overlay').remove();
						next_image.find('.video-wrap').width(170).height(95);
						next_image.find('.mejs-container').width(170).height(95);
						next_image.find('video').width(170).height(95);
					}
					$this.find('.right.carousel-control .img').html(next_image).find('img, div.video').addClass('old');

					if($this.find('.carousel-inner .item:last-child .image').length){
						src = image_regex.exec($this.find('.carousel-inner .item:last-child .image').attr('style'));
						prev_image = new Image();
						prev_image.src = src[1];
					}else{
						prev_image = $this.find('.carousel-inner .item:last-child > .video').clone();
						prev_image.find('.video-overlay').remove();
						prev_image.find('.video-wrap').width(170).height(95);
						prev_image.find('.mejs-container').width(170).height(95);
						prev_image.find('video').width(170).height(95);
					}
					$this.find('.left.carousel-control .img').html(prev_image).find('img, div.video').addClass('old');
				}

				if($this.hasClass('mkd_auto_start')){
					$this.carousel({
						interval: $slide_animation,
						pause: false
					});

					//pause slider when hover slider button
					$this.find('.slide_buttons_holder .qbutton')
						.mouseenter(function() {
							$this.carousel('pause');
						})
						.mouseleave(function() {
							$this.carousel('cycle');
						});

				} else {
					$this.carousel({
						interval: 0,
						pause: false
					});
				}
				if($this.find('.item video').length){
					initVideoBackgroundSize();
				}

				if($this.hasClass('responsive_height') || $this.hasClass('full_screen')) {
					$this.find('.item').each(function (i) {
						setSliderInitialElementsSize($j(this), i);
						setSliderElementsSize($j(this), i);
					});
				}

			}

            var backImg;

			if($j('html').hasClass('touch')){
				if($this.find('.item:first-child .mobile-video-image').length > 0){
					src = image_regex.exec($this.find('.item:first-child .mobile-video-image').attr('style'));
					if (src) {
						backImg = new Image();
						backImg.src = src[1];
						$j(backImg).load(function(){
							$j('.mkd_slider_preloader').fadeOut(500);
							initSlider();
						});
					}
				}
				else{
					src = image_regex.exec($this.find('.item:first-child .image').attr('style'));
					if (src) {
						backImg = new Image();
						backImg.src = src[1];
						$j(backImg).load(function(){
							$j('.mkd_slider_preloader').fadeOut(500);
							initSlider();
						});
					}
				}
			} else {
				if($this.find('.item:first-child video').length > 0){
					$this.find('.item:first-child video').get(0).addEventListener('loadeddata',function(){
						$j('.mkd_slider_preloader').fadeOut(500);
						initSlider();
					});
				}else{
					src = image_regex.exec($this.find('.item:first-child .image').attr('style'));
					if (src) {
						backImg = new Image();
						backImg.src = src[1];
						$j(backImg).load(function(){
							$j('.mkd_slider_preloader').fadeOut(500);
							initSlider();
						});
					}
				}
			}

			$this.on('slide.bs.carousel', function () {
				$this.addClass('in_progress');
				$this.find('.active .slider_content_outer').fadeTo(250,0);
			});
			$this.on('slid.bs.carousel', function () {
				$this.removeClass('in_progress');
				$this.find('.active .slider_content_outer').fadeTo(0,1);

				if($this.hasClass('slider_thumbs')){
					var curr_item = $j('div.item').index($j('div.item.active')[0]) + 1;
					setPrevNextNumbers(curr_item, all_items_count);

					// prev thumb
					if($this.find('.active').prev('div.item').length){
						if($this.find('.active').prev('div').find('.image').length){
							src = image_regex.exec($this.find('.active').prev('div').find('.image').attr('style'));
							prev_image = new Image();
							prev_image.src = src[1];
						}else{
							prev_image = $this.find('.active').prev('div').find('> .video').clone();
							prev_image.find('.video-overlay').remove();
							prev_image.find('.video-wrap').width(170).height(95);
							prev_image.find('.mejs-container').width(170).height(95);
							prev_image.find('video').width(170).height(95);
						}
						$this.find('.left.carousel-control .img .old').fadeOut(300,function(){
							$j(this).remove();
						});
						$this.find('.left.carousel-control .img').append(prev_image).find('img, div.video').fadeIn(300).addClass('old');

					}else{
						if($this.find('.carousel-inner .item:last-child .image').length){
							src = image_regex.exec($this.find('.carousel-inner .item:last-child .image').attr('style'));
							prev_image = new Image();
							prev_image.src = src[1];
						}else{
							prev_image = $this.find('.carousel-inner .item:last-child > .video').clone();
							prev_image.find('.video-overlay').remove();
							prev_image.find('.video-wrap').width(170).height(95);
							prev_image.find('.mejs-container').width(170).height(95);
							prev_image.find('video').width(170).height(95);
						}
						$this.find('.left.carousel-control .img .old').fadeOut(300,function(){
							$j(this).remove();
						});
						$this.find('.left.carousel-control .img').append(prev_image).find('img, div.video').fadeIn(300).addClass('old');
					}

					// next thumb
					if($this.find('.active').next('div.item').length){
						if($this.find('.active').next('div').find('.image').length){
							src = image_regex.exec($this.find('.active').next('div').find('.image').attr('style'));
							next_image = new Image();
							next_image.src = src[1];
						}else{
							next_image = $this.find('.active').next('div').find('> .video').clone();
							next_image.find('.video-overlay').remove();
							next_image.find('.video-wrap').width(170).height(95);
							next_image.find('.mejs-container').width(170).height(95);
							next_image.find('video').width(170).height(95);
						}

						$this.find('.right.carousel-control .img .old').fadeOut(300,function(){
							$j(this).remove();
						});
						$this.find('.right.carousel-control .img').append(next_image).find('img, div.video').fadeIn(300).addClass('old');

					}else{
						if($this.find('.carousel-inner .item:first-child .image').length){
							src = image_regex.exec($this.find('.carousel-inner .item:first-child .image').attr('style'));
							next_image = new Image();
							next_image.src = src[1];
						}else{
							next_image = $this.find('.carousel-inner .item:first-child > .video').clone();
							next_image.find('.video-overlay').remove();
							next_image.find('.video-wrap').width(170).height(95);
							next_image.find('.mejs-container').width(170).height(95);
							next_image.find('video').width(170).height(95);
						}
						$this.find('.right.carousel-control .img .old').fadeOut(300,function(){
							$j(this).remove();
						});
						$this.find('.right.carousel-control .img').append(next_image).find('img, div.video').fadeIn(300).addClass('old');
					}
				}
			});

			$this.swipe( {
				swipeLeft: function(event, direction, distance, duration, fingerCount){ $this.carousel('next'); },
				swipeRight: function(event, direction, distance, duration, fingerCount){ $this.carousel('prev'); },
				threshold:20
			});

		});

		if($j('.carousel').data('parallax') == 'yes'){
			if ($j('.no-touch .carousel').length) {
				skrollr_slider = skrollr.init({
					edgeStrategy: 'set',
					smoothScrolling: false,
					forceHeight: false
				});
				skrollr_slider.refresh();
			}
		}
	}
}

function checkSliderForHeaderStyle($this, header_effect){
	"use strict";

	if($j('.mkd_slider .carousel').not('.disable_slider_header_style_changing').length > 0) {

		var slide_header_style = "";
		if ($this.hasClass('light')) { slide_header_style = 'light'; }
		if ($this.hasClass('dark')) { slide_header_style = 'dark'; }

		if (slide_header_style !== "") {
			if (header_effect) {
				$j('header.page_header').removeClass('dark light').addClass(slide_header_style);
				$j('aside.vertical_menu_area').removeClass('dark light').addClass(slide_header_style);
			}
			$j('.carousel .carousel-control, .carousel .carousel-indicators').removeClass('dark light').addClass(slide_header_style);
		} else {
			if (header_effect) {
				$j('header.page_header').removeClass('dark light').addClass(default_header_style);
				$j('aside.vertical_menu_area').removeClass('dark light').addClass(default_header_style);
			}
			$j('.carousel .carousel-control, .carousel .carousel-indicators').removeClass('dark light').addClass(default_header_style);
		}
	}
}