var $j = jQuery.noConflict();

$j(document).ready(function() {
	"use strict";

	setTestimonialsEqualHeight();
});

$j(window).load(function(){
	"use strict";

	initTestimonials();
	setTestimonialsEqualHeight();
});

$j(window).resize(function() {
	"use strict";

	initTestimonials();
	setTestimonialsEqualHeight();
});

/*
 **	Init testimonials shortcode
 */
function initTestimonials(){
	"use strict";

	var acc;

	if($j('.testimonials_carousel').length){
		if($j('.vertical_split_slider').length){
			acc = 0;
		}else{
			acc = -100;
		}
		$j('.testimonials_carousel').each(function(){
			$j(this).appear(function() {
				$j(this).css('visibility','visible');
			},{accX: 0, accY: acc});

			var animationSpeed = 5000;
			if(typeof $j(this).data('auto-rotate-slides') !== 'undefined' && $j(this).data('auto-rotate-slides') !== false) {
				interval = parseFloat($j(this).data('auto-rotate-slides')) * 1000;
			}

			var slideshow = true;
			if(interval === 0) {
				slideshow = false;
			}

			var controlNavColor = "";
			if(typeof $j(this).data('navigation-color') !== 'undefined') {
				controlNavColor = $j(this).data('navigation-color');
			}

			var controlNav = true;
			if(typeof $j(this).data('show-navigation') !== 'undefined') {
				controlNav = $j(this).data('show-navigation') == 'no' ? false : true;
			}

			var directionNav = true;
			if(typeof $j(this).data('show-navigation-arrows') !== 'undefined') {
				directionNav = $j(this).data('show-navigation-arrows') == 'no' ? false : true;
			}

			var interval = 600;
			if(typeof $j(this).data('animation-speed') !== 'undefined' && $j(this).data('animation-speed') !== false) {
				animationSpeed = $j(this).data('animation-speed');
			}

			$j(this).flexslider({
				animationLoop: true,
				controlNav: controlNav,
				directionNav: directionNav,
				useCSS: false,
				pauseOnAction: true,
				pauseOnHover: false,
				slideshow: slideshow,
				animation: 'fade',
				itemMargin: 25,
				minItems: 1,
				maxItems: 1,
				prevText: "<span></span>",
				nextText: "<span></span>",
				animationSpeed: interval,
				slideshowSpeed: animationSpeed,
				start: function(slider){
					initParallax();
				}
			});

			if( controlNavColor !== "" ) {
				$j(this).find('ol.flex-control-nav li a').css("background-color", controlNavColor);
			}
		});

	}
}

/*
 ** Testimonials slider height (only for image absolute position)
 */

function setTestimonialsEqualHeight(){
	"use strict";

	if($j('.testimonials .slides li.absolute_position').length){
		var heights = [];

		$j('.testimonials .slides li.absolute_position').each(function(){
			$j(this).css('min-height', '0');
			$j(this).css('max-height', 'none');
			$j(this).css('height', 'auto');

			heights.push($j(this).height());
		});

		var max = Math.max.apply( Math, heights );

		$j('.testimonials .slides li.absolute_position').each(function(){
			$j(this).css('height', max + 'px');
		});
	}
}