<?php
/*
Template Name: Landing Page
*/
$mkd_options = mikado_one_mikado_return_global_options();
$mkd_toolbar = mikado_one_mikado_get_toolbar_param();

$mikado_one_mikado_sidebar = mikado_one_mikado_get_sidebar_layout(true);

$enable_page_comments = false;
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_enable-page-comments", true) == 'yes') {
	$enable_page_comments = true;
}

if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_background_color", true) != ""){
	$background_color = 'background-color: '.get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_background_color", true);
}else{
	$background_color = "";
}

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo( 'charset' ); ?>" />
	    <?php
	    if (mikado_one_mikado_return_is_ie()) { ?>
        <meta content="IE=edge,chrome=1" http-equiv="X-UA-Compatible">
        <?php } ?>

        <title><?php wp_title(''); ?></title>

        <?php
        /**
         * mikado_mikado_one_header_meta hook
         *
         * @see mikado_one_mikado_header_meta() - hooked with 10
         * @see mkd_user_scalable_meta() - hooked with 10
         */
        do_action('mikado_mikado_one_header_meta');
        ?>

        <link rel="profile" href="https://gmpg.org/xfn/11" />
        <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
        <link rel="shortcut icon" type="image/x-icon" href="<?php echo esc_url($mkd_options['favicon_image']); ?>">
        <link rel="apple-touch-icon" href="<?php echo esc_url($mkd_options['favicon_image']); ?>"/>

        <?php wp_head(); ?>

    </head>

<body <?php body_class(); ?>>

<div class="wrapper">
    <div class="wrapper_inner">

        <?php do_action('mikado_mikado_one_after_wrapper_inner'); ?>

        <?php if(isset($mkd_toolbar)) include("toolbar_examples.php") ?>
        <div class="content content_top_margin_none">
            <div class="content_inner">
                <?php get_template_part( 'title' ); ?>
                <?php
                $revslider = get_post_meta(mikado_one_mikado_get_page_id(), "mkd_revolution-slider", true);
                if (!empty($revslider)){ ?>
                    <div class="mkd_slider"><div class="mkd_slider_inner">
                            <?php echo do_shortcode($revslider); ?>
                        </div></div>
                <?php
                }
                ?>
                <div class="full_width"<?php mikado_one_mikado_style_attr($background_color); ?>>
                    <div class="full_width_inner">
                        <?php if(($mikado_one_mikado_sidebar == "default")||($mikado_one_mikado_sidebar == "")) : ?>
                            <?php if (have_posts()) :
                                while (have_posts()) : the_post(); ?>
                                    <?php the_content(); ?>
                                    <?php
                                    $args_pages = array(
                                        'before'           => '<p class="single_links_pages">',
                                        'after'            => '</p>',
                                        'pagelink'         => '<span>%</span>'
                                    );

                                    wp_link_pages($args_pages); ?>
                                    <?php
                                    if($enable_page_comments){
                                        ?>
                                        <div class="container">
                                            <div class="container_inner">
                                                <?php
                                                comments_template('', true);
                                                ?>
                                            </div>
                                        </div>
                                    <?php
                                    }
                                    ?>
                                <?php endwhile; ?>
		                        <?php wp_reset_postdata(); ?>
                            <?php endif; ?>
                        <?php elseif($mikado_one_mikado_sidebar == "1" || $mikado_one_mikado_sidebar == "2"): ?>

                        <?php if($mikado_one_mikado_sidebar == "1") : ?>
                        <div class="two_columns_66_33 clearfix grid2">
                            <div class="column1">
                        <?php elseif($mikado_one_mikado_sidebar == "2") : ?>
                        <div class="two_columns_75_25 clearfix grid2">
                            <div class="column1">
                                <?php endif; ?>
                                <?php if (have_posts()) :
                                    while (have_posts()) : the_post(); ?>
                                        <div class="column_inner">

                                            <?php the_content(); ?>
                                            <?php
                                            $args_pages = array(
                                                'before'           => '<p class="single_links_pages">',
                                                'after'            => '</p>',
                                                'pagelink'         => '<span>%</span>'
                                            );

                                            wp_link_pages($args_pages); ?>
                                            <?php
                                            if($enable_page_comments){
                                                ?>
                                                <div class="container">
                                                    <div class="container_inner">
                                                        <?php
                                                        comments_template('', true);
                                                        ?>
                                                    </div>
                                                </div>
                                            <?php
                                            }
                                            ?>
                                        </div>
                                    <?php endwhile; ?>
	                                <?php wp_reset_postdata(); ?>
                                <?php endif; ?>


                            </div>
                            <div class="column2"><?php get_sidebar();?></div>
                        </div>
                        <?php elseif($mikado_one_mikado_sidebar == "3" || $mikado_one_mikado_sidebar == "4"): ?>
                        <?php if($mikado_one_mikado_sidebar == "3") : ?>
                        <div class="two_columns_33_66 clearfix grid2">
                            <div class="column1"><?php get_sidebar();?></div>
                            <div class="column2">
                                <?php elseif($mikado_one_mikado_sidebar == "4") : ?>
                                <div class="two_columns_25_75 clearfix grid2">
                                    <div class="column1"><?php get_sidebar();?></div>
                                    <div class="column2">
                                        <?php endif; ?>
                                        <?php if (have_posts()) :
                                            while (have_posts()) : the_post(); ?>
                                                <div class="column_inner">
                                                    <?php the_content(); ?>
                                                    <?php
                                                    $args_pages = array(
                                                        'before'           => '<p class="single_links_pages">',
                                                        'after'            => '</p>',
                                                        'pagelink'         => '<span>%</span>'
                                                    );

                                                    wp_link_pages($args_pages); ?>
                                                    <?php
                                                    if($enable_page_comments){
                                                        ?>
                                                        <div class="container">
                                                            <div class="container_inner">
                                                                <?php
                                                                comments_template('', true);
                                                                ?>
                                                            </div>
                                                        </div>
                                                    <?php
                                                    }
                                                    ?>
                                                </div>
                                            <?php endwhile; ?>
	                                        <?php wp_reset_postdata(); ?>
                                        <?php endif; ?>


                                    </div>

                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
            </div>
        </div>
    </div>
</div>
<?php wp_footer(); ?>
</body>
</html>