<?php

if(!function_exists( 'mikado_one_mikado_header_classes' )) {
	/**
	 * Function that acts like filter for header classes based on theme settings
	 * @param array array of classes to add to header tag
	 *
	 * @see apply_filters()
	 */
	function mikado_one_mikado_header_classes($classes = array()) {
		$classes = array('page_header');
		$classes = apply_filters('mikado_one_mikado_header_classes', $classes);

		if(is_array($classes) && count($classes)) {
			echo esc_attr(implode(' ', $classes));
		}
	}
}

if(!function_exists( 'mikado_one_mikado_transparent_header_class' )) {
	/**
	 * Function that adds transparency class to header based on page or theme options
	 * @param array array of classes from main filter
	 * @return array array of classes with added transparent class
	 *
	 * @see mikado_one_mikado_is_default_wp_template()
	 */
	function mikado_one_mikado_transparent_header_class($classes) {
		$mkd_options = mikado_one_mikado_return_global_options();
		
		$is_header_transparent  	= false;
		$transparent_values_array 	= array('0.00', '0');
		$is_archive 				= mikado_one_mikado_is_default_wp_template();

		$transparent_header = 1;

		//is header transparent set on current page?
		if(!$is_archive && get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header_color_transparency_per_page", true) !== "") {
			//take value set for current page
			$transparent_header = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header_color_transparency_per_page", true));
		} elseif(isset($mkd_options['header_background_transparency_initial'])) {
			//take value set in global options
			$transparent_header = esc_attr($mkd_options['header_background_transparency_initial']);
		}

		//is header completely transparent?
		$is_header_transparent 	= in_array($transparent_header, $transparent_values_array);
		if($is_header_transparent) {
			$classes[]= 'transparent';
		}
		
		//is header transparent on scrolled window?
		if(isset($mkd_options['header_bottom_appearance']) && $mkd_options['header_bottom_appearance'] !== 'regular' && !in_array($mkd_options['header_background_transparency_sticky'], $transparent_values_array) || !in_array($mkd_options['header_background_transparency_scroll'], $transparent_values_array)) {
			$classes[] = 'scrolled_not_transparent';
		}
		
		return $classes;
	}

	add_filter('mikado_one_mikado_header_classes', 'mikado_one_mikado_transparent_header_class');
}

if(!function_exists( 'mikado_one_mikado_with_border_header_class' )) {
	/**
	 * Function that adds border class on header tag
	 * @param array array of classes from main filter
	 * @return array array of classes with added border class
	 *
	 * @see mikado_one_mikado_is_default_wp_template()
	 */
	function mikado_one_mikado_with_border_header_class($classes) {
		$mkd_options = mikado_one_mikado_return_global_options();

		$header_with_border = isset($mkd_options['header_bottom_border_color']) && $mkd_options['header_bottom_border_color'] != '';
		if($header_with_border) {
			$classes[]= 'with_border';
		}

		return $classes;
	}

	add_filter('mikado_one_mikado_header_classes', 'mikado_one_mikado_with_border_header_class');
}

if(!function_exists( 'mikado_one_mikado_wide_first_level_menu_bkg_header_class' )) {
	/**
	 * Function that shows wide background in 1st level menu 
	 * @param array array of classes from main filter
	 * @return array array of classes with added wide background class
	 *
	 * @see mikado_one_mikado_is_default_wp_template()
	 */
	function mikado_one_mikado_wide_first_level_menu_bkg_header_class($classes) {
		$mkd_options = mikado_one_mikado_return_global_options();

		$mkd_wide_first_level_menu_bkg_header_class = ((isset($mkd_options['header_bottom_appearance']) && $mkd_options['header_bottom_appearance'] == "fixed_hiding") || (isset($mkd_options['header_bottom_appearance']) && $mkd_options['header_bottom_appearance'] == "stick menu_bottom") ) && isset($mkd_options['enable_menu_wide_background']) && $mkd_options['enable_menu_wide_background'] == 'yes';
		if($mkd_wide_first_level_menu_bkg_header_class) {
			$classes[]= 'first_level_menu_wide_bkg';
		}

		return $classes;
	}

	add_filter('mikado_one_mikado_header_classes', 'mikado_one_mikado_wide_first_level_menu_bkg_header_class');
}

if(!function_exists( 'mikado_one_mikado_top_header_class' )) {
	/**
	 * Function that adds top header class to header tag
	 * @param array array of classes from main filter
	 * @return array array of classes with added top header class
	 */
	function mikado_one_mikado_top_header_class($classes) {
		$mkd_options = mikado_one_mikado_return_global_options();

		$display_header_top = "yes";
		if(isset($mkd_options['header_top_area'])){
			$display_header_top = esc_attr($mkd_options['header_top_area']);
		}
		if (!empty($_SESSION['mkd_cayman_header_top'])){
			$display_header_top = $_SESSION['mkd_cayman_header_top'];
		}

		if($display_header_top == 'yes') {
			$classes[] = 'has_top';
		}

		return $classes;
	}

	add_filter('mikado_one_mikado_header_classes', 'mikado_one_mikado_top_header_class');
}

if(!function_exists( 'mikado_one_mikado_has_woocommerce_dropdown_class' )) {
	/**
	 * Function that adds woocommerce dropdown class to header tag
	 * @param array array of classes from main filter
	 * @return array array of classes with added woocommerce dropdown class
	 *
	 * @see mikado_one_mikado_is_woocommerce_installed()
	 */
	function mikado_one_mikado_has_woocommerce_dropdown_class($classes) {
		if(is_active_sidebar('woocommerce_dropdown') && mikado_one_mikado_is_woocommerce_installed()) {
			$classes[]= 'has_woocommerce_dropdown ';
		}

		return $classes;
	}

	add_filter('mikado_one_mikado_header_classes', 'mikado_one_mikado_has_woocommerce_dropdown_class');
}

if(!function_exists( 'mikado_one_mikado_scroll_top_header_class' )) {
	/**
	 * Function that adds top header scroll class to header tag
	 * @param array array of classes from main filter
	 * @return array array of classes with added top header scroll class
	 */
	function mikado_one_mikado_scroll_top_header_class($classes) {
		$mkd_options = mikado_one_mikado_return_global_options();

		$header_top_area_scroll = "no";
		if(isset($mkd_options['header_top_area_scroll'])){
			$header_top_area_scroll = esc_attr($mkd_options['header_top_area_scroll']);
        }

		if($header_top_area_scroll == 'yes') {
			$classes[] = 'scroll_top';
		}

		if($mkd_options['header_top_area_scroll'] == 'no' && $mkd_options['header_top_area'] == 'yes') {
			$classes[]= 'scroll_header_top_area';
		}

		return $classes;
	}

	add_filter('mikado_one_mikado_header_classes' ,'mikado_one_mikado_scroll_top_header_class');
}

if(!function_exists( 'mikado_one_mikado_center_logo_class' )) {
	/**
	 * Function that adds center logo class to header tag
	 * @param array array of classes from main filter
	 * @return array array of classes with added center logo class
	 */
	function mikado_one_mikado_center_logo_class($classes) {
		$mkd_options = mikado_one_mikado_return_global_options();

		if((isset($mkd_options['center_logo_image']) && $mkd_options['center_logo_image'] == 'yes' && $mkd_options['header_bottom_appearance'] !== "stick_with_left_right_menu") || (isset($mkd_options['header_bottom_appearance']) && $mkd_options['header_bottom_appearance'] == "fixed_hiding")) {
			$classes[] = 'centered_logo';
		}

		return $classes;
	}

	add_filter('mikado_one_mikado_header_classes', 'mikado_one_mikado_center_logo_class');
}

if(!function_exists( 'mikado_one_mikado_header_fixed_right_class' )) {
	/**
	 * Function that adds fixed header class to header tag
	 * @param array array of classes from main filter
	 * @return array array of classes with added fixed header class
	 */
	function mikado_one_mikado_header_fixed_right_class($classes) {
		if(is_active_sidebar('header_fixed_right')) {
			$classes[]= 'has_header_fixed_right';
		}

		return $classes;
	}

	add_filter('mikado_one_mikado_header_classes', 'mikado_one_mikado_header_fixed_right_class');
}

if(!function_exists( 'mikado_one_mikado_header_style_class' )) {
	/**
	 * Function that adds header style class to header tag
	 * @param array array of classes from main filter
	 * @return array array of classes with added header style class
	 */
	function mikado_one_mikado_header_style_class($classes) {
		$mkd_options = mikado_one_mikado_return_global_options();
		
		if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header-style", true) != ""){
			$classes[]= esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header-style", true));
		} else if(isset($mkd_options['header_style'])){
			$classes[]= esc_attr($mkd_options['header_style']);
		}

		return $classes;
	}

	add_filter('mikado_one_mikado_header_classes', 'mikado_one_mikado_header_style_class');
}

if(!function_exists( 'mikado_one_mikado_header_style_on_scroll_class' )) {
    /**
     * Function that adds header style class to header tag
     * @param array array of classes from main filter
     * @return array array of classes with added header style class
     */
    function mikado_one_mikado_header_style_on_scroll_class($classes) {
        $mkd_options = mikado_one_mikado_return_global_options();
        
        if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header-style-on-scroll", true) != ""){
            if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_header-style-on-scroll", true) == "yes") {
                $classes[] = 'header_style_on_scroll';
            }
        } else if(isset($mkd_options['enable_header_style_on_scroll']) && $mkd_options['enable_header_style_on_scroll'] == 'yes'){
            $classes[]= 'header_style_on_scroll';
        }

        return $classes;
    }

    add_filter('mikado_one_mikado_header_classes', 'mikado_one_mikado_header_style_on_scroll_class');
}

if(!function_exists( 'mikado_one_mikado_header_class_first_level_bg_color' )) {
	/**
	 * Function that adds first level menu background color class to header tag
	 * @param array array of classes from main filter
	 * @return array array of classes with added first level menu background color class
	 */
	function mikado_one_mikado_header_class_first_level_bg_color($classes) {
		$mkd_options = mikado_one_mikado_return_global_options();

		//check if first level hover background color is set
		$has_first_lvl_bg_color = isset($mkd_options['menu_hover_background_color']) && $mkd_options['menu_hover_background_color'] !== '';

		if($has_first_lvl_bg_color) {
			$classes[]= 'with_hover_bg_color';
		}

		return $classes;
	}

	add_filter('mikado_one_mikado_header_classes', 'mikado_one_mikado_header_class_first_level_bg_color');
}

if(!function_exists( 'mikado_one_mikado_header_bottom_appearance_class' )) {
	/**
	 * Function that adds bottom header appearance class to header tag
	 * @param array array of classes from main filter
	 * @return array array of classes with added bottom header appearance class
	 */
	function mikado_one_mikado_header_bottom_appearance_class($classes) {
		$mkd_options = mikado_one_mikado_return_global_options();

        if (isset($_SESSION['mkd_cayman_header_type'])) {
            if ($_SESSION['mkd_cayman_header_type'] == "big") {
                $mkd_options["header_bottom_appearance"] = "stick menu_bottom";
            }
        }

        if(isset($mkd_options['header_bottom_appearance'])){
			$classes[]= esc_attr($mkd_options['header_bottom_appearance']);
		} else {
			$classes[]= 'regular';
		}

		return $classes;
	}

	add_filter('mikado_one_mikado_header_classes', 'mikado_one_mikado_header_bottom_appearance_class');
}

if(!function_exists( 'mikado_one_mikado_header_paspartu_alignment_class' )) {
    /**
     * Function that adds paspartu alignment class to header tag
     * @param array array of classes from main filter
     * @return array of classes with added paspartu alignment class
     */
    function mikado_one_mikado_header_paspartu_alignment_class($classes) {
        $mkd_options = mikado_one_mikado_return_global_options();

        if(isset($mkd_options['paspartu_header_alignment']) && $mkd_options['paspartu_header_alignment'] == 'yes' && isset($mkd_options['paspartu']) && $mkd_options['paspartu'] == 'yes'){
            $classes[]= 'paspartu_header_alignment';
        }

        return $classes;
    }

    add_filter('mikado_one_mikado_header_classes', 'mikado_one_mikado_header_paspartu_alignment_class');
}