<?php
/*
   Class: MikadoFramework
   A class that initializes Mikado Framework
*/
class MikadoFramework {

    private static $instance;
    public $mkdOptions;
    public $mkdMetaBoxes;

    private function __construct() {
        $this->mkdOptions = MikadoOptions::get_instance();
        $this->mkdMetaBoxes = MikadoMetaBoxes::get_instance();
    }
    
		public static function get_instance() {
		
			if ( null == self::$instance ) {
				self::$instance = new self;
			}
		
			return self::$instance;
		
		}
}

/*
   Class: MikadoOptions
   A class that initializes Mikado Options
*/
class MikadoOptions {

    private static $instance;
    public $adminPages;
    public $options;

    private function __construct() {
        $this->adminPages = array();
        $this->options = array();
    }
    
		public static function get_instance() {
		
			if ( null == self::$instance ) {
				self::$instance = new self;
			}
		
			return self::$instance;
		
		}

    public function addAdminPage($key, $page) {
        $this->adminPages[$key] = $page;
    }

    public function getAdminPage($key) {
        return $this->adminPages[$key];
    }

    public function getAdminPageFromSlug($slug) {
			foreach ($this->adminPages as $key=>$page ) {
				if ($page->slug == $slug)
					return $page;
			}
      return;
    }

    public function addOption($key, $value) {
        $this->options[$key] = $value;
    }

    public function getOption($key) {
			if(isset($this->options[$key]))
        return $this->options[$key];
      return;
    }
}

/*
   Class: MikadoAdminPage
   A class that initializes Mikado Admin Page
*/
class MikadoAdminPage implements iLayoutNode {

    public $layout;
		private $factory;
		public $slug;
		public $title;

    function __construct($slug="", $title="") {
        $this->layout = array();
				$this->factory = new MikadoFieldFactory();
				$this->slug = $slug;
				$this->title = $title;
    }

    public function hasChidren() {
        return (count($this->layout) > 0)?true:false;
    }

    public function getChild($key) {
        return $this->layout[$key];
    }

    public function addChild($key, $value) {
        $this->layout[$key] = $value;
    }

    function render() {
        foreach ($this->layout as $child) {
            $this->renderChild($child);
        }
    }

    public function renderChild(iRender $child) {
        $child->render($this->factory);
    }
}

/*
   Class: MikadoMetaBoxes
   A class that initializes Mikado Meta Boxes
*/
class MikadoMetaBoxes {

    private static $instance;
    public $metaBoxes;
    public $options;

    private function __construct() {
        $this->metaBoxes = array();
        $this->options = array();
    }
    
		public static function get_instance() {
		
			if ( null == self::$instance ) {
				self::$instance = new self;
			}
		
			return self::$instance;
		
		}

    public function addMetaBox($key, $box) {
        $this->metaBoxes[$key] = $box;
    }

    public function getMetaBox($key) {
        return $this->metaBoxes[$key];
    }

    public function addOption($key, $value) {
        $this->options[$key] = $value;
    }

    public function getOption($key) {
			if(isset($this->options[$key]))
        return $this->options[$key];
      return;
    }
}

/*
   Class: MikadoMetaBox
   A class that initializes Mikado Meta Box
*/
class MikadoMetaBox implements iLayoutNode {

    public $layout;
	private $factory;
	public $scope;
	public $title;
	public $hidden_property;
	public $hidden_values = array();

    function __construct($scope="", $title="",$hidden_property="", $hidden_values = array()) {
        $this->layout = array();
		$this->factory = new MikadoFieldFactory();
		$this->scope = $scope;
		$this->title = $title;
		$this->hidden_property = $hidden_property;
		$this->hidden_values = $hidden_values;
    }

    public function hasChidren() {
        return (count($this->layout) > 0)?true:false;
    }

    public function getChild($key) {
        return $this->layout[$key];
    }

    public function addChild($key, $value) {
        $this->layout[$key] = $value;
    }

    function render() {
        foreach ($this->layout as $child) {
            $this->renderChild($child);
        }
    }

    public function renderChild(iRender $child) {
        $child->render($this->factory);
    }
}

global $mkdFramework;
$mkdFramework = MikadoFramework::get_instance();