<?php

/**
 * Include all necessary framework files
 */
require_once("lib/mkd.layout.php");
require_once("lib/mkd.framework.php");
require_once("lib/mkd.functions.php");
require_once("lib/mkd.common.php");
require_once("admin/options/mkd-options-setup.php");
if ( mikado_one_mikado_core_installed() ) {
	require_once( "admin/meta-boxes/mkd-meta-boxes-setup.php" );
}

if(!function_exists( 'mikado_one_mikado_admin_scripts_init' )) {
	/**
	 * Function that only registers all scripts and styles that are used throughout admin
	 */
	function mikado_one_mikado_admin_scripts_init() {
		wp_register_style('mkdf-bootstrap', get_template_directory_uri().'/mkdinc/admin/assets/css/mkdf-bootstrap.css');
		wp_register_style('mkdf-jquery-ui', get_template_directory_uri().'/mkdinc/admin/assets/css/jquery-ui/jquery-ui.css');
		wp_register_style('mkdf-page-admin', get_template_directory_uri().'/mkdinc/admin/assets/css/mkdf-page.css');
		wp_register_style('mkdf-options-admin', get_template_directory_uri().'/mkdinc/admin/assets/css/mkdf-options.css');
		wp_register_style('mkdf-meta-boxes-admin', get_template_directory_uri().'/mkdinc/admin/assets/css/mkdf-meta-boxes.css');
		wp_register_style('mkdf-ui-admin', get_template_directory_uri().'/mkdinc/admin/assets/css/mkdf-ui/mkdf-ui.css');
		wp_register_style('mkdf-ui-import', get_template_directory_uri().'/mkdinc/admin/assets/css/mkdf-ui/mkdf-import.css');
		wp_register_style('mkdf-forms-admin', get_template_directory_uri().'/mkdinc/admin/assets/css/mkdf-forms.css');
		wp_register_style('elegant-icons-admin', get_template_directory_uri().'/mkdinc/admin/assets/css/elegant-icons/style.css');
		wp_register_style('font-awesome-admin', get_template_directory_uri().'/mkdinc/admin/assets/css/font-awesome/css/font-awesome.min.css');
		wp_register_script('bootstrap.min', get_template_directory_uri().'/mkdinc/admin/assets/js/bootstrap.min.js');
		wp_register_script('jquery.nouislider.min', get_template_directory_uri().'/mkdinc/admin/assets/js/mkdf-ui/jquery.nouislider.min.js');
		wp_register_script('mkdf-ui-admin', get_template_directory_uri().'/mkdinc/admin/assets/js/mkdf-ui/mkdf-ui.js');
		wp_register_script('mkdf-bootstrap-select', get_template_directory_uri().'/mkdinc/admin/assets/js/mkdf-ui/mkdf-bootstrap-select.min.js');
	}

	add_action('admin_init', 'mikado_one_mikado_admin_scripts_init');
}


if(!function_exists( 'mikado_one_mikado_enqueue_admin_styles' )) {
	/**
	 * Enqueue all styles that are needed for admin options page
	 */
	function mikado_one_mikado_enqueue_admin_styles() {
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_style('mkdf-bootstrap');
		wp_enqueue_style('mkdf-jquery-ui');
		wp_enqueue_style('mkdf-page-admin');
		wp_enqueue_style('mkdf-options-admin');
		wp_enqueue_style('mkdf-ui-admin');
		wp_enqueue_style('jquery.nouislider.min');
		wp_enqueue_style('mkdf-forms-admin');
		wp_enqueue_style('elegant-icons-admin');
		wp_enqueue_style('font-awesome-admin');
	}
}

if(!function_exists( 'mikado_one_mikado_enqueue_nav_menu_scripts' )) {
	/**
	 * Function that enqueues nav menu scripts. It does that by checking $hook variable
	 * @param $hook
	 */
	function mikado_one_mikado_enqueue_nav_menu_scripts($hook) {
		if($hook == 'nav-menus.php') {
			wp_enqueue_style('mkdf-nav-menu', get_template_directory_uri().'/mkdinc/admin/assets/css/mkdf-nav-menu.css');
		}
	}

	add_action('admin_enqueue_scripts', 'mikado_one_mikado_enqueue_nav_menu_scripts');
}


if(!function_exists( 'mikado_one_mikado_enqueue_styles_slider_taxonomy' )) {
	/**
	 * Enqueue styles when on slider taxonomy page in admin
	 */
	function mikado_one_mikado_enqueue_styles_slider_taxonomy() {
		if(isset($_GET['taxonomy']) && $_GET['taxonomy'] == 'slides_category') {
			mikado_one_mikado_enqueue_admin_styles();
		}
	}

	add_action('admin_print_scripts-edit-tags.php', 'mikado_one_mikado_enqueue_styles_slider_taxonomy');
}

if(!function_exists( 'mikado_one_mikado_enqueue_admin_scripts' )) {
	/**
	 * Enqueue all scripts that are needed for admin options page
	 */
	function mikado_one_mikado_enqueue_admin_scripts() {
		wp_enqueue_script('jquery-ui-datepicker');
		wp_enqueue_script('jquery-ui-accordion');
		wp_enqueue_script('wp-color-picker');
		wp_enqueue_script('bootstrap.min');
		wp_enqueue_media();
		wp_enqueue_script('jquery.nouislider.min');
		wp_enqueue_script('mkdf-ui-admin');
		wp_enqueue_script('mkdf-bootstrap-select');
	}
}

if(!function_exists( 'mikado_one_mikado_enqueue_meta_box_styles' )) {
	/**
	 * Enqueue all styles that are necessary for meta boxes
	 */
	function mikado_one_mikado_enqueue_meta_box_styles() {
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_style('mkdf-bootstrap');
		wp_enqueue_style('mkdf-jquery-ui');
		wp_enqueue_style('mkdf-page-admin');
		wp_enqueue_style('mkdf-meta-boxes-admin');
		wp_enqueue_style('mkdf-ui-admin');
		wp_enqueue_style('jquery.nouislider.min');
		wp_enqueue_style('mkdf-forms-admin');
		wp_enqueue_style('font-awesome-admin');
	}
}

if(!function_exists( 'mikado_one_mikado_enqueue_meta_box_scripts' )) {
	/**
	 * Enqueue all scripts that are needed for meta boxes
	 */
	function mikado_one_mikado_enqueue_meta_box_scripts() {
		wp_enqueue_script('jquery-ui-datepicker');
		wp_enqueue_script('jquery-ui-accordion');
		wp_enqueue_script('wp-color-picker');
		wp_enqueue_script('bootstrap.min');
		wp_enqueue_media();
		wp_enqueue_script('jquery.nouislider.min');
		wp_enqueue_script('mkdf-ui-admin');
	}
}



global $mkd_options;
$mkd_options  = get_option('mkd_options_mikado100');

if(!function_exists('init_mkd_theme_options')) {
	/**
	 * Function that initializes $mkd_options global variable.
	 * If options row does'nt exists in database it sets it to default options array
	 */
	function init_mkd_theme_options() {
		$mkd_options = mikado_one_mikado_return_global_options();
		$mkdFramework = mikado_one_mikado_return_framework();

		//is reset all options option set and equals to yes?
		if(isset($mkd_options['reset_to_defaults'])) {
			if( $mkd_options['reset_to_defaults'] == 'yes' ) {
				//remove theme options from db
				delete_option( "mkd_options_mikado100");
			}
		}

		//if theme options row don't exists in db
		if (!get_option("mkd_options_mikado100")) {
			add_option( "mkd_options_mikado100",
				$mkdFramework->mkdOptions->options
			);

			$mkd_options = $mkdFramework->mkdOptions->options;
		}
	}
}

if(!function_exists( 'mikado_one_mikado_strafter' )) {
	/**
	 * Function that returns string that comes after found string
	 * @param $string string where to search
	 * @param $substring string what to search for
	 * @return null|string string that comes after found string
	 */
	function mikado_one_mikado_strafter($string, $substring) {
		$pos = strpos($string, $substring);
		if ($pos === false) {
			return NULL;
		}

		return(substr($string, $pos+strlen($substring)));
	}
}


if(!function_exists( 'mikado_one_mikado_save_options' )) {
	/**
	 * Function that saves theme options via AJAX
	 * Hooks to wp_ajax_mkdf_save_options
	 * Defines mkd_after_theme_option_save hook
	 *
	 */
	function mikado_one_mikado_save_options() {
		$mkd_options = mikado_one_mikado_return_global_options();
		$mkdFramework = mikado_one_mikado_return_framework();
        
        if(current_user_can('administrator')) {
            $_REQUEST = stripslashes_deep($_REQUEST);
            
            check_ajax_referer( 'mkdf_ajax_save_nonce', 'mkdf_ajax_save_nonce' );

            foreach ($mkdFramework->mkdOptions->options as $key => $value) {
                if (isset($_REQUEST[ $key ])) {
                    $mkd_options[$key] = $_REQUEST[ $key ];
                }
            }

            update_option( 'mkd_options_mikado100', $mkd_options );
            //mkd_generate_dynamic_css_and_js();
            do_action('mikado_one_mikado_after_theme_option_save');
            echo "Saved";

            die();
        }
	}

	add_action('wp_ajax_mkdf_save_options', 'mikado_one_mikado_save_options');
}

/**
 * Remove the default Custom Fields meta box
 */

if(!function_exists( 'mikado_one_mikado_remove_default_custom_fields' )) {
	/**
	 * Function that removes default WordPress custom fields meta box
	 */
	function mikado_one_mikado_remove_default_custom_fields() {
		foreach ( array( 'normal', 'advanced', 'side' ) as $context ) {
			foreach ( array( "page", "post", "portfolio_page", "testimonials", "slides", "carousels" ) as $postType ) {
				remove_meta_box( 'postcustom', $postType, $context );
			}
		}
	}

	add_action('do_meta_boxes','mikado_one_mikado_remove_default_custom_fields');
}

if(!function_exists( 'mikado_one_mikado_admin_notice' )) {
    /**
     * Prints admin notice. It checks if notice has been disabled and if it hasn't then it displays it
     * @param $id string id of notice. It will be used to store notice dismis
     * @param $message string message to show to the user
     * @param $class string HTML class of notice
     * @param bool $is_dismisable whether notice is dismisable or not
     */
    function mikado_one_mikado_admin_notice($id, $message, $class, $is_dismisable = true) {
        $is_dismised = get_user_meta(get_current_user_id(), 'dismis_'.$id);

        //if notice isn't dismissed
        if(!$is_dismised && is_admin()) {
            echo '<div style="display: block;" class="'.esc_attr($class).' is-dismissible notice">';
            echo '<p>';

            echo wp_kses_post($message);

            if($is_dismisable) {
                echo '<strong style="display: block; margin-top: 7px;"><a href="'.esc_url(add_query_arg('mkd_dismis_notice', $id)).'">'.esc_html__('Dismiss this notice','mikado1').'</a></strong>';
            }

            echo '</p>';

            echo '</div>';
        }

    }
}

if(!function_exists( 'mikado_one_mikado_save_dismisable_notice' )) {
    /**
     * Updates user meta with dismisable notice. Hooks to admin_init action
     * in order to check this on every page request in admin
     */
    function mikado_one_mikado_save_dismisable_notice() {
        if(is_admin() && !empty($_GET['mkd_dismis_notice'])) {
            $notice_id = sanitize_key($_GET['mkd_dismis_notice']);
            $current_user_id = get_current_user_id();

            update_user_meta($current_user_id, 'dismis_'.$notice_id, 1);
        }
    }

    add_action('admin_init', 'mikado_one_mikado_save_dismisable_notice');
}

