<?php

if ( ! function_exists( 'mikado_one_mikado_pagination' ) ) {
	function mikado_one_mikado_pagination( $qode_blog_query ) {

		$mkd_options = mikado_one_mikado_return_global_options();

		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} elseif ( get_query_var( 'page' ) ) {
			$paged = get_query_var( 'page' );
		} else {
			$paged = 1;
		}

		if(isset($mkd_options['blog_page_range']) && $mkd_options['blog_page_range'] != "") {
			$max_number_of_pages = esc_attr( $mkd_options['blog_page_range'] );
		} else {
			$max_number_of_pages = $qode_blog_query->max_num_pages;
		}

		mikado_one_mikado_get_blog_pagination_html( $qode_blog_query->max_num_pages, $max_number_of_pages, $paged );

	}
}

if ( ! function_exists( 'mikado_one_mikado_get_blog_pagination_html' ) ) {
	function mikado_one_mikado_get_blog_pagination_html( $pages = '', $range = 4, $paged = 1 ) {

		$showitems = $range + 1;

		if ( 1 != $pages ) {
			echo "<div class='pagination'><ul>";
			if ( $paged > 2 && $paged > $range + 1 && $showitems < $pages ) {
				echo "<li class='first'><a href='" . get_pagenum_link( 1 ) . "'><span class='arrow_carrot-2left'></span></a></li>";
			}
			echo "<li class='prev";
			if ( $paged > 2 && $paged > $range + 1 && $showitems < $pages ) {
				echo " prev_first";
			}
			echo "'><a href='" . get_pagenum_link( $paged - 1 ) . "'><i class='arrow_carrot-left'></i></a></li>";

			for ( $i = 1; $i <= $pages; $i ++ ) {
				if ( 1 != $pages && ( ! ( $i >= $paged + $range + 1 || $i <= $paged - $range - 1 ) || $pages <= $showitems ) ) {
					if( $paged == $i ) { echo "<li class='active'><span>" . $i . "</span></li>"; } else { echo "<li><a href='" . get_pagenum_link( $i ) . "' class='inactive'>" . $i . "</a></li>"; }
				}
			}

			echo "<li class='next";
			if ( $paged < $pages - 1 && $paged + $range - 1 < $pages && $showitems < $pages ) {
				echo " next_last";
			}
			echo "'><a href=\"";
			if ( $pages > $paged ) {
				echo get_pagenum_link( $paged + 1 );
			} else {
				echo get_pagenum_link( $paged );
			}
			echo "\"><i class='arrow_carrot-right'></i></a></li>";

			if ( $paged < $pages - 1 && $paged + $range - 1 < $pages && $showitems < $pages ) {
				echo "<li class='last'><a href='" . get_pagenum_link( $pages ) . "'><span class='arrow_carrot-2right'></span></a></li>";
			}
			echo "</ul></div>\n";
		}
	}
}
?>