<?php
$mkd_options = mikado_one_mikado_return_global_options();

$blog_show_comments = "yes";
if (isset($mkd_options['blog_single_show_comments'])) {
    $blog_show_comments = esc_attr($mkd_options['blog_single_show_comments']);
}
$blog_show_author = "yes";
if (isset($mkd_options['blog_author_info'])) {
    $blog_show_author = esc_attr($mkd_options['blog_author_info']);
}
$blog_show_like = "no";
if (isset($mkd_options['blog_single_show_like'])) {
    $blog_show_like = esc_attr($mkd_options['blog_single_show_like']);
}
$blog_show_date = "yes";
if (isset($mkd_options['blog_single_show_date'])) {
    $blog_show_date = esc_attr($mkd_options['blog_single_show_date']);
}
$blog_show_social_share = "no";
if (isset($mkd_options['enable_social_share'])&& ($mkd_options['enable_social_share']) =="yes"){
    if (isset($mkd_options['post_types_names_post'])&& $mkd_options['post_types_names_post'] =="post"){
        if (isset($mkd_options['blog_single_show_social_share'])) {
            $blog_show_social_share = esc_attr($mkd_options['blog_single_show_social_share']);
        }
    }
}
$blog_show_category = "yes";
if (isset($mkd_options['blog_single_show_category'])) {
    $blog_show_category = esc_attr($mkd_options['blog_single_show_category']);
}
$blog_show_ql_icon_mark  = "yes";
if (isset($mkd_options['blog_single_show_ql_icon'])) {
    $blog_show_ql_icon_mark  = esc_attr($mkd_options['blog_single_show_ql_icon']);
}

$blog_ql_background_image = "no";
if(isset($mkd_options['blog_image_with_icon_centered_ql_background_image'])){
	$blog_ql_background_image = esc_attr($mkd_options['blog_image_with_icon_centered_ql_background_image']);
}

$background_image_object = wp_get_attachment_image_src(get_post_thumbnail_id( get_the_ID()), 'mikado-blog-image-format-link-quote');
$background_image_src = $background_image_object[0];

$_post_format = get_post_format();

$background_image_html = '';
$background_image_html_class = '';
if($blog_ql_background_image == "yes"){
	if(get_post_meta(get_the_ID(), "mkd_hide-featured-image", true) != "yes"){
		if($_post_format == "quote"){
			$background_image_html_class .=  ' quote_image';
		}elseif($_post_format == "link"){
			$background_image_html_class .=  ' link_image';
		}
		$background_image_html =  'background-image: url(' . esc_url($background_image_src ). ')';
	}
}
?>
<?php
	switch ($_post_format) {
		case "video":
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <div class="post_content_holder">
            <div class="post_image">
                <?php $_video_type = esc_attr(get_post_meta(get_the_ID(), "video_format_choose", true));?>
                <?php if($_video_type == "youtube") { ?>
                    <iframe  src="https://www.youtube.com/embed/<?php echo esc_url(get_post_meta(get_the_ID(), "video_format_link", true));  ?>?wmode=transparent" wmode="Opaque" frameborder="0" allowfullscreen></iframe>
                <?php } elseif ($_video_type == "vimeo"){ ?>
                    <iframe src="https://player.vimeo.com/video/<?php echo esc_url(get_post_meta(get_the_ID(), "video_format_link", true));  ?>?title=0&amp;byline=0&amp;portrait=0" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
                <?php } elseif ($_video_type == "self"){ ?>
                    <div class="video">
                        <div class="mobile-video-image" style="background-image: url(<?php echo esc_url(get_post_meta(get_the_ID(), "video_format_image", true));  ?>);"></div>
                        <div class="video-wrap"  >
                            <video class="video" poster="<?php echo esc_url(get_post_meta(get_the_ID(), "video_format_image", true));  ?>" preload="auto">
                                <?php if(get_post_meta(get_the_ID(), "video_format_webm", true) != "") { ?> <source type="video/webm" src="<?php echo esc_url(get_post_meta(get_the_ID(), "video_format_webm", true));  ?>"> <?php } ?>
                                <?php if(get_post_meta(get_the_ID(), "video_format_mp4", true) != "") { ?> <source type="video/mp4" src="<?php echo esc_url(get_post_meta(get_the_ID(), "video_format_mp4", true));  ?>"> <?php } ?>
                                <?php if(get_post_meta(get_the_ID(), "video_format_ogv", true) != "") { ?> <source type="video/ogg" src="<?php echo esc_url(get_post_meta(get_the_ID(), "video_format_ogv", true));  ?>"> <?php } ?>
                                <object width="320" height="240" type="application/x-shockwave-flash" data="<?php echo get_template_directory_uri(); ?>/js/flashmediaelement.swf">
                                    <param name="movie" value="<?php echo get_template_directory_uri(); ?>/js/flashmediaelement.swf" />
                                    <param name="flashvars" value="controls=true&file=<?php echo esc_url(get_post_meta(get_the_ID(), "video_format_mp4", true));  ?>" />
                                    <img src="<?php echo esc_url(get_post_meta(get_the_ID(), "video_format_image", true));  ?>" width="1920" height="800" title="<?php esc_attr_e( 'No video playback capabilities', 'mikado1' ); ?>" alt="<?php esc_attr_e( 'Video thumb', 'mikado1' ); ?>" />
                                </object>
                            </video>
                        </div></div>
                <?php } ?>
            </div>
            <div class="post_text">
                <div class="post_text_inner">
					<?php if($blog_show_category == "yes"){ ?>
						<span class="post_category"><?php the_category(', '); ?></span>
					<?php } ?>
					<h2><?php the_title(); ?></h2>
                    <?php the_content(); ?>
					<?php if(($blog_show_date == "yes") || ($blog_show_author == "yes") || ($blog_show_comments == "yes") || ($blog_show_like == "yes") || ($blog_show_social_share == "yes")){ ?>
						<div class="post_info">
							<?php if($blog_show_date == "yes"){ ?>
								<div class="date"><?php the_time('d M Y'); ?></div>
							<?php } ?>
							<?php if($blog_show_author == "yes") { ?>
								<div class="post_author">
									<span><?php esc_html_e('by','mikado1'); ?></span>
									<a class="post_author_link" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>">
										<?php the_author_meta('display_name'); ?>
									</a>
								</div>
							<?php } ?>
							<?php if($blog_show_comments == "yes"){ ?>
								<div>
									<a class="post_comments" href="<?php comments_link(); ?>" target="_self">
										<?php comments_number('0 ' . esc_html__('Comments','mikado1'), '1 '.esc_html__('Comment','mikado1'), '% '.esc_html__('Comments','mikado1') ); ?>
									</a>
								</div>
							<?php } ?>
							<?php if($blog_show_like == "yes") { ?>
								<div class="blog_like">
									<?php if( function_exists('mkd_like') ) mkd_like(); ?>
								</div>
							<?php } ?>
							<?php if($blog_show_social_share == "yes") { ?>
								<div>
									<?php if(mikado_one_mikado_is_plugin_installed()) { echo do_shortcode('[no_social_share]'); } ?>
								</div>
							<?php } ?>
						</div>
					<?php } ?>
                </div>
            </div>
        </div>
<?php
		break;
		case "audio":
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <div class="post_content_holder">
                <?php if(get_post_meta(get_the_ID(), "mkd_hide-featured-image", true) != "yes") {
                     if ( has_post_thumbnail() ) { ?>
                        <div class="post_image">
                            <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                                <?php the_post_thumbnail('full'); ?>
                            </a>
                        </div>
                        <div class="mkd_icon circle center">
                             <span class="mkd_font_elegant_holder_icon circle">
                                  <span class="mkd_font_elegant_icon icon_volume-high_alt" aria-hidden="true"></span>
                             </span>
                        </div>
                <?php }} ?>
            <div class="audio_image">
                <audio class="blog_audio" src="<?php echo esc_url(get_post_meta(get_the_ID(), "audio_link", true)); ?>" controls="controls">
                    <?php esc_html_e("Your browser don't support audio player","mikado1"); ?>
                </audio>
            </div>
            <div class="post_text">
                <div class="post_text_inner">
					<?php if($blog_show_category == "yes"){ ?>
						<span class="post_category"><?php the_category(', '); ?></span>
					<?php } ?>
					<h2><?php the_title(); ?></h2>
                    <?php the_content(); ?>
					<?php if(($blog_show_date == "yes") || ($blog_show_author == "yes") || ($blog_show_comments == "yes") || ($blog_show_like == "yes") || ($blog_show_social_share == "yes")){ ?>
						<div class="post_info">
							<?php if($blog_show_date == "yes"){ ?>
								<div class="date"><?php the_time('d M Y'); ?></div>
							<?php } ?>
							<?php if($blog_show_author == "yes") { ?>
								<div class="post_author">
									<span><?php esc_html_e('by','mikado1'); ?></span>
									<a class="post_author_link" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>">
										<?php the_author_meta('display_name'); ?>
									</a>
								</div>
							<?php } ?>
							<?php if($blog_show_comments == "yes"){ ?>
								<div>
									<a class="post_comments" href="<?php comments_link(); ?>" target="_self">
										<?php comments_number('0 ' . esc_html__('Comments','mikado1'), '1 '.esc_html__('Comment','mikado1'), '% '.esc_html__('Comments','mikado1') ); ?>
									</a>
								</div>
							<?php } ?>
							<?php if($blog_show_like == "yes") { ?>
								<div class="blog_like">
									<?php if( function_exists('mkd_like') ) mkd_like(); ?>
								</div>
							<?php } ?>
							<?php if($blog_show_social_share == "yes") { ?>
								<div>
									<?php if(mikado_one_mikado_is_plugin_installed()) { echo do_shortcode('[no_social_share]'); } ?>
								</div>
							<?php } ?>
						</div>
					<?php } ?>
                </div>
            </div>
        </div>
	
<?php
		break;
		case "link":
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<div class="post_content_holder">
				<div class="post_text <?php echo esc_attr($background_image_html_class); ?>" <?php mikado_one_mikado_style_attr($background_image_html); ?>>
                    <div class="post_text_inner">
						<?php if($blog_show_category == "yes"){ ?>
							<span class="post_category"><?php the_category(', '); ?></span>
						<?php } ?>
                        <div class="post_title">
							<?php $title_link = get_post_meta(get_the_ID(), "title_link", true) != '' ? esc_url(get_post_meta(get_the_ID(), "title_link", true)) : 'javascript: void(0)'; ?>
							<h3><a href="<?php echo esc_url($title_link); ?>"><?php the_title(); ?></a></h3>
                        </div>
						<?php if(($blog_show_date == "yes") || ($blog_show_author == "yes") || ($blog_show_comments == "yes") || ($blog_show_like == "yes") || ($blog_show_social_share == "yes")){ ?>
							<div class="post_info">
								<div class="post_info_inner">
									<?php if($blog_show_date == "yes") { ?>
										<div class="date"><?php the_time('d.M y'); ?></div>
									<?php } ?>
									<?php if($blog_show_author == "yes") { ?>
										<div class="post_author">
											<span><?php esc_html_e('by','mikado1'); ?></span>
											<a class="post_author_link" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>">
												<?php the_author_meta('display_name'); ?>
											</a>
										</div>
									<?php } ?>
									<?php if($blog_show_comments == "yes"){ ?>
										<div>
											<a class="post_comments" href="<?php comments_link(); ?>" target="_self">
												<?php comments_number('0 ' . esc_html__('Comments','mikado1'), '1 '.esc_html__('Comment','mikado1'), '% '.esc_html__('Comments','mikado1') ); ?>
											</a>
										</div>
									<?php } ?>
									<?php if($blog_show_like == "yes") { ?>
										<div class="blog_like">
											  <?php if( function_exists('mkd_like') ) mkd_like(); ?>
										 </div>
									<?php } ?>
									<?php if($blog_show_social_share == "yes"){ ?>
										<div>
											<?php if(mikado_one_mikado_is_plugin_installed()) { echo do_shortcode('[no_social_share]'); } ?>
										</div>
									<?php } ?>
								</div>
							</div>
						<?php } ?>
                        <div class="mkd_icon circle center">
                            <span class="mkd_font_elegant_holder_icon circle">
                                <span class="mkd_font_elegant_icon icon_paperclip" aria-hidden="true"></span>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="post_content"><?php the_content(); ?></div>
            </div>
<?php
		break;
		case "gallery":
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <div class="post_content_holder">
                <div class="icon_border">
                    <div class="post_image">
						<?php get_template_part('templates/blog/parts/post-format-gallery-slider'); ?>
                        <div class="mkd_icon circle center">
                             <span class="mkd_font_elegant_holder_icon circle">
                                 <span class="mkd_font_elegant_icon icon_images" aria-hidden="true"></span>
                             </span>
                        </div>
                    </div>
                </div>
                <div class="post_text">
                    <div class="post_text_inner">
						<?php if($blog_show_category == "yes"){ ?>
							<span class="post_category"><?php the_category(', '); ?></span>
						<?php } ?>
						<h2><?php the_title(); ?></h2>
						<?php the_content(); ?>
						<?php if(($blog_show_date == "yes") || ($blog_show_author == "yes") || ($blog_show_comments == "yes") || ($blog_show_like == "yes") || ($blog_show_social_share == "yes")){ ?>
							<div class="post_info">
								<?php if($blog_show_date == "yes"){ ?>
									<div class="date"><?php the_time('d M Y'); ?></div>
								<?php } ?>
								<?php if($blog_show_author == "yes") { ?>
									<div class="post_author">
										<span><?php esc_html_e('by','mikado1'); ?></span>
										<a class="post_author_link" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>">
											<?php the_author_meta('display_name'); ?>
										</a>
									</div>
								<?php } ?>
								<?php if($blog_show_comments == "yes"){ ?>
									<div>
										<a class="post_comments" href="<?php comments_link(); ?>" target="_self">
											<?php comments_number('0 ' . esc_html__('Comments','mikado1'), '1 '.esc_html__('Comment','mikado1'), '% '.esc_html__('Comments','mikado1') ); ?>
										</a>
									</div>
								<?php } ?>
								<?php if($blog_show_like == "yes") { ?>
									<div class="blog_like">
										<?php if( function_exists('mkd_like') ) mkd_like(); ?>
									</div>
								<?php } ?>
								<?php if($blog_show_social_share == "yes") { ?>
									<div>
										<?php if(mikado_one_mikado_is_plugin_installed()) { echo do_shortcode('[no_social_share]'); } ?>
									</div>
								<?php } ?>
							</div>
						<?php } ?>
                    </div>
                </div>
            </div>		
<?php
		break;
		case "quote":
?>
			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				<div class="post_content_holder">
					<div class="post_text <?php echo esc_attr($background_image_html_class); ?>" <?php mikado_one_mikado_style_attr($background_image_html); ?>>
                        <div class="post_text_inner">
							<?php if($blog_show_category == "yes"){ ?>
								<span class="post_category"><?php the_category(', '); ?></span>
							<?php } ?>
                            <div class="post_title">
                                <h3><?php echo esc_html(get_post_meta(get_the_ID(), "quote_format", true)); ?></h3>
								<span class="quote_author">&mdash; <?php the_title(); ?></span>
                            </div>
							<?php if(($blog_show_date == "yes") || ($blog_show_author == "yes") || ($blog_show_comments == "yes") || ($blog_show_like == "yes") || ($blog_show_social_share == "yes")){ ?>
								<div class="post_info">
									<div class="post_info_inner">
										<?php if($blog_show_date == "yes") { ?>
											<div class="date"><?php the_time('d.M y'); ?></div>
										<?php } ?>
										<?php if($blog_show_author == "yes") { ?>
											<div class="post_author">
												<span><?php esc_html_e('by','mikado1'); ?></span>
												<a class="post_author_link" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>">
													<?php the_author_meta('display_name'); ?>
												</a>
											</div>
										<?php } ?>
										<?php if($blog_show_comments == "yes"){ ?>
											<div>
												<a class="post_comments" href="<?php comments_link(); ?>" target="_self">
													<?php comments_number('0 ' . esc_html__('Comments','mikado1'), '1 '.esc_html__('Comment','mikado1'), '% '.esc_html__('Comments','mikado1') ); ?>
												</a>
											</div>
										<?php } ?>
										<?php if($blog_show_like == "yes") { ?>
											<div class="blog_like">
												  <?php if( function_exists('mkd_like') ) mkd_like(); ?>
											 </div>
										<?php } ?>
										<?php if($blog_show_social_share == "yes"){ ?>
											<div>
												<?php if(mikado_one_mikado_is_plugin_installed()) { echo do_shortcode('[no_social_share]'); } ?>
											</div>
										<?php } ?>
									</div>
								</div>
							<?php } ?>
                            <div class="mkd_icon circle center">
                                <span class="mkd_font_elegant_holder_icon circle">
                                     <span class="mkd_font_elegant_icon icon_quotations" aria-hidden="true"></span>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="post_content"><?php the_content(); ?></div>
				</div>
<?php
		break;
		default:
?>
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <div class="post_content_holder">
                <?php if(get_post_meta(get_the_ID(), "mkd_hide-featured-image", true) != "yes") {
                     if ( has_post_thumbnail() ) { ?>
                        <div class="icon_border">
                            <div class="post_image">
                                <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                                    <?php the_post_thumbnail('full'); ?>
                                </a>
                            </div>
                            <div class="mkd_icon circle center">
                                  <span class="mkd_font_elegant_holder_icon circle">
                                       <span class="mkd_font_elegant_icon icon_documents_alt" aria-hidden="true"></span>
                                  </span>
                            </div>
                        </div>
                <?php }} ?>
                <div class="post_text">
                    <div class="post_text_inner">
						<?php if($blog_show_category == "yes"){ ?>
							<span class="post_category"><?php the_category(', '); ?></span>
						<?php } ?>
						<h2><?php the_title(); ?></h2>
                        <?php the_content(); ?>
						<?php if(($blog_show_date == "yes") || ($blog_show_author == "yes") || ($blog_show_comments == "yes") || ($blog_show_like == "yes") || ($blog_show_social_share == "yes")){ ?>
							<div class="post_info">
								<?php if($blog_show_date == "yes"){ ?>
									<div class="date"><?php the_time('d M Y'); ?></div>
								<?php } ?>
								<?php if($blog_show_author == "yes") { ?>
									<div class="post_author">
										<span><?php esc_html_e('by','mikado1'); ?></span>
										<a class="post_author_link" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>">
											<?php the_author_meta('display_name'); ?>
										</a>
									</div>
								<?php } ?>
								<?php if($blog_show_comments == "yes"){ ?>
									<div>
										<a class="post_comments" href="<?php comments_link(); ?>" target="_self">
											<?php comments_number('0 ' . esc_html__('Comments','mikado1'), '1 '.esc_html__('Comment','mikado1'), '% '.esc_html__('Comments','mikado1') ); ?>
										</a>
									</div>
								<?php } ?>
								<?php if($blog_show_like == "yes") { ?>
									<div class="blog_like">
										<?php if( function_exists('mkd_like') ) mkd_like(); ?>
									</div>
								<?php } ?>
								<?php if($blog_show_social_share == "yes") { ?>
									<div>
										<?php if(mikado_one_mikado_is_plugin_installed()) { echo do_shortcode('[no_social_share]'); } ?>
									</div>
								<?php } ?>
							</div>
						<?php } ?>
                    </div>
                </div>
            </div>
<?php
}
?>
