<?php
//get global variables
$mkd_options = mikado_one_mikado_return_global_options();

//init variables
$container_styles			= '';

//is page background color set for current page?
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_background_color", true) != ""){
	$container_styles .= 'background-color: '. esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_page_background_color", true)).';';
}

//get current portfolio template
$portfolio_template = 'small-images';
if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_choose-portfolio-single-view", true) != "") {
	$portfolio_template = esc_attr(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_choose-portfolio-single-view", true));
} elseif($mkd_options['portfolio_style'] !== '') {
	$portfolio_template = esc_attr($mkd_options['portfolio_style']);
}

if(get_post_meta(mikado_one_mikado_get_page_id(), "mkd_content-top-padding", true) != ""){
	$content_style = 'padding-top: '.get_post_meta(mikado_one_mikado_get_page_id(), "mkd_content-top-padding", true).'px';
}else{
	$content_style = "";
}
?>

<div class="container" <?php mikado_one_mikado_style_attr($container_styles); ?>>
	<div class="container_inner default_template_holder clearfix" <?php mikado_one_mikado_style_attr($content_style); ?>>
		<div class="portfolio_single <?php echo esc_attr($portfolio_template); ?>">
			<?php
				if (post_password_required()) {
					echo get_the_password_form();
				} else {
					//load proper portfolio file based on portfolio template
					get_template_part('templates/portfolio/portfolio', $portfolio_template);

					get_template_part('templates/portfolio/parts/portfolio-navigation');

					get_template_part('templates/portfolio/parts/portfolio-comments');
				}
			?>
		</div> <!-- close div.portfolio single -->
	</div> <!-- close div.container inner -->
</div> <!-- close div.container -->