<?php

$args = array(
    "type"                          => "",
    "background_color"              => "",
    "background_transparency"       => "",
	'without_double_border'			=> "",
    "border_color"                  => "",
    "border_width"                  => "",
	"icon_pack"             		=> "",
	"fa_icon"               		=> "",
	"fe_icon"               		=> "",
    "size"                          => "",
    "icon_color"                    => "",
    "image"                         => "",
    "text_in_circle"                => "",
    "text_in_circle_tag"            => "h4",
    "font_size"                     => "",
    "text_in_circle_color"          => "",
    "link"                          => "",
    "link_target"                   => "_self",
    "title"                         => "",
    "title_tag"                     => "h4",
    "title_color"                   => "",
    "title_alignment"                => "",
    "text"                          => "",
    "text_color"                    => "",
    "text_alignment"                => ""

);

extract(shortcode_atts($args, $atts));

$type = esc_attr($type);
$background_color = esc_attr($background_color);
$background_transparency = esc_attr($background_transparency);
$without_double_border = esc_attr($without_double_border);
$border_color = esc_attr($border_color);
$border_width = esc_attr($border_width);
$icon_pack = esc_attr($icon_pack);
$fa_icon = esc_attr($fa_icon);
$fe_icon = esc_attr($fe_icon);
$size = esc_attr($size);
$icon_color = esc_attr($icon_color);
$image = esc_attr($image);
$text_in_circle = esc_html($text_in_circle);
$text_in_circle_tag = esc_attr($text_in_circle_tag);
$font_size = esc_attr($font_size);
$text_in_circle_color = esc_attr($text_in_circle_color);
$link = esc_url($link);
$link_target = esc_attr($link_target);
$title = esc_html($title);
$title_tag = esc_attr($title_tag);
$title_color = esc_attr($title_color);
$title_alignment = esc_attr($title_alignment);
$text = esc_html($text);
$text_color = esc_attr($text_color);
$text_alignment = esc_attr($text_alignment);

$headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');
//get correct heading value. If provided heading isn't valid get the default one
$title_tag = (in_array($title_tag, $headings_array)) ? $title_tag : $args['title_tag'];
$text_in_circle_tag = (in_array($text_in_circle_tag, $headings_array)) ? $text_in_circle_tag : $args['text_in_circle_tag'];

$html                  		= '';
$image_src             		= '';
$image_alt             		= '';
$circle_style          		= '';
$circle_wrapper_style		= '';
$border_class          		= '';
$text_in_circle_style  		= '';
$icon_style            		= '';
$title_style           		= '';
$text_style            		= '';
$circle_wrapper_classes  	= $type;
$image_with_text_style  = '';
$image_with_text_class  = '';


if($background_color !== "") {
    if($background_transparency !== "") {
        $bg_color = mikado_one_mikado_hex2rgb($background_color);
        $circle_style .= "background-color: rgba(". $bg_color[0]."," . $bg_color[1] . "," . $bg_color[2] . "," . $background_transparency . ");";
    } else {
        
        $circle_style .= "background-color: ".$background_color.";";
        
    }
}

if($border_color !== "") {
    $circle_style .= " border-color: ".$border_color.";";
	$circle_wrapper_style .= " border-color: ".$border_color.";";
}
if(esc_attr($border_width) > 5) {
	$border_class = " big_border";
}
if($border_width !== "") {
    $circle_style .= "border-width: ".$border_width."px;";
	$circle_wrapper_style .= "border-width: ".$border_width."px;";
}

if($text_in_circle_color !== "") {
    $text_in_circle_style .= "color: ".$text_in_circle_color.";";
}

if($font_size !== "") {
    $text_in_circle_style .= " font-size: ".$font_size."px;";
}

if($icon_color !== "") {
    $icon_style .= "color: ".$icon_color.';';
}

if($size !== '') {
	$icon_style .= "font-size: ".$size.'px;';
}

if($title_color !== "") {
    $title_style .= "color: ".$title_color;
}

if($text_color !== "") {
    $text_style .= "color: ".$text_color;
}

if($without_double_border == 'yes') {
	$circle_wrapper_classes .= ' without_double_border';
}

$html .= '<li class="mkd_circle_outer '.$circle_wrapper_classes.'">';

if($link !== ""){
    $html .= '<a href="'.$link.'" target="'.$link_target.'">';
}
if ($type == "image_with_text_type"){
    if (is_numeric($image)) {
        $image_src = wp_get_attachment_url($image);
        $image_alt = esc_attr(get_post_meta($image, '_wp_attachment_image_alt', true));
    }
    if($image_src !== ""){
        $image_with_text_style .= 'background: url('.$image_src.')';
        $image_with_text_class .= 'image_with_text';
    }
}
$html .= '<span class="mkd_circle_inner'. $border_class.' " style="'.$circle_wrapper_style.'"><span class="mkd_circle_inner2 '.$image_with_text_class.'" style="'.$circle_style.' '.$image_with_text_style.'">';

if($type == "image_type"){

    if (is_numeric($image)) {
        $image_src = wp_get_attachment_url($image);
        $image_alt = esc_attr(get_post_meta($image, '_wp_attachment_image_alt', true));
    }

    if($image_src !== ""){
        $html .= '<img class="mkd_image_in_circle" src="'.$image_src.'" alt="'.$image_alt.'" />';
    }

} else if ($type == "icon_type"){
	if($icon_pack == "font_awesome" && $fa_icon !== ""){
		$html .= '<i class="process_icon fa '.$fa_icon.'" style="'.$icon_style.'"></i>';
	}
	elseif($icon_pack == "font_elegant" && $fe_icon !== ""){
		$html .= '<span class="process_icon mkd_font_elegant_icon '.$fe_icon.'" style="'.$icon_style.'" ></span>';
	}
} else if ($type == "text_type"){
    $html .= '<'.$text_in_circle_tag.' class="mkd_text_in_circle" style="'.$text_in_circle_style.'">'.$text_in_circle.'</'.$text_in_circle_tag.'>';
}
else if ($type == "image_with_text_type"){
    $html .= '<'.$text_in_circle_tag.' class="mkd_text_in_circle" style="'.$text_in_circle_style.'">'.$text_in_circle.'</'.$text_in_circle_tag.'>';
}

$html .= '</span></span>';

if($link !== ""){
    $html .= '</a>';
}

if($title !== "" || $text !== ""){
    $html .= '<div class="mkd_circle_text_holder  '.$title_alignment.' '.$text_alignment.' ">';

    if($title !== ""){
        $html .= '<'.$title_tag.' class="mkd_circle_title" style="'.$title_style.'">'.$title.'</'.$title_tag.'>';
    }

    if($text !== ""){
        $html .= '<p class="mkd_circle_text" style="'.$text_style.'">'.$text.'</p>';
    }

    $html .= '</div>';
}

$html .= '</li>';

echo mikado_one_mikado_get_module_part($html);