<?php

$args = array(
    "background_color"			=> "",
    "title"             		=> "",
	"title_color"	    		=> "",
	"title_font_size"   		=> "",
	"title_tag"		    		=> "h5",
    "title_font_family"   		=> "",
    "title_font_weight"   		=> "700",
    "text"			    		=> "",
	"text_color"	    		=> "",
	"text_font_size"    		=> "",
	"price"             		=> "0",
	"price_color"	    		=> "",
    "price_font_family"     	=> "",
	"price_font_size"   		=> "",
    "price_font_weight"	  		=> "",
    "price_font_style"	  		=> "",
    "separator"		        	=> "",
    "separator_color"			=> "",
    "separator_type"			=> "",
    "separator_width"			=> "",
    "separator_position_top"	=> "",
    "separator_position_bottom"	=> ""

);

extract(shortcode_atts($args, $atts));

$background_color = esc_attr($background_color);
$title = esc_html($title);
$title_color = esc_attr($title_color);
$title_font_size = esc_attr($title_font_size);
$title_tag = esc_attr($title_tag);
$title_font_family = esc_attr($title_font_family);
$title_font_weight = esc_attr($title_font_weight);
$text = esc_html($text);
$text_color = esc_attr($text_color);
$text_font_size = esc_attr($text_font_size);
$price = esc_html($price);
$price_color = esc_attr($price_color);
$price_font_family = esc_attr($price_font_family);
$price_font_size = esc_attr($price_font_size);
$price_font_weight = esc_attr($price_font_weight);
$price_font_style = esc_attr($price_font_style);
$separator = esc_attr($separator);
$separator_color = esc_attr($separator_color);
$separator_type = esc_attr($separator_type);
$separator_width = esc_attr($separator_width);
$separator_position_top = esc_attr($separator_position_top);
$separator_position_bottom = esc_attr($separator_position_bottom);

$headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');

//get correct heading value. If provided heading isn't valid get the default one
$title_tag = (in_array($title_tag, $headings_array)) ? $title_tag : $args['title_tag'];

//init variables
$html 			    = '';
$title_styles 	    = '';
$text_styles 	    = '';
$price_styles 	    = '';
$separator_styles  	= '';
$separator_bottom_styles = '';
$background_styles  = '';

//generate title styles
if($background_color !== '') {
    $background_styles .= 'background-color: '.$background_color.';';
}
if($title_color !== '') {
	$title_styles .= 'color: '.$title_color.';';
}

if($title_font_size !== '') {
	$title_styles .= 'font-size: '.$title_font_size.'px;';
}

if($title_font_family !== '') {
    $title_styles .= 'font-family: '.$title_font_family.';';
}

if($title_font_weight !== '') {
    $title_styles .= 'font-weight: '.$title_font_weight.';';
}

//generate text styles
if($text_color !== '') {
	$text_styles .= 'color: '.$text_color.';';
}

if($text_font_size !== '') {
	$text_styles .= 'font-size: '.$text_font_size.'px;';
}

//generate price styles
if($price_color !== '') {
	$price_styles .= 'color: '.$price_color.';';
}

if($price_font_size !== '') {
	$price_styles .= 'font-size: '.$price_font_size.'px;';
}

if($price_font_family !== '') {
    $price_styles .= 'font-family: '.$price_font_family.';';
}
if($price_font_style !== '') {
    $price_styles .= 'font-style: '.$price_font_style.';';
}
if($price_font_weight !== '') {
    $price_styles .= 'font-weight: '.$price_font_weight.';';
}
//generate separator styles
if($separator !== 'no') {
	$separator_styles .= 'style="';
    if($separator_color !== '') {
        $separator_styles .= 'border-bottom-color: ' . $separator_color . ';';
    }
    if($separator_type !== '') {
        $separator_styles .= 'border-bottom-style: ' . $separator_type . ';';
    }
    if($separator_width !== '') {
        if(!strstr($separator_width, 'px')) {
            $separator_width .= 'px';
        }
        $separator_styles .= 'border-bottom-width: ' . $separator_width . ';';
    }
    if($separator_position_top !== '') {
    	if(!strstr($separator_position_top, 'px')) {
            $separator_position_top .= 'px';
        }
        $separator_styles .= 'padding-bottom: ' . $separator_position_top . ';';
    }
    if($separator_position_bottom !== '') {
    	if(!strstr($separator_position_bottom, 'px')) {
            $separator_position_bottom .= 'px';
        }
        $separator_bottom_styles .= 'style="';
        $separator_bottom_styles .= 'margin-bottom: ' . $separator_position_bottom . ';';
        $separator_bottom_styles .= '"';
    }

    $separator_styles .= '"';
}

$html .='<li class="mkd_pricing_list_item" '.$separator_styles.'>';
$html .='<div class="mkd_pricing_item_text" style="'.$background_styles.'">';
$html .= '<'.$title_tag.' class="mkd_pricing_item_title" style="'.$title_styles.'">'.$title.'</'.$title_tag.'>';
$html .= '</div>'; //close div.mkd_pricing_item_text
$html .= '<div class="mkd_pricing_item_price"  style="'.$background_styles.'">';
$html .= '<span style="'.$price_styles.'">'.$price.'</span>';
$html .= '</div>'; // close div.mkd_pricing_item_price
$html .= '</li>'; // close li.mkd_pricing_list_item

$html .= '<li class="mkd_pricing_item_includes_text" '.$separator_bottom_styles.'><p style="'.$text_styles.'">'.$text.'</p></li>';
// has to be in li tag, but it is not in pricing_list_item because of ::after on li element


echo mikado_one_mikado_get_module_part($html);

