<?php
class Woocommerce_Dropdown_Cart extends WP_Widget {

	public function __construct() {
		parent::__construct(
			'woocommerce-dropdown-cart', // Base ID
			'Woocommerce Dropdown Cart', // Name
			array( 'description' => esc_html__( 'Woocommerce Dropdown Cart','mikado1' ), ) // Args
		);
	}

	public function widget( $args, $instance ) {
		global $post;
		extract( $args );
		global $woocommerce; ?>
		<div class="shopping_cart_outer">
			<div class="shopping_cart_inner">
				<div class="shopping_cart_header">
					<a class="header_cart" href="<?php echo esc_url(wc_get_cart_url()); ?>"><i class="icon_cart_alt"></i><span class="header_cart_span"><?php echo esc_html($woocommerce->cart->cart_contents_count); ?></span></a>
					<div class="shopping_cart_dropdown">
						<div class="shopping_cart_dropdown_inner1">
							<?php
							$cart_is_empty = sizeof( $woocommerce->cart->get_cart() ) <= 0;
							$list_class = array( 'cart_list', 'product_list_widget' );
							?>
							<ul>

								<?php if ( !$cart_is_empty ) : ?>

									<?php foreach ( $woocommerce->cart->get_cart() as $cart_item_key => $cart_item ) :
										$_product = $cart_item['data'];

										// Only display if allowed
										if ( ! $_product->exists() || $cart_item['quantity'] == 0 ) {
											continue;
										}

										// Get price
										$product_price = get_option( 'woocommerce_tax_display_cart' ) == 'excl' ? wc_get_price_excluding_tax($_product) : wc_get_price_including_tax($_product);
										?>


										<li>
											<div class="item_image_holder">
												<a href="<?php echo get_permalink( $cart_item['product_id'] ); ?>">
													<?php echo wp_kses($_product->get_image(), array(
														'img' => array(
														'src' => true,
														'width' => true,
														'height' => true,
														'class' => true,
														'alt' => true,
														'title' => true,
														'id' => true
														)
													)); ?>
												</a>
											</div>
											<div class="item_info_holder">
												<div class="item_left">
													<a href="<?php echo get_permalink( $cart_item['product_id'] ); ?>">
														<?php echo apply_filters('woocommerce_widget_cart_product_title', $_product->get_title(), $_product ); ?>
													</a>
													<span class="quantity"><?php esc_html_e('Quantity: ','mikado1'); echo esc_html($cart_item['quantity']); ?>
												</div>
												<div class="item_right">
													<?php echo apply_filters( 'woocommerce_cart_item_price_html', wc_price( $product_price ), $cart_item, $cart_item_key ); ?>
													<?php echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf('<a href="%s" class="remove" title="%s">&times;</a>', esc_url( $woocommerce->cart->get_remove_url( $cart_item_key ) ), esc_html__('Remove this item','mikado1') ), $cart_item_key ); ?>

												</div>
											</div>
										</li>

									<?php endforeach; ?>
									<div class="cart_bottom">
										<div class="subtotal_holder">
											<span class="total"><?php esc_html_e( 'Total', 'mikado1' ); ?>:</span>
											<span class="total_amount">
												<?php echo wp_kses($woocommerce->cart->get_cart_subtotal(), array(
													'span' => array(
														'class' => true,
														'id' => true
													)
												)); ?>
											</span>
										</div>
										<div class="btns_holder">
											<a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="qbutton small view-cart"><?php esc_html_e( 'Shopping Bag', 'mikado1' ); ?></a>
											<a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" class="qbutton small checkout"><?php esc_html_e( 'Checkout', 'mikado1' ); ?><span class="arrow_right" aria-hidden="true"></span></a>
										</div>
									</div>
								<?php else : ?>

									<li class="empty_cart"><?php esc_html_e( 'No products in the cart.', 'mikado1' ); ?></li>

								<?php endif; ?>

							</ul>
						</div>
						<?php if ( sizeof( $woocommerce->cart->get_cart() ) <= 0 ) : ?>

						<?php endif; ?>
						

						<?php if ( sizeof( $woocommerce->cart->get_cart() ) <= 0 ) : ?>

						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
		<?php
	}


	public function update( $new_instance, $old_instance ) {
		$instance = array();

		return $instance;
	}

}

add_action( 'widgets_init', function() {
	do_action('mikado_one_mikado_register_woocommece_dropdown_cart');
});


?>
<?php
if(!function_exists('woocommerce_header_add_to_cart_fragment')) {

	function woocommerce_header_add_to_cart_fragment( $fragments ) {
		global $woocommerce;
		ob_start();
		?>
        <div class="shopping_cart_header">
            <a class="header_cart" href="<?php echo esc_url( wc_get_cart_url() ); ?>"><i class="icon_cart_alt"></i><span
                        class="header_cart_span"><?php echo esc_html( $woocommerce->cart->cart_contents_count ); ?></span></a>
            <div class="shopping_cart_dropdown">
                <div class="shopping_cart_dropdown_inner1">
					<?php
					$cart_is_empty = sizeof( $woocommerce->cart->get_cart() ) <= 0;
					//$list_class = array( 'cart_list', 'product_list_widget' );
					?>
                    <ul>

						<?php if ( ! $cart_is_empty ) : ?>

							<?php foreach ( $woocommerce->cart->get_cart() as $cart_item_key => $cart_item ) :

								$_product = $cart_item['data'];

								// Only display if allowed
								if ( ! $_product->exists() || $cart_item['quantity'] == 0 ) {
									continue;
								}

								// Get price
								$product_price = get_option( 'woocommerce_tax_display_cart' ) == 'excl' ? wc_get_price_excluding_tax( $_product ) : wc_get_price_including_tax( $_product );
								?>

                                <li>
                                    <div class="item_image_holder">
                                        <a href="<?php echo get_permalink( $cart_item['product_id'] ); ?>">
											<?php echo wp_kses( $_product->get_image(), array(
												'img' => array(
													'src'    => true,
													'width'  => true,
													'height' => true,
													'class'  => true,
													'alt'    => true,
													'title'  => true,
													'id'     => true
												)
											) ); ?>
                                        </a>
                                    </div>
                                    <div class="item_info_holder">
                                        <div class="item_left">
                                            <a href="<?php echo get_permalink( $cart_item['product_id'] ); ?>">
												<?php echo apply_filters( 'woocommerce_widget_cart_product_title', $_product->get_title(), $_product ); ?>
                                            </a>
                                            <span class="quantity"><?php esc_html_e( 'Quantity: ', 'mikado1' );
												echo esc_html( $cart_item['quantity'] ); ?>

                                        </div>
                                        <div class="item_right">
											<?php echo apply_filters( 'woocommerce_cart_item_price_html', wc_price( $product_price ), $cart_item, $cart_item_key );
											?>
											<?php echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf( '<a href="%s" class="remove" title="%s">&times;</a>', esc_url( $woocommerce->cart->get_remove_url( $cart_item_key ) ), esc_html__( 'Remove this item', 'mikado1' ) ), $cart_item_key ); ?>

                                        </div>
                                    </div>
                                </li>

							<?php endforeach; ?>
                            <div class="cart_bottom">
                                <div class="subtotal_holder">
                                    <span class="total"><?php esc_html_e( 'Total', 'mikado1' ); ?>:</span>
                                    <span class="total_amount">
										<?php echo wp_kses( $woocommerce->cart->get_cart_subtotal(), array(
											'span' => array(
												'class' => true,
												'id'    => true
											)
										) ); ?>
									</span>
                                </div>
                                <div class="btns_holder">
                                    <a href="<?php echo esc_url( wc_get_cart_url() ); ?>" class="qbutton small view-cart"><?php esc_html_e( 'Shopping Bag', 'mikado1' ); ?></a>
                                    <a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" class="qbutton small checkout"><?php esc_html_e( 'Checkout', 'mikado1' ); ?><span class="arrow_right"
                                                                                                                                                                                aria-hidden="true"></span></a>
                                </div>
                            </div>
						<?php else : ?>

                            <li class="empty_cart"><?php esc_html_e( 'No products in the cart.', 'mikado1' ); ?></li>

						<?php endif; ?>

                    </ul>
                </div>
				<?php if ( sizeof( $woocommerce->cart->get_cart() ) <= 0 ) : ?>

				<?php endif; ?>


				<?php if ( sizeof( $woocommerce->cart->get_cart() ) <= 0 ) : ?>

				<?php endif; ?>
            </div>
        </div>

		<?php
		$fragments['div.shopping_cart_header'] = ob_get_clean();

		return $fragments;
	}

	add_filter( 'woocommerce_add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment' );
}
?>