<?php
if (!function_exists ('add_action')) {
    header('Status: 403 Forbidden');
    header('HTTP/1.1 403 Forbidden');
    exit();
}
class Mikado_Import {

    public $message = "";
    public $attachments = false;
    function __construct() {
        add_action('admin_menu', array(&$this, 'mkd_admin_import'), 15);
        add_action('admin_init', array(&$this, 'register_mkd_theme_settings'), 15);

    }
    function register_mkd_theme_settings() {
        register_setting( 'mkd_options_import_page', 'mkd_options_import');
    }

    function init_mkd_import() {
        if(isset($_REQUEST['import_option'])) {
            $import_option = $_REQUEST['import_option'];
            if($import_option == 'content'){
                $this->import_content('proya_content.xml');
            }elseif($import_option == 'custom_sidebars') {
                $this->import_custom_sidebars('custom_sidebars.txt');
            } elseif($import_option == 'widgets') {
                $this->import_widgets('widgets.txt','custom_sidebars.txt');
            } elseif($import_option == 'options'){
                $this->import_options('options.txt');
            }elseif($import_option == 'menus'){
                $this->import_menus('menus.txt');
            }elseif($import_option == 'settingpages'){
                $this->import_settings_pages('settingpages.txt');
            }elseif($import_option == 'complete_content'){
                $this->import_content('proya_content.xml');
                $this->import_options('options.txt');
                $this->import_widgets('widgets.txt','custom_sidebars.txt');
                $this->import_menus('menus.txt');
                $this->import_settings_pages('settingpages.txt');
                $this->message = __("Content imported successfully", "mkd");
            }
        }
    }

    public function import_content($file){
        ob_start();
        require_once(MKD_CORE_ABS_PATH . '/import/class.wordpress-importer.php');
        $mkd_import = new WP_Import();
        set_time_limit(0);

        $mkd_import->fetch_attachments = $this->attachments;
        $returned_value = $mkd_import->import($file);
        if(is_wp_error($returned_value)){
            $this->message = esc_html__("An Error Occurred During Import", "mkd");
        }
        else {
            $this->message = esc_html__("Content imported successfully", "mkd");
        }
        ob_get_clean();
    }

    public function import_widgets($file, $file2){
        $this->import_custom_sidebars($file2);
        $options = $this->file_options($file);
        foreach ((array) $options['widgets'] as $mkd_widget_id => $mkd_widget_data) {
            update_option( 'widget_' . $mkd_widget_id, $mkd_widget_data );
        }
        $this->import_sidebars_widgets($file);
        $this->message = __("Widgets imported successfully", "mkd");
    }

    public function import_sidebars_widgets($file){
        $mkd_sidebars = get_option("sidebars_widgets");
        unset($mkd_sidebars['array_version']);
        $data = $this->file_options($file);
        if ( is_array($data['sidebars']) ) {
            $mkd_sidebars = array_merge( (array) $mkd_sidebars, (array) $data['sidebars'] );
            unset($mkd_sidebars['wp_inactive_widgets']);
            $mkd_sidebars = array_merge(array('wp_inactive_widgets' => array()), $mkd_sidebars);
            $mkd_sidebars['array_version'] = 2;
            wp_set_sidebars_widgets($mkd_sidebars);
        }
    }

    public function import_custom_sidebars($file){
        $options = $this->file_options($file);
        update_option( 'mkd_sidebars', $options);
        $this->message = __("Custom sidebars imported successfully", "mkd");
    }

    public function import_options($file){
        $options = $this->file_options($file);
        update_option( 'mkd_options_mikado100', $options);
        $this->message = __("Options imported successfully", "mkd");
    }

    public function import_menus($file){
        global $wpdb;
        $mkd_terms_table = $wpdb->prefix . "terms";
        $this->menus_data = $this->file_options($file);
        $menu_array = array();
        foreach ($this->menus_data as $registered_menu => $menu_slug) {
            $term_rows = $wpdb->get_results($wpdb->prepare("SELECT * FROM $mkd_terms_table where slug=%s", $menu_slug), ARRAY_A);
            if(isset($term_rows[0]['term_id'])) {
                $term_id_by_slug = $term_rows[0]['term_id'];
            } else {
                $term_id_by_slug = null;
            }
            $menu_array[$registered_menu] = $term_id_by_slug;
        }
        set_theme_mod('nav_menu_locations', array_map('absint', $menu_array ) );

    }
    public function import_settings_pages($file){
        $pages = $this->file_options($file);
        foreach($pages as $mkd_page_option => $mkd_page_id){
            update_option( $mkd_page_option, $mkd_page_id);
        }
    }

	function update_meta_fields_after_import( $folder ) {

		global $wpdb;



		$url         = home_url( '/' );

		$demo_urls   = $this->import_get_demo_urls( $folder );



		foreach ( $demo_urls as $demo_url ) {

			$sql_query   = "SELECT meta_id, meta_value FROM wp_postmeta WHERE meta_key LIKE 'mkd%' AND meta_value LIKE '" . esc_url( $demo_url ) . "%';";

			$meta_values = $wpdb->get_results( $sql_query );



			if ( ! empty( $meta_values ) ) {

				foreach ( $meta_values as $meta_value ) {

					$new_value = $this->recalc_serialized_lengths( str_replace( $demo_url, $url, $meta_value->meta_value ) );



					$wpdb->update( $wpdb->postmeta,    array( 'meta_value' => $new_value ), array( 'meta_id' => $meta_value->meta_id )    );

				}

			}

		}

	}



	function update_options_after_import( $folder ) {

		$url       = home_url( '/' );

		$demo_urls = $this->import_get_demo_urls( $folder );



		foreach ( $demo_urls as $demo_url ) {

			$global_options    = get_option( 'mkd_options_mikado100' );

			$new_global_values = str_replace( $demo_url, $url, $global_options );



			update_option( 'mkd_options_mikado100', $new_global_values );

		}

	}



	function import_get_demo_urls( $folder ) {

		$demo_urls   = array();

		$domain_urls = array();



		$domain_urls[] = str_replace( array( '/', 'new' ), array( '', '' ), $folder ) . '.mikado-themes.com/';

		$domain_urls[] = 'demo.mikado-themes.com/' . $folder;



		foreach ( $domain_urls as $domain_url ) {

			$demo_urls[] = ! empty( $domain_url ) ? 'http://' . $domain_url : '';

			$demo_urls[] = ! empty( $domain_url ) ? 'https://' . $domain_url : '';

		}



		return $demo_urls;

	}



	function recalc_serialized_lengths( $sObject ) {

		$ret = preg_replace_callback( '!s:(\d+):"(.*?)";!', 'recalc_serialized_lengths_callback', $sObject );



		return $ret;

	}



	function recalc_serialized_lengths_callback( $matches ) {

		return "s:" . strlen( $matches[2] ) . ":\"$matches[2]\";";

	}

    public function file_options($file){
        $file_content = "";
        $file_for_import = MKD_CORE_ABS_PATH . '/import/files/' . $file;
        /*if ( file_exists($file_for_import) ) {
            $file_content = $this->mkd_file_contents($file_for_import);
        } else {
            $this->message = __("File doesn't exist", "mkd");
        }*/
        $file_content = $this->mkd_file_contents($file);
        if ($file_content) {
            $unserialized_content = unserialize(base64_decode($file_content));
            if ($unserialized_content) {
                return $unserialized_content;
            }
        }
        return false;
    }

    function mkd_file_contents( $path ) {
		$url      = "http://export.mikado-themes.com/".$path;
		$response = wp_remote_get($url);
		$body     = wp_remote_retrieve_body($response);
		return $body;
    }

    function mkd_admin_import() {
		$slug = "_tabimport";
		$this->pagehook = add_submenu_page(
			'mkd_theme_menu',
			'Mikado Settings - Mikado Import',                   // The value used to populate the browser's title bar when the menu page is active
			'Import',                   // The text of the menu in the administrator's sidebar
			'administrator',                  // What roles are able to access the menu
			'mkd_theme_menu'.$slug,                // The ID used to bind submenu items to this menu
			array(&$this, 'mkd_generate_import_page')
		);
        //$this->pagehook = add_menu_page('Mikado Import', 'Mikado Import', 'manage_options', 'mkd_options_import_page', array(&$this, 'mkd_generate_import_page'),'dashicons-download');
    }

    function mkd_generate_import_page() {
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_style('mkdf-bootstrap');
		wp_enqueue_style('mkdf-jquery-ui');
		wp_enqueue_style('mkdf-page-admin');
		wp_enqueue_style('mkdf-options-admin');
		wp_enqueue_style('mkdf-ui-admin');
		wp_enqueue_style('jquery.nouislider.min');
		wp_enqueue_style('mkdf-forms-admin');
		wp_enqueue_style('elegant-icons-admin');
		wp_enqueue_style('font-awesome-admin');
		wp_enqueue_style('mkdf-ui-import');

		wp_enqueue_script('jquery-ui-datepicker');
		wp_enqueue_script('jquery-ui-accordion');
		wp_enqueue_script('wp-color-picker'); //colorpicker
		wp_enqueue_script('bootstrap.min');
		wp_enqueue_media();
		wp_enqueue_script('jquery.nouislider.min');
		wp_enqueue_script('mkdf-ui-admin');
		wp_enqueue_script('mkdf-bootstrap-select');

		global $mkdFramework;
		$tab    = mikado_one_mikado_get_admin_tab();
		?>
		<div class="mkdf-options-page mkdf-page">

			<div class="mkdf-page-header page-header clearfix">

				<div class="mkdf-theme-name pull-left" >
					<img src="<?php echo esc_url(get_template_directory_uri() . '/mkdinc/admin/assets/img/mkd-logo.png'); ?>" alt="mkd_logo" class="mkdf-header-logo pull-left"/>
					<?php $current_theme = wp_get_theme(); ?>
					<h1 class="pull-left">
						<?php echo esc_attr($current_theme->get('Name')); ?>
						<small><?php echo esc_attr($current_theme->get('Version')); ?></small>
					</h1>
				</div>
				<div class="mkdf-top-section-holder">
					<div class="mkdf-top-section-holder-inner">

					</div>
				</div>

			</div> <!-- close div.mkdf-page-header -->

			<div class="mkdf-page-content-wrapper">
				<div class="mkdf-page-content">
					<div class="mkdf-page-navigation mkdf-tabs-wrapper vertical left clearfix">

						<div class="mkdf-tabs-navigation-wrapper">

							<ul class="nav nav-tabs clearfix">
								<?php
								foreach ($mkdFramework->mkdOptions->adminPages as $key=>$page ) {
									$slug = "";
									if (!empty($page->slug)) $slug = "_tab".$page->slug;
									$icon = "icon_building";
									switch ($page->slug) {
										case 1:
											$icon = 'icon_pencil-edit_alt';
											break;
										case 2:
											$icon = 'icon_folder-open_alt';
											break;
										case 3:
											$icon = 'icon_archive_alt';
											break;
										case 4:
											$icon = 'icon_clipboard';
											break;
										case 5:
											$icon = 'icon_cone_alt';
											break;
										case 6:
											$icon = 'icon_rook';
											break;
										case 7:
											$icon = 'icon_genius';
											break;
										case 8:
											$icon = 'icon_book_alt';
											break;
										case 9:
											$icon = 'icon_images';
											break;
										case 10:
											$icon = 'arrow_left-right';
											break;
										case 11:
											$icon = 'arrow_up-down_alt';
											break;
										case 12:
											$icon = 'icon_group';
											break;
										case 13:
											$icon = 'icon_error-triangle_alt';
											break;
										case 14:
											$icon = 'icon_mail_alt';
											break;
										case 15:
											$icon = 'icon_cart_alt';
											break;
										case 16:
											$icon = 'icon_contacts_alt';
											break;
										case 17:
											$icon = 'icon_refresh';
											break;
										case 18:
											$icon = 'icon_tools';
											break;
										case 19:
											$icon = 'icon_cart_alt';
											break;
										case 20:
											$icon = 'arrow_back';
											break;
									}
									?>
									<li<?php if ($page->slug == $tab) echo " class=\"active\""; ?>><a href="<?php echo get_admin_url(); ?>admin.php?page=mkd_theme_menu<?php echo esc_attr($slug); ?>"><i class="<?php echo esc_attr($icon); ?> mkdf-tooltip mkdf-inline-tooltip left" data-placement="top" data-toggle="tooltip" title="<?php echo esc_attr($page->title); ?>"></i><span><?php echo esc_html($page->title); ?></span></a></li>
								<?php
								}
								?>
								<li class="active"><a href="<?php echo get_admin_url(); ?>admin.php?page=mkd_theme_menu_tabimport"><i class="icon_download mkdf-tooltip mkdf-inline-tooltip left" data-placement="top" data-toggle="tooltip" title="Import"></i><span>Import</span></a></li>

							</ul>
						</div> <!-- close div.mkdf-tabs-navigation-wrapper -->

						<div class="mkdf-tabs-content">
							<div class="tab-content">
										<div class="tab-pane fade in active" id="import">
											<div class="mkdf-tab-content">
												<div class="mkdf-page-title-holder clearfix">
													<h2 class="mkdf-page-title">Import</h2>
												</div>

												<form method="post" class="mkd_ajax_form mkdf-import-page-holder">
													<div class="mkdf-page-form">
														<div class="mkdf-page-form-section-holder">
															<h3 class="mkdf-page-section-title">Import Demo Content</h3>
															<div class="mkdf-page-form-section" id="mkdf_first_color">
																<div class="mkdf-field-desc">
																	<h4>Import</h4>

																	<p>Choose demo content you want to import</p>
																</div>
																<!-- close div.mkdf-field-desc -->

																<div class="mkdf-section-content">
																	<div class="container-fluid">
																		<div class="row">
																			<div class="col-lg-3">
																				<select name="import_example" id="import_example" class="form-control mkdf-form-element dependence">
												                                     <option value="mikado3">Mikado 3 - Muscle</option>
												                                     <option value="mikado4">Mikado 4 - Prayer</option>
												                                     <option value="mikado5">Mikado 5 - Stylist</option>
												                                     <option value="mikado6">Mikado 6 - Burlesque</option>
												                                     <option value="mikado7">Mikado 7 - Torque</option>
												                                     <option value="mikado8">Mikado 8 - Scope</option>
												                                     <option value="mikado9">Mikado 9 - Vibrant</option>
												                                     <option value="mikado17">Mikado 17 - Jam Session</option>
												                                     <option value="mikado18">Mikado 18 - Sensei</option>
												                                     <option value="mikado21">Mikado 21 - Beatz</option>
												                                     <option value="mikado24">Mikado 24 - Extreme</option>
												                                     <option value="mikado27">Mikado 27 - Carlo</option>
												                                     <option value="mikado29">Mikado 29 - Gourmet</option>
												                                     <option value="mikado32">Mikado 32 - Storefront</option>
												                                     <option value="mikado33">Mikado 33 - Explorer</option>
												                                     <option value="mikado34">Mikado 34 - Askew</option>
												                                     <option value="mikado36">Mikado 36 - Leather</option>
												                                     <option value="mikado37">Mikado 37 - Adventurer</option>
												                                     <option value="mikado40">Mikado 40 - Spice</option>
												                                     <option value="mikado43">Mikado 43 - Desk</option>
												                                     <option value="mikado50">Mikado 50 - Mint</option>
												                                     <option value="mikado51">Mikado 51 - Lightbulb</option>
												                                     <option value="mikado52">Mikado 52 - Titan</option>
												                                     <option value="mikado58">Mikado 58 - Opening Day</option>
												                                     <option value="mikado59">Mikado 59 - Countdown</option>
												                                     <option value="mikado60">Mikado 60 - Reflect</option>
												                                     <option value="mikado68">Mikado 68 - RBJ</option>
												                                     <option value="mikado69">Mikado 69 - Craft</option>
												                                     <option value="mikado72">Mikado 72 - Wilderness</option>
												                                     <option value="mikado73">Mikado 73 - Construct</option>
												                                     <option value="mikado75">Mikado 75 - Metallic</option>
												                                     <option value="mikado78">Mikado 78 - Estate</option>
												                                     <option value="mikado81">Mikado 81 - Futura</option>
												                                     <option value="mikado86">Mikado 86 - Croissant</option>
												                                     <option value="mikado92">Mikado 92 - City Lights</option>
												                                     <option value="mikado94">Mikado 94 - Organic</option>
												                                     <option value="mikado98">Mikado 98 - RePrint</option>
																				</select>
																			</div>
																		</div>
																	</div>
																</div>
																<!-- close div.mkdf-section-content -->

															</div>

															<div class="mkdf-page-form-section" id="mkdf_vertical_area">


																<div class="mkdf-field-desc">
																	<h4>Import Type</h4>

																	<p>Enabling this option will switch to a Side Position (default is Top Position)</p>
																</div>
																<!-- close div.mkdf-field-desc -->



																<div class="mkdf-section-content">
																	<div class="container-fluid">
																		<div class="row">
																			<div class="col-lg-3">
																				<select name="import_option" id="import_option" class="form-control mkdf-form-element">
																					<option value="">Please Select</option>
																					<option value="complete_content">All</option>
																					<option value="content">Content</option>
																					<option value="widgets">Widgets</option>
																					<option value="options">Options</option>
																				</select>
																			</div>
																		</div>
																	</div>
																</div>
																<!-- close div.mkdf-section-content -->

															</div>
															<div class="mkdf-page-form-section">


																<div class="mkdf-field-desc">
																	<h4>Import attachments</h4>

																	<p>Do you want to import media files?</p>
																</div>
																<!-- close div.mkdf-field-desc -->
																<div class="mkdf-section-content">
																	<div class="container-fluid">
																		<div class="row">
																			<div class="col-lg-12">
																				<p class="field switch">
																					<label class="cb-enable dependence"><span>Yes</span></label>
																					<label class="cb-disable selected dependence"><span>No</span></label>
																					<input type="checkbox" id="import_attachments" class="checkbox" name="import_attachments" value="1">
																				</p>
																			</div>
																		</div>
																	</div>
																</div>
																<!-- close div.mkdf-section-content -->
															</div>
															<div class="mkdf-page-form-section">


																<div class="mkdf-field-desc">
																	<input type="submit" class="btn btn-primary btn-sm " value="Import" name="import" id="import_demo_data" />
																</div>
																<!-- close div.mkdf-field-desc -->
																<div class="mkdf-section-content">
																	<div class="container-fluid">
																		<div class="row">
																			<div class="col-lg-12">
																				<div class="import_load"><span><?php _e('The import process may take some time. Please be patient.', 'mkd') ?> </span><br />
																					<div class="mkd-progress-bar-wrapper html5-progress-bar">
																						<div class="progress-bar-wrapper">
																							<progress id="progressbar" value="0" max="100"></progress>
																						</div>
																						<div class="progress-value">0%</div>
																						<div class="progress-bar-message">
																						</div>
																					</div>
																				</div>
																			</div>
																		</div>
																	</div>
																</div>
																<!-- close div.mkdf-section-content -->
															</div>
															<div class="mkdf-page-form-section mkdf-import-button-wrapper">

																<div class="alert alert-warning">
																	<strong><?php _e('Important notes:', 'mkd') ?></strong>
																	<ul>
																		<li><?php _e('Please note that import process will take time needed to download all attachments from demo web site.', 'mkd'); ?></li>
																		<li> <?php _e('If you plan to use shop, please install WooCommerce before you run import.', 'mkd')?></li>
																	</ul>
																</div>
															</div>
														</div>

													</div>
												</form>

											</div><!-- close mkdf-tab-content -->
										</div>
							</div>
						</div> <!-- close div.mkdf-tabs-content -->

					</div> <!-- close div.mkdf-page-navigation -->

				</div> <!-- close div.mkdf-page-content -->

			</div> <!-- close div.mkdf-page-content-wrapper -->

		</div> <!-- close div.mkd-options-page -->

		<a id='back_to_top' href='#'>
            <span class="fa-stack">
                <span class="arrow_carrot-up"></span>
            </span>
		</a>
        <script type="text/javascript">
			(function($) {
				$(document).ready(function() {
					$(document).on('click', '#import_demo_data', function(e) {
						e.preventDefault();
						if (confirm('Are you sure, you want to import Demo Data now?')) {
							$('.import_load').css('display','block');
							var progressbar = $('#progressbar');
							var import_opt = $( "#import_option" ).val();
							var import_expl = $( "#import_example" ).val();
							var p = 0;
							if(import_opt == 'content'){
								for(var i=1;i<10;i++){
									var str;
									if (i < 10) str = 'mikado_content_0'+i+'.xml';
									else str = 'mikado_content_'+i+'.xml';
									jQuery.ajax({
										type: 'POST',
										url: ajaxurl,
										data: {
											action: 'mkd_dataImport',
											xml: str,
											example: import_expl,
											import_attachments: ($("#import_attachments").is(':checked') ? 1 : 0)
										},
										success: function(data, textStatus, XMLHttpRequest){
											p+= 10;
											$('.progress-value').html((p) + '%');
											progressbar.val(p);
											if (p === 90) {
												str = 'mikado_content_10.xml';
												jQuery.ajax({
													type: 'POST',
													url: ajaxurl,
													data: {
														action: 'mkd_dataImport',
														xml: str,
														example: import_expl,
														import_attachments: ($("#import_attachments").is(':checked') ? 1 : 0)
													},
													success: function(data, textStatus, XMLHttpRequest){
														p+= 10;
														$('.progress-value').html((p) + '%');
														progressbar.val(p);
														$('.progress-bar-message').html('<div class="alert alert-success"><strong>Import is completed</strong></div>');
													}
												});
											}
										},
										error: function(MLHttpRequest, textStatus, errorThrown){
										}
									});
								}
							} else if(import_opt == 'widgets') {
								jQuery.ajax({
									type: 'POST',
									url: ajaxurl,
									data: {
										action: 'mkd_widgetsImport',
										example: import_expl
									},
									success: function(data, textStatus, XMLHttpRequest){
										$('.progress-value').html((100) + '%');
										progressbar.val(100);
									}
								});
								$('.progress-bar-message').html('<div class="alert alert-success"><strong>Import is completed</strong></div>');
							} else if(import_opt == 'options'){
								jQuery.ajax({
									type: 'POST',
									url: ajaxurl,
									data: {
										action: 'mkd_optionsImport',
										example: import_expl
									},
									success: function(data, textStatus, XMLHttpRequest){
										$('.progress-value').html((100) + '%');
										progressbar.val(100);
									}
								});
								$('.progress-bar-message').html('<div class="alert alert-success"><strong>Import is completed</strong></div>');
							}else if(import_opt == 'complete_content'){
								for(var i=1;i<10;i++){
									var str;
									if (i < 10) str = 'mikado_content_0'+i+'.xml';
									else str = 'mikado_content_'+i+'.xml';
									jQuery.ajax({
										type: 'POST',
										url: ajaxurl,
										data: {
											action: 'mkd_dataImport',
											xml: str,
											example: import_expl,
											import_attachments: ($("#import_attachments").is(':checked') ? 1 : 0)
										},
										success: function(data, textStatus, XMLHttpRequest){
											p+= 10;
											$('.progress-value').html((p) + '%');
											progressbar.val(p);
											if (p === 90) {
												str = 'mikado_content_10.xml';
												jQuery.ajax({
													type: 'POST',
													url: ajaxurl,
													data: {
														action: 'mkd_dataImport',
														xml: str,
														example: import_expl,
														import_attachments: ($("#import_attachments").is(':checked') ? 1 : 0)
													},
													success: function(data, textStatus, XMLHttpRequest){
														jQuery.ajax({
															type: 'POST',
															url: ajaxurl,
															data: {
																action: 'mkd_otherImport',
																example: import_expl
															},
															success: function(data, textStatus, XMLHttpRequest){
																//alert(data);
																$('.progress-value').html((100) + '%');
																progressbar.val(100);
																$('.progress-bar-message').html('<div class="alert alert-success">Import is completed.</div>');
															},
															error: function(MLHttpRequest, textStatus, errorThrown){
															}
														});
													}
												});
											}
										}
									});
								}
							}
						}
						return false;
					});
				});
			})(jQuery);

        </script>

    <?php	}

}
global $my_Mikado_Import;
$my_Mikado_Import = new Mikado_Import();



if(!function_exists('mkd_dataImport')){
    function mkd_dataImport(){
        global $my_Mikado_Import;

        if ($_POST['import_attachments'] == 1)
            $my_Mikado_Import->attachments = true;
        else
            $my_Mikado_Import->attachments = false;

        $folder = "mikado1/";
        if (!empty($_POST['example']))
            $folder = $_POST['example']."/";

        $my_Mikado_Import->import_content($folder.$_POST['xml']);
        $my_Mikado_Import->update_meta_fields_after_import($folder);

        die();
    }

    add_action('wp_ajax_mkd_dataImport', 'mkd_dataImport');
}

if(!function_exists('mkd_widgetsImport')){
    function mkd_widgetsImport(){
        global $my_Mikado_Import;

        $folder = "mikado1/";
        if (!empty($_POST['example']))
            $folder = $_POST['example']."/";

        $my_Mikado_Import->import_widgets($folder.'widgets.txt',$folder.'custom_sidebars.txt');

        die();
    }

    add_action('wp_ajax_mkd_widgetsImport', 'mkd_widgetsImport');
}

if(!function_exists('mkd_optionsImport')){
    function mkd_optionsImport(){
        global $my_Mikado_Import;

        $folder = "mikado1/";
        if (!empty($_POST['example']))
            $folder = $_POST['example']."/";

        $my_Mikado_Import->import_options($folder.'options.txt');
	    $my_Mikado_Import->update_meta_fields_after_import($folder);

        die();
    }

    add_action('wp_ajax_mkd_optionsImport', 'mkd_optionsImport');
}

if(!function_exists('mkd_otherImport')){
    function mkd_otherImport(){
        global $my_Mikado_Import;

        $folder = "mikado1/";
        if (!empty($_POST['example']))
            $folder = $_POST['example']."/";

        $my_Mikado_Import->import_options($folder.'options.txt');
        $my_Mikado_Import->import_widgets($folder.'widgets.txt',$folder.'custom_sidebars.txt');
        $my_Mikado_Import->import_menus($folder.'menus.txt');
        $my_Mikado_Import->import_settings_pages($folder.'settingpages.txt');



	    $my_Mikado_Import->update_meta_fields_after_import( $folder );

	    $my_Mikado_Import->update_options_after_import( $folder );

        die();
    }

    add_action('wp_ajax_mkd_otherImport', 'mkd_otherImport');
}